/*
  gdbm-exists.c
  
  Jonathan B. Leffert <jonathan@leffert.net>
  17 May 2000
  
  $Id: gdbm-exists.c,v 1.1 2000/05/17 21:08:53 jonathan Exp $
  
  Copyright (c) 2000 Jonathan B. Leffert <jonathan@leffert.net>
  All rights reserved.
*/

#include "common.h"

/* prototypes */
void parse_args(int *, char ***, char **);
void usage(char *);

/*
  function defs
*/

void parse_args(int *argc, char ***argv, char **dbName)
{
  char *options = "d:hv";
  int c;

  while ( (c = getopt(*argc, *argv, options)) != EOF )
    {
      switch (c)
	{
	case 'd':
	  /* database name */
	  *dbName = optarg;
	  break;
	case 'h':
	  /* request help */
	  usage((*argv)[0]);
	  exit(0);
	  break;
	case 'v':
	  /* version info */
	  printf("Version %f\n", VERSION);
	  exit(0);
	  break;
	case '?':
	  /* unknown option */
	  usage((*argv)[0]);
	  exit(1);
	  break;
	default:
	  /* default: do nothing */
	  break;
	}
    }
}

void usage(char *program_name)
{
  printf("Usage:\n");
  printf("\n");
  printf("%s [-hv] [-d DB]\n", program_name);
  printf("\n");
  printf("-d DB = Test for existance of specified database.\n");
  printf("        Must be supplied.\n");
  printf("-h    = This help message.\n");
  printf("-v    = Prints version information.\n");
  printf("\n");
  printf("This program tests for the existance of the given database.\n");
  printf("\n");
  printf("Error Codes:\n");
  printf("  0 if the database exists\n");
  printf("  1 if the database does not exist\n");
}

/*
  main
*/

int main(int argc, char **argv)
{
  char *name = NULL;
  GDBM_FILE db = NULL;
  int returnValue = 0;

  parse_args(&argc, &argv, &name);

  if ( name != NULL )
    {
      /* try to open the database */
      db = open_gdbm_database_ro(name);
      if ( db != NULL )
	{
	  /* open suceeded, database already exists */
	  /* close the database */
	  gdbm_close(db);
	}
      else
	{
	  returnValue = 1;
	}
    }
  else
    {
      /* happens if no -d flag given */
      usage(argv[0]);
      exit(1);
    }
  
  return returnValue;
}
