/*
  soundmgr.c
  
  socket-based sound manager for /dev/audio
  
  by Bill Kendrick
  kendrick@zippy.sonoma.edu
  http://zippy.sonoma.edu/kendrick/
  
  April 22, 1998 - April 22, 1998
  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "soundmgr.h"


int sound_len[256];
unsigned char * au_file_data[256];


FILE * soundmgr(int num_sounds, char * * files)
{
  FILE * fi, * sound_fs;
  char file[1024];
  int len, sound_position, i, cntl, want_length, sound_pos_tmp,
    which_sound, z, zc, pid;
  char c;
  struct timeval now, then;
  long time_padding;
  struct stat sbuf;
  
  
  /* Open /dev/audio: */
  
  devaudio_fd = open("/dev/audio", O_RDWR);
  
  if (devaudio_fd == -1)
    {
      fprintf(stderr, "Can't open /dev/audio\n");
      return(NULL);
    }
  
  
  /* Fork off into mgr. process: */
  
  if (pipe(pipefds) < 0)
    {
      perror("pipe");
      return(NULL);
    }
  
  pid = fork();
  
  if (pid == 0)
    {
      /* Figure out our file descriptors: */
      
      close(0);
      dup(pipefds[0]);
      close(pipefds[0]);
      close(pipefds[1]);
      
      cntl = fcntl(0, F_GETFL, 0);
      cntl = cntl | O_NONBLOCK;
      fcntl(0, F_SETFL, cntl);
      
      len = 0;
      
      sound_position = 0;
      
      for (i = 0; i < SOUND_BUF; i++)
	sound_data[i] = 0;
      
      
      /* Load sounds: */
      
      for (i = 0; i < num_sounds; i++)
	{
	  stat(files[i], &sbuf);
	  au_file_data[i] = malloc(sbuf.st_size);
	  sound_len[i] = sbuf.st_size;
	  
	  fi = fopen(files[i], "r");
	  
	  if (fi != NULL)
	    {
	      sound_pos_tmp = 0;
	      
	      for (sound_pos_tmp = 0; sound_pos_tmp < sound_len[i]; 
		   sound_pos_tmp++)
		{
		  zc = fgetc(fi);
		  au_file_data[i][sound_pos_tmp] = 
		    (unsigned char) zc;
		}
	      
	      fclose(fi);
	    }
	  else
	    {
	      perror(file);
	      exit(0);
	    }
	}
      
      fprintf(stderr, "(Sound manager: running!)\n");
      
      
      /* MAIN SOUND MANAGER LOOP: */
      
      do
	{
	  gettimeofday(&then, NULL);
	  
	  
	  /* Read from parent: */
	  
	  z = read(0, &c, 1);
	  
	  if (z > 0)
	    {
	      if (c != '\n')
		{
		  file[len] = c;
		  len++;
		}
	      else
		{
		  /* Copy sound into queue: */
		  
		  file[len] = '\0';
		  len = 0;
		  
		  if (strcmp(file, "SHH") == 0)
		    {
		      for (i = 0; i < SOUND_BUF; i++)
			sound_data[(i + sound_position) % SOUND_BUF] = 0;
		    }
		  else
		    {
		      which_sound = atoi(file);
		      
		      for (i = 0; i < sound_len[which_sound]; i++)
			{
			  sound_data[(i + sound_position) % SOUND_BUF] =
			    au_file_data[which_sound][i];
			}
		    }
		}
	    }
	  
	  
	  /* Play sound: */
	  
	  want_length = 20;
	  
	  if (sound_data[sound_position] != 0)
	    {
	      write(devaudio_fd, &sound_data[sound_position],
		    want_length);
	      
	      for (sound_pos_tmp = 0; sound_pos_tmp < want_length;
		   sound_pos_tmp++)
		sound_data[(sound_position + sound_pos_tmp) % SOUND_BUF] = 0;
	    }
	  
	  sound_position = (sound_position + want_length) % SOUND_BUF;
	  
	  
	  gettimeofday(&now, NULL);
	  
	  time_padding = 200 - ((now.tv_sec - then.tv_sec) * 1000000 +
				(now.tv_usec - then.tv_usec));
	  
	  if (time_padding > 0)
	    usleep(time_padding);
	}
      while (z != 0);
      
      printf("(Sound manager: quitting!)\n");
      
      exit(0);
    }
  else if (pid == -1)
    {
      perror("fork");
      exit(1);
    }
  else
    {
      close(pipefds[0]);
      
      sound_fs = fdopen(pipefds[1], "w");
      
      fprintf(stderr, "Connected to sound manager\n");
      
      return(sound_fs);
    }
  
  return(NULL);
}


void playsound(FILE * sound_fs, int whichfile)
{
  if (sound_fs != NULL)
    {
      fprintf(sound_fs, "%d\n", whichfile);
      fflush(sound_fs);
    }
}


void silence(FILE * sound_fs)
{
  if (sound_fs != NULL)
    {
      fprintf(sound_fs, "SHH\n");
      fflush(sound_fs);
    }
}
