/*
 * tvutil.h
 *
 * API for misc (non-X) utility routines for FXTV.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVUTIL_H
#define __TVUTIL_H

#include "tvtypes.h"

typedef struct {
    int fd;                     /*  filedesc to bind                   */
    int is_pipe;                /*  T = create IPC pipe; F = just dup  */
    int fd_saved;               /*  When is_pipe, saved fd             */

} TVUTIL_PIPE_END;


#ifdef __cplusplus
extern "C" {
#endif

void TVUTILOutOfMemory();

void TVUTILPipeSetup( char            *shell_cmd,
                      char            *shell_cmd2[],
                      TVUTIL_PIPE_END  end[3],
                      pid_t           *child_pid );

void TVUTILPipeCleanup( pid_t            child_pid,
                        TVUTIL_PIPE_END  end[3],
                        int             *ex_status );

void TVUTILCmdStrToArgList( char    shell_cmd[],
                            char ***cmd,
                            char  **argbuf );

void TVUTILstrupr( char *str );
void TVUTILstrlwr( char *str );

char *TVUTILStrStrip( 
          char    *str, 
          char    *strip_chars,
          TV_BOOL  leading,
          TV_BOOL  imbedded,
          TV_BOOL  trailing );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
