/*
 * rawvideo.h
 *
 * API for reading & writing raw video files (w/ interleaved audio)
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __RAWVIDEO_H
#define __RAWVIDEO_H

#include "tvtypes.h"
#include "tvcapture.h"
#include "tvaudio.h"

#define TV_RAW_MAX_FILES  4

typedef TV_IMAGE TV_RAW_IMAGE;
typedef TV_SOUND TV_RAW_SOUND;

typedef struct {
    TV_RAW_IMAGE img;
    TV_RAW_SOUND snd;
} TV_RAW_HEADER;

typedef struct {
    TV_INT32 image_bytes;                 /*  Size of image data to follow   */
    TV_INT32 sound_bytes;                 /*  Size of audio data to follow   */
    TV_INT32 delay;                       /*  Elapsed delay since last image */
} TV_RAW_IMAGE_HEADER;

typedef struct TV_RAW_VIDEO_FILE TV_RAW_VIDEO_FILE;



#ifdef __cplusplus
extern "C" {
#endif

TV_UINT32 TVRAWVIDEOCalcImageSize( TV_RAW_IMAGE *img );

TV_BOOL TVRAWVIDEOOpen( char               *filenames[],
                        TV_INT32            num_files,
                        TV_BOOL             read,
                        TV_RAW_VIDEO_FILE **rf );

TV_BOOL TVRAWVIDEOClose( TV_RAW_VIDEO_FILE **rf );

TV_BOOL TVRAWVIDEOHeaderWrite( TV_RAW_VIDEO_FILE *rf,
                               TV_RAW_IMAGE      *img,
                               TV_RAW_SOUND      *snd );

TV_BOOL TVRAWVIDEOHeaderRead( TV_RAW_VIDEO_FILE *rf,
                              TV_RAW_IMAGE      *img, 
                              TV_RAW_SOUND      *snd,
                              TV_BOOL           *eof );

TV_BOOL TVRAWVIDEOImageWrite( TV_RAW_VIDEO_FILE   *rf,
                              TV_RAW_IMAGE_HEADER *head, 
                              TV_RAW_IMAGE        *img,
                              TV_RAW_SOUND        *snd );

TV_BOOL TVRAWVIDEOImageRead( TV_RAW_VIDEO_FILE   *rf,
                             TV_RAW_IMAGE_HEADER *head, 
                             TV_RAW_IMAGE        *img,
                             TV_RAW_SOUND        *snd, 
                             TV_BOOL             *eof );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
