// @(#) $Id: input.h,v 1.2 2003/07/29 23:29:11 balu Exp $

#ifndef __INPUT_H
#define __INPUT_H

#include <string>
#include <vector>

using namespace std;

class Input
{
private:

bool eof;

protected:

void setEof(bool);

Input();

public:

bool isEof() const;
operator void *() const;

virtual string &getLine()=0;
virtual string nextLine()=0;
};

typedef vector<string> FileList;

class InputFile:
      public Input
{
private:

FileList *list;
FileList::iterator current;
string line;
istream *in;

void next();

public:

InputFile(FileList *aList=NULL);

virtual string &getLine();
virtual string nextLine();
};

class InputFilter:
      public Input
{
private:

Input *upper;

protected:

virtual bool isBoundary()=0;

InputFilter(Input *);

public:

Input *getUpper() const;

virtual string &getLine();
virtual string nextLine();
};

class FromFilter:
      public InputFilter
{
protected:

virtual bool isBoundary();

public:

FromFilter(Input *);
};

class BoundaryFilter:
      public InputFilter
{
private:

string boundary;

protected:

virtual bool isBoundary();

public:

BoundaryFilter(Input *,const string &);
};

#endif /* __INPUT_H */
