/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:40 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 2 */

/*
 * This function contains 8 FP additions, 7 FP multiplications,
 * (or, 6 additions, 5 multiplications, 2 fused multiply/add),
 * 11 stack variables, and 16 memory accesses
 */
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_2(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (2 * iostride);
     {
	  fftw_real tmp12;
	  fftw_real tmp13;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp12 = X[0];
	  tmp13 = X[iostride];
	  X[iostride] = tmp12 - tmp13;
	  X[0] = tmp12 + tmp13;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 1) {
	  fftw_real tmp4;
	  fftw_real tmp5;
	  fftw_real tmp9;
	  fftw_real tmp6;
	  fftw_real tmp7;
	  fftw_real tmp11;
	  fftw_real tmp8;
	  fftw_real tmp10;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp4 = X[0];
	  tmp5 = Y[-iostride];
	  tmp9 = tmp4 - tmp5;
	  tmp6 = Y[0];
	  tmp7 = X[iostride];
	  tmp11 = tmp6 + tmp7;
	  X[0] = tmp4 + tmp5;
	  Y[-iostride] = tmp6 - tmp7;
	  tmp8 = c_re(W[0]);
	  tmp10 = c_im(W[0]);
	  X[iostride] = (tmp8 * tmp9) + (tmp10 * tmp11);
	  Y[0] = (tmp8 * tmp11) - (tmp10 * tmp9);
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp3;
	  fftw_real tmp2;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  X[0] = K2_000000000 * tmp1;
	  tmp3 = Y[0];
	  tmp2 = c_im(W[0]);
	  X[iostride] = tmp2 * (K2_000000000 * tmp3);
     }
}

static const int twiddle_order[] =
{1};
fftw_codelet_desc fftw_hc2hc_backward_2_desc =
{
     "fftw_hc2hc_backward_2",
     (void (*)()) fftw_hc2hc_backward_2,
     2,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     43,
     1,
     twiddle_order,
};
