#ifndef SIGSCHED_H
#define SIGSCHED_H

typedef struct
 {
  int type;
  union { int n; void *c; } u;
 }
ss_sig;

typedef struct
 {
  int (*sched)();
  int (*unsched)();
  union { int n; char *c; } u;
 }
ss_extern;

typedef void ss_thread();
typedef int ss_id;
typedef void *ss_idptr;

extern ss_sig *ss_asap(void);
extern ss_sig *ss_signal(int);
extern ss_sig *ss_sigread(int);
extern ss_sig *ss_sigwrite(int);
extern ss_sig *ss_sigexcept(int);

extern int ss_addsig(int);

extern void ss_externsetsig(ss_sig*,ss_extern*);

extern int ss_schedvwait(ss_sig *,ss_thread *,int,ss_id,ss_idptr,int);
extern int ss_schedwait(ss_sig *,ss_thread *,ss_id,int);
extern int ss_sched(ss_sig *,ss_thread *,ss_id);
extern int ss_schedonce(ss_sig *,ss_thread *,ss_id);
extern int ss_unschedv(ss_sig *,ss_thread *,int,ss_id,ss_idptr);
extern int ss_unsched(ss_sig *,ss_thread *,ss_id);

extern void ss_forcewait(void);
extern void ss_unforcewait(void);

extern int ss_exec(void);

#endif
