#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>

#include "prjlibs-c/types.h"
#include "fdtools.h"
#include "cmsg.h"

ssize_t fd_xfer_recv(type_fd sock, type_fd* fds, size_t nfds) {
  char iov_buf[1];
  struct iovec iov={ iov_buf, sizeof iov_buf };
  struct msghdr msg={ NULL, 0, &iov, 1, NULL, 0, 0 };
  struct cmsghdr* cmsg;
  size_t const arrsize=nfds*sizeof (type_fd);
  size_t datasize, i, nfds_recvd;
  msg.msg_controllen=CMSG_SPACE(arrsize);
  if (arrsize==0 || arrsize/sizeof (type_fd)!=nfds ||
      msg.msg_controllen<arrsize) {
    errno=EINVAL;
    return -1;
  }
  msg.msg_control=malloc(msg.msg_controllen);
  if (msg.msg_control==NULL) return -1;
  while (recvmsg(sock, &msg, 0)<0)
    if (errno!=EINTR) {
      type_error const error=errno;
      free(msg.msg_control);
      errno=error;
      return -1;
    }
  cmsg=CMSG_FIRSTHDR(&msg);
  if (cmsg==NULL || cmsg->cmsg_level!=SOL_SOCKET ||
      cmsg->cmsg_type!=SCM_RIGHTS) {
    free(msg.msg_control);
    errno=0;
    return -1;
  }
  datasize=cmsg->cmsg_len-(CMSG_DATA(cmsg)-(unsigned char*)cmsg);
  while (CMSG_LEN(datasize)<cmsg->cmsg_len) ++datasize;
  while (CMSG_LEN(datasize)>cmsg->cmsg_len) --datasize;
  nfds_recvd=datasize/sizeof (type_fd);
  if (datasize>nfds*sizeof (type_fd)) datasize=nfds*sizeof (type_fd);
  memcpy(fds, CMSG_DATA(cmsg), datasize);
  free(msg.msg_control);
  for (i=nfds_recvd; i<nfds; ++i) fds[i]=-1;
  return nfds_recvd;
}
