#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <limits.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/types.h"
#include "prjlibs-c/diewarn.h"
#include "fdtools.h"

enum { fd_format0_bytes=(sizeof (type_fd)*CHAR_BIT+2)/3+1 };

static void cleanup_fd(type_fd fd) {
  type_error const error=errno;
  while (close(fd)<0 && errno==EINTR);
  errno=error;
}

#define ADD(lvalue, expr) do { \
  (lvalue)+=(expr); \
  if ((lvalue)<(expr)) goto inval; \
} while (0)

ssize_t fd_xfer_child(type_fd* fds, size_t nfds, char** argv) {
  pid_t pid;
  type_fd sock[2], highsock;
  int status;
  ssize_t nfds_recvd;
  size_t argc, allargc, fdsize, allocsize, i;
  if (nfds==0) goto inval;
  for (argc=0; argv[argc]!=NULL; ++argc);
  fdsize=nfds;
  ADD(fdsize, 1u);
  fdsize*=fd_format0_bytes;
  if (fdsize/fd_format0_bytes!=nfds+1) goto inval;
  allargc=argc;
  ADD(allargc, 3u);
  ADD(allargc, nfds);
  allocsize=allargc*sizeof (char*);
  if (allocsize/sizeof (char*)!=allargc) goto inval;
  ADD(allocsize, fdsize);
  for (highsock=9, i=0; i!=nfds; ++i)
    if (highsock<fds[i]) highsock=fds[i];
  if (highsock==INT_MAX) goto inval;
  if (socketpair(AF_UNIX, SOCK_STREAM, 0, sock)!=0) return -1;
  highsock=fcntl(sock[1], F_DUPFD, highsock+1);
  if (highsock<0) goto cleanup_sock1;
  while (close(sock[1])<0)
    if (errno!=EINTR) goto cleanup_highsock;
  pid=fork();
  if (pid<0) goto cleanup_highsock;
  if (pid==0) {
    char** arglist;
    char (*formats)[fd_format0_bytes];
    while (close(sock[0])<0)
      if (errno!=EINTR) DIE1(close, "socket");
    arglist=malloc(allocsize);
    if (arglist==NULL) DIE0(alloc);
    formats=(void*)(arglist+allargc);
    memcpy(arglist, argv, argc*sizeof (char*));
    arglist[argc]=(char*)"sendfd";
    formats[0][int_fmt(formats[0], highsock)]='\0';
    arglist[argc+1u]=formats[0];
    ++formats;
    for (i=0; i!=nfds; ++i) {
      char* const format=formats[i];
      arglist[argc+2u+i]=format;
      format[int_fmt(format, fds[i])]='\0';
    }
    arglist[argc+2u+nfds]=NULL;
    execvp(arglist[0], arglist);
    DIE1(exec, arglist[0]);
  }
  while (close(highsock)<0)
    if (errno!=EINTR) goto cleanup_sock0;
  nfds_recvd=fd_xfer_recv(sock[0], fds, nfds);
  while (close(sock[0])<0)
    if (errno!=EINTR) return -1;
  for (;;) {
    pid_t const child=waitpid(pid, &status, 0);
    if (child==pid) break;
    if (child>=0) continue; /* reaped the wrong child - impossible */
    if (errno!=EINTR) return -1;
  }
  if (!WIFEXITED(status) || WEXITSTATUS(status)!=0) { errno=0; return -1; }
  return nfds_recvd;
  inval:
  errno=EINVAL;
  return -1;
  cleanup_sock1:    cleanup_fd(sock[1]); goto cleanup_sock0;
  cleanup_highsock: cleanup_fd(highsock);
  cleanup_sock0:    cleanup_fd(sock[0]);
  return -1;
}
