#include "prjlibs-c/standards.h"
#include <fcntl.h>
#include <sys/types.h>
#include <limits.h>
#include <stdlib.h>

#include "prjlibs-c/types.h"
#include "fdtools.h"

type_fd fd_scan_or_open(type_bool* scan, char const* arg, int flags,
                        mode_t mode) {
  *scan=('0'<=arg[0] && arg[0]<='9');
  if (*scan) {
    char* end;
    unsigned long const fd=strtoul(arg, &end, 10);
    if (*end!='\0' || fd>INT_MAX) return -1;
    return fd;
  } else
    return open(arg, flags, mode);
}
