#include "prjlibs-c/standards.h"
#include <sys/ioctl.h>

#include "prjlibs-c/types.h"
#include "fdtools.h"

#ifdef TIOCCONS

type_status fd_grabconsole(type_fd fd) {
  int x=1;
  return ioctl(fd, TIOCCONS, (char*)&x);
}

#else

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/strredir.h>
#include <errno.h>
#include <stropts.h>

type_status fd_grabconsole(type_fd fd) {
  type_error error=0;
  type_fd const console=open("/dev/console", O_RDONLY);
  if (console<0) return -1;
  if (ioctl(console, SRIOCSREDIR, fd)!=0) error=errno;
  while (close(console)<0)
    if (errno!=EINTR) {
      if (error!=0) errno=error;
      return -1;
    }
  if (error==0) return 0;
  errno=error;
  return -1;
}

#endif
