#ifndef PACKAGE__PROG__PRJLIBS__WARN_H
#define PACKAGE__PROG__PRJLIBS__WARN_H

/* Examine the expression (to generate diagnostics), but don't evaluate it. */
#define WARN_CHK(x) (0? (void)(x): (void)0)

/* Trigger a diagnostic if this value is not of the pointed-to type. */
#define WARN_PTYPE(ptype, value) WARN_CHK(*(ptype)0=(value))

/* Trigger a diagnostic if this value is not of this type. */
#define WARN_TYPE(type, value) WARN_PTYPE(type*, value)

/* Convert this value to this type, safely. */
#define WARN_CAST(type, value) (WARN_TYPE(type, value), (type)value)

/* Trigger a diagnostic if this value is not an array of this type. */
#define WARN_ARR(type, value) \
  WARN_CHK(*(type (**)[sizeof (value)/sizeof *(value)])0=&(value))

/* Trigger a diagnostic if the expression is true. */
#define WARN_IF(x) \
  (WARN_TYPE(unsigned long, x), \
   WARN_CHK((struct { char a[(x)? -1: 1]; }*)0))

#endif
