#include "standards.h"
#include <string.h>

#include "vec.h"

enum { sz0=sizeof (double), sz1=sizeof (long[2]), sz=(sz0>sz1? sz0: sz1) };

unsigned char* vec_shift(size_t typesize, vec_type* v) {
  if (v->len==0) return (errno=EINVAL, (void*)NULL);
  if (typesize<=sz) {
    char tmp[sz];
    memcpy(tmp, v->s, typesize);
    memmove(v->s, v->s+typesize, v->len-typesize);
    memcpy(v->s+v->len-typesize, tmp, typesize);
    v->len-=typesize;
    return v->s+v->len;
  } else {
    vec_insn(typesize, v, v->len/typesize, v->s, 1);
    memmove(v->s, v->s+typesize, v->len-2*typesize);
    v->len-=2*typesize;
    return v->s+v->len+typesize;
  }
}
