#ifndef PACKAGE__PROG__PRJLIBS__INT_H
#define PACKAGE__PROG__PRJLIBS__INT_H

#include <limits.h>
#include "warn.h"

/* Check the properties of a type or value without triggering a diagnostic. */
#define INTATTR_SIGNED(type) ((type)-1<(type)1)
#define INTATTR_UNSIGNED(type) (!INTATTR_SIGNED(type))
#define INTATTR_NEGATIVE(type, value) \
  (WARN_CAST(type, value)<(INTATTR_SIGNED(type)? (type)0: (type)(value)))

#define INTATTR_LEN_NUM_2 1
#define INTATTR_LEN_DEN_2 1

#define INTATTR_LEN_NUM_4 1
#define INTATTR_LEN_DEN_4 2

#define INTATTR_LEN_NUM_8 1
#define INTATTR_LEN_DEN_8 3

#define INTATTR_LEN_NUM_10 146
#define INTATTR_LEN_DEN_10 485

#define INTATTR_LEN_NUM_16 1
#define INTATTR_LEN_DEN_16 4

#define INTATTR_LEN_NUM_32 1
#define INTATTR_LEN_DEN_32 5

#define INTATTR_LEN_NUM_36 206
#define INTATTR_LEN_DEN_36 1065

#define INTATTR_LEN_NUM_64 1
#define INTATTR_LEN_DEN_64 6

#define INTATTR_LEN(base, type) \
  (((sizeof (type)*CHAR_BIT-INTATTR_SIGNED(type))*INTATTR_LEN_NUM_##base \
    +(INTATTR_LEN_DEN_##base-1))/ \
   INTATTR_LEN_DEN_##base+INTATTR_SIGNED(type))

#endif
