/*****************************************************************
 * pbmtitle.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * pbmtitle.c: Add a title to a pbm bitmap
 *
 * USAGE
 *	% pbmtitle [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:18:32 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/pbmtitle.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 23-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>

# define USAGE "Usage: pbmtitle 'new title' < pbm > pbm"

#ifndef lint
static char *fbmid =
"$FBM pbmtitle.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ char buf[BUFSIZ];
  int lines=0;

  if (argc != 2 || argv[1][0] == '-')
  { fprintf (stderr, "%s\n", USAGE);
    exit (1);
  }
  
  while (fgets (buf, BUFSIZ, stdin))
  { if (buf[0] != '#') { printf ("%s", buf); lines++; }
    else if (strncmp (buf, "# Title: ", 9)) printf ("%s", buf);
    
    if (lines == 2) printf ("# Title: %s\n", argv[1]);
  }
  
  exit (0);
}
