/*****************************************************************
 * fbrev.c: FBM Release 1.2 07-Apr-93 Michael Mauldin
 *
 * Copyright (C) 1989-1993 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbrev.c: Reverse intensity of image.
 *
 * USAGE
 *      % fbrev < image > image2
 *
 * EDITLOG
 *      LastEditDate = Thu Dec 27 14:47:54 1990 - Michael Mauldin
 *      LastFileName = /usr2/mlm/src/misc/fbm/fbrev.c
 *
 * HISTORY
 * 07-Apr-93  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Added -J switch
 *
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 21-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *      Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include <ctype.h>
# include "fbm.h"

# define USAGE \
	"Usage: fbrev [ -<type> ] < image > image"

#ifndef lint
static char *fbmid =
"$FBM fbrev.c <1.2> 07-Apr-93 (C) 1989-1993 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ FBM image;
  register unsigned char *bmptr, *tail;
  register int i;
  int outtype = FMT_FBM;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'J':	outtype = FMT_JPEG; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
        default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }
  
  /* Clear the memory pointer so alloc_fbm won't be confused */
  image.cm  = image.bm  = (unsigned char *) NULL;

  /* Now read in the image */
  if (read_bitmap (&image, (char *) NULL))
  { if (image.hdr.clrlen > 0)
    { fprintf (stderr, "Reversing map: \"%s\" [%dx%d], %d colors\n",
               image.hdr.title[0] ? image.hdr.title : "(untitled)",
	       image.hdr.cols, image.hdr.rows, image.hdr.clrlen / 3);

      for (i=0; i<image.hdr.clrlen; i++)
      { image.cm[i] = WHITE - image.cm[i]; }
    }
    
    else if (image.hdr.physbits != 8)
    { fprintf (stderr,
	       "fbrev: can't handle files with %d physical bytes per pixel.\n",
	       image.hdr.physbits);
      exit (1);
    }
    
    else
    { fprintf (stderr, "Reversing: \"%s\" [%dx%d]",
               image.hdr.title[0] ? image.hdr.title : "(untitled)",
	       image.hdr.cols, image.hdr.rows);
      if (image.hdr.planes > 1)
      { fprintf (stderr, ", %d planes", image.hdr.planes); }
      fprintf (stderr, "\n");

      bmptr = image.bm;
      tail = bmptr + image.hdr.plnlen * image.hdr.planes;

      while (bmptr < tail)
      { *bmptr = WHITE - *bmptr;
        bmptr++;
      }
    }
    
    /* Write it out */
    write_bitmap (&image, stdout, outtype);
  }
  else
  { exit (1); }
  
  exit (0);
}
