/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: unicode.c,v 1.2 2005/07/12 23:12:29 pullmoll Exp $
 *****************************************************************************/
#include "osd.h"
#include "zlib.h"
#include "memalloc.h"
#include "unicode.h"
#include "logger.h"

#define	SAVE_MEMORY	1

#if (NEED_WCNAME || NEED_WCNAME10 || NEED_WCCOMMENT || NEED_WCGCAT || NEED_WCCOMM ||NEED_WCBIDI || NEED_WCDECO || NEED_WCDIGIT || NEED_WCNUMERIC || NEED_WCMIRRORED || NEED_WCUCASE || NEED_WCLCASE || NEED_WCTCASE || NEED_WCRANGES)

#define	UNICODE_LIST	"node/unicode.txt.gz"
#define	PLANESIZE	65536
static unicode_data_t *unicode_data;

#endif

static const fontmap_t iso8859_1[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x00A1},  /* INVERTED EXCLAMATION MARK */
	{0xA2, 0x00A2},  /* CENT SIGN */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA5, 0x00A5},  /* YEN SIGN */
	{0xA6, 0x00A6},  /* BROKEN BAR */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAA, 0x00AA},  /* FEMININE ORDINAL INDICATOR */
	{0xAB, 0x00AB},  /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xAC, 0x00AC},  /* NOT SIGN */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x00AE},  /* REGISTERED SIGN */
	{0xAF, 0x00AF},  /* MACRON */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x00B1},  /* PLUS-MINUS SIGN */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x00B4},  /* ACUTE ACCENT */
	{0xB5, 0x00B5},  /* MICRO SIGN */
	{0xB6, 0x00B6},  /* PILCROW SIGN */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x00B8},  /* CEDILLA */
	{0xB9, 0x00B9},  /* SUPERSCRIPT ONE */
	{0xBA, 0x00BA},  /* MASCULINE ORDINAL INDICATOR */
	{0xBB, 0x00BB},  /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xBC, 0x00BC},  /* VULGAR FRACTION ONE QUARTER */
	{0xBD, 0x00BD},  /* VULGAR FRACTION ONE HALF */
	{0xBE, 0x00BE},  /* VULGAR FRACTION THREE QUARTERS */
	{0xBF, 0x00BF},  /* INVERTED QUESTION MARK */
	{0xC0, 0x00C0},  /* LATIN CAPITAL LETTER A WITH GRAVE */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x00C3},  /* LATIN CAPITAL LETTER A WITH TILDE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xC7, 0x00C7},  /* LATIN CAPITAL LETTER C WITH CEDILLA */
	{0xC8, 0x00C8},  /* LATIN CAPITAL LETTER E WITH GRAVE */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x00CA},  /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x00CC},  /* LATIN CAPITAL LETTER I WITH GRAVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x00CF},  /* LATIN CAPITAL LETTER I WITH DIAERESIS */
	{0xD0, 0x00D0},  /* LATIN CAPITAL LETTER ETH (Icelandic) */
	{0xD1, 0x00D1},  /* LATIN CAPITAL LETTER N WITH TILDE */
	{0xD2, 0x00D2},  /* LATIN CAPITAL LETTER O WITH GRAVE */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xD9, 0x00D9},  /* LATIN CAPITAL LETTER U WITH GRAVE */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x00DD},  /* LATIN CAPITAL LETTER Y WITH ACUTE */
	{0xDE, 0x00DE},  /* LATIN CAPITAL LETTER THORN (Icelandic) */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S (German) */
	{0xE0, 0x00E0},  /* LATIN SMALL LETTER A WITH GRAVE */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x00E3},  /* LATIN SMALL LETTER A WITH TILDE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xE7, 0x00E7},  /* LATIN SMALL LETTER C WITH CEDILLA */
	{0xE8, 0x00E8},  /* LATIN SMALL LETTER E WITH GRAVE */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x00EA},  /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x00EC},  /* LATIN SMALL LETTER I WITH GRAVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x00EF},  /* LATIN SMALL LETTER I WITH DIAERESIS */
	{0xF0, 0x00F0},  /* LATIN SMALL LETTER ETH (Icelandic) */
	{0xF1, 0x00F1},  /* LATIN SMALL LETTER N WITH TILDE */
	{0xF2, 0x00F2},  /* LATIN SMALL LETTER O WITH GRAVE */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xF9, 0x00F9},  /* LATIN SMALL LETTER U WITH GRAVE */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x00FD},  /* LATIN SMALL LETTER Y WITH ACUTE */
	{0xFE, 0x00FE},  /* LATIN SMALL LETTER THORN (Icelandic) */
	{0xFF, 0x00FF},  /* LATIN SMALL LETTER Y WITH DIAERESIS */
	{0,0}
};

static const fontmap_t iso8859_2[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x0104},  /* LATIN CAPITAL LETTER A WITH OGONEK */
	{0xA2, 0x02D8},  /* BREVE */
	{0xA3, 0x0141},  /* LATIN CAPITAL LETTER L WITH STROKE */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA5, 0x013D},  /* LATIN CAPITAL LETTER L WITH CARON */
	{0xA6, 0x015A},  /* LATIN CAPITAL LETTER S WITH ACUTE */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x0160},  /* LATIN CAPITAL LETTER S WITH CARON */
	{0xAA, 0x015E},  /* LATIN CAPITAL LETTER S WITH CEDILLA */
	{0xAB, 0x0164},  /* LATIN CAPITAL LETTER T WITH CARON */
	{0xAC, 0x0179},  /* LATIN CAPITAL LETTER Z WITH ACUTE */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x017D},  /* LATIN CAPITAL LETTER Z WITH CARON */
	{0xAF, 0x017B},  /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x0105},  /* LATIN SMALL LETTER A WITH OGONEK */
	{0xB2, 0x02DB},  /* OGONEK */
	{0xB3, 0x0142},  /* LATIN SMALL LETTER L WITH STROKE */
	{0xB4, 0x00B4},  /* ACUTE ACCENT */
	{0xB5, 0x013E},  /* LATIN SMALL LETTER L WITH CARON */
	{0xB6, 0x015B},  /* LATIN SMALL LETTER S WITH ACUTE */
	{0xB7, 0x02C7},  /* CARON */
	{0xB8, 0x00B8},  /* CEDILLA */
	{0xB9, 0x0161},  /* LATIN SMALL LETTER S WITH CARON */
	{0xBA, 0x015F},  /* LATIN SMALL LETTER S WITH CEDILLA */
	{0xBB, 0x0165},  /* LATIN SMALL LETTER T WITH CARON */
	{0xBC, 0x017A},  /* LATIN SMALL LETTER Z WITH ACUTE */
	{0xBD, 0x02DD},  /* DOUBLE ACUTE ACCENT */
	{0xBE, 0x017E},  /* LATIN SMALL LETTER Z WITH CARON */
	{0xBF, 0x017C},  /* LATIN SMALL LETTER Z WITH DOT ABOVE */
	{0xC0, 0x0154},  /* LATIN CAPITAL LETTER R WITH ACUTE */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x0102},  /* LATIN CAPITAL LETTER A WITH BREVE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x0139},  /* LATIN CAPITAL LETTER L WITH ACUTE */
	{0xC6, 0x0106},  /* LATIN CAPITAL LETTER C WITH ACUTE */
	{0xC7, 0x00C7},  /* LATIN CAPITAL LETTER C WITH CEDILLA */
	{0xC8, 0x010C},  /* LATIN CAPITAL LETTER C WITH CARON */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x0118},  /* LATIN CAPITAL LETTER E WITH OGONEK */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x011A},  /* LATIN CAPITAL LETTER E WITH CARON */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x010E},  /* LATIN CAPITAL LETTER D WITH CARON */
	{0xD0, 0x0110},  /* LATIN CAPITAL LETTER D WITH STROKE */
	{0xD1, 0x0143},  /* LATIN CAPITAL LETTER N WITH ACUTE */
	{0xD2, 0x0147},  /* LATIN CAPITAL LETTER N WITH CARON */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x0150},  /* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x0158},  /* LATIN CAPITAL LETTER R WITH CARON */
	{0xD9, 0x016E},  /* LATIN CAPITAL LETTER U WITH RING ABOVE */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x0170},  /* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x00DD},  /* LATIN CAPITAL LETTER Y WITH ACUTE */
	{0xDE, 0x0162},  /* LATIN CAPITAL LETTER T WITH CEDILLA */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S */
	{0xE0, 0x0155},  /* LATIN SMALL LETTER R WITH ACUTE */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x0103},  /* LATIN SMALL LETTER A WITH BREVE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x013A},  /* LATIN SMALL LETTER L WITH ACUTE */
	{0xE6, 0x0107},  /* LATIN SMALL LETTER C WITH ACUTE */
	{0xE7, 0x00E7},  /* LATIN SMALL LETTER C WITH CEDILLA */
	{0xE8, 0x010D},  /* LATIN SMALL LETTER C WITH CARON */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x0119},  /* LATIN SMALL LETTER E WITH OGONEK */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x011B},  /* LATIN SMALL LETTER E WITH CARON */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x010F},  /* LATIN SMALL LETTER D WITH CARON */
	{0xF0, 0x0111},  /* LATIN SMALL LETTER D WITH STROKE */
	{0xF1, 0x0144},  /* LATIN SMALL LETTER N WITH ACUTE */
	{0xF2, 0x0148},  /* LATIN SMALL LETTER N WITH CARON */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x0151},  /* LATIN SMALL LETTER O WITH DOUBLE ACUTE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x0159},  /* LATIN SMALL LETTER R WITH CARON */
	{0xF9, 0x016F},  /* LATIN SMALL LETTER U WITH RING ABOVE */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x0171},  /* LATIN SMALL LETTER U WITH DOUBLE ACUTE */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x00FD},  /* LATIN SMALL LETTER Y WITH ACUTE */
	{0xFE, 0x0163},  /* LATIN SMALL LETTER T WITH CEDILLA */
	{0xFF, 0x02D9},  /* DOT ABOVE */
	{0,0}
};

static const fontmap_t iso8859_3[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x0126},  /* LATIN CAPITAL LETTER H WITH STROKE */
	{0xA2, 0x02D8},  /* BREVE */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA6, 0x0124},  /* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x0130},  /* LATIN CAPITAL LETTER I WITH DOT ABOVE */
	{0xAA, 0x015E},  /* LATIN CAPITAL LETTER S WITH CEDILLA */
	{0xAB, 0x011E},  /* LATIN CAPITAL LETTER G WITH BREVE */
	{0xAC, 0x0134},  /* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAF, 0x017B},  /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x0127},  /* LATIN SMALL LETTER H WITH STROKE */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x00B4},  /* ACUTE ACCENT */
	{0xB5, 0x00B5},  /* MICRO SIGN */
	{0xB6, 0x0125},  /* LATIN SMALL LETTER H WITH CIRCUMFLEX */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x00B8},  /* CEDILLA */
	{0xB9, 0x0131},  /* LATIN SMALL LETTER DOTLESS I */
	{0xBA, 0x015F},  /* LATIN SMALL LETTER S WITH CEDILLA */
	{0xBB, 0x011F},  /* LATIN SMALL LETTER G WITH BREVE */
	{0xBC, 0x0135},  /* LATIN SMALL LETTER J WITH CIRCUMFLEX */
	{0xBD, 0x00BD},  /* VULGAR FRACTION ONE HALF */
	{0xBF, 0x017C},  /* LATIN SMALL LETTER Z WITH DOT ABOVE */
	{0xC0, 0x00C0},  /* LATIN CAPITAL LETTER A WITH GRAVE */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x010A},  /* LATIN CAPITAL LETTER C WITH DOT ABOVE */
	{0xC6, 0x0108},  /* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */
	{0xC7, 0x00C7},  /* LATIN CAPITAL LETTER C WITH CEDILLA */
	{0xC8, 0x00C8},  /* LATIN CAPITAL LETTER E WITH GRAVE */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x00CA},  /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x00CC},  /* LATIN CAPITAL LETTER I WITH GRAVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x00CF},  /* LATIN CAPITAL LETTER I WITH DIAERESIS */
	{0xD1, 0x00D1},  /* LATIN CAPITAL LETTER N WITH TILDE */
	{0xD2, 0x00D2},  /* LATIN CAPITAL LETTER O WITH GRAVE */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x0120},  /* LATIN CAPITAL LETTER G WITH DOT ABOVE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x011C},  /* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */
	{0xD9, 0x00D9},  /* LATIN CAPITAL LETTER U WITH GRAVE */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x016C},  /* LATIN CAPITAL LETTER U WITH BREVE */
	{0xDE, 0x015C},  /* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S */
	{0xE0, 0x00E0},  /* LATIN SMALL LETTER A WITH GRAVE */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x010B},  /* LATIN SMALL LETTER C WITH DOT ABOVE */
	{0xE6, 0x0109},  /* LATIN SMALL LETTER C WITH CIRCUMFLEX */
	{0xE7, 0x00E7},  /* LATIN SMALL LETTER C WITH CEDILLA */
	{0xE8, 0x00E8},  /* LATIN SMALL LETTER E WITH GRAVE */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x00EA},  /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x00EC},  /* LATIN SMALL LETTER I WITH GRAVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x00EF},  /* LATIN SMALL LETTER I WITH DIAERESIS */
	{0xF1, 0x00F1},  /* LATIN SMALL LETTER N WITH TILDE */
	{0xF2, 0x00F2},  /* LATIN SMALL LETTER O WITH GRAVE */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x0121},  /* LATIN SMALL LETTER G WITH DOT ABOVE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x011D},  /* LATIN SMALL LETTER G WITH CIRCUMFLEX */
	{0xF9, 0x00F9},  /* LATIN SMALL LETTER U WITH GRAVE */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x016D},  /* LATIN SMALL LETTER U WITH BREVE */
	{0xFE, 0x015D},  /* LATIN SMALL LETTER S WITH CIRCUMFLEX */
	{0xFF, 0x02D9},  /* DOT ABOVE */
	{0,0}
};

static const fontmap_t iso8859_4[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x0104},  /* LATIN CAPITAL LETTER A WITH OGONEK */
	{0xA2, 0x0138},  /* LATIN SMALL LETTER KRA */
	{0xA3, 0x0156},  /* LATIN CAPITAL LETTER R WITH CEDILLA */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA5, 0x0128},  /* LATIN CAPITAL LETTER I WITH TILDE */
	{0xA6, 0x013B},  /* LATIN CAPITAL LETTER L WITH CEDILLA */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x0160},  /* LATIN CAPITAL LETTER S WITH CARON */
	{0xAA, 0x0112},  /* LATIN CAPITAL LETTER E WITH MACRON */
	{0xAB, 0x0122},  /* LATIN CAPITAL LETTER G WITH CEDILLA */
	{0xAC, 0x0166},  /* LATIN CAPITAL LETTER T WITH STROKE */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x017D},  /* LATIN CAPITAL LETTER Z WITH CARON */
	{0xAF, 0x00AF},  /* MACRON */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x0105},  /* LATIN SMALL LETTER A WITH OGONEK */
	{0xB2, 0x02DB},  /* OGONEK */
	{0xB3, 0x0157},  /* LATIN SMALL LETTER R WITH CEDILLA */
	{0xB4, 0x00B4},  /* ACUTE ACCENT */
	{0xB5, 0x0129},  /* LATIN SMALL LETTER I WITH TILDE */
	{0xB6, 0x013C},  /* LATIN SMALL LETTER L WITH CEDILLA */
	{0xB7, 0x02C7},  /* CARON */
	{0xB8, 0x00B8},  /* CEDILLA */
	{0xB9, 0x0161},  /* LATIN SMALL LETTER S WITH CARON */
	{0xBA, 0x0113},  /* LATIN SMALL LETTER E WITH MACRON */
	{0xBB, 0x0123},  /* LATIN SMALL LETTER G WITH CEDILLA */
	{0xBC, 0x0167},  /* LATIN SMALL LETTER T WITH STROKE */
	{0xBD, 0x014A},  /* LATIN CAPITAL LETTER ENG */
	{0xBE, 0x017E},  /* LATIN SMALL LETTER Z WITH CARON */
	{0xBF, 0x014B},  /* LATIN SMALL LETTER ENG */
	{0xC0, 0x0100},  /* LATIN CAPITAL LETTER A WITH MACRON */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x00C3},  /* LATIN CAPITAL LETTER A WITH TILDE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xC7, 0x012E},  /* LATIN CAPITAL LETTER I WITH OGONEK */
	{0xC8, 0x010C},  /* LATIN CAPITAL LETTER C WITH CARON */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x0118},  /* LATIN CAPITAL LETTER E WITH OGONEK */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x0116},  /* LATIN CAPITAL LETTER E WITH DOT ABOVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x012A},  /* LATIN CAPITAL LETTER I WITH MACRON */
	{0xD0, 0x0110},  /* LATIN CAPITAL LETTER D WITH STROKE */
	{0xD1, 0x0145},  /* LATIN CAPITAL LETTER N WITH CEDILLA */
	{0xD2, 0x014C},  /* LATIN CAPITAL LETTER O WITH MACRON */
	{0xD3, 0x0136},  /* LATIN CAPITAL LETTER K WITH CEDILLA */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xD9, 0x0172},  /* LATIN CAPITAL LETTER U WITH OGONEK */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x0168},  /* LATIN CAPITAL LETTER U WITH TILDE */
	{0xDE, 0x016A},  /* LATIN CAPITAL LETTER U WITH MACRON */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S */
	{0xE0, 0x0101},  /* LATIN SMALL LETTER A WITH MACRON */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x00E3},  /* LATIN SMALL LETTER A WITH TILDE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xE7, 0x012F},  /* LATIN SMALL LETTER I WITH OGONEK */
	{0xE8, 0x010D},  /* LATIN SMALL LETTER C WITH CARON */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x0119},  /* LATIN SMALL LETTER E WITH OGONEK */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x0117},  /* LATIN SMALL LETTER E WITH DOT ABOVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x012B},  /* LATIN SMALL LETTER I WITH MACRON */
	{0xF0, 0x0111},  /* LATIN SMALL LETTER D WITH STROKE */
	{0xF1, 0x0146},  /* LATIN SMALL LETTER N WITH CEDILLA */
	{0xF2, 0x014D},  /* LATIN SMALL LETTER O WITH MACRON */
	{0xF3, 0x0137},  /* LATIN SMALL LETTER K WITH CEDILLA */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xF9, 0x0173},  /* LATIN SMALL LETTER U WITH OGONEK */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x0169},  /* LATIN SMALL LETTER U WITH TILDE */
	{0xFE, 0x016B},  /* LATIN SMALL LETTER U WITH MACRON */
	{0xFF, 0x02D9},  /* DOT ABOVE */
	{0,0}
};

static const fontmap_t iso8859_5[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x0401},  /* CYRILLIC CAPITAL LETTER IO */
	{0xA2, 0x0402},  /* CYRILLIC CAPITAL LETTER DJE */
	{0xA3, 0x0403},  /* CYRILLIC CAPITAL LETTER GJE */
	{0xA4, 0x0404},  /* CYRILLIC CAPITAL LETTER UKRAINIAN IE */
	{0xA5, 0x0405},  /* CYRILLIC CAPITAL LETTER DZE */
	{0xA6, 0x0406},  /* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
	{0xA7, 0x0407},  /* CYRILLIC CAPITAL LETTER YI */
	{0xA8, 0x0408},  /* CYRILLIC CAPITAL LETTER JE */
	{0xA9, 0x0409},  /* CYRILLIC CAPITAL LETTER LJE */
	{0xAA, 0x040A},  /* CYRILLIC CAPITAL LETTER NJE */
	{0xAB, 0x040B},  /* CYRILLIC CAPITAL LETTER TSHE */
	{0xAC, 0x040C},  /* CYRILLIC CAPITAL LETTER KJE */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x040E},  /* CYRILLIC CAPITAL LETTER SHORT U */
	{0xAF, 0x040F},  /* CYRILLIC CAPITAL LETTER DZHE */
	{0xB0, 0x0410},  /* CYRILLIC CAPITAL LETTER A */
	{0xB1, 0x0411},  /* CYRILLIC CAPITAL LETTER BE */
	{0xB2, 0x0412},  /* CYRILLIC CAPITAL LETTER VE */
	{0xB3, 0x0413},  /* CYRILLIC CAPITAL LETTER GHE */
	{0xB4, 0x0414},  /* CYRILLIC CAPITAL LETTER DE */
	{0xB5, 0x0415},  /* CYRILLIC CAPITAL LETTER IE */
	{0xB6, 0x0416},  /* CYRILLIC CAPITAL LETTER ZHE */
	{0xB7, 0x0417},  /* CYRILLIC CAPITAL LETTER ZE */
	{0xB8, 0x0418},  /* CYRILLIC CAPITAL LETTER I */
	{0xB9, 0x0419},  /* CYRILLIC CAPITAL LETTER SHORT I */
	{0xBA, 0x041A},  /* CYRILLIC CAPITAL LETTER KA */
	{0xBB, 0x041B},  /* CYRILLIC CAPITAL LETTER EL */
	{0xBC, 0x041C},  /* CYRILLIC CAPITAL LETTER EM */
	{0xBD, 0x041D},  /* CYRILLIC CAPITAL LETTER EN */
	{0xBE, 0x041E},  /* CYRILLIC CAPITAL LETTER O */
	{0xBF, 0x041F},  /* CYRILLIC CAPITAL LETTER PE */
	{0xC0, 0x0420},  /* CYRILLIC CAPITAL LETTER ER */
	{0xC1, 0x0421},  /* CYRILLIC CAPITAL LETTER ES */
	{0xC2, 0x0422},  /* CYRILLIC CAPITAL LETTER TE */
	{0xC3, 0x0423},  /* CYRILLIC CAPITAL LETTER U */
	{0xC4, 0x0424},  /* CYRILLIC CAPITAL LETTER EF */
	{0xC5, 0x0425},  /* CYRILLIC CAPITAL LETTER HA */
	{0xC6, 0x0426},  /* CYRILLIC CAPITAL LETTER TSE */
	{0xC7, 0x0427},  /* CYRILLIC CAPITAL LETTER CHE */
	{0xC8, 0x0428},  /* CYRILLIC CAPITAL LETTER SHA */
	{0xC9, 0x0429},  /* CYRILLIC CAPITAL LETTER SHCHA */
	{0xCA, 0x042A},  /* CYRILLIC CAPITAL LETTER HARD SIGN */
	{0xCB, 0x042B},  /* CYRILLIC CAPITAL LETTER YERU */
	{0xCC, 0x042C},  /* CYRILLIC CAPITAL LETTER SOFT SIGN */
	{0xCD, 0x042D},  /* CYRILLIC CAPITAL LETTER E */
	{0xCE, 0x042E},  /* CYRILLIC CAPITAL LETTER YU */
	{0xCF, 0x042F},  /* CYRILLIC CAPITAL LETTER YA */
	{0xD0, 0x0430},  /* CYRILLIC SMALL LETTER A */
	{0xD1, 0x0431},  /* CYRILLIC SMALL LETTER BE */
	{0xD2, 0x0432},  /* CYRILLIC SMALL LETTER VE */
	{0xD3, 0x0433},  /* CYRILLIC SMALL LETTER GHE */
	{0xD4, 0x0434},  /* CYRILLIC SMALL LETTER DE */
	{0xD5, 0x0435},  /* CYRILLIC SMALL LETTER IE */
	{0xD6, 0x0436},  /* CYRILLIC SMALL LETTER ZHE */
	{0xD7, 0x0437},  /* CYRILLIC SMALL LETTER ZE */
	{0xD8, 0x0438},  /* CYRILLIC SMALL LETTER I */
	{0xD9, 0x0439},  /* CYRILLIC SMALL LETTER SHORT I */
	{0xDA, 0x043A},  /* CYRILLIC SMALL LETTER KA */
	{0xDB, 0x043B},  /* CYRILLIC SMALL LETTER EL */
	{0xDC, 0x043C},  /* CYRILLIC SMALL LETTER EM */
	{0xDD, 0x043D},  /* CYRILLIC SMALL LETTER EN */
	{0xDE, 0x043E},  /* CYRILLIC SMALL LETTER O */
	{0xDF, 0x043F},  /* CYRILLIC SMALL LETTER PE */
	{0xE0, 0x0440},  /* CYRILLIC SMALL LETTER ER */
	{0xE1, 0x0441},  /* CYRILLIC SMALL LETTER ES */
	{0xE2, 0x0442},  /* CYRILLIC SMALL LETTER TE */
	{0xE3, 0x0443},  /* CYRILLIC SMALL LETTER U */
	{0xE4, 0x0444},  /* CYRILLIC SMALL LETTER EF */
	{0xE5, 0x0445},  /* CYRILLIC SMALL LETTER HA */
	{0xE6, 0x0446},  /* CYRILLIC SMALL LETTER TSE */
	{0xE7, 0x0447},  /* CYRILLIC SMALL LETTER CHE */
	{0xE8, 0x0448},  /* CYRILLIC SMALL LETTER SHA */
	{0xE9, 0x0449},  /* CYRILLIC SMALL LETTER SHCHA */
	{0xEA, 0x044A},  /* CYRILLIC SMALL LETTER HARD SIGN */
	{0xEB, 0x044B},  /* CYRILLIC SMALL LETTER YERU */
	{0xEC, 0x044C},  /* CYRILLIC SMALL LETTER SOFT SIGN */
	{0xED, 0x044D},  /* CYRILLIC SMALL LETTER E */
	{0xEE, 0x044E},  /* CYRILLIC SMALL LETTER YU */
	{0xEF, 0x044F},  /* CYRILLIC SMALL LETTER YA */
	{0xF0, 0x2116},  /* NUMERO SIGN */
	{0xF1, 0x0451},  /* CYRILLIC SMALL LETTER IO */
	{0xF2, 0x0452},  /* CYRILLIC SMALL LETTER DJE */
	{0xF3, 0x0453},  /* CYRILLIC SMALL LETTER GJE */
	{0xF4, 0x0454},  /* CYRILLIC SMALL LETTER UKRAINIAN IE */
	{0xF5, 0x0455},  /* CYRILLIC SMALL LETTER DZE */
	{0xF6, 0x0456},  /* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
	{0xF7, 0x0457},  /* CYRILLIC SMALL LETTER YI */
	{0xF8, 0x0458},  /* CYRILLIC SMALL LETTER JE */
	{0xF9, 0x0459},  /* CYRILLIC SMALL LETTER LJE */
	{0xFA, 0x045A},  /* CYRILLIC SMALL LETTER NJE */
	{0xFB, 0x045B},  /* CYRILLIC SMALL LETTER TSHE */
	{0xFC, 0x045C},  /* CYRILLIC SMALL LETTER KJE */
	{0xFD, 0x00A7},  /* SECTION SIGN */
	{0xFE, 0x045E},  /* CYRILLIC SMALL LETTER SHORT U */
	{0xFF, 0x045F},  /* CYRILLIC SMALL LETTER DZHE */
	{0,0}
};

static const fontmap_t iso8859_7[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x2018},  /* LEFT SINGLE QUOTATION MARK */
	{0xA2, 0x2019},  /* RIGHT SINGLE QUOTATION MARK */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA6, 0x00A6},  /* BROKEN BAR */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAB, 0x00AB},  /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xAC, 0x00AC},  /* NOT SIGN */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAF, 0x2015},  /* HORIZONTAL BAR */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x00B1},  /* PLUS-MINUS SIGN */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x0384},  /* GREEK TONOS */
	{0xB5, 0x0385},  /* GREEK DIALYTIKA TONOS */
	{0xB6, 0x0386},  /* GREEK CAPITAL LETTER ALPHA WITH TONOS */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x0388},  /* GREEK CAPITAL LETTER EPSILON WITH TONOS */
	{0xB9, 0x0389},  /* GREEK CAPITAL LETTER ETA WITH TONOS */
	{0xBA, 0x038A},  /* GREEK CAPITAL LETTER IOTA WITH TONOS */
	{0xBB, 0x00BB},  /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xBC, 0x038C},  /* GREEK CAPITAL LETTER OMICRON WITH TONOS */
	{0xBD, 0x00BD},  /* VULGAR FRACTION ONE HALF */
	{0xBE, 0x038E},  /* GREEK CAPITAL LETTER UPSILON WITH TONOS */
	{0xBF, 0x038F},  /* GREEK CAPITAL LETTER OMEGA WITH TONOS */
	{0xC0, 0x0390},  /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */
	{0xC1, 0x0391},  /* GREEK CAPITAL LETTER ALPHA */
	{0xC2, 0x0392},  /* GREEK CAPITAL LETTER BETA */
	{0xC3, 0x0393},  /* GREEK CAPITAL LETTER GAMMA */
	{0xC4, 0x0394},  /* GREEK CAPITAL LETTER DELTA */
	{0xC5, 0x0395},  /* GREEK CAPITAL LETTER EPSILON */
	{0xC6, 0x0396},  /* GREEK CAPITAL LETTER ZETA */
	{0xC7, 0x0397},  /* GREEK CAPITAL LETTER ETA */
	{0xC8, 0x0398},  /* GREEK CAPITAL LETTER THETA */
	{0xC9, 0x0399},  /* GREEK CAPITAL LETTER IOTA */
	{0xCA, 0x039A},  /* GREEK CAPITAL LETTER KAPPA */
	{0xCB, 0x039B},  /* GREEK CAPITAL LETTER LAMDA */
	{0xCC, 0x039C},  /* GREEK CAPITAL LETTER MU */
	{0xCD, 0x039D},  /* GREEK CAPITAL LETTER NU */
	{0xCE, 0x039E},  /* GREEK CAPITAL LETTER XI */
	{0xCF, 0x039F},  /* GREEK CAPITAL LETTER OMICRON */
	{0xD0, 0x03A0},  /* GREEK CAPITAL LETTER PI */
	{0xD1, 0x03A1},  /* GREEK CAPITAL LETTER RHO */
	{0xD3, 0x03A3},  /* GREEK CAPITAL LETTER SIGMA */
	{0xD4, 0x03A4},  /* GREEK CAPITAL LETTER TAU */
	{0xD5, 0x03A5},  /* GREEK CAPITAL LETTER UPSILON */
	{0xD6, 0x03A6},  /* GREEK CAPITAL LETTER PHI */
	{0xD7, 0x03A7},  /* GREEK CAPITAL LETTER CHI */
	{0xD8, 0x03A8},  /* GREEK CAPITAL LETTER PSI */
	{0xD9, 0x03A9},  /* GREEK CAPITAL LETTER OMEGA */
	{0xDA, 0x03AA},  /* GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */
	{0xDB, 0x03AB},  /* GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */
	{0xDC, 0x03AC},  /* GREEK SMALL LETTER ALPHA WITH TONOS */
	{0xDD, 0x03AD},  /* GREEK SMALL LETTER EPSILON WITH TONOS */
	{0xDE, 0x03AE},  /* GREEK SMALL LETTER ETA WITH TONOS */
	{0xDF, 0x03AF},  /* GREEK SMALL LETTER IOTA WITH TONOS */
	{0xE0, 0x03B0},  /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */
	{0xE1, 0x03B1},  /* GREEK SMALL LETTER ALPHA */
	{0xE2, 0x03B2},  /* GREEK SMALL LETTER BETA */
	{0xE3, 0x03B3},  /* GREEK SMALL LETTER GAMMA */
	{0xE4, 0x03B4},  /* GREEK SMALL LETTER DELTA */
	{0xE5, 0x03B5},  /* GREEK SMALL LETTER EPSILON */
	{0xE6, 0x03B6},  /* GREEK SMALL LETTER ZETA */
	{0xE7, 0x03B7},  /* GREEK SMALL LETTER ETA */
	{0xE8, 0x03B8},  /* GREEK SMALL LETTER THETA */
	{0xE9, 0x03B9},  /* GREEK SMALL LETTER IOTA */
	{0xEA, 0x03BA},  /* GREEK SMALL LETTER KAPPA */
	{0xEB, 0x03BB},  /* GREEK SMALL LETTER LAMDA */
	{0xEC, 0x03BC},  /* GREEK SMALL LETTER MU */
	{0xED, 0x03BD},  /* GREEK SMALL LETTER NU */
	{0xEE, 0x03BE},  /* GREEK SMALL LETTER XI */
	{0xEF, 0x03BF},  /* GREEK SMALL LETTER OMICRON */
	{0xF0, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0xF1, 0x03C1},  /* GREEK SMALL LETTER RHO */
	{0xF2, 0x03C2},  /* GREEK SMALL LETTER FINAL SIGMA */
	{0xF3, 0x03C3},  /* GREEK SMALL LETTER SIGMA */
	{0xF4, 0x03C4},  /* GREEK SMALL LETTER TAU */
	{0xF5, 0x03C5},  /* GREEK SMALL LETTER UPSILON */
	{0xF6, 0x03C6},  /* GREEK SMALL LETTER PHI */
	{0xF7, 0x03C7},  /* GREEK SMALL LETTER CHI */
	{0xF8, 0x03C8},  /* GREEK SMALL LETTER PSI */
	{0xF9, 0x03C9},  /* GREEK SMALL LETTER OMEGA */
	{0xFA, 0x03CA},  /* GREEK SMALL LETTER IOTA WITH DIALYTIKA */
	{0xFB, 0x03CB},  /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA */
	{0xFC, 0x03CC},  /* GREEK SMALL LETTER OMICRON WITH TONOS */
	{0xFD, 0x03CD},  /* GREEK SMALL LETTER UPSILON WITH TONOS */
	{0xFE, 0x03CE},  /* GREEK SMALL LETTER OMEGA WITH TONOS */
	{0,0}
};

static const fontmap_t iso8859_8[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA2, 0x00A2},  /* CENT SIGN */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA5, 0x00A5},  /* YEN SIGN */
	{0xA6, 0x00A6},  /* BROKEN BAR */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAA, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xAB, 0x00AB},  /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xAC, 0x00AC},  /* NOT SIGN */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x00AE},  /* REGISTERED SIGN */
	{0xAF, 0x203E},  /* OVERLINE */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x00B1},  /* PLUS-MINUS SIGN */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x00B4},  /* ACUTE ACCENT */
	{0xB5, 0x00B5},  /* MICRO SIGN */
	{0xB6, 0x00B6},  /* PILCROW SIGN */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x00B8},  /* CEDILLA */
	{0xB9, 0x00B9},  /* SUPERSCRIPT ONE */
	{0xBA, 0x00F7},  /* DIVISION SIGN */
	{0xBB, 0x00BB},  /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xBC, 0x00BC},  /* VULGAR FRACTION ONE QUARTER */
	{0xBD, 0x00BD},  /* VULGAR FRACTION ONE HALF */
	{0xBE, 0x00BE},  /* VULGAR FRACTION THREE QUARTERS */
	{0xDF, 0x2017},  /* DOUBLE LOW LINE */
	{0xE0, 0x05D0},  /* HEBREW LETTER ALEF */
	{0xE1, 0x05D1},  /* HEBREW LETTER BET */
	{0xE2, 0x05D2},  /* HEBREW LETTER GIMEL */
	{0xE3, 0x05D3},  /* HEBREW LETTER DALET */
	{0xE4, 0x05D4},  /* HEBREW LETTER HE */
	{0xE5, 0x05D5},  /* HEBREW LETTER VAV */
	{0xE6, 0x05D6},  /* HEBREW LETTER ZAYIN */
	{0xE7, 0x05D7},  /* HEBREW LETTER HET */
	{0xE8, 0x05D8},  /* HEBREW LETTER TET */
	{0xE9, 0x05D9},  /* HEBREW LETTER YOD */
	{0xEA, 0x05DA},  /* HEBREW LETTER FINAL KAF */
	{0xEB, 0x05DB},  /* HEBREW LETTER KAF */
	{0xEC, 0x05DC},  /* HEBREW LETTER LAMED */
	{0xED, 0x05DD},  /* HEBREW LETTER FINAL MEM */
	{0xEE, 0x05DE},  /* HEBREW LETTER MEM */
	{0xEF, 0x05DF},  /* HEBREW LETTER FINAL NUN */
	{0xF0, 0x05E0},  /* HEBREW LETTER NUN */
	{0xF1, 0x05E1},  /* HEBREW LETTER SAMEKH */
	{0xF2, 0x05E2},  /* HEBREW LETTER AYIN */
	{0xF3, 0x05E3},  /* HEBREW LETTER FINAL PE */
	{0xF4, 0x05E4},  /* HEBREW LETTER PE */
	{0xF5, 0x05E5},  /* HEBREW LETTER FINAL TSADI */
	{0xF6, 0x05E6},  /* HEBREW LETTER TSADI */
	{0xF7, 0x05E7},  /* HEBREW LETTER QOF */
	{0xF8, 0x05E8},  /* HEBREW LETTER RESH */
	{0xF9, 0x05E9},  /* HEBREW LETTER SHIN */
	{0xFA, 0x05EA},  /* HEBREW LETTER TAV */
	{0,0}
};

static const fontmap_t iso8859_9[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x00A1},  /* INVERTED EXCLAMATION MARK */
	{0xA2, 0x00A2},  /* CENT SIGN */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA5, 0x00A5},  /* YEN SIGN */
	{0xA6, 0x00A6},  /* BROKEN BAR */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00A8},  /* DIAERESIS */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAA, 0x00AA},  /* FEMININE ORDINAL INDICATOR */
	{0xAB, 0x00AB},  /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xAC, 0x00AC},  /* NOT SIGN */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x00AE},  /* REGISTERED SIGN */
	{0xAF, 0x00AF},  /* MACRON */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x00B1},  /* PLUS-MINUS SIGN */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x00B4},  /* ACUTE ACCENT */
	{0xB5, 0x00B5},  /* MICRO SIGN */
	{0xB6, 0x00B6},  /* PILCROW SIGN */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x00B8},  /* CEDILLA */
	{0xB9, 0x00B9},  /* SUPERSCRIPT ONE */
	{0xBA, 0x00BA},  /* MASCULINE ORDINAL INDICATOR */
	{0xBB, 0x00BB},  /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xBC, 0x00BC},  /* VULGAR FRACTION ONE QUARTER */
	{0xBD, 0x00BD},  /* VULGAR FRACTION ONE HALF */
	{0xBE, 0x00BE},  /* VULGAR FRACTION THREE QUARTERS */
	{0xBF, 0x00BF},  /* INVERTED QUESTION MARK */
	{0xC0, 0x00C0},  /* LATIN CAPITAL LETTER A WITH GRAVE */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x00C3},  /* LATIN CAPITAL LETTER A WITH TILDE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xC7, 0x00C7},  /* LATIN CAPITAL LETTER C WITH CEDILLA */
	{0xC8, 0x00C8},  /* LATIN CAPITAL LETTER E WITH GRAVE */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x00CA},  /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x00CC},  /* LATIN CAPITAL LETTER I WITH GRAVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x00CF},  /* LATIN CAPITAL LETTER I WITH DIAERESIS */
	{0xD0, 0x011E},  /* LATIN CAPITAL LETTER G WITH BREVE */
	{0xD1, 0x00D1},  /* LATIN CAPITAL LETTER N WITH TILDE */
	{0xD2, 0x00D2},  /* LATIN CAPITAL LETTER O WITH GRAVE */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xD9, 0x00D9},  /* LATIN CAPITAL LETTER U WITH GRAVE */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x0130},  /* LATIN CAPITAL LETTER I WITH DOT ABOVE */
	{0xDE, 0x015E},  /* LATIN CAPITAL LETTER S WITH CEDILLA */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S */
	{0xE0, 0x00E0},  /* LATIN SMALL LETTER A WITH GRAVE */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x00E3},  /* LATIN SMALL LETTER A WITH TILDE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xE7, 0x00E7},  /* LATIN SMALL LETTER C WITH CEDILLA */
	{0xE8, 0x00E8},  /* LATIN SMALL LETTER E WITH GRAVE */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x00EA},  /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x00EC},  /* LATIN SMALL LETTER I WITH GRAVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x00EF},  /* LATIN SMALL LETTER I WITH DIAERESIS */
	{0xF0, 0x011F},  /* LATIN SMALL LETTER G WITH BREVE */
	{0xF1, 0x00F1},  /* LATIN SMALL LETTER N WITH TILDE */
	{0xF2, 0x00F2},  /* LATIN SMALL LETTER O WITH GRAVE */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xF9, 0x00F9},  /* LATIN SMALL LETTER U WITH GRAVE */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x0131},  /* LATIN SMALL LETTER DOTLESS I */
	{0xFE, 0x015F},  /* LATIN SMALL LETTER S WITH CEDILLA */
	{0xFF, 0x00FF},  /* LATIN SMALL LETTER Y WITH DIAERESIS */
	{0,0}
};

static const fontmap_t iso8859_10[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x0104},  /* LATIN CAPITAL LETTER A WITH OGONEK */
	{0xA2, 0x0112},  /* LATIN CAPITAL LETTER E WITH MACRON */
	{0xA3, 0x0122},  /* LATIN CAPITAL LETTER G WITH CEDILLA */
	{0xA4, 0x012A},  /* LATIN CAPITAL LETTER I WITH MACRON */
	{0xA5, 0x0128},  /* LATIN CAPITAL LETTER I WITH TILDE */
	{0xA6, 0x0136},  /* LATIN CAPITAL LETTER K WITH CEDILLA */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x013B},  /* LATIN CAPITAL LETTER L WITH CEDILLA */
	{0xA9, 0x0110},  /* LATIN CAPITAL LETTER D WITH STROKE */
	{0xAA, 0x0160},  /* LATIN CAPITAL LETTER S WITH CARON */
	{0xAB, 0x0166},  /* LATIN CAPITAL LETTER T WITH STROKE */
	{0xAC, 0x017D},  /* LATIN CAPITAL LETTER Z WITH CARON */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x016A},  /* LATIN CAPITAL LETTER U WITH MACRON */
	{0xAF, 0x014A},  /* LATIN CAPITAL LETTER ENG */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x0105},  /* LATIN SMALL LETTER A WITH OGONEK */
	{0xB2, 0x0113},  /* LATIN SMALL LETTER E WITH MACRON */
	{0xB3, 0x0123},  /* LATIN SMALL LETTER G WITH CEDILLA */
	{0xB4, 0x012B},  /* LATIN SMALL LETTER I WITH MACRON */
	{0xB5, 0x0129},  /* LATIN SMALL LETTER I WITH TILDE */
	{0xB6, 0x0137},  /* LATIN SMALL LETTER K WITH CEDILLA */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x013C},  /* LATIN SMALL LETTER L WITH CEDILLA */
	{0xB9, 0x0111},  /* LATIN SMALL LETTER D WITH STROKE */
	{0xBA, 0x0161},  /* LATIN SMALL LETTER S WITH CARON */
	{0xBB, 0x0167},  /* LATIN SMALL LETTER T WITH STROKE */
	{0xBC, 0x017E},  /* LATIN SMALL LETTER Z WITH CARON */
	{0xBD, 0x2015},  /* HORIZONTAL BAR */
	{0xBE, 0x016B},  /* LATIN SMALL LETTER U WITH MACRON */
	{0xBF, 0x014B},  /* LATIN SMALL LETTER ENG */
	{0xC0, 0x0100},  /* LATIN CAPITAL LETTER A WITH MACRON */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x00C3},  /* LATIN CAPITAL LETTER A WITH TILDE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xC7, 0x012E},  /* LATIN CAPITAL LETTER I WITH OGONEK */
	{0xC8, 0x010C},  /* LATIN CAPITAL LETTER C WITH CARON */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x0118},  /* LATIN CAPITAL LETTER E WITH OGONEK */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x0116},  /* LATIN CAPITAL LETTER E WITH DOT ABOVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x00CF},  /* LATIN CAPITAL LETTER I WITH DIAERESIS */
	{0xD0, 0x00D0},  /* LATIN CAPITAL LETTER ETH (Icelandic) */
	{0xD1, 0x0145},  /* LATIN CAPITAL LETTER N WITH CEDILLA */
	{0xD2, 0x014C},  /* LATIN CAPITAL LETTER O WITH MACRON */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x0168},  /* LATIN CAPITAL LETTER U WITH TILDE */
	{0xD8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xD9, 0x0172},  /* LATIN CAPITAL LETTER U WITH OGONEK */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x00DD},  /* LATIN CAPITAL LETTER Y WITH ACUTE */
	{0xDE, 0x00DE},  /* LATIN CAPITAL LETTER THORN (Icelandic) */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S (German) */
	{0xE0, 0x0101},  /* LATIN SMALL LETTER A WITH MACRON */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x00E3},  /* LATIN SMALL LETTER A WITH TILDE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xE7, 0x012F},  /* LATIN SMALL LETTER I WITH OGONEK */
	{0xE8, 0x010D},  /* LATIN SMALL LETTER C WITH CARON */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x0119},  /* LATIN SMALL LETTER E WITH OGONEK */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x0117},  /* LATIN SMALL LETTER E WITH DOT ABOVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x00EF},  /* LATIN SMALL LETTER I WITH DIAERESIS */
	{0xF0, 0x00F0},  /* LATIN SMALL LETTER ETH (Icelandic) */
	{0xF1, 0x0146},  /* LATIN SMALL LETTER N WITH CEDILLA */
	{0xF2, 0x014D},  /* LATIN SMALL LETTER O WITH MACRON */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x0169},  /* LATIN SMALL LETTER U WITH TILDE */
	{0xF8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xF9, 0x0173},  /* LATIN SMALL LETTER U WITH OGONEK */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x00FD},  /* LATIN SMALL LETTER Y WITH ACUTE */
	{0xFE, 0x00FE},  /* LATIN SMALL LETTER THORN (Icelandic) */
	{0xFF, 0x0138},  /* LATIN SMALL LETTER KRA */
	{0,0}
};

static const fontmap_t iso8859_13[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x201D},  /* RIGHT DOUBLE QUOTATION MARK */
	{0xA2, 0x00A2},  /* CENT SIGN */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x00A4},  /* CURRENCY SIGN */
	{0xA5, 0x201E},  /* DOUBLE LOW-9 QUOTATION MARK */
	{0xA6, 0x00A6},  /* BROKEN BAR */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAA, 0x0156},  /* LATIN CAPITAL LETTER R WITH CEDILLA */
	{0xAB, 0x00AB},  /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xAC, 0x00AC},  /* NOT SIGN */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x00AE},  /* REGISTERED SIGN */
	{0xAF, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x00B1},  /* PLUS-MINUS SIGN */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x201C},  /* LEFT DOUBLE QUOTATION MARK */
	{0xB5, 0x00B5},  /* MICRO SIGN */
	{0xB6, 0x00B6},  /* PILCROW SIGN */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xB9, 0x00B9},  /* SUPERSCRIPT ONE */
	{0xBA, 0x0157},  /* LATIN SMALL LETTER R WITH CEDILLA */
	{0xBB, 0x00BB},  /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xBC, 0x00BC},  /* VULGAR FRACTION ONE QUARTER */
	{0xBD, 0x00BD},  /* VULGAR FRACTION ONE HALF */
	{0xBE, 0x00BE},  /* VULGAR FRACTION THREE QUARTERS */
	{0xBF, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xC0, 0x0104},  /* LATIN CAPITAL LETTER A WITH OGONEK */
	{0xC1, 0x012E},  /* LATIN CAPITAL LETTER I WITH OGONEK */
	{0xC2, 0x0100},  /* LATIN CAPITAL LETTER A WITH MACRON */
	{0xC3, 0x0106},  /* LATIN CAPITAL LETTER C WITH ACUTE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x0118},  /* LATIN CAPITAL LETTER E WITH OGONEK */
	{0xC7, 0x0112},  /* LATIN CAPITAL LETTER E WITH MACRON */
	{0xC8, 0x010C},  /* LATIN CAPITAL LETTER C WITH CARON */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x0179},  /* LATIN CAPITAL LETTER Z WITH ACUTE */
	{0xCB, 0x0116},  /* LATIN CAPITAL LETTER E WITH DOT ABOVE */
	{0xCC, 0x0122},  /* LATIN CAPITAL LETTER G WITH CEDILLA */
	{0xCD, 0x0136},  /* LATIN CAPITAL LETTER K WITH CEDILLA */
	{0xCE, 0x012A},  /* LATIN CAPITAL LETTER I WITH MACRON */
	{0xCF, 0x013B},  /* LATIN CAPITAL LETTER L WITH CEDILLA */
	{0xD0, 0x0160},  /* LATIN CAPITAL LETTER S WITH CARON */
	{0xD1, 0x0143},  /* LATIN CAPITAL LETTER N WITH ACUTE */
	{0xD2, 0x0145},  /* LATIN CAPITAL LETTER N WITH CEDILLA */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x014C},  /* LATIN CAPITAL LETTER O WITH MACRON */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x0172},  /* LATIN CAPITAL LETTER U WITH OGONEK */
	{0xD9, 0x0141},  /* LATIN CAPITAL LETTER L WITH STROKE */
	{0xDA, 0x015A},  /* LATIN CAPITAL LETTER S WITH ACUTE */
	{0xDB, 0x016A},  /* LATIN CAPITAL LETTER U WITH MACRON */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x017B},  /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
	{0xDE, 0x017D},  /* LATIN CAPITAL LETTER Z WITH CARON */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S (German) */
	{0xE0, 0x0105},  /* LATIN SMALL LETTER A WITH OGONEK */
	{0xE1, 0x012F},  /* LATIN SMALL LETTER I WITH OGONEK */
	{0xE2, 0x0101},  /* LATIN SMALL LETTER A WITH MACRON */
	{0xE3, 0x0107},  /* LATIN SMALL LETTER C WITH ACUTE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x0119},  /* LATIN SMALL LETTER E WITH OGONEK */
	{0xE7, 0x0113},  /* LATIN SMALL LETTER E WITH MACRON */
	{0xE8, 0x010D},  /* LATIN SMALL LETTER C WITH CARON */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x017A},  /* LATIN SMALL LETTER Z WITH ACUTE */
	{0xEB, 0x0117},  /* LATIN SMALL LETTER E WITH DOT ABOVE */
	{0xEC, 0x0123},  /* LATIN SMALL LETTER G WITH CEDILLA */
	{0xED, 0x0137},  /* LATIN SMALL LETTER K WITH CEDILLA */
	{0xEE, 0x012B},  /* LATIN SMALL LETTER I WITH MACRON */
	{0xEF, 0x013C},  /* LATIN SMALL LETTER L WITH CEDILLA */
	{0xF0, 0x0161},  /* LATIN SMALL LETTER S WITH CARON */
	{0xF1, 0x0144},  /* LATIN SMALL LETTER N WITH ACUTE */
	{0xF2, 0x0146},  /* LATIN SMALL LETTER N WITH CEDILLA */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x014D},  /* LATIN SMALL LETTER O WITH MACRON */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x0173},  /* LATIN SMALL LETTER U WITH OGONEK */
	{0xF9, 0x0142},  /* LATIN SMALL LETTER L WITH STROKE */
	{0xFA, 0x015B},  /* LATIN SMALL LETTER S WITH ACUTE */
	{0xFB, 0x016B},  /* LATIN SMALL LETTER U WITH MACRON */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x017C},  /* LATIN SMALL LETTER Z WITH DOT ABOVE */
	{0xFE, 0x017E},  /* LATIN SMALL LETTER Z WITH CARON */
	{0xFF, 0x2019},  /* RIGHT SINGLE QUOTATION MARK */
	{0,0}
};

static const fontmap_t iso8859_14[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x1E02},  /* LATIN CAPITAL LETTER B WITH DOT ABOVE */
	{0xA2, 0x1E03},  /* LATIN SMALL LETTER B WITH DOT ABOVE */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x010A},  /* LATIN CAPITAL LETTER C WITH DOT ABOVE */
	{0xA5, 0x010B},  /* LATIN SMALL LETTER C WITH DOT ABOVE */
	{0xA6, 0x1E0A},  /* LATIN CAPITAL LETTER D WITH DOT ABOVE */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x1E80},  /* LATIN CAPITAL LETTER W WITH GRAVE */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAA, 0x1E82},  /* LATIN CAPITAL LETTER W WITH ACUTE */
	{0xAB, 0x1E0B},  /* LATIN SMALL LETTER D WITH DOT ABOVE */
	{0xAC, 0x1EF2},  /* LATIN CAPITAL LETTER Y WITH GRAVE */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x00AE},  /* REGISTERED SIGN */
	{0xAF, 0x0178},  /* LATIN CAPITAL LETTER Y WITH DIAERESIS */
	{0xB0, 0x1E1E},  /* LATIN CAPITAL LETTER F WITH DOT ABOVE */
	{0xB1, 0x1E1F},  /* LATIN SMALL LETTER F WITH DOT ABOVE */
	{0xB2, 0x0120},  /* LATIN CAPITAL LETTER G WITH DOT ABOVE */
	{0xB3, 0x0121},  /* LATIN SMALL LETTER G WITH DOT ABOVE */
	{0xB4, 0x1E40},  /* LATIN CAPITAL LETTER M WITH DOT ABOVE */
	{0xB5, 0x1E41},  /* LATIN SMALL LETTER M WITH DOT ABOVE */
	{0xB6, 0x00B6},  /* PILCROW SIGN */
	{0xB7, 0x1E56},  /* LATIN CAPITAL LETTER P WITH DOT ABOVE */
	{0xB8, 0x1E81},  /* LATIN SMALL LETTER W WITH GRAVE */
	{0xB9, 0x1E57},  /* LATIN SMALL LETTER P WITH DOT ABOVE */
	{0xBA, 0x1E83},  /* LATIN SMALL LETTER W WITH ACUTE */
	{0xBB, 0x1E60},  /* LATIN CAPITAL LETTER S WITH DOT ABOVE */
	{0xBC, 0x1EF3},  /* LATIN SMALL LETTER Y WITH GRAVE */
	{0xBD, 0x1E84},  /* LATIN CAPITAL LETTER W WITH DIAERESIS */
	{0xBE, 0x1E85},  /* LATIN SMALL LETTER W WITH DIAERESIS */
	{0xBF, 0x1E61},  /* LATIN SMALL LETTER S WITH DOT ABOVE */
	{0xC0, 0x00C0},  /* LATIN CAPITAL LETTER A WITH GRAVE */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x00C3},  /* LATIN CAPITAL LETTER A WITH TILDE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xC7, 0x00C7},  /* LATIN CAPITAL LETTER C WITH CEDILLA */
	{0xC8, 0x00C8},  /* LATIN CAPITAL LETTER E WITH GRAVE */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x00CA},  /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x00CC},  /* LATIN CAPITAL LETTER I WITH GRAVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x00CF},  /* LATIN CAPITAL LETTER I WITH DIAERESIS */
	{0xD0, 0x0174},  /* LATIN CAPITAL LETTER W WITH CIRCUMFLEX */
	{0xD1, 0x00D1},  /* LATIN CAPITAL LETTER N WITH TILDE */
	{0xD2, 0x00D2},  /* LATIN CAPITAL LETTER O WITH GRAVE */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x1E6A},  /* LATIN CAPITAL LETTER T WITH DOT ABOVE */
	{0xD8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xD9, 0x00D9},  /* LATIN CAPITAL LETTER U WITH GRAVE */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x00DD},  /* LATIN CAPITAL LETTER Y WITH ACUTE */
	{0xDE, 0x0176},  /* LATIN CAPITAL LETTER Y WITH CIRCUMFLEX */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S */
	{0xE0, 0x00E0},  /* LATIN SMALL LETTER A WITH GRAVE */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x00E3},  /* LATIN SMALL LETTER A WITH TILDE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xE7, 0x00E7},  /* LATIN SMALL LETTER C WITH CEDILLA */
	{0xE8, 0x00E8},  /* LATIN SMALL LETTER E WITH GRAVE */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x00EA},  /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x00EC},  /* LATIN SMALL LETTER I WITH GRAVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x00EF},  /* LATIN SMALL LETTER I WITH DIAERESIS */
	{0xF0, 0x0175},  /* LATIN SMALL LETTER W WITH CIRCUMFLEX */
	{0xF1, 0x00F1},  /* LATIN SMALL LETTER N WITH TILDE */
	{0xF2, 0x00F2},  /* LATIN SMALL LETTER O WITH GRAVE */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x1E6B},  /* LATIN SMALL LETTER T WITH DOT ABOVE */
	{0xF8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xF9, 0x00F9},  /* LATIN SMALL LETTER U WITH GRAVE */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x00FD},  /* LATIN SMALL LETTER Y WITH ACUTE */
	{0xFE, 0x0177},  /* LATIN SMALL LETTER Y WITH CIRCUMFLEX */
	{0xFF, 0x00FF},  /* LATIN SMALL LETTER Y WITH DIAERESIS */
	{0,0}
};

static const fontmap_t iso8859_15[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0xA0, 0x00A0},  /* NO-BREAK SPACE */
	{0xA1, 0x00A1},  /* INVERTED EXCLAMATION MARK */
	{0xA2, 0x00A2},  /* CENT SIGN */
	{0xA3, 0x00A3},  /* POUND SIGN */
	{0xA4, 0x20AC},  /* EURO SIGN */
	{0xA5, 0x00A5},  /* YEN SIGN */
	{0xA6, 0x0160},  /* LATIN CAPITAL LETTER S WITH CARON */
	{0xA7, 0x00A7},  /* SECTION SIGN */
	{0xA8, 0x0161},  /* LATIN SMALL LETTER S WITH CARON */
	{0xA9, 0x00A9},  /* COPYRIGHT SIGN */
	{0xAA, 0x00AA},  /* FEMININE ORDINAL INDICATOR */
	{0xAB, 0x00AB},  /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xAC, 0x00AC},  /* NOT SIGN */
	{0xAD, 0x00AD},  /* SOFT HYPHEN */
	{0xAE, 0x00AE},  /* REGISTERED SIGN */
	{0xAF, 0x00AF},  /* MACRON */
	{0xB0, 0x00B0},  /* DEGREE SIGN */
	{0xB1, 0x00B1},  /* PLUS-MINUS SIGN */
	{0xB2, 0x00B2},  /* SUPERSCRIPT TWO */
	{0xB3, 0x00B3},  /* SUPERSCRIPT THREE */
	{0xB4, 0x017D},  /* LATIN CAPITAL LETTER Z WITH CARON */
	{0xB5, 0x00B5},  /* MICRO SIGN */
	{0xB6, 0x00B6},  /* PILCROW SIGN */
	{0xB7, 0x00B7},  /* MIDDLE DOT */
	{0xB8, 0x017E},  /* LATIN SMALL LETTER Z WITH CARON */
	{0xB9, 0x00B9},  /* SUPERSCRIPT ONE */
	{0xBA, 0x00BA},  /* MASCULINE ORDINAL INDICATOR */
	{0xBB, 0x00BB},  /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
	{0xBC, 0x0152},  /* LATIN CAPITAL LIGATURE OE */
	{0xBD, 0x0153},  /* LATIN SMALL LIGATURE OE */
	{0xBE, 0x0178},  /* LATIN CAPITAL LETTER Y WITH DIAERESIS */
	{0xBF, 0x00BF},  /* INVERTED QUESTION MARK */
	{0xC0, 0x00C0},  /* LATIN CAPITAL LETTER A WITH GRAVE */
	{0xC1, 0x00C1},  /* LATIN CAPITAL LETTER A WITH ACUTE */
	{0xC2, 0x00C2},  /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
	{0xC3, 0x00C3},  /* LATIN CAPITAL LETTER A WITH TILDE */
	{0xC4, 0x00C4},  /* LATIN CAPITAL LETTER A WITH DIAERESIS */
	{0xC5, 0x00C5},  /* LATIN CAPITAL LETTER A WITH RING ABOVE */
	{0xC6, 0x00C6},  /* LATIN CAPITAL LETTER AE */
	{0xC7, 0x00C7},  /* LATIN CAPITAL LETTER C WITH CEDILLA */
	{0xC8, 0x00C8},  /* LATIN CAPITAL LETTER E WITH GRAVE */
	{0xC9, 0x00C9},  /* LATIN CAPITAL LETTER E WITH ACUTE */
	{0xCA, 0x00CA},  /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
	{0xCB, 0x00CB},  /* LATIN CAPITAL LETTER E WITH DIAERESIS */
	{0xCC, 0x00CC},  /* LATIN CAPITAL LETTER I WITH GRAVE */
	{0xCD, 0x00CD},  /* LATIN CAPITAL LETTER I WITH ACUTE */
	{0xCE, 0x00CE},  /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	{0xCF, 0x00CF},  /* LATIN CAPITAL LETTER I WITH DIAERESIS */
	{0xD0, 0x00D0},  /* LATIN CAPITAL LETTER ETH */
	{0xD1, 0x00D1},  /* LATIN CAPITAL LETTER N WITH TILDE */
	{0xD2, 0x00D2},  /* LATIN CAPITAL LETTER O WITH GRAVE */
	{0xD3, 0x00D3},  /* LATIN CAPITAL LETTER O WITH ACUTE */
	{0xD4, 0x00D4},  /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
	{0xD5, 0x00D5},  /* LATIN CAPITAL LETTER O WITH TILDE */
	{0xD6, 0x00D6},  /* LATIN CAPITAL LETTER O WITH DIAERESIS */
	{0xD7, 0x00D7},  /* MULTIPLICATION SIGN */
	{0xD8, 0x00D8},  /* LATIN CAPITAL LETTER O WITH STROKE */
	{0xD9, 0x00D9},  /* LATIN CAPITAL LETTER U WITH GRAVE */
	{0xDA, 0x00DA},  /* LATIN CAPITAL LETTER U WITH ACUTE */
	{0xDB, 0x00DB},  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
	{0xDC, 0x00DC},  /* LATIN CAPITAL LETTER U WITH DIAERESIS */
	{0xDD, 0x00DD},  /* LATIN CAPITAL LETTER Y WITH ACUTE */
	{0xDE, 0x00DE},  /* LATIN CAPITAL LETTER THORN */
	{0xDF, 0x00DF},  /* LATIN SMALL LETTER SHARP S */
	{0xE0, 0x00E0},  /* LATIN SMALL LETTER A WITH GRAVE */
	{0xE1, 0x00E1},  /* LATIN SMALL LETTER A WITH ACUTE */
	{0xE2, 0x00E2},  /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
	{0xE3, 0x00E3},  /* LATIN SMALL LETTER A WITH TILDE */
	{0xE4, 0x00E4},  /* LATIN SMALL LETTER A WITH DIAERESIS */
	{0xE5, 0x00E5},  /* LATIN SMALL LETTER A WITH RING ABOVE */
	{0xE6, 0x00E6},  /* LATIN SMALL LETTER AE */
	{0xE7, 0x00E7},  /* LATIN SMALL LETTER C WITH CEDILLA */
	{0xE8, 0x00E8},  /* LATIN SMALL LETTER E WITH GRAVE */
	{0xE9, 0x00E9},  /* LATIN SMALL LETTER E WITH ACUTE */
	{0xEA, 0x00EA},  /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
	{0xEB, 0x00EB},  /* LATIN SMALL LETTER E WITH DIAERESIS */
	{0xEC, 0x00EC},  /* LATIN SMALL LETTER I WITH GRAVE */
	{0xED, 0x00ED},  /* LATIN SMALL LETTER I WITH ACUTE */
	{0xEE, 0x00EE},  /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
	{0xEF, 0x00EF},  /* LATIN SMALL LETTER I WITH DIAERESIS */
	{0xF0, 0x00F0},  /* LATIN SMALL LETTER ETH */
	{0xF1, 0x00F1},  /* LATIN SMALL LETTER N WITH TILDE */
	{0xF2, 0x00F2},  /* LATIN SMALL LETTER O WITH GRAVE */
	{0xF3, 0x00F3},  /* LATIN SMALL LETTER O WITH ACUTE */
	{0xF4, 0x00F4},  /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
	{0xF5, 0x00F5},  /* LATIN SMALL LETTER O WITH TILDE */
	{0xF6, 0x00F6},  /* LATIN SMALL LETTER O WITH DIAERESIS */
	{0xF7, 0x00F7},  /* DIVISION SIGN */
	{0xF8, 0x00F8},  /* LATIN SMALL LETTER O WITH STROKE */
	{0xF9, 0x00F9},  /* LATIN SMALL LETTER U WITH GRAVE */
	{0xFA, 0x00FA},  /* LATIN SMALL LETTER U WITH ACUTE */
	{0xFB, 0x00FB},  /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
	{0xFC, 0x00FC},  /* LATIN SMALL LETTER U WITH DIAERESIS */
	{0xFD, 0x00FD},  /* LATIN SMALL LETTER Y WITH ACUTE */
	{0xFE, 0x00FE},  /* LATIN SMALL LETTER THORN */
	{0xFF, 0x00FF},  /* LATIN SMALL LETTER Y WITH DIAERESIS */
	{0,0}
};

static const fontmap_t jisx201_1976[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x00A5},  /* YEN SIGN */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x203E},  /* OVERLINE */
	{0xA1, 0xFF61},  /* HALFWIDTH IDEOGRAPHIC FULL STOP */
	{0xA2, 0xFF62},  /* HALFWIDTH LEFT CORNER BRACKET */
	{0xA3, 0xFF63},  /* HALFWIDTH RIGHT CORNER BRACKET */
	{0xA4, 0xFF64},  /* HALFWIDTH IDEOGRAPHIC COMMA */
	{0xA5, 0xFF65},  /* HALFWIDTH KATAKANA MIDDLE DOT */
	{0xA6, 0xFF66},  /* HALFWIDTH KATAKANA LETTER WO */
	{0xA7, 0xFF67},  /* HALFWIDTH KATAKANA LETTER SMALL A */
	{0xA8, 0xFF68},  /* HALFWIDTH KATAKANA LETTER SMALL I */
	{0xA9, 0xFF69},  /* HALFWIDTH KATAKANA LETTER SMALL U */
	{0xAA, 0xFF6A},  /* HALFWIDTH KATAKANA LETTER SMALL E */
	{0xAB, 0xFF6B},  /* HALFWIDTH KATAKANA LETTER SMALL O */
	{0xAC, 0xFF6C},  /* HALFWIDTH KATAKANA LETTER SMALL YA */
	{0xAD, 0xFF6D},  /* HALFWIDTH KATAKANA LETTER SMALL YU */
	{0xAE, 0xFF6E},  /* HALFWIDTH KATAKANA LETTER SMALL YO */
	{0xAF, 0xFF6F},  /* HALFWIDTH KATAKANA LETTER SMALL TU */
	{0xB0, 0xFF70},  /* HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK */
	{0xB1, 0xFF71},  /* HALFWIDTH KATAKANA LETTER A */
	{0xB2, 0xFF72},  /* HALFWIDTH KATAKANA LETTER I */
	{0xB3, 0xFF73},  /* HALFWIDTH KATAKANA LETTER U */
	{0xB4, 0xFF74},  /* HALFWIDTH KATAKANA LETTER E */
	{0xB5, 0xFF75},  /* HALFWIDTH KATAKANA LETTER O */
	{0xB6, 0xFF76},  /* HALFWIDTH KATAKANA LETTER KA */
	{0xB7, 0xFF77},  /* HALFWIDTH KATAKANA LETTER KI */
	{0xB8, 0xFF78},  /* HALFWIDTH KATAKANA LETTER KU */
	{0xB9, 0xFF79},  /* HALFWIDTH KATAKANA LETTER KE */
	{0xBA, 0xFF7A},  /* HALFWIDTH KATAKANA LETTER KO */
	{0xBB, 0xFF7B},  /* HALFWIDTH KATAKANA LETTER SA */
	{0xBC, 0xFF7C},  /* HALFWIDTH KATAKANA LETTER SI */
	{0xBD, 0xFF7D},  /* HALFWIDTH KATAKANA LETTER SU */
	{0xBE, 0xFF7E},  /* HALFWIDTH KATAKANA LETTER SE */
	{0xBF, 0xFF7F},  /* HALFWIDTH KATAKANA LETTER SO */
	{0xC0, 0xFF80},  /* HALFWIDTH KATAKANA LETTER TA */
	{0xC1, 0xFF81},  /* HALFWIDTH KATAKANA LETTER TI */
	{0xC2, 0xFF82},  /* HALFWIDTH KATAKANA LETTER TU */
	{0xC3, 0xFF83},  /* HALFWIDTH KATAKANA LETTER TE */
	{0xC4, 0xFF84},  /* HALFWIDTH KATAKANA LETTER TO */
	{0xC5, 0xFF85},  /* HALFWIDTH KATAKANA LETTER NA */
	{0xC6, 0xFF86},  /* HALFWIDTH KATAKANA LETTER NI */
	{0xC7, 0xFF87},  /* HALFWIDTH KATAKANA LETTER NU */
	{0xC8, 0xFF88},  /* HALFWIDTH KATAKANA LETTER NE */
	{0xC9, 0xFF89},  /* HALFWIDTH KATAKANA LETTER NO */
	{0xCA, 0xFF8A},  /* HALFWIDTH KATAKANA LETTER HA */
	{0xCB, 0xFF8B},  /* HALFWIDTH KATAKANA LETTER HI */
	{0xCC, 0xFF8C},  /* HALFWIDTH KATAKANA LETTER HU */
	{0xCD, 0xFF8D},  /* HALFWIDTH KATAKANA LETTER HE */
	{0xCE, 0xFF8E},  /* HALFWIDTH KATAKANA LETTER HO */
	{0xCF, 0xFF8F},  /* HALFWIDTH KATAKANA LETTER MA */
	{0xD0, 0xFF90},  /* HALFWIDTH KATAKANA LETTER MI */
	{0xD1, 0xFF91},  /* HALFWIDTH KATAKANA LETTER MU */
	{0xD2, 0xFF92},  /* HALFWIDTH KATAKANA LETTER ME */
	{0xD3, 0xFF93},  /* HALFWIDTH KATAKANA LETTER MO */
	{0xD4, 0xFF94},  /* HALFWIDTH KATAKANA LETTER YA */
	{0xD5, 0xFF95},  /* HALFWIDTH KATAKANA LETTER YU */
	{0xD6, 0xFF96},  /* HALFWIDTH KATAKANA LETTER YO */
	{0xD7, 0xFF97},  /* HALFWIDTH KATAKANA LETTER RA */
	{0xD8, 0xFF98},  /* HALFWIDTH KATAKANA LETTER RI */
	{0xD9, 0xFF99},  /* HALFWIDTH KATAKANA LETTER RU */
	{0xDA, 0xFF9A},  /* HALFWIDTH KATAKANA LETTER RE */
	{0xDB, 0xFF9B},  /* HALFWIDTH KATAKANA LETTER RO */
	{0xDC, 0xFF9C},  /* HALFWIDTH KATAKANA LETTER WA */
	{0xDD, 0xFF9D},  /* HALFWIDTH KATAKANA LETTER N */
	{0xDE, 0xFF9E},  /* HALFWIDTH KATAKANA VOICED SOUND MARK */
	{0xDF, 0xFF9F},  /* HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK */
	{0,0}
};

static const fontmap_t koi8_r[] = {
	{0x01, 0x25C6},  /* BLACK DIAMOND */
	{0x02, 0x2592},  /* MEDIUM SHADE */
	{0x03, 0x2409},  /* SYMBOL FOR HORIZONTAL TABULATION */
	{0x04, 0x240C},  /* SYMBOL FOR FORM FEED */
	{0x05, 0x240D},  /* SYMBOL FOR CARRIAGE RETURN */
	{0x06, 0x240A},  /* SYMBOL FOR LINE FEED */
	{0x07, 0x00B0},  /* DEGREE SIGN */
	{0x08, 0x00B1},  /* PLUS-MINUS SIGN */
	{0x09, 0x2424},  /* SYMBOL FOR NEWLINE */
	{0x0A, 0x240B},  /* SYMBOL FOR VERTICAL TABULATION */
	{0x0B, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x0C, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x0D, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x0E, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x0F, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x12, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x15, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x16, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x17, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x18, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x19, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x1A, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x1B, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x1C, 0x03C0},  /* GREEK SMALL LETTER PI */
	{0x1D, 0x2260},  /* NOT EQUAL TO */
	{0x1E, 0x00A3},  /* POUND SIGN */
	{0x1F, 0x00B7},  /* MIDDLE DOT */
	{0x20, 0x0020},  /* SPACE */
	{0x21, 0x0021},  /* EXCLAMATION MARK */
	{0x22, 0x0022},  /* QUOTATION MARK */
	{0x23, 0x0023},  /* NUMBER SIGN */
	{0x24, 0x0024},  /* DOLLAR SIGN */
	{0x25, 0x0025},  /* PERCENT SIGN */
	{0x26, 0x0026},  /* AMPERSAND */
	{0x27, 0x0027},  /* APOSTROPHE */
	{0x28, 0x0028},  /* LEFT PARENTHESIS */
	{0x29, 0x0029},  /* RIGHT PARENTHESIS */
	{0x2A, 0x002A},  /* ASTERISK */
	{0x2B, 0x002B},  /* PLUS SIGN */
	{0x2C, 0x002C},  /* COMMA */
	{0x2D, 0x002D},  /* HYPHEN-MINUS */
	{0x2E, 0x002E},  /* FULL STOP */
	{0x2F, 0x002F},  /* SOLIDUS */
	{0x30, 0x0030},  /* DIGIT ZERO */
	{0x31, 0x0031},  /* DIGIT ONE */
	{0x32, 0x0032},  /* DIGIT TWO */
	{0x33, 0x0033},  /* DIGIT THREE */
	{0x34, 0x0034},  /* DIGIT FOUR */
	{0x35, 0x0035},  /* DIGIT FIVE */
	{0x36, 0x0036},  /* DIGIT SIX */
	{0x37, 0x0037},  /* DIGIT SEVEN */
	{0x38, 0x0038},  /* DIGIT EIGHT */
	{0x39, 0x0039},  /* DIGIT NINE */
	{0x3A, 0x003A},  /* COLON */
	{0x3B, 0x003B},  /* SEMICOLON */
	{0x3C, 0x003C},  /* LESS-THAN SIGN */
	{0x3D, 0x003D},  /* EQUALS SIGN */
	{0x3E, 0x003E},  /* GREATER-THAN SIGN */
	{0x3F, 0x003F},  /* QUESTION MARK */
	{0x40, 0x0040},  /* COMMERCIAL AT */
	{0x41, 0x0041},  /* LATIN CAPITAL LETTER A */
	{0x42, 0x0042},  /* LATIN CAPITAL LETTER B */
	{0x43, 0x0043},  /* LATIN CAPITAL LETTER C */
	{0x44, 0x0044},  /* LATIN CAPITAL LETTER D */
	{0x45, 0x0045},  /* LATIN CAPITAL LETTER E */
	{0x46, 0x0046},  /* LATIN CAPITAL LETTER F */
	{0x47, 0x0047},  /* LATIN CAPITAL LETTER G */
	{0x48, 0x0048},  /* LATIN CAPITAL LETTER H */
	{0x49, 0x0049},  /* LATIN CAPITAL LETTER I */
	{0x4A, 0x004A},  /* LATIN CAPITAL LETTER J */
	{0x4B, 0x004B},  /* LATIN CAPITAL LETTER K */
	{0x4C, 0x004C},  /* LATIN CAPITAL LETTER L */
	{0x4D, 0x004D},  /* LATIN CAPITAL LETTER M */
	{0x4E, 0x004E},  /* LATIN CAPITAL LETTER N */
	{0x4F, 0x004F},  /* LATIN CAPITAL LETTER O */
	{0x50, 0x0050},  /* LATIN CAPITAL LETTER P */
	{0x51, 0x0051},  /* LATIN CAPITAL LETTER Q */
	{0x52, 0x0052},  /* LATIN CAPITAL LETTER R */
	{0x53, 0x0053},  /* LATIN CAPITAL LETTER S */
	{0x54, 0x0054},  /* LATIN CAPITAL LETTER T */
	{0x55, 0x0055},  /* LATIN CAPITAL LETTER U */
	{0x56, 0x0056},  /* LATIN CAPITAL LETTER V */
	{0x57, 0x0057},  /* LATIN CAPITAL LETTER W */
	{0x58, 0x0058},  /* LATIN CAPITAL LETTER X */
	{0x59, 0x0059},  /* LATIN CAPITAL LETTER Y */
	{0x5A, 0x005A},  /* LATIN CAPITAL LETTER Z */
	{0x5B, 0x005B},  /* LEFT SQUARE BRACKET */
	{0x5C, 0x005C},  /* REVERSE SOLIDUS */
	{0x5D, 0x005D},  /* RIGHT SQUARE BRACKET */
	{0x5E, 0x005E},  /* CIRCUMFLEX ACCENT */
	{0x5F, 0x005F},  /* LOW LINE */
	{0x60, 0x0060},  /* GRAVE ACCENT */
	{0x61, 0x0061},  /* LATIN SMALL LETTER A */
	{0x62, 0x0062},  /* LATIN SMALL LETTER B */
	{0x63, 0x0063},  /* LATIN SMALL LETTER C */
	{0x64, 0x0064},  /* LATIN SMALL LETTER D */
	{0x65, 0x0065},  /* LATIN SMALL LETTER E */
	{0x66, 0x0066},  /* LATIN SMALL LETTER F */
	{0x67, 0x0067},  /* LATIN SMALL LETTER G */
	{0x68, 0x0068},  /* LATIN SMALL LETTER H */
	{0x69, 0x0069},  /* LATIN SMALL LETTER I */
	{0x6A, 0x006A},  /* LATIN SMALL LETTER J */
	{0x6B, 0x006B},  /* LATIN SMALL LETTER K */
	{0x6C, 0x006C},  /* LATIN SMALL LETTER L */
	{0x6D, 0x006D},  /* LATIN SMALL LETTER M */
	{0x6E, 0x006E},  /* LATIN SMALL LETTER N */
	{0x6F, 0x006F},  /* LATIN SMALL LETTER O */
	{0x70, 0x0070},  /* LATIN SMALL LETTER P */
	{0x71, 0x0071},  /* LATIN SMALL LETTER Q */
	{0x72, 0x0072},  /* LATIN SMALL LETTER R */
	{0x73, 0x0073},  /* LATIN SMALL LETTER S */
	{0x74, 0x0074},  /* LATIN SMALL LETTER T */
	{0x75, 0x0075},  /* LATIN SMALL LETTER U */
	{0x76, 0x0076},  /* LATIN SMALL LETTER V */
	{0x77, 0x0077},  /* LATIN SMALL LETTER W */
	{0x78, 0x0078},  /* LATIN SMALL LETTER X */
	{0x79, 0x0079},  /* LATIN SMALL LETTER Y */
	{0x7A, 0x007A},  /* LATIN SMALL LETTER Z */
	{0x7B, 0x007B},  /* LEFT CURLY BRACKET */
	{0x7C, 0x007C},  /* VERTICAL LINE */
	{0x7D, 0x007D},  /* RIGHT CURLY BRACKET */
	{0x7E, 0x007E},  /* TILDE */
	{0x80, 0x2500},  /* BOX DRAWINGS LIGHT HORIZONTAL */
	{0x81, 0x2502},  /* BOX DRAWINGS LIGHT VERTICAL */
	{0x82, 0x250C},  /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
	{0x83, 0x2510},  /* BOX DRAWINGS LIGHT DOWN AND LEFT */
	{0x84, 0x2514},  /* BOX DRAWINGS LIGHT UP AND RIGHT */
	{0x85, 0x2518},  /* BOX DRAWINGS LIGHT UP AND LEFT */
	{0x86, 0x251C},  /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
	{0x87, 0x2524},  /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
	{0x88, 0x252C},  /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
	{0x89, 0x2534},  /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
	{0x8A, 0x253C},  /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
	{0x8B, 0x2580},  /* UPPER HALF BLOCK */
	{0x8C, 0x2584},  /* LOWER HALF BLOCK */
	{0x8D, 0x2588},  /* FULL BLOCK */
	{0x8E, 0x258C},  /* LEFT HALF BLOCK */
	{0x8F, 0x2590},  /* RIGHT HALF BLOCK */
	{0x90, 0x2591},  /* LIGHT SHADE */
	{0x91, 0x2592},  /* MEDIUM SHADE */
	{0x92, 0x2593},  /* DARK SHADE */
	{0x93, 0x2320},  /* TOP HALF INTEGRAL */
	{0x94, 0x25A0},  /* BLACK SQUARE */
	{0x95, 0x2219},  /* BULLET OPERATOR */
	{0x96, 0x221A},  /* SQUARE ROOT */
	{0x97, 0x2248},  /* ALMOST EQUAL TO */
	{0x98, 0x2264},  /* LESS-THAN OR EQUAL TO */
	{0x99, 0x2265},  /* GREATER-THAN OR EQUAL TO */
	{0x9A, 0x00A0},  /* NO-BREAK SPACE */
	{0x9B, 0x2321},  /* BOTTOM HALF INTEGRAL */
	{0x9C, 0x00B0},  /* DEGREE SIGN */
	{0x9D, 0x00B2},  /* SUPERSCRIPT TWO */
	{0x9E, 0x00B7},  /* MIDDLE DOT */
	{0x9F, 0x00F7},  /* DIVISION SIGN */
	{0xA0, 0x2550},  /* BOX DRAWINGS DOUBLE HORIZONTAL */
	{0xA1, 0x2551},  /* BOX DRAWINGS DOUBLE VERTICAL */
	{0xA2, 0x2552},  /* BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE */
	{0xA3, 0x0451},  /* CYRILLIC SMALL LETTER IO */
	{0xA4, 0x2553},  /* BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE */
	{0xA5, 0x2554},  /* BOX DRAWINGS DOUBLE DOWN AND RIGHT */
	{0xA6, 0x2555},  /* BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE */
	{0xA7, 0x2556},  /* BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE */
	{0xA8, 0x2557},  /* BOX DRAWINGS DOUBLE DOWN AND LEFT */
	{0xA9, 0x2558},  /* BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE */
	{0xAA, 0x2559},  /* BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE */
	{0xAB, 0x255A},  /* BOX DRAWINGS DOUBLE UP AND RIGHT */
	{0xAC, 0x255B},  /* BOX DRAWINGS UP SINGLE AND LEFT DOUBLE */
	{0xAD, 0x255C},  /* BOX DRAWINGS UP DOUBLE AND LEFT SINGLE */
	{0xAE, 0x255D},  /* BOX DRAWINGS DOUBLE UP AND LEFT */
	{0xAF, 0x255E},  /* BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */
	{0xB0, 0x255F},  /* BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE */
	{0xB1, 0x2560},  /* BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
	{0xB2, 0x2561},  /* BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */
	{0xB3, 0x0401},  /* CYRILLIC CAPITAL LETTER IO */
	{0xB4, 0x2562},  /* BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE */
	{0xB5, 0x2563},  /* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
	{0xB6, 0x2564},  /* BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE */
	{0xB7, 0x2565},  /* BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE */
	{0xB8, 0x2566},  /* BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
	{0xB9, 0x2567},  /* BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE */
	{0xBA, 0x2568},  /* BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE */
	{0xBB, 0x2569},  /* BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
	{0xBC, 0x256A},  /* BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */
	{0xBD, 0x256B},  /* BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE */
	{0xBE, 0x256C},  /* BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */
	{0xBF, 0x00A9},  /* COPYRIGHT SIGN */
	{0xC0, 0x044E},  /* CYRILLIC SMALL LETTER YU */
	{0xC1, 0x0430},  /* CYRILLIC SMALL LETTER A */
	{0xC2, 0x0431},  /* CYRILLIC SMALL LETTER BE */
	{0xC3, 0x0446},  /* CYRILLIC SMALL LETTER TSE */
	{0xC4, 0x0434},  /* CYRILLIC SMALL LETTER DE */
	{0xC5, 0x0435},  /* CYRILLIC SMALL LETTER IE */
	{0xC6, 0x0444},  /* CYRILLIC SMALL LETTER EF */
	{0xC7, 0x0433},  /* CYRILLIC SMALL LETTER GHE */
	{0xC8, 0x0445},  /* CYRILLIC SMALL LETTER HA */
	{0xC9, 0x0438},  /* CYRILLIC SMALL LETTER I */
	{0xCA, 0x0439},  /* CYRILLIC SMALL LETTER SHORT I */
	{0xCB, 0x043A},  /* CYRILLIC SMALL LETTER KA */
	{0xCC, 0x043B},  /* CYRILLIC SMALL LETTER EL */
	{0xCD, 0x043C},  /* CYRILLIC SMALL LETTER EM */
	{0xCE, 0x043D},  /* CYRILLIC SMALL LETTER EN */
	{0xCF, 0x043E},  /* CYRILLIC SMALL LETTER O */
	{0xD0, 0x043F},  /* CYRILLIC SMALL LETTER PE */
	{0xD1, 0x044F},  /* CYRILLIC SMALL LETTER YA */
	{0xD2, 0x0440},  /* CYRILLIC SMALL LETTER ER */
	{0xD3, 0x0441},  /* CYRILLIC SMALL LETTER ES */
	{0xD4, 0x0442},  /* CYRILLIC SMALL LETTER TE */
	{0xD5, 0x0443},  /* CYRILLIC SMALL LETTER U */
	{0xD6, 0x0436},  /* CYRILLIC SMALL LETTER ZHE */
	{0xD7, 0x0432},  /* CYRILLIC SMALL LETTER VE */
	{0xD8, 0x044C},  /* CYRILLIC SMALL LETTER SOFT SIGN */
	{0xD9, 0x044B},  /* CYRILLIC SMALL LETTER YERU */
	{0xDA, 0x0437},  /* CYRILLIC SMALL LETTER ZE */
	{0xDB, 0x0448},  /* CYRILLIC SMALL LETTER SHA */
	{0xDC, 0x044D},  /* CYRILLIC SMALL LETTER E */
	{0xDD, 0x0449},  /* CYRILLIC SMALL LETTER SHCHA */
	{0xDE, 0x0447},  /* CYRILLIC SMALL LETTER CHE */
	{0xDF, 0x044A},  /* CYRILLIC SMALL LETTER HARD SIGN */
	{0xE0, 0x042E},  /* CYRILLIC CAPITAL LETTER YU */
	{0xE1, 0x0410},  /* CYRILLIC CAPITAL LETTER A */
	{0xE2, 0x0411},  /* CYRILLIC CAPITAL LETTER BE */
	{0xE3, 0x0426},  /* CYRILLIC CAPITAL LETTER TSE */
	{0xE4, 0x0414},  /* CYRILLIC CAPITAL LETTER DE */
	{0xE5, 0x0415},  /* CYRILLIC CAPITAL LETTER IE */
	{0xE6, 0x0424},  /* CYRILLIC CAPITAL LETTER EF */
	{0xE7, 0x0413},  /* CYRILLIC CAPITAL LETTER GHE */
	{0xE8, 0x0425},  /* CYRILLIC CAPITAL LETTER HA */
	{0xE9, 0x0418},  /* CYRILLIC CAPITAL LETTER I */
	{0xEA, 0x0419},  /* CYRILLIC CAPITAL LETTER SHORT I */
	{0xEB, 0x041A},  /* CYRILLIC CAPITAL LETTER KA */
	{0xEC, 0x041B},  /* CYRILLIC CAPITAL LETTER EL */
	{0xED, 0x041C},  /* CYRILLIC CAPITAL LETTER EM */
	{0xEE, 0x041D},  /* CYRILLIC CAPITAL LETTER EN */
	{0xEF, 0x041E},  /* CYRILLIC CAPITAL LETTER O */
	{0xF0, 0x041F},  /* CYRILLIC CAPITAL LETTER PE */
	{0xF1, 0x042F},  /* CYRILLIC CAPITAL LETTER YA */
	{0xF2, 0x0420},  /* CYRILLIC CAPITAL LETTER ER */
	{0xF3, 0x0421},  /* CYRILLIC CAPITAL LETTER ES */
	{0xF4, 0x0422},  /* CYRILLIC CAPITAL LETTER TE */
	{0xF5, 0x0423},  /* CYRILLIC CAPITAL LETTER U */
	{0xF6, 0x0416},  /* CYRILLIC CAPITAL LETTER ZHE */
	{0xF7, 0x0412},  /* CYRILLIC CAPITAL LETTER VE */
	{0xF8, 0x042C},  /* CYRILLIC CAPITAL LETTER SOFT SIGN */
	{0xF9, 0x042B},  /* CYRILLIC CAPITAL LETTER YERU */
	{0xFA, 0x0417},  /* CYRILLIC CAPITAL LETTER ZE */
	{0xFB, 0x0428},  /* CYRILLIC CAPITAL LETTER SHA */
	{0xFC, 0x042D},  /* CYRILLIC CAPITAL LETTER E */
	{0xFD, 0x0429},  /* CYRILLIC CAPITAL LETTER SHCHA */
	{0xFE, 0x0427},  /* CYRILLIC CAPITAL LETTER CHE */
	{0xFF, 0x042A},  /* CYRILLIC CAPITAL LETTER HARD SIGN */
	{0,0}
};

/* IBM Codepage 437 mapped to Unicode */
static const fontmap_t cp437[] = {
	{0x01, 0x263a},
	{0x02, 0x263b},
	{0x03, 0x2665},
	{0x04, 0x2666},
	{0x05, 0x2663},
	{0x06, 0x2660},
	{0x07, 0x2022},
	{0x08, 0x25d8},
	{0x09, 0x25cb},
	{0x0a, 0x25d9},
	{0x0b, 0x2642},
	{0x0c, 0x2640},
	{0x0d, 0x266a},
	{0x0e, 0x266b},
	{0x0f, 0x263c},
	{0x10, 0x25b6},
	{0x11, 0x25c0},
	{0x12, 0x2195},
	{0x13, 0x203c},
	{0x14, 0x00b6},
	{0x15, 0x00a7},
	{0x16, 0x25ac},
	{0x17, 0x21a8},
	{0x18, 0x2191},
	{0x19, 0x2193},
	{0x1a, 0x2192},
	{0x1b, 0x2190},
	{0x1c, 0x221f},
	{0x1d, 0x2194},
	{0x1e, 0x25b2},
	{0x1f, 0x25bc},
	{0x20, 0x0020},
	{0x21, 0x0021},
	{0x22, 0x0022},
	{0x23, 0x0023},
	{0x24, 0x0024},
	{0x25, 0x0025},
	{0x26, 0x0026},
	{0x27, 0x0027},
	{0x28, 0x0028},
	{0x29, 0x0029},
	{0x2a, 0x002a},
	{0x2b, 0x002b},
	{0x2c, 0x002c},
	{0x2d, 0x002d},
	{0x2e, 0x002e},
	{0x2f, 0x002f},
	{0x30, 0x0030},
	{0x31, 0x0031},
	{0x32, 0x0032},
	{0x33, 0x0033},
	{0x34, 0x0034},
	{0x35, 0x0035},
	{0x36, 0x0036},
	{0x37, 0x0037},
	{0x38, 0x0038},
	{0x39, 0x0039},
	{0x3a, 0x003a},
	{0x3b, 0x003b},
	{0x3c, 0x003c},
	{0x3d, 0x003d},
	{0x3e, 0x003e},
	{0x3f, 0x003f},
	{0x40, 0x0040},
	{0x41, 0x0041},
	{0x42, 0x0042},
	{0x43, 0x0043},
	{0x44, 0x0044},
	{0x45, 0x0045},
	{0x46, 0x0046},
	{0x47, 0x0047},
	{0x48, 0x0048},
	{0x49, 0x0049},
	{0x4a, 0x004a},
	{0x4b, 0x004b},
	{0x4c, 0x004c},
	{0x4d, 0x004d},
	{0x4e, 0x004e},
	{0x4f, 0x004f},
	{0x50, 0x0050},
	{0x51, 0x0051},
	{0x52, 0x0052},
	{0x53, 0x0053},
	{0x54, 0x0054},
	{0x55, 0x0055},
	{0x56, 0x0056},
	{0x57, 0x0057},
	{0x58, 0x0058},
	{0x59, 0x0059},
	{0x5a, 0x005a},
	{0x5b, 0x005b},
	{0x5c, 0x005c},
	{0x5d, 0x005d},
	{0x5e, 0x005e},
	{0x5f, 0x005f},
	{0x60, 0x0060},
	{0x61, 0x0061},
	{0x62, 0x0062},
	{0x63, 0x0063},
	{0x64, 0x0064},
	{0x65, 0x0065},
	{0x66, 0x0066},
	{0x67, 0x0067},
	{0x68, 0x0068},
	{0x69, 0x0069},
	{0x6a, 0x006a},
	{0x6b, 0x006b},
	{0x6c, 0x006c},
	{0x6d, 0x006d},
	{0x6e, 0x006e},
	{0x6f, 0x006f},
	{0x70, 0x0070},
	{0x71, 0x0071},
	{0x72, 0x0072},
	{0x73, 0x0073},
	{0x74, 0x0074},
	{0x75, 0x0075},
	{0x76, 0x0076},
	{0x77, 0x0077},
	{0x78, 0x0078},
	{0x79, 0x0079},
	{0x7a, 0x007a},
	{0x7b, 0x007b},
	{0x7c, 0x007c},
	{0x7d, 0x007d},
	{0x7e, 0x007e},
	{0x7f, 0x2302},
	{0x80, 0x00c7},
	{0x81, 0x00fc},
	{0x82, 0x00e9},
	{0x83, 0x00e2},
	{0x84, 0x00e4},
	{0x85, 0x00e0},
	{0x86, 0x00e5},
	{0x87, 0x00e7},
	{0x88, 0x00ea},
	{0x89, 0x00eb},
	{0x8a, 0x00e8},
	{0x8b, 0x00ef},
	{0x8c, 0x00ee},
	{0x8d, 0x00ec},
	{0x8e, 0x00c4},
	{0x8f, 0x00c5},
	{0x90, 0x00c9},
	{0x91, 0x00e6},
	{0x92, 0x00c6},
	{0x93, 0x00f4},
	{0x94, 0x00f6},
	{0x95, 0x00f2},
	{0x96, 0x00fb},
	{0x97, 0x00f9},
	{0x98, 0x00ff},
	{0x99, 0x00d6},
	{0x9a, 0x00dc},
	{0x9b, 0x00a2},
	{0x9c, 0x00a3},
	{0x9d, 0x00a5},
	{0x9e, 0x20a7},
	{0x9f, 0x0192},
	{0xa0, 0x00e1},
	{0xa1, 0x00ed},
	{0xa2, 0x00f3},
	{0xa3, 0x00fa},
	{0xa4, 0x00f1},
	{0xa5, 0x00d1},
	{0xa6, 0x00aa},
	{0xa7, 0x00ba},
	{0xa8, 0x00bf},
	{0xa9, 0x2310},
	{0xaa, 0x00ac},
	{0xab, 0x00bd},
	{0xac, 0x00bc},
	{0xad, 0x00a1},
	{0xae, 0x00ab},
	{0xaf, 0x00bb},
	{0xb0, 0x2591},
	{0xb1, 0x2592},
	{0xb2, 0x2593},
	{0xb3, 0x2502},
	{0xb4, 0x2524},
	{0xb5, 0x2561},
	{0xb6, 0x2562},
	{0xb7, 0x2556},
	{0xb8, 0x2555},
	{0xb9, 0x2563},
	{0xba, 0x2551},
	{0xbb, 0x2557},
	{0xbc, 0x255d},
	{0xbd, 0x255c},
	{0xbe, 0x255b},
	{0xbf, 0x2510},
	{0xc0, 0x2514},
	{0xc1, 0x2534},
	{0xc2, 0x252c},
	{0xc3, 0x251c},
	{0xc4, 0x2500},
	{0xc5, 0x253c},
	{0xc6, 0x255e},
	{0xc7, 0x255f},
	{0xc8, 0x255a},
	{0xc9, 0x2554},
	{0xca, 0x2569},
	{0xcb, 0x2566},
	{0xcc, 0x2560},
	{0xcd, 0x2550},
	{0xce, 0x256c},
	{0xcf, 0x2567},
	{0xd0, 0x2568},
	{0xd1, 0x2564},
	{0xd2, 0x2565},
	{0xd3, 0x2559},
	{0xd4, 0x2558},
	{0xd5, 0x2552},
	{0xd6, 0x2553},
	{0xd7, 0x256b},
	{0xd8, 0x256a},
	{0xd9, 0x2518},
	{0xda, 0x250c},
	{0xdb, 0x2588},
	{0xdc, 0x2584},
	{0xdd, 0x258c},
	{0xde, 0x2590},
	{0xdf, 0x2580},
	{0xe0, 0x03b1},
	{0xe1, 0x00df},
	{0xe2, 0x0393},
	{0xe3, 0x03c0},
	{0xe4, 0x03a3},
	{0xe5, 0x03c3},
	{0xe6, 0x00b5},
	{0xe7, 0x03c4},
	{0xe8, 0x03a6},
	{0xe9, 0x0398},
	{0xea, 0x03a9},
	{0xeb, 0x03b4},
	{0xec, 0x221e},
	{0xed, 0x03c6},
	{0xee, 0x03b5},
	{0xef, 0x2229},
	{0xf0, 0x2261},
	{0xf1, 0x00b1},
	{0xf2, 0x2265},
	{0xf3, 0x2264},
	{0xf4, 0x2320},
	{0xf5, 0x2321},
	{0xf6, 0x00f7},
	{0xf7, 0x2248},
	{0xf8, 0x00b0},
	{0xf9, 0x2219},
	{0xfa, 0x00b7},
	{0xfb, 0x221a},
	{0xfc, 0x207f},
	{0xfd, 0x00b2},
	{0xfe, 0x25a0},
	{0xff, 0x00a0},
	{0,0}
};

const fontmap_t *map_iso8859_1 = iso8859_1;
const fontmap_t *map_iso8859_2 = iso8859_2;
const fontmap_t *map_iso8859_3 = iso8859_3;
const fontmap_t *map_iso8859_4 = iso8859_4;
const fontmap_t *map_iso8859_5 = iso8859_5;
const fontmap_t *map_iso8859_7 = iso8859_7;
const fontmap_t *map_iso8859_8 = iso8859_8;
const fontmap_t *map_iso8859_9 = iso8859_9;
const fontmap_t *map_iso8859_10 = iso8859_10;
const fontmap_t *map_iso8859_13 = iso8859_13;
const fontmap_t *map_iso8859_14 = iso8859_14;
const fontmap_t *map_iso8859_15 = iso8859_15;
const fontmap_t *map_jisx201_1976 = jisx201_1976;
const fontmap_t *map_koi8_r = koi8_r;
const fontmap_t *map_cp437 = cp437;

const fontmap_t *wcmapset(const char *charset)
{
	const fontmap_t *map;

	if (NULL == charset) {
		map = map_iso8859_1;
	} else {
		if (0 == strcasecmp(charset, "utf-8")) {
			map = NULL;
		} else if (0 == strcasecmp(charset, "iso8859-1")) {
			map = map_iso8859_1;
		} else if (0 == strcasecmp(charset, "iso8859-2")) {
			map = map_iso8859_2;
		} else if (0 == strcasecmp(charset, "iso8859-3")) {
			map = map_iso8859_3;
		} else if (0 == strcasecmp(charset, "iso8859-4")) {
			map = map_iso8859_4;
		} else if (0 == strcasecmp(charset, "iso8859-5")) {
			map = map_iso8859_5;
		} else if (0 == strcasecmp(charset, "iso8859-7")) {
			map = map_iso8859_7;
		} else if (0 == strcasecmp(charset, "iso8859-8")) {
			map = map_iso8859_8;
		} else if (0 == strcasecmp(charset, "iso8859-9")) {
			map = map_iso8859_9;
		} else if (0 == strcasecmp(charset, "iso8859-10")) {
			map = map_iso8859_10;
		} else if (0 == strcasecmp(charset, "iso8859-13")) {
			map = map_iso8859_13;
		} else if (0 == strcasecmp(charset, "iso8859-14")) {
			map = map_iso8859_14;
		} else if (0 == strcasecmp(charset, "iso8859-15")) {
			map = map_iso8859_15;
		} else if (0 == strcasecmp(charset, "jisx201-1976")) {
			map = map_jisx201_1976;
		} else if (0 == strcasecmp(charset, "koi8-r")) {
			map = map_koi8_r;
		} else if (0 == strcasecmp(charset, "cp437")) {
			map = map_cp437;
		} else {
			map = map_iso8859_1;
		}
	}
	return map;
}

uint32_t wcmapcode(const fontmap_t *map, uint8_t ch)
{
	if (NULL == map) {
		errno = EINVAL;
		return 0xfffd;
	}

	for (/* */; 0 != map->bytecode; map++) {
		if (ch == map->bytecode)
			return map->unicode;
	}
	return 0xfffd;
}

uint8_t mapencode(const fontmap_t *map, uint32_t ucs)
{
	if (NULL == map) {
		errno = EINVAL;
		return 0;
	}
	for (/* */; 0 != map->bytecode; map++) {
		if (ucs == map->unicode)
			return map->bytecode;
	}
	return 0;
}

#if	NEED_RANGES
typedef struct range_s {
	uint32_t first, last;
	const char *name;
}	range_t;

static const range_t ranges[] =
{
    {0x0000, 0x007f, "Basic Latin"},
    {0x0080, 0x00ff, "Latin-1 Supplement"},
    {0x0100, 0x017f, "Latin Extended-A"},
    {0x0180, 0x024f, "Latin Extended-B"},
    {0x0250, 0x02af, "IPA Extensions"},
    {0x02b0, 0x02ff, "Spacing Modifier Letters"},
    {0x0300, 0x036f, "Combining Diacritical Marks"},
    {0x0370, 0x03ff, "Greek"},
    {0x0400, 0x04ff, "Cyrillic"},
    {0x0530, 0x058f, "Armenian"},
    {0x0590, 0x05ff, "Hebrew"},
    {0x0600, 0x06ff, "Arabic"},
    {0x0700, 0x074f, "Syriac"},
    {0x0780, 0x07bf, "Thaana"},
    {0x0900, 0x097f, "Devanagari"},
    {0x0980, 0x09ff, "Bengali"},
    {0x0a00, 0x0a7f, "Gurmukhi"},
    {0x0a80, 0x0aff, "Gujarati"},
    {0x0b00, 0x0b7f, "Oriya"},
    {0x0b80, 0x0bff, "Tamil"},
    {0x0c00, 0x0c7f, "Telugu"},
    {0x0c80, 0x0cff, "Kannada"},
    {0x0d00, 0x0d7f, "Malayalam"},
    {0x0d80, 0x0dff, "Sinhala"},
    {0x0e00, 0x0e7f, "Thai"},
    {0x0e80, 0x0eff, "Lao"},
    {0x0f00, 0x0fff, "Tibetan"},
    {0x1000, 0x109f, "Myanmar"},
    {0x10a0, 0x10ff, "Georgian"},
    {0x1100, 0x11ff, "Hangul Jamo"},
    {0x1200, 0x137f, "Ethiopic"},
    {0x13a0, 0x13ff, "Cherokee"},
    {0x1400, 0x167f, "Unified Canadian Aboriginal Syllabic"},
    {0x1680, 0x169f, "Ogham"},
    {0x16a0, 0x16ff, "Runic"},
    {0x1780, 0x17ff, "Khmer"},
    {0x1800, 0x18af, "Mongolian"},
    {0x1e00, 0x1eff, "Latin Extended Additional"},
    {0x1f00, 0x1fff, "Greek Extended"},
    {0x2000, 0x206f, "General Punctuation"},
    {0x2070, 0x208f, "Superscripts and Subscripts"},
    {0x20a0, 0x20cf, "Currency Symbols"},
    {0x20d0, 0x20ff, "Combining Marks for Symbols"},
    {0x2100, 0x214f, "Letterlike Symbols"},
    {0x2150, 0x218f, "Number Forms"},
    {0x2190, 0x21ff, "Arrows"},
    {0x2200, 0x22ff, "Mathematical Operators"},
    {0x2300, 0x23ff, "Miscellaneous Technical"},
    {0x2400, 0x243f, "Control Pictures"},
    {0x2440, 0x245f, "Optical Character Recognition"},
    {0x2460, 0x24ff, "Enclosed Alphanumerics"},
    {0x2500, 0x257f, "Box Drawing"},
    {0x2580, 0x259f, "Block Elements"},
    {0x25a0, 0x25ff, "Geometric Shapes"},
    {0x2600, 0x26ff, "Miscellaneous Symbols"},
    {0x2700, 0x27bf, "Dingbats"},
    {0x2800, 0x28ff, "Braille Patterns"},
    {0x2e80, 0x2eff, "CJK Radicals Supplement"},
    {0x2f00, 0x2fdf, "Kangxi Radicals"},
    {0x2ff0, 0x2fff, "Ideographic Description Characters"},
    {0x3000, 0x303f, "CJK Symbols and Punctuation"},
    {0x3040, 0x309f, "Hiragana"},
    {0x30a0, 0x30ff, "Katakana"},
    {0x3100, 0x312f, "Bopomofo"},
    {0x3130, 0x318f, "Hangul Compatibility Jamo"},
    {0x3190, 0x319f, "Kanbun"},
    {0x31a0, 0x31bf, "Bopomofo Extended"},
    {0x3200, 0x32ff, "Enclosed CJK Letters and Months"},
    {0x3300, 0x33ff, "CJK Compatibility"},
    {0x3400, 0x4dbf, "CJK Unified Ideographs Extension A"},
    {0x4e00, 0x9faf, "CJK Unified Ideographs"},
    {0xa000, 0xa48f, "Yi Syllables"},
    {0xa490, 0xa4cf, "Yi Radicals"},
    {0xac00, 0xd7af, "Hangul Syllables"},
    {0xd800, 0xdb7f, "High Surrogates"},
    {0xdb80, 0xdbff, "High Private Use Surrogates"},
    {0xdc00, 0xdfff, "Low Surrogates"},
    {0xe000, 0xf8ff, "Private Use"},
    {0xf900, 0xfaff, "CJK Compatibility Ideographs"},
    {0xfb00, 0xfb4f, "Alphabetic Presentation Forms"},
    {0xfb50, 0xfdff, "Arabic Presentation Forms-A"},
    {0xfe20, 0xfe2f, "Combining Half Marks"},
    {0xfe30, 0xfe4f, "CJK Compatibility Forms"},
    {0xfe50, 0xfe6f, "Small Form Variants"},
    {0xfe70, 0xfeff, "Arabic Presentation Forms-B"},
    {0xff00, 0xffef, "Halfwidth and Fullwidth Forms"},
    {0xfff0, 0xffff, "Specials"}
};
#endif

#if	NEED_WCCOM
static const char *canonical_combining(uint8_t val)
{
	switch (val) {
	case 0:
		return "Spacing, split, enclosing, reordrant, and Tibetan subjoined";
	case 1:
		return "Overlays and interior";
	case 7:
		return "Nuktas";
	case 8:
		return "Hiragana/Katakana voicing marks";
	case 9:
		return "Viramas";
	case 10:
		return "Start of fixed position classes";
	case 199:
		return "End of fixed position classes";
	case 200:
		return "Below left attached";
	case 202:
		return "Below attached";
	case 204:
		return "Below right attached";
	case 208:
		return "Left attached (reordrant around single base character)";
	case 210:
		return "Right attached";
	case 212:
		return "Above left attached";
	case 214:
		return "Above attached";
	case 216:
		return "Above right attached";
	case 218:
		return "Below left";
	case 220:
		return "Below";
	case 222:
		return "Below right";
	case 224:
		return "Left (reordrant around single base character)";
	case 226:
		return "Right";
	case 228:
		return "Above left";
	case 230:
		return "Above";
	case 232:
		return "Above right";
	case 233:
		return "Double below";
	case 234:
		return "Double above";
	case 240:
		return "Below (iota subscript)";
	}
	return "INVALID";
}
#endif

#if	NEED_WCNAME
const char *wcname(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->name;
	return NULL;
}
#endif

#if	NEED_WCNAME10
const char *wcname10(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->name10;
	return NULL;
}
#endif

#if	NEED_WCCOMMENT
const char *wccomment(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->comment;
	return NULL;
}
#endif

#if	NEED_WCGCAT
uint8_t wcgcat(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->gcat;
	return gcat_0;
}

const char *wcgcat_name(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		switch (unicode_data[ucs]->gcat) {
		case gcat_0:
			return "";
		case gcat_Lu:
			return "Lu: Letter, Uppercase";
		case gcat_Ll:
			return "Ll: Letter, Lowercase";
		case gcat_Lt:
			return "Lt: Letter, Titlecase";
		case gcat_Mn:
			return "Mn: Mark, Non-Spacing";
		case gcat_Mc:
			return "Mc: Mark, Spacing Combining";
		case gcat_Me:
			return "Me: Mark, Enclosing";
		case gcat_Nd:
			return "Nd: Number, Decimal Digit";
		case gcat_Nl:
			return "Nl: Number, Letter";
		case gcat_No:
			return "No: Number, Other";
		case gcat_Zs:
			return "Zs: Separator, Space";
		case gcat_Zl:
			return "Zl: Separator, Line";
		case gcat_Zp:
			return "Zp: Separator, Paragraph";
		case gcat_Cc:
			return "Cc: Other, Control";
		case gcat_Cf:
			return "Cf: Other, Format";
		case gcat_Cs:
			return "Cs: Other, Surrogate";
		case gcat_Co:
			return "Co: Other, Private Use";
		case gcat_Cn:
			return "Cn: Other, Not Assigned (no characters have this property)";
		case gcat_Lm:
			return "Lm: Letter, Modifier";
		case gcat_Lo:
			return "Lo: Letter, Other";
		case gcat_Pc:
			return "Pc: Punctuation, Connector";
		case gcat_Pd:
			return "Pd: Punctuation, Dash";
		case gcat_Ps:
			return "Ps: Punctuation, Open";
		case gcat_Pe:
			return "Pe: Punctuation, Close";
		case gcat_Pi:
			return "Pi: Punctuation, Initial quote\n" \
				"(may behave like Ps or Pe depending on usage)";
		case gcat_Pf:
			return "Pf: Punctuation, Final quote\n" \
				"(may behave like Ps or Pe depending on usage)";
		case gcat_Po:
			return "Po: Punctuation, Other";
		case gcat_Sm:
			return "Sm: Symbol, Math";
		case gcat_Sc:
			return "Sc: Symbol, Currency";
		case gcat_Sk:
			return "Sk: Symbol, Modifier";
		case gcat_So:
			return "So: Symbol, Other";
		}
	return "";
}
#endif

#if	NEED_WCCOM
uint8_t wcccom(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->ccom;
	return 255;
}

const char * wcccom_name(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return canonical_combining(unicode_data[ucs]->ccom);
	return "";
}
#endif

#if	NEED_WCBIDI
uint8_t wcbidi(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->bidi;
	return bidi_0;
}

const char * wcbidi_name(uint32_t ucs)
{
    if (ucs < PLANESIZE && NULL != unicode_datag)
        switch (unicode_data[ucs]->bidi) {
		case bidi_0:	return "";
		case bidi_L:	return "L: Left-to-Right";
		case bidi_LRE:	return "LRE: Left-to-Right Embedding";
		case bidi_LRO:	return "LRO: Left-to-Right Override";
		case bidi_R:	return "R: Right-to-Left";
		case bidi_AL:	return "AL: Right-to-Left Arabic";
		case bidi_RLE:	return "RLE: Right-to-Left Embedding";
		case bidi_RLO:	return "RLO: Right-to-Left Override";
		case bidi_PDF:	return "PDF: Pop Directional Format";
		case bidi_EN:	return "EN: European Number";
		case bidi_ES:	return "ES: European Number Separator";
		case bidi_ET:	return "ET: European Number Terminator";
		case bidi_AN:	return "AN: Arabic Number";
		case bidi_CS:	return "CS: Common Number Separator";
		case bidi_NSM:	return "NSM: Non-Spacing Mark";
		case bidi_BN:	return "BN: Boundary Neutral";
		case bidi_B:	return "B: Paragraph Separator";
		case bidi_S:	return "S: Segment Separator";
		case bidi_WS:	return "WS: Whitespace";
		case bidi_ON:	return "ON: Other Neutrals";
		}
	return "";
}
#endif

#if	NEED_WCDECO
uint8_t wcdeco(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->deco;
	return deco_0;
}

const char * wcdeco_name(uint32_t ucs)
{
	if (ucs < PLANESIZE &&
		NULL != unicode_datag &&
		0 != unicode_data[ucs]->decn)
		switch (unicode_data[ucs]->deco) {
		case deco_0:
			return "";
		case deco_canonical:
			return "canonical mapping";
		case deco_font:
			return "A font variant (e.g. a blackletter form).";
		case deco_noBreak:
			return "A no-break version of a space or hyphen.";
		case deco_initial:
			return "An initial presentation form (Arabic).";
		case deco_medial:
			return "A medial presentation form (Arabic).";
		case deco_final:
			return "A final presentation form (Arabic).";
		case deco_isolated:
			return "An isolated presentation form (Arabic).";
		case deco_circle:
			return "An encircled form.";
		case deco_super:
			return "A superscript form.";
		case deco_sub:
			return "A subscript form.";
		case deco_vertical:
			return "A vertical layout presentation form.";
		case deco_wide:
			return "A wide (or zenkaku) compatibility character.";
		case deco_narrow:
			return "A narrow (or hankaku) compatibility character.";
		case deco_small:
			return "A small variant form (CNS compatibility).";
		case deco_square:
			return "A CJK squared font variant.";
		case deco_fraction:
			return "A vulgar fraction form.";
		case deco_compat:
			return "Otherwise unspecified compatibility character.";
		}
	return "";
}

uint32_t wcdeco_n(uint32_t ucs, int n)
{
	if (ucs < PLANESIZE && NULL != unicode_datag) {
		if (n == -1)
			return unicode_data[ucs]->decn;
		else
		if (n < unicode_data[ucs]->decn)
			return unicode_data[ucs]->decp[n];
	}
	return 0;
}
#endif

#if	NEED_WCDECIMAL
uint8_t wcdecimal(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->decimal_digit;
	return 0;
}

uint8_t wcdigit(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->digit;
	return 0;
}
#endif

#if	NEED_WCNUMERIC
uint8_t wcnumeric(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->numeric;
	return 0;
}
#endif

#if	NEED_WCMIRRORED
int wcmirrored(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		return unicode_data[ucs]->mirrored;
	return 0;
}
#endif

#if	NEED_WCUCASE
uint32_t wcucase(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		if (0 != unicode_data[ucs]->uppercase)
			return unicode_data[ucs]->uppercase;
	return ucs;
}
#endif

#if	NEED_WCLCASE
uint32_t wclcase(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		if (0 != unicode_data[ucs]->lowercase)
			return unicode_data[ucs]->lowercase;
	return ucs;
}
#endif

#if	NEED_WCTCASE
uint32_t wctcase(uint32_t ucs)
{
	if (ucs < PLANESIZE && NULL != unicode_datag)
		if (0 != unicode_data[ucs]->titlecase)
			return unicode_data[ucs]->titlecase;
	return ucs;
}
#endif

#if	NEED_WCWIDTH
int ucs_wcwidth(uint32_t ucs)
{
	/* sorted list of non-overlapping intervals of non-spacing characters */
	static const struct interval {
		uint16_t first, last;
	} combining[] = {
		{ 0x0300, 0x034E }, { 0x0360, 0x0362 }, { 0x0483, 0x0486 },
		{ 0x0488, 0x0489 }, { 0x0591, 0x05A1 }, { 0x05A3, 0x05B9 },
		{ 0x05BB, 0x05BD }, { 0x05BF, 0x05BF }, { 0x05C1, 0x05C2 },
		{ 0x05C4, 0x05C4 }, { 0x064B, 0x0655 }, { 0x0670, 0x0670 },
		{ 0x06D6, 0x06E4 }, { 0x06E7, 0x06E8 }, { 0x06EA, 0x06ED },
		{ 0x0711, 0x0711 }, { 0x0730, 0x074A }, { 0x07A6, 0x07B0 },
		{ 0x0901, 0x0902 }, { 0x093C, 0x093C }, { 0x0941, 0x0948 },
		{ 0x094D, 0x094D }, { 0x0951, 0x0954 }, { 0x0962, 0x0963 },
		{ 0x0981, 0x0981 }, { 0x09BC, 0x09BC }, { 0x09C1, 0x09C4 },
		{ 0x09CD, 0x09CD }, { 0x09E2, 0x09E3 }, { 0x0A02, 0x0A02 },
		{ 0x0A3C, 0x0A3C }, { 0x0A41, 0x0A42 }, { 0x0A47, 0x0A48 },
		{ 0x0A4B, 0x0A4D }, { 0x0A70, 0x0A71 }, { 0x0A81, 0x0A82 },
		{ 0x0ABC, 0x0ABC }, { 0x0AC1, 0x0AC5 }, { 0x0AC7, 0x0AC8 },
		{ 0x0ACD, 0x0ACD }, { 0x0B01, 0x0B01 }, { 0x0B3C, 0x0B3C },
		{ 0x0B3F, 0x0B3F }, { 0x0B41, 0x0B43 }, { 0x0B4D, 0x0B4D },
		{ 0x0B56, 0x0B56 }, { 0x0B82, 0x0B82 }, { 0x0BC0, 0x0BC0 },
		{ 0x0BCD, 0x0BCD }, { 0x0C3E, 0x0C40 }, { 0x0C46, 0x0C48 },
		{ 0x0C4A, 0x0C4D }, { 0x0C55, 0x0C56 }, { 0x0CBF, 0x0CBF },
		{ 0x0CC6, 0x0CC6 }, { 0x0CCC, 0x0CCD }, { 0x0D41, 0x0D43 },
		{ 0x0D4D, 0x0D4D }, { 0x0DCA, 0x0DCA }, { 0x0DD2, 0x0DD4 },
		{ 0x0DD6, 0x0DD6 }, { 0x0E31, 0x0E31 }, { 0x0E34, 0x0E3A },
		{ 0x0E47, 0x0E4E }, { 0x0EB1, 0x0EB1 }, { 0x0EB4, 0x0EB9 },
		{ 0x0EBB, 0x0EBC }, { 0x0EC8, 0x0ECD }, { 0x0F18, 0x0F19 },
		{ 0x0F35, 0x0F35 }, { 0x0F37, 0x0F37 }, { 0x0F39, 0x0F39 },
		{ 0x0F71, 0x0F7E }, { 0x0F80, 0x0F84 }, { 0x0F86, 0x0F87 },
		{ 0x0F90, 0x0F97 }, { 0x0F99, 0x0FBC }, { 0x0FC6, 0x0FC6 },
		{ 0x102D, 0x1030 }, { 0x1032, 0x1032 }, { 0x1036, 0x1037 },
		{ 0x1039, 0x1039 }, { 0x1058, 0x1059 }, { 0x17B7, 0x17BD },
		{ 0x17C6, 0x17C6 }, { 0x17C9, 0x17D3 }, { 0x18A9, 0x18A9 },
		{ 0x20D0, 0x20E3 }, { 0x302A, 0x302F }, { 0x3099, 0x309A },
		{ 0xFB1E, 0xFB1E }, { 0xFE20, 0xFE23 }
	};
	int min = 0;
	int max = sizeof(combining) / sizeof(combining[0]) - 1;
	int mid;

	/* test for 8-bit control characters */
	if (ucs == 0)
		return 0;
	if (ucs < 32 || (ucs >= 0x7f && ucs < 0xa0))
		return -1;

	/* first quick check for Latin-1 etc. characters */
	if (ucs < combining[0].first)
		return 1;

	/* binary search in table of non-spacing characters */
	while (max >= min)
	{
		mid = (min + max) / 2;
		if (combining[mid].last < ucs)
			min = mid + 1;
		else if (combining[mid].first > ucs)
			max = mid - 1;
		else if (combining[mid].first <= ucs && combining[mid].last >= ucs)
			return 0;
	}

	/* if we arrive here, ucs is not a combining or C0/C1 control character */

	/* fast test for majority of non-wide scripts */
	if (ucs < 0x1100)
		return 1;

	return 1 +
		((ucs >= 0x1100 && ucs <= 0x115f) || /* Hangul Jamo */
		 (ucs >= 0x2e80 && ucs <= 0xa4cf && (ucs & ~0x0011) != 0x300a && ucs != 0x303f) || /* CJK ... Yi */
		 (ucs >= 0xac00 && ucs <= 0xd7a3) || /* Hangul Syllables */
		 (ucs >= 0xf900 && ucs <= 0xfaff) || /* CJK Compatibility Ideographs */
		 (ucs >= 0xfe30 && ucs <= 0xfe6f) || /* CJK Compatibility Forms */
		 (ucs >= 0xff00 && ucs <= 0xff5f) || /* Fullwidth Forms */
		 (ucs >= 0xffe0 && ucs <= 0xffe6));
}
#endif

#if	NEED_RANGES
const char *wcrange_name(uint32_t ucs)
{
	static uint32_t hit = 0;
	uint32_t i;

	for (i = hit; i < sizeof(ranges)/sizeof(ranges[0]); i++) {
		if (ranges[i].first <= ucs && ucs <= ranges[i].last) {
			hit = i;
			return ranges[i].name;
		}
	}

	for (i = 0; i < hit; i++) {
		if (ranges[i].first <= ucs && ucs <= ranges[i].last) {
			hit = i;
			return ranges[i].name;
		}
	}

	return NULL;
}

uint32_t wcrange_first(uint32_t ucs)
{
	static uint32_t hit = 0;
	uint32_t i;

	for (i = hit; i < sizeof(ranges)/sizeof(ranges[0]); i++) {
		if (ranges[i].first <= ucs && ucs <= ranges[i].last) {
			hit = i;
			return ranges[i].first;
		}
	}

	for (i = 0; i < hit; i++) {
		if (ranges[i].first <= ucs && ucs <= ranges[i].last) {
			hit = i;
			return ranges[i].first;
		}
	}

	return ucs;
}

uint32_t wcrange_last(uint32_t ucs)
{
	static uint32_t hit = 0;
	uint32_t i;

	for (i = hit; i < sizeof(ranges)/sizeof(ranges[0]); i++) {
		if (ranges[i].first <= ucs && ucs <= ranges[i].last) {
			hit = i;
			return ranges[i].last;
		}
	}

	for (i = 0; i < hit; i++) {
		if (ranges[i].first <= ucs && ucs <= ranges[i].last) {
			hit = i;
			return ranges[i].last;
		}
	}

	return ucs;
}
#endif

#if	NEED_WCENCODE
int wcencode(char *dst, uint32_t ucs, int mode)
{
	size_t len = 0;

	switch (mode) {
	case WC_UTF8:
		if (ucs < 0x80) {
			dst[len++] = (char)ucs;
		} else if (ucs < 0x800) {
			dst[len++] = (char)(0xc0 | (uint8_t)(ucs >> 6));
			dst[len++] = (char)(0x80 | (uint8_t)(ucs & 0x3f));
		} else if (ucs < 0x10000) {
			dst[len++] = (char)(0xe0 | (uint8_t)(ucs >> 12));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 6) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)(ucs & 0x3f));
		} else if (ucs < 0x200000) {
			dst[len++] = (char)(0xf0 | (uint8_t)(ucs >> 18));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 12) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 6) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)(ucs & 0x3f));
		} else if (ucs < 0x4000000) {
			dst[len++] = (char)(0xf8 | (uint8_t)(ucs >> 24));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 18) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 12) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 6) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)(ucs & 0x3f));
		} else {
			dst[len++] = (char)(0xfc | (uint8_t)(ucs >> 30));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 24) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 18) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 12) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)((ucs >> 6) & 0x3f));
			dst[len++] = (char)(0x80 | (uint8_t)(ucs & 0x3f));
		}
		break;
	default:
		errno = EINVAL;
		return -1;
	}
	dst[len] = '\0';
	return len;
}
#endif

#if (NEED_WCNAME || NEED_WCNAME10 || NEED_WCCOMMENT || NEED_WCGCAT || NEED_WCCOMM ||NEED_WCBIDI || NEED_WCDECO || NEED_WCDIGIT || NEED_WCNUMERIC || NEED_WCMIRRORED || NEED_WCUCASE || NEED_WCLCASE || NEED_WCTCASE || NEED_WCRANGES)

static char *e_strtok(char *src, const char *delim)
{
	static char *tok = NULL;
	char *dst = tok;
	const char *d;

	if (NULL != src)
		tok = src;
	while (NULL != tok && '\0' != *tok) {
		d = delim;
		while (*d) {
			if (*tok == *d) {
				*tok++ = '\0';
				return dst;
			}
			d++;
		}
		tok++;
	}
	return NULL;
}

#undef	LINESIZE
#define	LINESIZE	4096

int unicode(void)
{
	char *filename = xcalloc(MAXPATHLEN, sizeof(char));
	char *line = NULL, *token;
	lzwfile_t *lzw;
	uint32_t first = 0, last = 0, code;
	int linenum, tokennum;
	unicode_data_t u;
	size_t total_alloc = 0;
	FUN("unicode");

	unicode_data = (unicode_data_t *)
		xcalloc(PLANESIZE, sizeof(unicode_data_t));
	total_alloc += PLANESIZE * sizeof(unicode_data_t *);

	pm_snprintf(filename, MAXPATHLEN, "%s%s",
		g_conf->progpath, UNICODE_LIST);

	gz = gzopen(filename, "r");
	if (NULL == gz) {
		LOG(L_ERROR,("gzopen('%s','%s') call failed (%s)\n",
			filename, "r", strerror(errno)));
		info("%s missing ", UNICODE_LIST);
		xfree(filename);
		xfree(unicode_data);
		return -1;
	}
	xfree(filename);

	line = xcalloc(LINESIZE, sizeof(char));
	linenum = 0;

	for (;;) {
		if (NULL == lzw_gets(line, LINESIZE, lzw))
			break;
		memset(&u, 0, sizeof(u));
		linenum++;

		tokennum = 1;
		if (NULL == (token = e_strtok(line, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
		if (NULL != token) {
			code = strtoul(token, NULL, 16);
		} else {
			code = PLANESIZE;
		}

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
		if (NULL != token) {
			/* range description */
			if (token[0] == '<') {
				if (0 == strcasecmp(token+strlen(token)-8,", First>")) {
					strcpy(token, token + 1);
					token[strlen(token)-8] = '\0';
					first = code;
					LOG(L_NORMAL,("first %d\n", first));
				} else if (0 == strcasecmp(token+strlen(token)-7,", Last>")) {
					strcpy(token, token + 1);
					token[strlen(token)-7] = '\0';
					last = code;
					LOG(L_NORMAL,("last %d\n", last));
				}
			}
#if	NEED_WCNAME
			u.name = xstrdup(token);
			total_alloc += strlen(token) + 1;
#endif
		}

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCGCAT
		/* parse global category */
		if (NULL != token) {
			if (0 == strcmp(token, "Lu"))
				u.gcat = gcat_Lu;
			if (0 == strcmp(token, "Ll"))
				u.gcat = gcat_Ll;
			if (0 == strcmp(token, "Lt"))
				u.gcat = gcat_Lt;
			if (0 == strcmp(token, "Mn"))
				u.gcat = gcat_Mn;
			if (0 == strcmp(token, "Mc"))
				u.gcat = gcat_Mc;
			if (0 == strcmp(token, "Me"))
				u.gcat = gcat_Me;
			if (0 == strcmp(token, "Nd"))
				u.gcat = gcat_Nd;
			if (0 == strcmp(token, "Nl"))
				u.gcat = gcat_Nl;
			if (0 == strcmp(token, "No"))
				u.gcat = gcat_No;
			if (0 == strcmp(token, "Zs"))
				u.gcat = gcat_Zs;
			if (0 == strcmp(token, "Zl"))
				u.gcat = gcat_Zl;
			if (0 == strcmp(token, "Zp"))
				u.gcat = gcat_Zp;
			if (0 == strcmp(token, "Cc"))
				u.gcat = gcat_Cc;
			if (0 == strcmp(token, "Cf"))
				u.gcat = gcat_Cf;
			if (0 == strcmp(token, "Cs"))
				u.gcat = gcat_Cs;
			if (0 == strcmp(token, "Co"))
				u.gcat = gcat_Co;
			if (0 == strcmp(token, "Cn"))
				u.gcat = gcat_Cn;
			if (0 == strcmp(token, "Lm"))
				u.gcat = gcat_Lm;
			if (0 == strcmp(token, "Lo"))
				u.gcat = gcat_Lo;
			if (0 == strcmp(token, "Pc"))
				u.gcat = gcat_Pc;
			if (0 == strcmp(token, "Pd"))
				u.gcat = gcat_Pd;
			if (0 == strcmp(token, "Ps"))
				u.gcat = gcat_Ps;
			if (0 == strcmp(token, "Pe"))
				u.gcat = gcat_Pe;
			if (0 == strcmp(token, "Pi"))
				u.gcat = gcat_Pi;
			if (0 == strcmp(token, "Pf"))
				u.gcat = gcat_Pf;
			if (0 == strcmp(token, "Po"))
				u.gcat = gcat_Po;
			if (0 == strcmp(token, "Sm"))
				u.gcat = gcat_Sm;
			if (0 == strcmp(token, "Sc"))
				u.gcat = gcat_Sc;
			if (0 == strcmp(token, "Sk"))
				u.gcat = gcat_Sk;
			if (0 == strcmp(token, "So"))
				u.gcat = gcat_So;
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCCOM
		if (NULL != token) {
			u.ccom = (uint8_t)strtoul(token, NULL, 10);
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCBIDI
		if (NULL != token) {
			if (0 == strcmp(token, "L"))
				u.bidi = bidi_L;
			if (0 == strcmp(token, "LRE"))
				u.bidi = bidi_LRE;
			if (0 == strcmp(token, "LRO"))
				u.bidi = bidi_LRO;
			if (0 == strcmp(token, "R"))
				u.bidi = bidi_R;
			if (0 == strcmp(token, "AL"))
				u.bidi = bidi_AL;
			if (0 == strcmp(token, "RLE"))
				u.bidi = bidi_RLE;
			if (0 == strcmp(token, "RLO"))
				u.bidi = bidi_RLO;
			if (0 == strcmp(token, "PDF"))
				u.bidi = bidi_PDF;
			if (0 == strcmp(token, "EN"))
				u.bidi = bidi_EN;
			if (0 == strcmp(token, "ES"))
				u.bidi = bidi_ES;
			if (0 == strcmp(token, "ET"))
				u.bidi = bidi_ET;
			if (0 == strcmp(token, "AN"))
				u.bidi = bidi_AN;
			if (0 == strcmp(token, "CS"))
				u.bidi = bidi_CS;
			if (0 == strcmp(token, "NSM"))
				u.bidi = bidi_NSM;
			if (0 == strcmp(token, "BN"))
				u.bidi = bidi_BN;
			if (0 == strcmp(token, "B"))
				u.bidi = bidi_B;
			if (0 == strcmp(token, "S"))
				u.bidi = bidi_S;
			if (0 == strcmp(token, "WS"))
				u.bidi = bidi_WS;
			if (0 == strcmp(token, "ON"))
				u.bidi = bidi_ON;
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCDECO
		if (NULL != token) {
			uint16_t deco[256];
			uint8_t n = 0;
			char *p = token;

			if (0 == strncmp(token, "<font>", 6))
				u.deco = deco_font;
			if (0 == strncmp(token, "<noBreak>", 9))
				u.deco = deco_noBreak;
			if (0 == strncmp(token, "<initial>", 9))
				u.deco = deco_initial;
			if (0 == strncmp(token, "<medial>", 8))
				u.deco = deco_medial;
			if (0 == strncmp(token, "<final>", 7))
				u.deco = deco_final;
			if (0 == strncmp(token, "<isolated>", 10))
				u.deco = deco_initial;
			if (0 == strncmp(token, "<circle>", 8))
				u.deco = deco_circle;
			if (0 == strncmp(token, "<super>", 7))
				u.deco = deco_super;
			if (0 == strncmp(token, "<sub>", 5))
				u.deco = deco_sub;
			if (0 == strncmp(token, "<vertical>", 10))
				u.deco = deco_vertical;
			if (0 == strncmp(token, "<wide>", 6))
				u.deco = deco_wide;
			if (0 == strncmp(token, "<narrow>", 8))
				u.deco = deco_narrow;
			if (0 == strncmp(token, "<small>", 7))
				u.deco = deco_small;
			if (0 == strncmp(token, "<square>", 8))
				u.deco = deco_square;
			if (0 == strncmp(token, "<fraction>", 10))
				u.deco = deco_fraction;
			if (0 == strncmp(token, "<compat>", 8))
				u.deco = deco_compat;
			if (u.deco != deco_0)
				while (isspace(*p))
					p++;
			while (*p) {
				while (isspace(*p))
					p++;
				deco[n++] = (uint16_t) strtoul(p, NULL, 16);
				while (isxdigit(*p))
					p++;
				if (n >= 255)
					break;
			}
			if (n > 0) {
				u.decn = n;
				u.decp = (uint16_t *)xcalloc(n, sizeof(uint32_t));
				memcpy(u.decp, deco, n * sizeof(uint32_t));
				total_alloc += n * sizeof(uint32_t);
			}
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCDECIMAL
		if (NULL != token && *token != '\0') {
			u.decimal_digit = (uint8_t)strtoul(token, NULL, 10);
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCDIGIT
		if (NULL != token && *token != '\0') {
			u.digit = (uint8_t)strtoul(token, NULL, 10);
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCNUMERIC
		if (NULL != token && *token) {
			u.numeric = (uint8_t)strtoul(token, NULL, 10);
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCMIRRORED
		if (NULL != token && *token) {
			u.mirrored = token[0] == 'Y';
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCNAME10
		if (NULL != token && *token) {
			u.name10 = xstrdup(token);
			total_alloc += strlen(token) + 1;
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
		if (NULL != token && *token) {
			/* hmm */
		}

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCUCASE
		if (NULL != token && *token) {
			u.uppercase = strtoul(token, NULL, 16);
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCLCASE
		if (NULL != token && *token) {
			u.lowercase = strtoul(token, NULL, 16);
		}
#endif

		tokennum++;
		if (NULL == (token = e_strtok(NULL, ";\n"))) {
			LOG(L_ERROR,("token #%d failed on line %d\n",
				tokennum, linenum));
		}
#if	NEED_WCTCASE
		if (NULL != token && *token) {
			u.titlecase = strtoul(token, NULL, 16);
		}
#endif

		if (first > 0 && last > 0) {
			if (first + 1 >= PLANESIZE) {
				LOG(L_NORMAL,("range %d-%d outside plane 0\n",
					first + 1, last));
			} else {
				LOG(L_NORMAL,("setting range %d-%d\n",
					first + 1, last));
				for (code = first + 1; code <= last && code < PLANESIZE; code++)
					unicode_data[code] = unicode_data[first];
			}
			first = last = 0;
		} else if (code < PLANESIZE) {
			unicode_data[code] = u;
		}
	}
	lzw_close(lzw);
	xfree(line);

	info("%s %dK ",
		UNICODE_LIST,
		total_alloc / 1024);

	return 0;
}

#else	/* unicode tables not needed */

int unicode(void)
{
	info("unused ");

	return 0;
}

#endif
