/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: uri.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_uri_h_
#define	_uri_h_

#include "osd.h"
#include "key.h"

#define	URI_PROTO		"entropy:"
#define	URI_PROTO_ALT	"freenet:"
#define	URI_CHK			"CHK@"
#define	URI_SSK			"SSK@"
#define	URI_KSK			"KSK@"
#define	URI_SVKEXT		"BCMA"
#define	URI_SVKEXT_ALT	"PAgM"

#ifdef	__cplusplus
extern "C" {
#endif

int is_valid_uri(chkey_t *key, const char *uri);
int is_valid_chk(chkey_t *key, const char *uri);
int is_valid_ssk(chkey_t *key, const char *uri);
int is_valid_ksk(chkey_t *key, const char *uri);
int is_valid_bit(chkey_t *key, const char *uri);

int is_chk(const char *uri);
int is_ssk(const char *uri);
char *normalize_uri(const char *uri);
char *create_uri_from_chk(const chkey_t *key);
char *create_uri_from_ssk(const chkey_t *key);
int create_chk_from_ksk(chkey_t *key, const char *ksk);

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_uri_h_) */
