/* $Id: twofish_debug.h,v 1.1.1.1 2005/06/21 14:14:16 pullmoll Exp $ */

#ifdef DEBUGFISH	/* keep these macros common so they are same for both versions */

#define DebugDump(x,s,R,XOR,doRot,showT,needBswap)	\
	{ _Dump(x,s,R,XOR,doRot,showT,needBswap,t0,t1); }
#define	DebugDumpKey(key) { _DumpKey(key); }
#define	IV_ROUND	-100
	
void _Dump(const void *p,const char *s,int R,int XOR,int doRot,int showT,int needBswap,
		   uint32_t t0,uint32_t t1)
	{
	char line[512];	/* build output here */
	int  i,n;
	uint32_t q[4];

	if (R == IV_ROUND)
		sprintf(line,"%sIV:    ",s);
	else
		sprintf(line,"%sR[%2d]: ",s,R);
	for (n=0;line[n];n++) ;
	
	for (i=0;i<4;i++)
		{
		q[i]=((const uint32_t *)p)[i^(XOR)];
		if (needBswap) q[i]=Bswap(q[i]);
		}

	sprintf(line+n,"x= %08uX  %08uX  %08uX  %08uX.",
			ROR(q[0],doRot*(R  )/2),
			ROL(q[1],doRot*(R  )/2),
			ROR(q[2],doRot*(R+1)/2),
			ROL(q[3],doRot*(R+1)/2));
	for (;line[n];n++) ;

	if (showT)
		sprintf(line+n,"    t0=%08uX. t1=%08uX.",t0,t1);
	for (;line[n];n++) ;

	sprintf(line+n,"\n");
	printf(line);
	}

void _DumpKey(const keyInstance *key)
	{
	char	line[512];
	int		i;
	int		k64Cnt=(key->keyLen+63)/64;	/* round up to next multiple of 64 bits */
	int		subkeyCnt = ROUND_SUBKEYS + 2*key->numRounds;

	sprintf(line,";\n;makeKey:   Input key            -->  S-box key     [%s]\n",
		   (key->direction == DIR_ENCRYPT) ? "Encrypt" : "Decrypt");
	printf(line);
	for (i=0;i<k64Cnt;i++)	/* display in RS format */
		{
		sprintf(line,";%12s %08uX %08uX  -->  %08uX\n","",
			   key->key32[2*i+1],key->key32[2*i],key->sboxKeys[k64Cnt-1-i]);
		printf(line);
		}
	sprintf(line,";%11sSubkeys\n","");
	printf(line);
	for (i=0;i<subkeyCnt/2;i++)
		{
		sprintf(line,";%12s %08uX %08uX%s\n","",key->subKeys[2*i],key->subKeys[2*i+1],
			  (2*i ==  INPUT_WHITEN) ? "   Input whiten" :
			  (2*i == OUTPUT_WHITEN) ? "  Output whiten" :
		      (2*i == ROUND_SUBKEYS) ? "  Round subkeys" : "");
		printf(line);
		}
	printf(line);
	}
#else
#define DebugDump(x,s,R,XOR,doRot,showT,needBswap)
#define	DebugDumpKey(key)
#endif
