/*
 * SHA-1 in C
 * By Steve Reid <steve@edmweb.com>
 * 100% Public Domain
 */

/* $Id: sha1.h,v 1.1.1.1 2005/06/21 14:14:15 pullmoll Exp $ */
#ifndef _sha1_h_
#define	_sha1_h_

#include "osd.h"
#include "tools.h"

#define	SHA1SIZE	20

typedef struct sha1_state_s {
	uint32_t state[5];
	uint32_t count[2];  
	uint8_t buffer[64];
}	sha1_state_t;

typedef struct sha1_digest_s {
	uint8_t digest[SHA1SIZE];
}	sha1_digest_t;

#ifdef	__cplusplus
extern "C" {
#endif
  
void sha1_transform(uint32_t state[5], const uint8_t buffer[64]);
void sha1_init(sha1_state_t *pss);
void sha1_append(sha1_state_t *pss, const void *data, size_t len);
void sha1_finish(sha1_state_t *pss, sha1_digest_t *pd);
void sha1(const void *data, size_t len, sha1_digest_t *pd);
const char *sha1_hexstr(const sha1_digest_t *pd);
const char *sha1_hexshort(const sha1_digest_t *pd);
int sha1_strhex(sha1_digest_t *pd, const char *src);

#ifdef	__cplusplus
}
#endif

#endif /* !defined(_sha1_h_) */
