/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: settings.h,v 1.8 2005/08/13 04:06:46 pullmoll Exp $
 *****************************************************************************/
#ifndef	_settings_h_
#define	_settings_h_

#include "osd.h"

#ifndef	MAXPATHLEN
#define	MAXPATHLEN	255
#endif

#define	UNKNOWN_LENGTH	((size_t)-1)
#define	INVALID_ADDR	((caddr_t)-1)

#define	CHUNKSIZE		(256*1024)			/* size of a FEC chunk */
#define	FRAGSIZE		(CHUNKSIZE*8)	/* file fragment size */
#define	FCP_BLOCKSIZE	(128*1024)			/* maximum FCP transfers block size */
#define	FNP_BUFFSIZE	(32*1024)			/* FNP maximum block size */
#define	TEMPSIZE		(1024*1024)	/* temporary buffer for (un)compress */

#define	TICKS_PER_SEC	10				/* bandwidth dispatcher ticks/sec */
#define	NICE			5				/* niceness of child processes */

#define	MKVERSION2(major,minor) \
	(((uint64_t)(major)<<32)|(uint32_t)(minor))

#define	MKMINOR(level,step) \
	(((uint32_t)(level)<<16)|((uint16_t)step))

#define	MKVERSION3(major,minor_level,minor_step) \
	MKVERSION2(major,MKMINOR(minor_level,minor_step))

#define	MINOR_LEVEL(minor) ((uint32_t)(minor)/0x10000)
#define	MINOR_STEP(minor) ((uint32_t)(minor)%0x10000)

#define	PROGNAME		"entropy_rsa"

#define	NODE_NAME		"ENTROPY/RSA"

#define	PEER_MINVERSION	MKVERSION3(0,9,1)
#define	PEER_MINBUILD	438

#ifndef	NODE_PROTO
#define	NODE_PROTO		"1.2"
#endif

#define	PROGPATH_DEFAULT	"./"
#ifndef	RUNPATH_DEFAULT
#define	RUNPATH_DEFAULT		"./"
#endif
#ifndef	TEMPPATH_DEFAULT
#define	TEMPPATH_DEFAULT	"./tmp"
#endif
#ifndef	SEEDNODES_DEFAULT
#define	SEEDNODES_DEFAULT	"seed.txt"
#endif
#ifndef	WHITELIST_DEFAULT
#define	WHITELIST_DEFAULT	"whitelist.txt"
#endif
#ifndef	BLACKLIST_DEFAULT
#define	BLACKLIST_DEFAULT	"blacklist.txt"
#endif
#ifndef	CONFIG_DEFAULT
#define	CONFIG_DEFAULT		PROGNAME ".conf"
#endif

#define	MAXBLACKLIST	256
#define	MAXWHITELIST	256

#define	NODE_NAME_DEFAULT	"UNKNOWN"
#define	NODE_PORT_DEFAULT	37373

#define	FCP_HOST_DEFAULT	"127.0.0.1"
#define	FCP_PORT_DEFAULT	8482

#define	PROXY_HOST_DEFAULT	"127.0.0.1"
#define	PROXY_PORT_DEFAULT	9999

#define	BIND_ADDR_DEFAULT	"0.0.0.0"
#define	BIND_PORT_DEFAULT	0

#define	BACKLOG_DEFAULT		64	/* backlog value for listen() */

#define	CRYPTO_DEFAULT		"lorenz"

#define	MAX_HTL				255
#define	MAX_HTL_DEFAULT		25
#define	PROXY_HTL_DEFAULT	5
#define	ANNOUNCE_HTL		(g_conf->maxhtl*3/10)

/* Assume a 768/128 kbit DSL connection as the most common type */
#define	BWLIMIT_DEFAULT		0
#define	BWLIMIT_IN_DEFAULT	(128*1024)
#define	BWLIMIT_OUT_DEFAULT	(14*1024)

#define	FEC_QUEUESIZE		256
#define	FEC_QUEUESIZE_DEFAULT 64
#define	FCP_RETRIES_DEFAULT	3

#define	PROXYCACHE			64

#define	NEWS_SKIP_DEFAULT	3
#define	NEWS_TRIES_DEFAULT	1
#define	NEWS_DAYS_DEFAULT	14
#define	SECSPERDAY	(24*60*60)

/* Fixed setting, because many limits depend on it */
#define	PEERS_MAX		64
#define	PEERS_IN_MAX		(PEERS_MAX/2)
#define	PEERS_OUT_MAX		(PEERS_MAX/2)

#define	STOREPATH_DEFAULT	"./store"
#define	STOREDEPTH_DEFAULT	2
#define	STORESIZE_DEFAULT	((uint64_t)1024 * 1024 * 1024)

enum {
	LOGSECTION_CORE,
	LOGSECTION_MEM,
	LOGSECTION_SHM,
	LOGSECTION_SOCK	,
	LOGSECTION_CRYPTO,
	LOGSECTION_PEER,
	LOGSECTION_STORE,
	LOGSECTION_FILE,
	LOGSECTION_CLIENT,
	LOGSECTION_PROXY,
	LOGSECTION_NEWS,
	LOGSECTIONS		/* number of sections */
};

#if	STORE_TYPE == 2
#define MYSQL_USER_DEFAULT	"myname"
#define MYSQL_PASS_DEFAULT	"mypass"
#define MYSQL_DB_DEFAULT	"entropy"
#define MYSQL_HOST_DEFAULT	"localhost"
#define MYSQL_PORT_DEFAULT	0
#define	MYSQL_TABLESIZE_DEFAULT	((uint64_t)1024*1024*1024)
#endif	/* STORE_TYPE == 2 */

typedef struct configuration_s {
	/* timestamp of the config file to recognize updates */
	time_t timestamp;
	int niceness;
	/* sock.c */
	int backlog;
	/* entropy.c */
	char program[MAXPATHLEN];
	char progname[MAXPATHLEN];
	char progpath[MAXPATHLEN];
	char runpath[MAXPATHLEN];
	char configfile[MAXPATHLEN];
	char temppath[MAXPATHLEN];
	char logfile[MAXPATHLEN];
	int loglevel[LOGSECTIONS];
	/* peer.c */
	struct sockaddr_in node;
	char nodename[MAXPATHLEN];
	int nodeport;		/* port to announce */
	char bindaddr[4*4];	/* dotted quad */
	int bindport;		/* port to bind to */
	int maxhtl;
	uint32_t fec_queuesize;
	uint32_t bwlimit;
	uint32_t bwlimit_in;
	uint32_t bwlimit_out;
	uint64_t bwlimit_daily;
	char seednodes[MAXPATHLEN];
	char whitelist[MAXPATHLEN];
	char blacklist[MAXPATHLEN];
	size_t whitecnt;
	size_t blackcnt;
	struct sockaddr_in white[MAXWHITELIST];
	struct sockaddr_in black[MAXBLACKLIST];
	uint32_t latest_major;
	uint32_t latest_minor;
	uint32_t latest_build;
	/* client.c */
	char fcphost[MAXPATHLEN];
	int fcpport;
	int fcpretries;
	/* proxy.c */
	char proxyhost[MAXPATHLEN];
	int proxyport;
	int proxyhtl;
#if	PROXYCACHE
	size_t proxycache;
#endif
	/* news.c */
	char news_base[MAXPATHLEN];
	char news_boards[MAXPATHLEN];
	char news_ignore[MAXPATHLEN];
	size_t news_days;
	size_t news_tries;
	size_t news_skip;
	char news_nick[32];

	/* store.c */
	char storepath[MAXPATHLEN];
	uint64_t storesize;
	uint32_t storedepth;
	uint32_t storekeys;
	uint32_t storehead;

#if	STORE_TYPE == 2
	/* store_mysql.c */
	char mysql_user[32];
	char mysql_pass[32];
	char mysql_db[32];
	char mysql_host[MAXPATHLEN];
	unsigned int mysql_port;
	int mysql_optimize;
	uint64_t mysql_tablesize;
#endif	/* STORE_TYPE == 2 */

	char password[16+1];
	char language[2+1];

#define	MAXCRYPTOMODULENAMELEN	32
#define	CRYPTOMODULES			16
	char crypto_default[MAXCRYPTOMODULENAMELEN];
	size_t crypto_reject[CRYPTOMODULES];
}	configuration_t;

#ifdef	__cplusplus
extern "C" {
#endif
/* configuration: shared memory */
extern configuration_t *g_conf;

int conf_init(int argc, char **argv);
int conf_read_line(char *line, const char *source, configuration_t *p_conf);
int conf_read(int argc, char **argv, const char *filename);
int conf_write(const char *filename);
int conf_update();

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_config_h_) */
