/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: news.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_news_h_
#define	_news_h_

#include "osd.h"
#include "memalloc.h"
#include "shmalloc.h"
#include "i18n.h"
#include "key.h"
#include "uri.h"
#include "file.h"
#include "peer.h"
#include "store.h"
#include "png.h"
#include "vt.h"
#include "i18n.h"
#include "sock.h"
#include "mime.h"

/* This should be related to the amount of shared memory in shmalloc.h */
#define	MAX_NEWS	512
#define	MAX_BOARDS	512

#define	MAX_BOARDSIZE	31
#define	MAX_FROMSIZE	31
#define	MAX_SUBJECTSIZE	127
#define	MAX_CHARSETSIZE	31
#define	MAX_BODYSIZE	64*1024
/*
 *	a news post structure
 *	rc is the result code of the insertion
 *	*board is the board name where this news is inserted
 *	date is the date and time of the message
 *	fquri will receive the fully qualified URI of the message
 *	status is updated with information from the insertion proceeding
 */
typedef struct news_post_s {
	int rc;
	void *user;
	int (*writer)(vt_t *vt, const char *str, int len);
	const char *board;		/* board name for the message */
	const char *charset;	/* charset used to encode the message */
	struct tm date;			/* date and time of the message */
	char *data;				/* the body */
	char fquri[80];			/* fully qualified URI returned from insert */
}	news_post_t;

/*
 *	a news board structure
 *	key is the content hash key of the _boardlist entry
 *	slot is the slot number, where this board announcement was found
 *	date is the date for which this board announcement was found
 *	*board is the board's name
 */
typedef struct news_board_s {
	chkey_t key;
	size_t slot;
	struct tm date;
	char board[MAX_BOARDSIZE+1];
}	news_board_t;

/*
 *	a news entry structure
 *	key is the content hash key of the message
 *	slot is the slot, where this message was found
 *	date is the date this message
 *	*board is the board name of this message
 *	*from is the sender's name for this message
 *	*subject is the subject line for this message
 *	time is the date and time according to the message header
 *	*body is the contents of the message
 *	seen is set to non zero by the message viewer in src/proxy.c
 */
typedef struct news_entry_s {
	chkey_t key;
	size_t slot;
	struct tm date;
	char board[MAX_BOARDSIZE+1];
	char from[MAX_FROMSIZE+1];	
	char subject[MAX_SUBJECTSIZE+1];
	char charset[MAX_CHARSETSIZE+1];
	time_t time;
	int seen;
	char body[1];	/* really up to MAX_BODYSIZE+1 */
}	news_entry_t;

/*
 *	the news polling structure
 *	sem is a semaphore used to lock down this structure during changes
 *	rescan is a flag that, if set, restarts the scanning schedule from today
 *	magic is the KSK@ prefix where messages will be inserted
 *	pass is the scan pass number
 *	board contains the currently scanned board name
 *	date contains the currently scanned date
 *	past is the current offset into the past in seconds (increments by 86400)
 *	decay is a value that reduces the scan-into-past depth after every scan
 *	slot is the currently scanned slot number
 *	skip is the currently skipped number of (missing) slots
 *	retry[] is an array of retry counts, starting from number (= retry[0])
 *	board_idx is the index into the configured list of boards to scan
 *	board_cnt is the number of _boardlist entries that we found
 *	boardlist[] is an array of board entries
 *	entry_cnt is the number of messages that we found
 *	entrylist[] is an array of message entries
 */
typedef struct news_s {
	osd_sem_t sem;
	int rescan;
	char magic[MAXPATHLEN];
	size_t pass;
	char board[MAXPATHLEN];
	struct tm date;
	time_t past;
	size_t decay;
	size_t slot;
	size_t skip;
	size_t retry[64];
	size_t board_idx;
	size_t board_max, board_cnt;
	news_board_t **boardlist;
	size_t entry_max, entry_cnt;
	news_entry_t **entrylist;
}	news_t;

#ifdef	__cplusplus
extern "C" {
#endif
extern news_t *g_news;

int news_post(const char *lang, news_post_t *np);
int news(void);
#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_news_h_) */
