/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: logger.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_logger_h_
#define	_logger_h_

#include "osd.h"

#define	L_NONE		0
#define	L_ERROR		1
#define	L_NORMAL	2
#define	L_MINOR		3
#define	L_DEBUG		4
#define	L_DEBUGX	5

#define	L_CORE		LOGSECTION_CORE
#define	L_MEM		LOGSECTION_MEM
#define	L_SHM		LOGSECTION_SHM
#define	L_SOCK		LOGSECTION_SOCK
#define	L_CRYPTO	LOGSECTION_CRYPTO
#define	L_PEER		LOGSECTION_PEER
#define	L_FILE		LOGSECTION_FILE
#define	L_STORE		LOGSECTION_STORE
#define	L_CLIENT	LOGSECTION_CLIENT
#define	L_PROXY		LOGSECTION_PROXY
#define	L_NEWS		LOGSECTION_NEWS

#if	DEBUG

#ifdef	__GNUC__
#define	FORMAT_CHECK	__attribute__((format(printf,1,2)))
#else
#define	FORMAT_CHECK
#endif

#ifndef	LOGLEVEL
#define	LOGLEVEL(section) g_conf->loglevel[section]
#endif
#ifndef	LOGFILE
#define	LOGFILE g_conf->logfile
#endif

#define	FUN(name) \
	static const char *__function__ = name; \
	(void)__function__

#define	LOG(level,msg) \
	if (NULL != g_conf && level <= LOGLEVEL(L_CORE)) \
		logprintf(level, __function__, __FILE__, __LINE__, logappend msg)

#define	LOGS(section,level,msg) \
	if (NULL != g_conf && level <= LOGLEVEL(section)) \
		logprintf(level, __function__, __FILE__, __LINE__, logappend msg)

#ifdef	__cplusplus
extern "C" {
#endif
int logprintf(int lvl, const char *func, const char *file, int line, char *msg);
char *logappend(const char *fmt, ...) FORMAT_CHECK;
#ifdef	__cplusplus
}
#endif
#else

#define	LOG(level,msg)
#define	LOGS(level,section,msg)
#define	FUN(name)

#endif

#endif	/* !defined(_logger_h_) */
