/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: i18n.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_i18n_h_
#define	_i18n_h_

#include "osd.h"

/* localization lookup table entry */
typedef struct l10n_s {
	struct l10n_s *next;
	char *lang;
	char *charset;
	char *english;
	char *localized;
}	l10n_t;

#define	LO(src)	localize(LANG,CHARSET,src)

#ifdef	__cplusplus
extern "C" {
#endif
const char *localize(const char *lang, const char *charset,
	const char *english);
int i18n(const char *path);
#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_i18n_h_) */
