/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: funclib.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_funclib_h_
#define	_funclib_h_

#include "osd.h"

/* functions not supplied by all systems */
#if	!HAVE_GETPAGESIZE
int getpagesize(void);
#endif

#if	!HAVE_STRTOULL   
#ifndef	ULLONG_MAX
/* first guarantee sign extension to 64 bits; then switch to unsigned */
#define	ULLONG_MAX ((uint64_t)(int64_t)-1)
#endif
uint64_t strtoull(const char *nptr, char **endptr, int base);
#endif

#if	!HAVE_TIMEGM
time_t timegm(struct tm *tm);
#endif

#if	!HAVE_UTIMES
int utimes(const char *file, const struct timeval *times);
#endif

#endif	/* !defined(_funclib_h_) */
