/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: file.h,v 1.3 2005/08/13 04:06:46 pullmoll Exp $
 *****************************************************************************/
#ifndef _file_h_
#define	_file_h_

#include "osd.h"
#include "tools.h"
#include "temp.h"
#include "crypt.h"
#include "ek5.h"
#include "sha1.h"
#include "key.h"
#include "uri.h"
#include "fec.h"
#include "store.h"
#include "peer.h"
#include "memalloc.h"
#include "logger.h"

#define	INFO_TYPE_PROGRESS	0
#define	INFO_TYPE_RESTARTED	-1
#define	INFO_TYPE_COMPLETED	1

#define	KEY_VERSION	"RSA2"

typedef struct file_info_s {
	int type;
	int internal;
	sha1_digest_t hash;
	off_t offs;
	size_t size;
}	file_info_t;

#ifdef	__cplusplus
extern "C" {
#endif
/* use for the 'flags' parameter of file_get and file_put */
enum {
	FILE_INT=0x01,
	FILE_DEL=0x02,
	FILE_ZAP=0x04,
	FILE_META=0x08,
	FILE_PART=0x10
};

typedef int (*file_callback)(void *user, file_info_t *info);

int file_squeeze(uint8_t **gzbuff, size_t *gzsize, char *src, size_t size);
int file_expand(char **xpbuff, size_t *xpsize, uint8_t *src, size_t size);

int file_get_frag(sha1_digest_t *s, int htl);

int file_get(chkey_t *key, tempfile_t *tfdata, tempfile_t *tfmeta,
	int htl, size_t *slimit, void *user, file_callback cb, int flags);
int file_put(chkey_t *key, tempfile_t *tfdata, tempfile_t *tfmeta,
	int htl, int *collision, void *user, file_callback cb, int flags);
int file_put_redirect(chkey_t *key, const chkey_t *chk, const char *uri,
	char **fquri, int htl, int *collision, int flags);

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_file_h_) */
