static char rcsid[] = "@(#)$Id: elmterminal.c,v 1.7 2001/06/16 10:40:38 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmutil.h"
#include "s_me.h"
#include "s_elm.h"

extern char *optarg;		
extern int   optind;		

int main(argc, argv)
     int argc;
     char *argv[];
{
  int err = 0;
  int c;
  int global = 0;
  struct terminal_map_item * MAP = NULL;
  char *targetfile = NULL;

#if DEBUG
  init_debugfile("ELMTERMINAL");
#endif
  locale_init();
  user_init();
  init_defaults();
  
  while ((c = getopt(argc, argv, "Gd:w:")) != EOF) {
    switch(c) {
    case 'G':
	global++;
	break;
    case 'd' : 
#if DEBUG
	set_debugging(optarg);	 
#else
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			"Warning: system created without debugging enabled - request ignored\n"));
#endif
	break;
    case 'w' : 
	targetfile = optarg;
	if (0 != access(targetfile,WRITE_ACCESS)) {
	    int errcode = errno;
	    
	    if (errcode != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  targetfile, error_description(errcode));
		err++;
		goto fail;
	    }
	}
	break;
    case '?':
	err = 1;
	goto fail;
    }
  }


    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);

#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMTERMINAL program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    error_sleep(5+sleepmsg);	    
	}
#endif
    }
#endif

  if (!global)
      read_rc_file();

  if (optind < argc) {
      int errcount = 0;
      MAP = load_terminal_map(argv[optind],&errcount);
      if (!MAP || errcount) {
	err = 1;
	goto fail;
      }
  }
	  
  if (!MAP) {
      if (global)
	  MAP = system_terminal_map;
      else
	  MAP = user_terminal_map;
  }

  if (targetfile) {
      char * tmp = elm_message(FRM("%s.N"),targetfile);
      int errcode = can_open(tmp,"w");
      FILE *f;
      
      if (errcode) {
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      f = fopen(tmp,"w");
      if (!f) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      dump_terminal_map(f,MAP);
      if (EOF == fclose(f)) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      if (0 != rename(tmp,targetfile)) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
			    "Failed to rename temporary file to %.50s: %30s"),
		    targetfile, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      free(tmp);
  }    
  else
      dump_terminal_map(stdout,MAP);

 fail:
  if (err)
      lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			"%s failed; exit code=%d"),
		argv[0],err);

  return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
