static char rcsid[] = "@(#)$Id: screen.c,v 1.20 2001/06/14 18:25:45 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.20 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/**  screen display routines for ELM program 

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ui");

#define  minimum(a,b)	((a) < (b) ? (a) : (b))

char *show_status();

extern char version_buff[];

static int fix_header_page P_((void));

void showscreen()
{

	ClearScreen();

	update_title();

	last_header_page = -1;	 	/* force a redraw regardless */
	show_headers();

	if (mini_menu)
	  show_menu();

	show_last_error();
	
	/* define_softkeys(MAIN); */
}

void update_title()
{
    /** display a new title line, probably due to new mail arriving **/
    
    struct string * folder_string = NULL;
    struct string * buffer = NULL;
    struct string * buffer2 = NULL;

    ClearLine(1);
    ClearLine(2);

    if (current_folder) {
	int l1,l2,l;
	if (*hostname && menu_display_host) 
	    folder_string = format_string(FRM("%s:%S"), hostname, 
					  current_folder->cur_folder_disp);
	else
	    folder_string = dup_string(current_folder->cur_folder_disp);
	

	if (selected)
	    buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
					   ElmShownWithSelect,
					   "%s is '%S' with %d shown out of %d"),
				   folder_type(current_folder),
				   folder_string, selected, message_count);
	else if (message_count == 1)
	    buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
					   ElmShownNoSelect,
					   "%s is '%S' with 1 message"),
				   folder_type(current_folder),
				   folder_string);
	else
	    buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
					   ElmShownNoSelectPlural,
					   "%s is '%S' with %d messages"),
				   folder_type(current_folder),
				   folder_string, message_count);
    
	free_string(&folder_string);

	l1 = string_len(buffer);

	buffer2 = format_string(FRM("[ELM %s]"),version_buff);
	l2 = string_len(buffer2);
	l = l1 + l2 + 1; /* Assumed */

	if (l > elm_COLUMNS) {
	    if (l2 < elm_COLUMNS)
		PutLineX(2,(elm_COLUMNS - l2)/2,FRM("%S"),buffer2);
	    if (l1 > elm_COLUMNS) 
		PutLineX(1,1,FRM("%S"),buffer);
	    else
		PutLineX(1,(elm_COLUMNS - l1)/2,FRM("%S"),buffer);
	} else {
	    PutLineX(1,(elm_COLUMNS - l)/2,FRM("%S %S"),buffer,buffer2);
	}
	
	free_string(&buffer);
	free_string(&buffer2);
    }    
}

void show_menu()
{
    /** write main system menu... **/

    if (user_level == 0) {	/* a rank beginner.  Give less options  */
	  print_format_center(elm_LINES-7, 
			      CATGETS(elm_msg_cat, ElmSet, 
				      ElmLevel0MenuLine1,
				      "You can use any of the following commands by pressing the first character;"));
         print_format_center(elm_LINES-6, 
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmLevel0MenuLine2,
				     "d)elete or u)ndelete mail,  m)ail a message,  r)eply or f)orward mail,  q)uit"));
	 print_format_center(elm_LINES-5, 
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmLevel0MenuLine3,
				     "To read a message, press <return>.  j = move down, k = move up, ? = help"));
    } else {
	print_format_center(elm_LINES-7, 
			    CATGETS(elm_msg_cat, ElmSet, 
				    ElmLevel1MenuLine1,
				    "|=pipe, !=shell, ?=help, <n>=set current to n, /=search pattern"));
        print_format_center(elm_LINES-6, 
			    CATGETS(elm_msg_cat, ElmSet, 
				    ElmLevel1MenuLine2,
				    "a)lias, C)opy, c)hange folder, d)elete, e)dit, f)orward, g)roup reply, m)ail,"));
	print_format_center(elm_LINES-5, 
			    CATGETS(elm_msg_cat, ElmSet, 
				    ElmLevel1MenuLine3,
				    "n)ext, o)ptions, p)rint, q)uit, r)eply, s)ave, t)ag, u)ndelete, or e(x)it"));
    }
}

static struct string * build_header_line P_((struct header_rec *entry, 
					     int message_number, 
					     int highlight, 
					     struct string *from, 
					     int really_to));



int show_headers()
{
	/** Display page of headers (10) if present.  First check to 
	    ensure that header_page is in bounds, fixing silently if not.
	    If out of bounds, return zero, else return non-zero 
	    Modified to only show headers that are "visible" to ze human
	    person using ze program, eh?
	**/

	register int this_msg = 0, line = 4, last = 0, last_line, 
		     displayed = 0, using_to;

	if (fix_header_page())
	    return(FALSE);

	if (selected) {
	  if ((header_page*headers_per_page) > selected)
	    return(FALSE); 	/* too far! too far! */

	  this_msg = visible_to_index(header_page * headers_per_page + 1);
	  displayed = header_page * headers_per_page;

	  last = displayed+headers_per_page;

	}
	else {
	  if (header_page == last_header_page) 	/* nothing to do! */
	    return(FALSE);

	  /** compute last header to display **/
  
	  this_msg = header_page * headers_per_page;
	  last = this_msg + (headers_per_page - 1);
	}

	if (last >= message_count) last = message_count-1;

	/** Okay, now let's show the header page! **/

	ClearLine(line);	/* Clear the top line... */

	MoveCursor(line, 0);	/* and move back to the top of the page... */

	while ((selected && displayed < last) || this_msg <= last) {
	    struct string * buffer = NULL;

#if DEBUG
	    if (Debug.active > 10 && !inalias) {
		struct addr_item * p;

		for (p =  headers[this_msg]->from; p && p->addr; p++) {
		    DPRINT(Debug,15,(&Debug, 
				     "-- %d:from[%d] addr='%s' comment='%S' fullname='%S'\n",
				     this_msg,p - headers[this_msg]->from,
				     p->addr,
				     p->comment,
				     p->fullname));		    
		}

		for (p =  headers[this_msg]->to; p && p->addr; p++) {
		    DPRINT(Debug,15,(&Debug, 
				     "-- %d:  to[%d] addr='%s' comment='%S' fullname='%S'\n",
				     this_msg,p - headers[this_msg]->to,
				     p->addr,
				     p->comment,
				     p->fullname));		    
		}

		for (p =  headers[this_msg]->cc; p && p->addr; p++) {
		    DPRINT(Debug,15,(&Debug, 
				     "-- %d:  cc[%d] addr='%s' comment='%S' fullname='%S'\n",
				     this_msg,p - headers[this_msg]->cc,
				     p->addr,
				     p->comment,
				     p->fullname));		    
		}
	    }
#endif

	  if (inalias) {
	    if (this_msg == current-1)
	      buffer = build_alias_line(aliases[this_msg], this_msg+1,TRUE);
	    else
	      buffer = build_alias_line(aliases[this_msg], this_msg+1,FALSE);
	  }
	  else {
	      struct string * newfrom = NULL;
	      using_to = DisplayAddress(headers[this_msg], &newfrom);
	      
	      if (this_msg == current-1) 
		  buffer = build_header_line(headers[this_msg], this_msg+1,
					     TRUE, newfrom, using_to);
	      else
		  buffer = build_header_line(headers[this_msg], this_msg+1, 
					     FALSE, newfrom, using_to);
	      free_string(&newfrom);
	  }

	  if (selected) 
	    displayed++;

	  if (this_msg == current-1 && has_highlighting && ! arrow_cursor) {
	      StartInverse();
	      Write_to_screen(FRM("%S\n\r"), buffer);	/* avoid '%' probs */
	      EndInverse();
	  } else
	      Write_to_screen(FRM("%S\n\r"), buffer);	/* avoid '%' probs */
	  CleartoEOLN();
	  line++;		/* for clearing up in a sec... */

	  if (selected) {
	      if ((this_msg = next_message(this_msg, FALSE)) < 0)
		  break;	/* GET OUTTA HERE! */
	      
	      /* the preceeding looks gross because we're using an INDEX
		 variable to pretend to be a "current" counter, and the 
		 current counter is always 1 greater than the actual 
		 index.  Does that make sense??
	      */
	  }
	  else
	      this_msg++;					/* even dumber...  */

	  free_string(&buffer);
	}

	/* clear unused lines */

	if (mini_menu)
	  last_line = elm_LINES-8;
	else
	  last_line = elm_LINES-4;

	while (line < last_line) {
	  CleartoEOLN();
	  NewLine();
	  line++;
	}

	display_central_message();

	last_current = current;
	last_header_page = header_page;

	return(TRUE);
}

void show_current()
{
    /** Show the new header, with all the usual checks **/
    
    int first = 0, last = 0, last_line, new_line, using_to;

    (void) fix_header_page();	/* Who cares what it does? ;-) */

    /** compute the first and last header on this page **/
    first = header_page * headers_per_page + 1;
    last  = first + (headers_per_page - 1);

    /* if not a full page adjust last to be the real last */
    if (selected && last > selected)
	last = selected;
    if (!selected && last > message_count) 
	last = message_count;

    /** okay, now let's show the pointers... **/

    /** have we changed??? **/
    if (current == last_current) 
	return;

    if (selected) {
	last_line = ((compute_visible(last_current)-1) %
		     headers_per_page)+4;
	new_line  = ((compute_visible(current)-1) % headers_per_page)+4;
    } else {
	last_line = ((last_current-1) % headers_per_page)+4;
	new_line  = ((current-1) % headers_per_page)+4;
    }
    
    if (has_highlighting && ! arrow_cursor) {
	struct string * new_buffer = NULL;

	
	if (inalias)
	    new_buffer = build_alias_line(aliases[current-1], current,TRUE);
	else {
	    struct string * newfrom = NULL;
	    using_to = DisplayAddress(headers[current-1], &newfrom);
	    new_buffer = build_header_line(headers[current-1],  current,
					   TRUE, newfrom, using_to);
	    free_string(&newfrom);
	}
	
	/* clear last current if it's in proper range */
	if (last_current > 0		/* not a dummy value */
	    && compute_visible(last_current) <= last
	    && compute_visible(last_current) >= first) {
	    struct string * old_buffer = NULL;
	    
	    DPRINT(Debug,5,(&Debug,  
			    "\nlast_current = %d ... clearing [1] before we add [2]\n", 
			    last_current));
	    DPRINT(Debug,5,(&Debug, 
			    "first = %d, and last = %d\n\n",
			    first, last));
	    
	    if (inalias)
		old_buffer = build_alias_line(aliases[last_current-1],
					      last_current, FALSE);
	    else {
		struct string * newfrom = NULL;       
		using_to = DisplayAddress(headers[last_current-1], &newfrom);
		old_buffer = build_header_line(headers[last_current-1], 
					       last_current, FALSE, newfrom, 
					       using_to);
		free_string(&newfrom);
	    }

	    ClearLine(last_line);	    
	    PutLineX(last_line, 0, FRM("%S"),old_buffer);
	    free_string(&old_buffer);
	}
	MoveCursor(new_line, 0);
	StartInverse();
	Write_to_screen(FRM("%S"), new_buffer);
	EndInverse();

	free_string(&new_buffer);
    } else {
	if (on_page(last_current-1)) 
	    PutLine0(last_line,0,"  ");	/* remove old pointer... */
	if (on_page(current-1))
	    PutLine0(new_line, 0,"->");
    }
	
    last_current = current;
}

static struct string * build_header_line(entry, message_number, highlight, 
					 from, really_to)
     struct header_rec *entry;
     int message_number, highlight, really_to;
     struct string *from;
{
    struct string * buffer = NULL;
    struct string * ret    = NULL;

    /** Build in buffer the message header ... entry is the current
	message entry, 'from' is a modified (displayable) from line, 
	'highlight' is either TRUE or FALSE, and 'message_number'
	is the number of the message.
    **/
	
    int who_width = 18, subj_width = 0;
    int header_without_subj_width;

    /* truncate 'from' to 18 characters -
     * this includes the leading "To" if really_to is true.
     */

    if (*entry->time_menu == '\0')
	make_menu_date(entry); 

    /* show "To " in a way that it can never be truncated. */
    if (really_to) {
	who_width -= 3;
    }
        
    buffer = format_string(FRM("%.2s%.2s%c%-3d %.10s %.3s%-*.*S (%d) %s"),
			   (highlight && arrow_cursor)? "->" : "  ",
			   show_status(entry->status,entry),
			   (entry->status & TAGGED?  '+' : ' '),
			   message_number,
			   entry->time_menu,
			   (really_to ? "To " : ""),
			   /* give max and min width parameters for 'from' */
			   who_width,
			   who_width,
			   from,
			   
			   entry->lines, 
			   (entry->lines / 1000   > 0? ""   :	/* spacing the  */
			    entry->lines / 100   > 0? " "  :	/* same for the */
			    entry->lines / 10  > 0? "  " :	/* lines in ()  */
			    "   ")      /*   [wierd]    */
			   );
	


    /* Get width of the header so far. */
    header_without_subj_width = string_len(buffer);
    
    /* Set the subject display width.
     * If it is too long, truncate it to fit.
     * If it is highlighted but not with the arrow  cursor,
     * expand it to fit so that the reverse video bar extends
     * aesthetically the full length of the line.
     */
    if ((highlight && !arrow_cursor)
	|| (elm_COLUMNS-header_without_subj_width 
	    < (subj_width = string_len(entry->subject))))
	subj_width = elm_COLUMNS-header_without_subj_width;
        
    /* complete line with subject. */
    if (subj_width > 0) {
	ret = format_string(FRM("%S%-*.*S"),
			    buffer,
			    subj_width, subj_width, entry->subject);   
	free_string(&buffer);
    } else
	ret = buffer;
    
    return ret;
}

int fix_header_page()
{
	/** this routine will check and ensure that the current header
	    page being displayed contains messages!  It will silently
	    fix 'header-page' if wrong.  Returns TRUE if changed.  **/

	int last_page, old_header;

	old_header = header_page;

	last_page = (int) ((message_count-1) / headers_per_page);
 
	if (header_page > last_page) 
	  header_page = last_page;
	else if (header_page < 0) 
          header_page = 0;

	return(old_header != header_page);
}

int on_page(message)
     int message;
{
	/** Returns true iff the specified message is on the displayed page. **/

	if (selected) message = compute_visible(message);

	if (message >= header_page * headers_per_page)
	  if (message < ((header_page+1) * headers_per_page))
	    return(TRUE);

	return(FALSE);
}

char *show_status(status,hdr)
int status;
struct header_rec *hdr;
{
	/** This routine returns a pair of characters indicative of
	    the status of this message.  The first character represents
	    the interim status of the message (e.g. the status within 
	    the mail system):

		E = Expired message
		N = New message
		O = Unread old message	dsi mailx emulation addition
		D = Deleted message
		_ = (space) default 

	    and the second represents the permanent attributes of the
	    message:

		C = Company Confidential message
	        U = Urgent (or Priority) message
		P = Private message
		A = Action associated with message
		F = Form letter
		M = MIME compliant message which needs metamail
		? = Unsupported MIME version
		m = Non-MIME message which needs metamail
		_ = (space) default
	**/

	static char mybuffer[3];

	/** the first character, please **/

	     if (status & DELETED)	mybuffer[0] = 'D';
	else if (status & EXPIRED)	mybuffer[0] = 'E';
	else if (status & NEW)		mybuffer[0] = 'N';
	else if (status & UNREAD)	mybuffer[0] = 'O';
        else if (status & REPLIED)	mybuffer[0] = 'r';
	else                            mybuffer[0] = ' ';

	/** and the second... **/

	     if (status & CONFIDENTIAL) mybuffer[1] = 'C';
	else if (status & URGENT)       mybuffer[1] = 'U';
	else if (status & PRIVATE_MAIL) mybuffer[1] = 'P';
	else if (status & ACTION)       mybuffer[1] = 'A';
	else if (status & FORM_LETTER)  mybuffer[1] = 'F';
	else if (hdr) {
	  if (hdr->encrypted)                     mybuffer[1] = 'e';
	  else if ((status & MIME_MESSAGE) && (status & MIME_UNSUPPORTED))
	    mybuffer[1] = '?';
	  else if ((status & MIME_MESSAGE) && 
		   hdr->mime_rec.disposition != DISP_INLINE) 
	      mybuffer[1] = 'a';
	  else if ((status & MIME_MESSAGE) && hdr->mime_rec.notplain) {
	    if (hdr->mime_rec.flags & MIME_SIGNED)
	      mybuffer[1] = 's';
            else if (hdr->mime_rec.flags & MIME_ENCRYPTED)
	      mybuffer[1] = 'p';
	    else 
	      mybuffer[1] = 'M';
	  }
	  else if ((status & PRE_MIME_CONTENT) && hdr->mime_rec.notplain)
	    mybuffer[1] = 'm';
#ifdef USE_PGP
	  else if (hdr->pgp & PGP_MESSAGE)	  mybuffer[1] = 'P';
	  else if (hdr->pgp & PGP_SIGNED_MESSAGE) mybuffer[1] = 'S';
	  else if (hdr->pgp & PGP_PUBLIC_KEY)	  mybuffer[1] = 'K';
#endif /* USE_PGP */
	  else	    
	    mybuffer[1] = ' ';
	}
	else 			        mybuffer[1] = ' ';

	mybuffer[2] = '\0';

	return( (char *) mybuffer);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */




