static char rcsid[] = "@(#)$Id: mkhdrs.c,v 1.15 2001/06/09 13:37:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.15 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This contains all the header generating routines for the ELM
    program.

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"header");

char *elm_date_str();

static void expand_backquote P_((char *buffer,
				 FILE *filedesc));

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}


void generate_reply_to(current_header,headers)
     struct header_rec * current_header;
     struct mailing_headers *headers;
{
    /** Generate an 'in-reply-to' message... **/
    char date_buf[SLEN];
    int found = 0;

    free_id_phrase(&(headers->in_reply_to));

    if (add_irt_phrase) {
	headers->in_reply_to.text = new_string(display_charset);
    
	if (current_header->messageid) {
	    headers->in_reply_to.id = safe_strdup(current_header->messageid);
	    add_ascii_to_string(headers->in_reply_to.text,s2us(" from "));
	} else
	    add_ascii_to_string(headers->in_reply_to.text,s2us("From "));
	
	if (current_header) {	
	    struct addr_item *p;
	    
	    for (p = current_header->from; p && p->addr && p->fullname; p++) {
		
		if (found)
		    add_ascii_to_string(headers->in_reply_to.text,s2us(", "));
		
		found++;
		
		if (string_len(p->fullname)) {
		    struct string * tmp = 
			cat_strings(headers->in_reply_to.text,
				    p->fullname,1);
		    free_string(&(headers->in_reply_to.text));
		    headers->in_reply_to.text = tmp;		
		}
		else
		    add_ascii_to_string(headers->in_reply_to.text,
					s2us(p->addr));	    
	    }
	    
	    if (!found && current_header->env_from[0]) {
		add_ascii_to_string(headers->in_reply_to.text,s2us("(env: "));
		add_ascii_to_string(headers->in_reply_to.text,
				    s2us(current_header->env_from));
		add_ascii_to_string(headers->in_reply_to.text,s2us(")"));
	    } else if (!found)
		add_ascii_to_string(headers->in_reply_to.text,s2us("someone"));


	    add_ascii_to_string(headers->in_reply_to.text,s2us(" at "));
	    add_ascii_to_string(headers->in_reply_to.text,
				s2us(elm_date_str(date_buf,
						  current_header->time_sent +
						  current_header->tz_offset,
						  sizeof date_buf)));
	}


    } else if (current_header->messageid) {
	/* RFC 2822 (obsoletes RFC 822) says that in-reply-to
	   header should only include message-id
	*/
	headers->in_reply_to.id = safe_strdup(current_header->messageid);
    }
}

void add_mailheaders(filedesc)
     FILE *filedesc;
{
	/** Add the users .mailheaders file if available.  Allow backquoting 
	    in the file, too, for fortunes, etc...*shudder*
	**/

	FILE *fd;
	char buffer[SLEN];


	if ((fd = fopen(user_mailheaders, "r")) != NULL) {
	  while (fgets(buffer, SLEN, fd) != NULL)
	    if (strlen(buffer) < 2) {
	        DPRINT(Debug,2,(&Debug, 
				"Strlen of line from .elmheaders is < 2 (write_header_info)"));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWarningBlankIgnored,
				"Warning: blank line in %s ignored!"), 
			user_mailheaders);
	      if (sleepmsg > 0)
		    sleep(sleepmsg);
	    }
	    else if (occurances_of(BACKQUOTE, buffer) >= 2) 
	      expand_backquote(buffer, filedesc);
	    else 
	      fprintf(filedesc, "%s", buffer);

	    fclose(fd);
	}
}

static void expand_backquote(buffer, filedesc)
     char *buffer;
     FILE *filedesc;
{
	/** This routine is called with a line of the form:
		Fieldname: `command`
	    and is expanded accordingly..
	**/

	FILE *fd;
	char command[SLEN], command_buffer[SLEN], fname[SLEN],
	     prefix[SLEN];
	register int i, j = 0;

	for (i=0; buffer[i] != BACKQUOTE; i++)
	  prefix[j++] = buffer[i];
	prefix[j] = '\0';

	j = 0;

	for (i=chloc(buffer, BACKQUOTE)+1; buffer[i] != BACKQUOTE;i++)
	  command[j++] = buffer[i];
	command[j] = '\0';

	elm_sfprintf(fname,sizeof fname,
		     FRM("%s%s%d"), temp_dir, temp_print, getpid());

	elm_sfprintf(command_buffer, sizeof command_buffer,
		     FRM("%s > %s"), command, fname);

	(void) system_call(command_buffer, 0);

	if ((fd = fopen(fname, "r")) == NULL) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBackquoteCmdFailed,
			    "Backquoted command \"%s\" in elmheaders failed."),
		    command);
	  return;	
	}

	/* If we get a line that is less than 80 - length of prefix then we
	   can toss it on the same line, otherwise, simply prepend each line
	   *starting with this line* with a leading tab and cruise along */

	if (fgets(command_buffer, SLEN, fd) == NULL) 
	  fprintf(filedesc, prefix);
	else {
	  if (strlen(command_buffer) + strlen(prefix) < 80) 
	    fprintf(filedesc, "%s%s", prefix, command_buffer);
	  else
	    fprintf(filedesc, "%s\n\t%s", prefix, command_buffer);
	  
	  while (fgets(command_buffer, SLEN, fd) != NULL) 
	    fprintf(filedesc, "\t%s", command_buffer);
	
	  fclose(fd);
	}

	unlink(fname);	/* don't leave the temp file laying around! */
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
