static char rcsid[] = "@(#)$Id: mailmsg2.c,v 1.41 2001/06/09 15:34:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.41 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Interface to allow mail to be sent to users.  Part of ELM  **/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"mail");

#ifdef USE_DSN
#include "menu2.h"
#endif

static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}
static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}


extern int errno;
extern char version_buff[];

char *error_description();
long ftell();


int  gotten_key;
char *bounce_off_remote();

static int verify_transmission P_((char *filename,int  *form_p, 
				   int *need_redraw_p, int already_has_text, 
				   struct copy_file *copy_file,
				   int force_cmd, int options, int *dsn, 
				   struct mailing_headers *geaders,
				   mime_t **attachments));  /* Prototype */
static void mail_sent P_((FILE *fd, char * title, struct run_state *rs,
 			  int ret, int exit_stat));

static int append_sig P_((FILE *file,struct mailing_headers *headers));

static int recall_last_msg P_((char *filename, int  copy_msg, 
			       int *cancelled_msg, int *already_has_text));

int mail_backend(real_reply,headers,dsn,func,encoding_top,title,resend)
     FILE *real_reply;
     struct mailing_headers * headers;
     int dsn;
     end_handler *func;
     int encoding_top;
     char * title;
     int resend;
{
    char *mailerflags[20], **argv;
    int mf_idx=0;
    struct run_state RS;
    char t[80];

    int options = SY_ENV_SHELL;
    int ret;


    mailerflags[mf_idx++] = mailer;
    
    if (strcmp(sendmail, mailer) == 0) {
	mailerflags[mf_idx++] = "-oi";
	mailerflags[mf_idx++] = "-oem";
	if (sendmail_verbose)
	    mailerflags[mf_idx++] = "-v";
	if (metoo) 
	    mailerflags[mf_idx++] = "-om";
    } else if (strcmp(submitmail, mailer) == 0)
	mailerflags[mf_idx++] = "-mlrnv";
    else if (strcmp(execmail, mailer) == 0) {
	if (sendmail_verbose)
	    mailerflags[mf_idx++] = "-d";
	if (metoo)
	    mailerflags[mf_idx++] = "-m";
    } 
        
#ifdef USE_8BITMIME
    if (encoding_top == ENCODING_8BIT)
	mailerflags[mf_idx++] = "-B8BITMIME";
#endif
#ifdef USE_BINARYMIME
    if (encoding_top == ENCODING_BINARY)
	/* With -BBINARYMIME lines must terminate with \r\n
	 * Unix's \n is _NOT_ sufficient - K E H              */
	mailerflags[mf_idx++] = "-BBINARYMIME";
#endif
    
#ifdef USE_DSN
    if (dsn & DSN_FULL) {
	mailerflags[mf_idx++] = "-R";
	mailerflags[mf_idx++] = "full";
    } else if (dsn & DSN_HDRS) {
	mailerflags[mf_idx++] = "-R";
	mailerflags[mf_idx++] = "hdrs";
    }
    
    if (dsn & DSN_NEVER) {
	mailerflags[mf_idx++] = "-N";
	mailerflags[mf_idx++] = "never";
    } else if (dsn & (DSN_SUCCESS|DSN_FAILURE|DSN_DELAY)) {	    
	t[0] = '\0';
	if (dsn & DSN_SUCCESS)
	    strfcat(t,"success", sizeof t);
	if (dsn & DSN_FAILURE) {
	    if (t[0]) strfcat(t,",", sizeof t);
	    strfcat(t,"failure", sizeof t);
	}
	if (dsn & DSN_DELAY) {
	    if (t[0]) strfcat(t,",", sizeof t);
	    strfcat(t,"delay", sizeof t);
	}
	mailerflags[mf_idx++] = "-N";
	mailerflags[mf_idx++] = t;
    }
#endif
    mailerflags[mf_idx] = NULL;
    
    if (strcmp(submitmail, mailer) == 0)
	argv = mailerflags;
    else {
	char **argvt = argv_from_headers(headers);
	argv = join_argv(mailerflags,argvt);
	free(argvt);
    }

    if (!sendmail_verbose)
	options |= SY_NOTTY;

    fseek (real_reply, 0, 0);
#ifdef _POSIX_VERSION
    fflush(real_reply);  /* Synzronize underlying file descriptor */
#else
    seek(fileno(real_reply),0,0);
#endif

    ret=start_run(&RS, options, argv, fileno(real_reply),-1);
    
    if (ret) {
	int backgrounded = 0;
	int exit_code;

	ret = run_already_done(&RS,&exit_code);
	if (0 == ret) {
	    if (resend)
		lib_transient(CATGETS(elm_msg_cat, ElmSet, ElmResendingMail,
				  "Resending mail..."));
	    else
		lib_transient(CATGETS(elm_msg_cat, ElmSet, ElmSendingMail,
				  "Sending mail..."));
	    FlushBuffer();
	    
#ifdef BACKGROUD_PROCESSES       /* We assume POSIX in here */
	    if (background_wait_time) {
 		int tmp;
 		DPRINT(Debug,4, (&Debug, 
				 "Sleeping ( %d seconds ) for completion!\n",
				 background_wait_time));
#if POLL_METHOD	  
		tmp = wait_for_timeout(background_wait_time);
		if (!tmp) {
		    DPRINT(Debug,4,(&Debug,  
				    " -- sleeping interrupted\n"));
		}
#else
 		tmp = sleep(background_wait_time);  
 		/* POSIX sleep returns time in left on
 		 * interrupt -- when sendmail terminates
		 * we will get interrupt (SIGCHLD signal)
		 */
		if (tmp > 0) {
		    DPRINT(Debug,4,(&Debug,  
				    " -- sleeping interrupted, %d seconds left!\n",
				    tmp));
		} else if (tmp < 0) {
		    DPRINT(Debug,4,(&Debug,  
				    " -- sleeping failed?\n"));
		}
#endif
		ret = run_already_done(&RS,&exit_code);
		if (0 == ret) 
		    ret = maybe_background(&RS,&exit_code,
					   real_reply,title,mail_sent);
		if (0 == ret) {
		    if (resend)
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmResendingMailBackground,
					  "Resending mail... in background"));
		    
		    else
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmSendingMailBackground,
					  "Sending mail... in background"));
		    FlushBuffer();
		    backgrounded = 1;
		}
	    } else
#endif
		ret = wait_end(&RS,&exit_code);
	}
	if (!backgrounded)
	    func(real_reply,title,&RS,ret,exit_code);
    } else {
	if (RS.save_errno)
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailErrno,
			      "Failed: %.30s: %.40s"),
		      argv[0],error_description(RS.save_errno));
	else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantStart,
			      "Can't start %.30s"),
		      argv[0]);
    }
    
    if (argv != mailerflags)
	free(argv);
    
    return ret;
}

static CONST unsigned char * csUs P_((const char *str));
static CONST unsigned char * csUs(str)
     CONST char *str;
{
    return (CONST unsigned char *)str;
}


int mail(current_header,options,form, headers)
     struct header_rec * current_header;
     int options,form;
     struct mailing_headers * headers;
{
    int copy_msg      = 0 != current_header && 0 != (options & MAIL_COPY_MSG);
    int edit_message  =                        0 != (options & MAIL_EDIT_MSG);
    int forwarding    = 0 != current_header && 0 != (options & MAIL_FORWARDING);

    mime_t *attachments = NULL;

    /** Given the addresses and various other miscellany (specifically, 
	'copy-msg' indicates whether a copy of the current message should 
	be included, 'edit_message' indicates whether the message should 
	be edited) this routine will invoke an editor for the user and 
	then actually mail off the message. 'form' can be YES, NO, or
	MAYBE.  YES=add "Content-Type: mailform" header, MAYBE=add the
	M)ake form option to last question, and NO=don't worry about it!
	Also, if 'copy_msg' = FORM, then grab the form temp file and use
	that...
	Return TRUE if the main part of the screen has been changed
	(useful for knowing whether a redraw is needed.
    **/

    FILE *reply = NULL;
    char fname[SLEN], very_long_buffer[VERY_LONG_STRING];
	  
    int ch,  line_len;
    register int retransmit = FALSE; 
    int      already_has_text = FALSE;		/* we need an ADDRESS */
    int	 signature_done = FALSE;
    int	 need_redraw = 0;
    int	 err;
    int reask_verify = FALSE;
    int dsn = 0;
    mime_send_t MIME_info;
    
    FILE * converted_buffer = NULL;      /* Temp file which hold converted
					    nody parts -- now include mime
					    headers however ...
					 */
    static int conv_count = 0;
    char * temp1 = NULL;

    static int cancelled_msg = 0;
    char title[80];
    int code = 0;
    struct copy_file COPY_FILE;

    zero_copy_file(&COPY_FILE);
#ifdef USE_DSN
    if(DSN_success)
	dsn |= DSN_SUCCESS|DSN_FAILURE|DSN_DELAY;
#endif
    
    if (current_header && (options & MAIL_ISFORM))
	copy_msg = FORM;
    
    /* Initialize structure */
    clear_mime_send_info(&MIME_info);
    
    if (allow_no_encoding >= 2)
	/* Just send BINARY anyway */
	MIME_info.raw_level     = mailer_binary;
    else if (allow_no_encoding >= 1 &&
	     MIME_info.raw_level < mailer_8bit)
	/* Just send 8BIT anyway */
	MIME_info.raw_level     = mailer_8bit;
    
    dump_expanded_address(4,"Mailing to",headers->to);
    DPRINT(Debug,4, (&Debug,"   (with%s editing)\n",
		     edit_message? "" : "out"));
    
    /* this will get set to 1 on a successful reply */ 
    me_retcode = 0;

    gotten_key = 0;		/* ignore previously gotten encryption key */
    
    /** first generate the temporary filename **/

    elm_sfprintf(cur_editfile,sizeof cur_editfile,
		 FRM("%s%s%d"), 
		 temp_dir, temp_file, getpid());
    
    /** if possible, let's try to recall the last message? **/
    
    if (! batch_only && copy_msg != FORM && user_level != 0)
	retransmit = recall_last_msg(cur_editfile, copy_msg, &cancelled_msg, 
				     &already_has_text);

    /** if we're not retransmitting, create the file.. **/

    if (! retransmit) {
	if ((reply = safeopen_rdwr(cur_editfile)) == NULL) {
	    err = errno;
	    DPRINT(Debug,1,(&Debug,  
			    "Attempt to write to temp file %s failed with error %s (mail)\n",
			    cur_editfile, error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotCreateFile,
			      "Could not create file %s (%s)."),
		      cur_editfile, error_description(errno));
	    return(need_redraw);
	}
    }
   
    (void) elm_chown(cur_editfile, userid, groupid);

    /* copy the message from standard input */
    if (batch_only) {
	while (0 < (line_len = fread(very_long_buffer, 1, 
				     sizeof(very_long_buffer), stdin)))
	    fwrite(very_long_buffer, 1, line_len, reply);
    }

    /** if there is an included file, copy it into the temp file **/
    if (*included_file) {
	FILE *input;
	if ((input = fopen(included_file,"r")) == NULL) {
	    DPRINT(Debug,1,(&Debug,   
			    "Can't open included file %s.  Failed with error %s (mail)\n",
			    included_file, error_description(errno)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotOpenFile,
			      "Could not open file %s."), 
		      included_file);
	    return(need_redraw);
	}

	while (fgets(very_long_buffer, VERY_LONG_STRING, input) != NULL) 
	    fputs(very_long_buffer, reply);
	
	fclose(input);
	already_has_text = TRUE;
    } 

    if (copy_msg == FORM) {
	elm_sfprintf(fname, sizeof fname,
		     FRM("%s%s%d"), temp_dir, temp_form_file, getpid());
	fclose(reply);	/* we can't retransmit a form! */
	if (access(fname,ACCESS_EXISTS) != 0) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotFindForm,
			      "Couldn't find forms file!"));
	    return(need_redraw);
	}
	DPRINT(Debug,4,(&Debug,   
			"-- renaming existing file %s to file %s --\n",
			fname, cur_editfile));
	rename(fname, cur_editfile);	  
    } else if (copy_msg && ! retransmit) {  /* if retransmit we have it! */
	struct string * From_buffer = NULL;
	struct addr_item *p;
	    
	if (current_header->from) {
	    for (p = current_header->from; p->addr && p->fullname; p++) {
		if (From_buffer)
		    add_ascii_to_string(From_buffer,s2us(", "));
		else
		    From_buffer = new_string(display_charset);
		if (string_len(p->fullname)) {
		    struct string * temp = cat_strings(From_buffer,
						       p->fullname,1);
		    free_string(&From_buffer);
		    From_buffer = temp;
		} else {
		    add_ascii_to_string(From_buffer,csUs(p->addr));
		}
	    }
	}
	    
	if (!forwarding || (forwarding && !mimeforward)) {
	    if (forwarding && !quote_forward) {
		if (From_buffer) {
		    elm_fprintf(reply,
				CATGETS(elm_msg_cat, ElmSet, ElmForwarded1,
					"----- Forwarded message from %S -----\n\n"), 
				From_buffer);
		} else
		    elm_fprintf (reply, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmForwarded2,
					 "----- Forwarded message (env-from %s) -----\n\n"), 
				 current_header->env_from);
		
	    } else if (attribution[0] && current_header) {
		if (From_buffer) {
		    char * str = us2s(stream_from_string(From_buffer,1,NULL));
		    fprintf(reply, attribution, str);
		    free(str);
		} else
		    fprintf(reply, attribution, current_header->env_from);
		fputc('\n', reply);
	    }
	    if (edit_message && current_folder) {
		int NOHDR = forwarding ? noheaderfwd : noheader;
		int NOQUOTE = forwarding && !quote_forward; 
		copy_message(current_folder,current_header,
			     NOQUOTE ? "" : prefixchars, reply,
			     ( NOHDR ? CM_REMOVE_HEADER : 0 ) 
			     | CM_REMOVE_ENVELOPE | CM_DECODE 
			     /* I think it is good idea to use CM_FILT_HDR
			      * even when we don't have forwarding ... -KEH
			      */
			     | CM_FILT_HDR );
		already_has_text = TRUE;	/* we just added it, right? */
	    } else if (current_folder) {
		int NOHDR = forwarding ? noheaderfwd : noheader;
		copy_message(current_folder,current_header,
			     "", reply,
			     ( NOHDR ? CM_REMOVE_HEADER : 0 ) 
			     | CM_REMOVE_ENVELOPE
			     /* I added CM_DECODE to here -KEH */
			     | CM_DECODE);
	    }
	    if (forwarding && !quote_forward) {
		if (From_buffer)
		    elm_fprintf (reply, 
				 CATGETS(elm_msg_cat, ElmSet, ElmForwarded3,
					 "----- End of forwarded message from %S -----\n"),
				 From_buffer);
		else
		    elm_fprintf (reply, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmForwarded4,
					 "----- End of forwarded message (env-from %s) -----\n"),
				 current_header->env_from);
	    }
	} else {
	    FILE *tmpfp;
	    
	    /* Use MESSAGE/RFC822 to forward messages. */
	    
	    elm_sfprintf (very_long_buffer, sizeof very_long_buffer,
			  FRM("%selmfwd.%d"), 
			  temp_dir, getpid ());
	    if (! (tmpfp = safeopen_rdwr (very_long_buffer))) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailFileForward,
				  "Failed to create file for forwarding"));
	    } else if (current_folder) {
		attachments = (mime_t *) mime_t_alloc ();
		attachments->flags = MIME_RFC822;
		attachments->pathname = strmcpy(attachments->pathname, 
						very_long_buffer);
				
		copy_message(current_folder,current_header,"",tmpfp,
			     CM_REMOVE_ENVELOPE);
		    
		attachments->length = fsize(tmpfp);
		fclose (tmpfp);
		attachments->unlink = 1; /* mark for later deletion */
		attachments->type = MIME_TYPE_MESSAGE;
		strfcpy (attachments->subtype, "rfc822", 
			 sizeof attachments->subtype);
		if (From_buffer)
		    attachments->description = 
			format_string(CATGETS(elm_msg_cat, ElmSet, 
					      ElmForwardedMesg1,
					      "Forwarded message from %S"), 
				      From_buffer);
		else
		    attachments->description = 
			format_string(CATGETS(elm_msg_cat, ElmSet, 
					      ElmForwardedMesg2,
					      "Forwarded message from %s"), 
				      current_header->env_from);
				
		/* Pick up the encoding from the message. */
		attachments->encoding = ENCODING_7BIT;
		(void) update_encoding (&(attachments->encoding),
					current_header->mime_rec.encoding);
	    }
	}
	if (From_buffer)
	    free_string(&From_buffer);
    }
    
    /* Initial attachment */
    if(attachments) 
	attachments->next = attach_files;
    else
	attachments = attach_files;
    attach_files = NULL;

    /* append signature now if we are going to use an external editor */
    /* Don't worry about the remote/local determination too much */
    
    if (already_has_text || 
	(strcmp(editor,"builtin") != 0 && strcmp(editor,"none") != 0)) {
	signature_done = TRUE;
	if (!retransmit && copy_msg != FORM) 
	    already_has_text |= append_sig(reply, headers);
    }

    if (! retransmit && copy_msg != FORM)
	if (reply != NULL)
	    (void) fclose(reply);	/* on replies, it won't be open! */

    /** Edit the message **/

    /* calculate default save_file name */
    if (COPY_FILE.copy_file)
	clear_copy_file(&COPY_FILE);        /* signals to not save a copy */
    
    if(auto_copy_sent) {
	if(save_by_name) {
	    if(force_name) {
		/* signals save by 'to' logname */
		COPY_FILE.copy_file = format_string(FRM("="));
	    } else {
		/* conditional save by 'to' logname */
		COPY_FILE.copy_file = format_string(FRM("=?"));
	    }
	} else {
	    /* signals save to sentmail */
	    COPY_FILE.copy_file = format_string(FRM("<"));
	}
    } 
    
    /* tell to verify_transmission() */
    if (attachments) 
	options |= MAIL_HAVE_ATTACHMENTS;
#ifdef USE_PGP
    if (current_header &&
	current_header->pgp & PGP_MESSAGE)
	options |= MAIL_HAVE_PGP_ENCODED;
#endif

    do { /* So we can return here if check_for_multipart() fails
	  * - K E H <hurtta+elm@ozone.FMI.FI>    */
	code = 0;
	reask_verify = 0;
	
	/* ask the user to confirm transmission of the message */
	if (!batch_only) {
	fatal_label:
	    ch = (edit_message? 'e' : '\0');
	    code = verify_transmission(cur_editfile, &form, &need_redraw,
				       already_has_text, &COPY_FILE, ch,
				       options, &dsn,
				       headers, &attachments);	    
	    /* Empty ... */
	    if (-2 == code && !attachments)
		return need_redraw;
	    if (form == YES && format_form(cur_editfile) < 1) {
		cancelled_msg = (bytes(cur_editfile) > 0);
		return need_redraw;
	    }
            /* so we can mark the reply flag */
	    if (0 == code)
		me_retcode = 1;
	}

	if ((reply = fopen(cur_editfile,"r+")) == NULL) {
	    err = errno;
	    DPRINT(Debug,1,(&Debug,  
			    "Attempt to open file %s for reading failed with error %s (mail)\n",
			    cur_editfile, error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotOpenReply,
			      "Could not open reply file (%s)."), 
		      error_description(err));
	    return need_redraw;
	}

	/* Append signature if not done earlier, so that need_eccoding
	 * takes account of 8-bit data on signature
	 */
	
	if (!signature_done && !retransmit && copy_msg != FORM) {
	    /* Go to the end of the file! */
	    fseek (reply, 0, 2);
	    append_sig(reply, headers);
	    rewind(reply);
	    signature_done = TRUE;
	}

	MIME_info.encoding_top  = ENCODING_7BIT;/* Encoding for Multipart/ */
	  	 
#if 0	  
	if (allow_no_hdrencoding && headers->subject)
	    MIME_info.need_enc |= check_8bit_string (headers->subject);
#endif

	if (code < 0)
	    cancelled_msg = (bytes(cur_editfile) > 0);
	else
	    cancelled_msg = FALSE;	/* it ain't cancelled, is it? */
	
	if (check_for_multipart(reply, &MIME_info) < 0) { 
	    /* Error in [include ...] */
	    if (code < 0)
		goto fail_label;

	    if (!batch_only) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFixInclude,
				  "Please fix [include ...] lines!"));
		edit_message = FALSE;
		reask_verify = TRUE; /* Go to verify_transmission again. */
		continue;
	    }
	}

	if (converted_buffer)
	    fclose(converted_buffer);
	temp1 = elm_message(FRM("%selmcv-%d-%d"),
			    temp_dir, getpid (),
			    conv_count++);
	converted_buffer = safeopen_rdwr(temp1);
	if (!converted_buffer) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmOpenFailedCopy,
			      "Temp file open failed to in copy"));
	    free(temp1);
	    temp1 = NULL;
	    if (code < 0)
		goto fail_label;
	    if (batch_only)
		leave(0);
	    edit_message = FALSE;
	    reask_verify = TRUE; /* Go to verify_transmission again. */
	    continue;
	}
	DPRINT(Debug,2,(&Debug,   "mail: using temp file (%s)\n",
			temp1));
	unlink(temp1);
	free(temp1);
	temp1 = NULL;

	if (!convert_text(reply,converted_buffer, &MIME_info,
			  display_charset,text_charset,
#ifdef USE_PGP
			  pgp_status,
#else
			  0,
#endif
			  attachments)) {
	    if (code < 0)
		goto fail_label;
	    if (batch_only)
		leave(0);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedConvertMessage,
			      "Failed convert message, fix errors and retry or f)orget it"));
	    reask_verify = TRUE; /* Go to verify_transmission again. */
	    edit_message = FALSE;	    
	} else
	    MIME_info.msg_is_multipart = MIME_info.top_parts_count > 1;

	/* End of check_for_multipart failure loop */
    } while (!batch_only && reask_verify);
	
    if (MIME_info.msg_is_multipart) {
	(void) mime_generate_boundary (MIME_info.mime_boundary,
				       sizeof MIME_info.mime_boundary);
	add_parameter_1(&(MIME_info.type_opts_top), "boundary",
			MIME_info.mime_boundary, 
			FALSE);
    }

#ifndef DONT_ADD_FROM
    make_from_addr(&(headers->from));
#endif
    
    if (code < 0) {
	char * lbuf = elm_message(FRM("%s/%s"), 
			   home, dead_letter);
	int i;
	FILE *fp_copy = NULL;

	for (i = 1; i < 100; i++) {
	    if (0 == access(lbuf,ACCESS_EXISTS)) {
		char *lbuf1 = elm_message(FRM("%s/%02d.%s"),
					  home,i,dead_letter);
		
		/* link() will fail if target file exists
		   NOTE: We can't use rename() bevause it will replace
		   target file 
		*/
		int r = link(lbuf,lbuf1);

		if (0 == r) {
		    DPRINT(Debug,1,(&Debug,  "File %s renamed to %s\n",
			       lbuf,lbuf1));
		    unlink (lbuf);
		}
		free(lbuf1);
		if (0 == r)
		    break;
	    }
	} 

	fp_copy = write_header_info(lbuf,headers,(form == YES),TRUE,
				    &MIME_info);

	if (fp_copy) {
	    copy_message_across(&MIME_info,fp_copy,TRUE,converted_buffer);

	}
	fclose(fp_copy);

    } else {
	FILE *real_reply     = NULL;     /* second is post-input buffer */
	char *whole_msg_file = NULL;

	rewind(converted_buffer);
	if (COPY_FILE.copy_file) /* i.e. if copy_file contains a name */
	    save_copy(headers,&COPY_FILE, form, &MIME_info, 
		      converted_buffer);

	/** write all header information into whole_msg_file **/

	if((whole_msg_file=tempnam(temp_dir, "snd.")) == NULL) {
	    DPRINT(Debug,1,(&Debug,   "couldn't make temp file nam! (mail)\n"));
	    
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotMakeTemp,
			      "Sorry - couldn't make temp file name."));
	    
	    edit_message = FALSE;
	    fclose(reply);
	    reply = NULL;	
	    free(whole_msg_file);
	    whole_msg_file = NULL;
	    
	    if (!batch_only)
		goto fatal_label;
	    
	    goto fail_label;
	}

	/** try to write headers to new temp file **/
	
	DPRINT(Debug,6,(&Debug,   "Composition file='%s' and mail buffer='%s'\n", 
		   cur_editfile, whole_msg_file));
	
	dump_expanded_address(2,"From",headers->from);
	dump_expanded_address(2,"To",headers->to);
	dump_expanded_address(2,"CC",headers->cc);
	dump_expanded_address(2,"Bcc",headers->bcc);
	
	if ((real_reply = 
	     write_header_info(whole_msg_file, headers,
			       form == YES, FALSE, &MIME_info)) == NULL) {
	    lib_error(FRM("Failed to create temp file for mailing!"));
	    
	    edit_message = FALSE;
	    fclose(reply);
	    reply = NULL;		
	    free(whole_msg_file);
	    whole_msg_file = NULL;
	    
	    if (!batch_only)
		goto fatal_label;
	    
	    goto fail_label;
	}
	

	rewind(converted_buffer);
	if (!copy_message_across(&MIME_info,real_reply,FALSE,converted_buffer)) {
	    edit_message = FALSE;
	    fclose(reply);
	    reply = NULL;	
	    unlink(whole_msg_file);
	    free(whole_msg_file);
	    whole_msg_file = NULL;
	    fclose(real_reply);
	    real_reply = NULL;
	    
	    if (!batch_only)
		goto fatal_label;
	    
	    goto fail_label;
	}
	
	elm_sfprintf(title, sizeof title,
		     CATGETS(elm_msg_cat, ElmSet, ElmMailTo,
			     "Mail to %.50s..."),
		     headers->to.addrs ? headers->to.addrs[0].addr : 
		     "(someone)");
	
	mail_backend(real_reply,headers,dsn,mail_sent, 
		     MIME_info.encoding_top, title,0);
	
	unlink(whole_msg_file);
	free(whole_msg_file);
	whole_msg_file = NULL;
	fclose(real_reply);
	real_reply = NULL;
	
    }
    fclose(reply);
    reply = NULL;
	
 fail_label:	
    if (attachments) {
	mime_destroy (attachments);
	attachments = 0;
    }

    if (converted_buffer)
	fclose(converted_buffer);
    converted_buffer = NULL;

    /* Unlink temp file now.
     * This is a precaution in case the message was encrypted.
     * I.e. even though this file is readable by the owner only,
     * encryption is supposed to hide things even from someone
     * with root privelges. The best we can do is not let this
     * file just hang after we're finished with it.
     */
    (void)unlink(cur_editfile);
#ifdef USE_PGP
    pgp_status=0;
#endif
    
    free_mime_send_info(&MIME_info);
    clear_copy_file(&COPY_FILE);
    return(need_redraw);	
}

static void mail_sent (fd,title,rs,ret,exit_code)
     FILE *fd; 
     char * title;
     struct run_state *rs;
     int ret; 
     int exit_code;
{

  lower_prompt(title);
  if (ret < 0) 
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailSignal,
		      "%.30s fail: Signal?"),
	      mailer);
  else if (ret > 0) {
    if (rs->save_errno)
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailErrno,
			"Failed: %.30s: %.40s"),
		mailer,error_description(rs->save_errno));
    else if (exit_code) {
      lib_error(
		CATGETS(elm_msg_cat, ElmSet, 
			ElmMailerReturnedError,
			"mailer returned error status %d"), 
		exit_code);
    } else
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailSent, "Mail sent!"));
  } else {
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLostErrno,
		      "%.30s lost: %.40s"),
	      mailer,error_description(rs->save_errno));
  }
}

int mail_form(current_header, address, subj)
     struct header_rec *current_header;
     struct addr_item *address; 
     char *subj;
{
    int res;
    
    struct mailing_headers headers;
    struct expanded_address A;
    
    zero_mailing_headers(&headers);
    zero_expanded_address(&A);

    headers.subject = new_string2(display_charset,s2us(subj));

    addr_to_expanded(&A,address);
    copy_expanded_address(&headers.to, A);
    
    res = mail(current_header,MAIL_ISFORM,NO, &headers);
    
    free_expanded_address(&A);
    free_mailing_headers(&headers);

    return res;
}

static int recall_last_msg(filename, copy_msg, cancelled_msg, already_has_text)
     char *filename;
     int  copy_msg, *cancelled_msg, *already_has_text;
{
	char ch;
	char msg[SLEN];

	/** If filename exists and we've recently cancelled a message,
	    the ask if the user wants to use that message instead!  This
	    routine returns TRUE if the user wants to retransmit the last
	    message, FALSE otherwise...
	**/

	register int retransmit = FALSE;

	if (access(filename, EDIT_ACCESS) == 0 && *cancelled_msg) {
	  Raw(ON);
	  CleartoEOLN();
	  if (copy_msg)
	    elm_sfprintf(msg, sizeof msg,
			 CATGETS(elm_msg_cat, ElmSet, ElmRecallLastInstead,
				 "Recall last kept message instead? (%c/%c) "),
			 *def_ans_yes, *def_ans_no);
	  else
	    elm_sfprintf(msg, sizeof msg,
			 CATGETS(elm_msg_cat, ElmSet, ElmRecallLastKept,
				 "Recall last kept message? (%c/%c) "),
			 *def_ans_yes, *def_ans_no);
	  do {
	    ch = want_to(msg, '\0', elm_LINES-1, 0);
	    if (ch == *def_ans_yes) {
              retransmit++;
	      *already_has_text = TRUE;
	    } else if (ch != *def_ans_no) {
	      Write_to_screen(FRM("%c??"), 07);	/* BEEP */
	      if (sleepmsg > 0)
		    sleep((sleepmsg + 1) / 2);
	      ch = 0;
	    }
	  } while (ch == 0);

	  FlushBuffer();

	  *cancelled_msg = 0;
	}

	return(retransmit);
}

#ifdef USE_DSN

void dsn_menu P_((int *));
void dsn_menu(dsn)
     int * dsn;
{
  static int hdr_only = 0;
  static int failure  = 1;
  static int delay    = 1;
  static int success  = 0;
  static int DSN_off  = 0;

#define BOL 1
  static struct menu_item dsn_items[] = {
    { "Return H)eaders only on FAILURE:", 'h', 3,  BOL, (char *) &hdr_only,
      sizeof hdr_only },
    { "Return DSN on F)AILURE         :", 'f', 5,  BOL, (char *) &failure,
      sizeof failure },
    { "              D)ELAY           :", 'd', 6,  BOL, (char *) &delay,
      sizeof delay },
    { "              S)UCCESS         :", 's', 7,  BOL, (char *) &success,
      sizeof success },
    { "U)se defaults (DSN off)        :", 'u', 12, BOL, (char *) &DSN_off,
      sizeof DSN_off }
  };

  if (0 == *dsn)
    DSN_off = 1;
  else {
    if (DSN_FULL    & *dsn) hdr_only = 0;
    if (DSN_HDRS    & *dsn) hdr_only = 1;
    if (DSN_SUCCESS & *dsn) success  = 1;
    if (DSN_FAILURE & *dsn) failure  = 1;
    if (DSN_DELAY   & *dsn) delay    = 1;
    if (DSN_NEVER   & *dsn) { success = 0; failure = 0; delay = 0; }
  }
  
  generic_menu(dsn_items,sizeof dsn_items / sizeof (struct menu_item),
	       "DSN (Delivery Status Notification) Configuration",
	       "DSN: ");

  if (DSN_off) *dsn = 0;
  else if (!success && !failure && !delay) *dsn = DSN_NEVER;
  else {
    int val = 0;
    if (hdr_only) val |= DSN_HDRS;
    else          val |= DSN_FULL;
    if (success)  val |= DSN_SUCCESS;
    if (failure)  val |= DSN_FAILURE;
    if (delay)    val |= DSN_DELAY;

    *dsn = val;
  }
  
}
#endif


/*
 * verify_transmission() - Ask the user to confirm transmission of the
 * message.  Returns 0 to send it, -1 to forget it.
 */
static int verify_transmission(filename, form_p, need_redraw_p,
			       already_has_text, copy_file, force_cmd, options,
			       dsn, headers, attachments
			       )
     char *filename;	    /* pathname to mail mssg composition file        */
     int  *form_p;	    /* pointer to form message state	             */
     int *need_redraw_p;    /* pointer to flag indicating screen stepped on  */
     int already_has_text;  /* indicates there is already text in the mssg   */
     struct copy_file *copy_file; /* pointer to buffer holding copy file name   */
     int force_cmd;	    /* command to do, '\0' to prompt user for cmd    */
     int options;
     int *dsn;
     struct mailing_headers *headers;   
     mime_t **attachments;
{
    char *prompt_mssg = NULL;	/* message to display prompting for cmd	*/
    char prompt_menu[SLEN],	/* menu of available commands		*/
	prompt_menu2[SLEN];
    int bad_cmd;		/* set TRUE to bitch about user's entry	*/
    int did_prompt;		/* TRUE if cmd prompted for and entered	*/
    int prev_form;		/* "*form_p" value last time thru loop	*/
    int cmd;			/* command to perform			*/
    char lbuf[VERY_LONG_STRING];
    int x_coord, y_coord;
    int replying          = 0 != (options & MAIL_REPLYING);
    int have_attachments  = 0 != (options & MAIL_HAVE_ATTACHMENTS);
#ifdef USE_PGP
    int was_pgp_encoded   = 0 != (options & MAIL_HAVE_PGP_ENCODED);
#endif
    int def_cmd = 's';

#ifdef USE_PGP
    if (replying && was_pgp_encoded &&
	! (pgp_status & PGP_MESSAGE)) 
	def_cmd = 'p';
#endif

    prev_form = *form_p + 1;	/* force build of prompt strings	*/
    bad_cmd = FALSE;		/* nothing to complain about yet	*/

    for (;;) {

	/* build up prompt and menu strings */
	if (prev_form == *form_p) {
	    ; /* not changed - no need to rebuild the strings */
	} else if (user_level == 0) {
	    prompt_mssg = catgets(elm_msg_cat, ElmSet, ElmVfyPromptPleaseChoose,
		"Please choose one of the following options by parenthesized letter: s");
	    strfcpy(prompt_menu, 
		    catgets(elm_msg_cat, ElmSet, ElmVfyMenuUser0,
			    "e)dit message, edit h)eaders, s)end it, or f)orget it."),
		    sizeof prompt_menu);
            prompt_menu2[0] = '\0';

	    /* In some conditions add these also to menu in user_level == 0 */
	    if (have_attachments)
	      strfcat(prompt_menu2, "a)ttachments", sizeof prompt_menu2);
#ifdef USE_DSN
	    if (dsn && *dsn != 0) {
	      if (prompt_menu2[0]) strfcat(prompt_menu2,", ", 
					   sizeof prompt_menu2);
	      strfcat(prompt_menu2, "D)SN", sizeof prompt_menu2);
	    }
#endif
#ifdef USE_PGP
	    if (replying && was_pgp_encoded) {
	      if (prompt_menu2[0]) strfcat(prompt_menu2,", ",
					   sizeof prompt_menu2);
	      strfcat(prompt_menu2, "p)gp", sizeof prompt_menu2);
	    }
#endif
	} else {
	    prompt_mssg = catgets(elm_msg_cat, ElmSet, ElmVfyPromptAndNow,
		"And now: s");
	    switch (*form_p) {
	    case PREFORMATTED:
		prompt_menu[0] = '\0';
		break;
	    case YES:
		strfcpy(prompt_menu, catgets(elm_msg_cat, ElmSet,
					     ElmVfyMenuEditForm, 
					     "e)dit form, "),
			sizeof prompt_menu);
		break;
	    case MAYBE:
		strfcpy(prompt_menu, catgets(elm_msg_cat, ElmSet,
					     ElmVfyMenuEditMake, 
					     "e)dit msg, m)ake form, "),
			sizeof prompt_menu);
		break;
	    default:
		strfcpy(prompt_menu, catgets(elm_msg_cat, ElmSet,
					     ElmVfyMenuEditMsg, 
					     "e)dit message, "),
			sizeof prompt_menu);
		break;
	    }
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuVfyCpy,
					"h)eaders, c)opy, "),
		    sizeof prompt_menu);
#ifdef ISPELL
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuIspell,
					 "i)spell, "),
		    sizeof prompt_menu);
#endif
#ifdef ALLOW_SUBSHELL
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuShell,
					 "!)shell, "),
		    sizeof prompt_menu);
#endif
            /* The previous line was getting too full... */
            prompt_menu2[0] = '\0';
	    strfcat(prompt_menu2, "a)ttachments", sizeof prompt_menu2);
#ifdef USE_DSN
	    if (dsn) strfcat(prompt_menu2, ", D)SN", sizeof prompt_menu2);
#endif
#ifdef USE_PGP
	    if (prompt_menu2[0]) strfcat(prompt_menu2,", ", 
					 sizeof prompt_menu2);
            strfcat(prompt_menu2, "p)gp", sizeof prompt_menu2);
#endif
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuSndFgt,
					 "s)end, or f)orget"),
		    sizeof prompt_menu);
	}



	prev_form = *form_p;

	/* complain if last entry was bad */
	if (bad_cmd) {
	    Write_to_screen(FRM("%c??"), 07);
	    if (sleepmsg > 0)
		sleep((sleepmsg + 1) / 2);
	    bad_cmd = FALSE;
	}

	/* if we don't have a cmd, display prompt and get response from user */
	if (force_cmd != '\0' &&
	    isascii(force_cmd)) {
	    cmd = tolower(force_cmd);
	    force_cmd = '\0';
	    did_prompt = FALSE;
	} else {
	redraw:
	    ClearLine(elm_LINES-3);
	    PutLine0(elm_LINES-3, 0, prompt_mssg);
	    GetXYLocation(&x_coord, &y_coord);
	    y_coord--; /* backspace over default answer */
	    PutLineX(elm_LINES-3, y_coord, FRM("%c"),def_cmd);
	    ClearLine(elm_LINES-2);
	    Centerline(elm_LINES-2, prompt_menu);
            ClearLine(elm_LINES-1);
            Centerline(elm_LINES-1, prompt_menu2);
	    FlushBuffer();
	    MoveCursor(x_coord, y_coord);
	    cmd = ReadCh(REDRAW_MARK);
	    if (cmd == REDRAW_MARK)
	      goto redraw;
	    if (cmd == EOF)
	      leave(0);
#ifdef ASCII_CTYPE
	    if (isascii(cmd))
#endif
	      cmd = tolower((unsigned char)cmd);
	    did_prompt = TRUE;
	}

	switch (cmd) {
	case '\n':
	case '\r':
	    cmd = def_cmd;
	}

	/* handle command */
	switch (cmd) {

	case 'a':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuAtttach,
					"Attachments"));
	    *attachments = (mime_t *) attach_menu (*attachments, FALSE,
						   display_charset);
	    break;
#ifdef USE_DSN
        case 'd':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuDsn,
					"Dsn"));
	  if (dsn) dsn_menu(dsn);
	  break;
#endif
	case 's':
	    if (did_prompt) {
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuSend,
					"Send"));
		/* Call FlushBuffer() after writing of "Send" so that
		 * user get immediately feedback (it may take time
		 * to encode big attachments)
		 */
		FlushBuffer();
	    }
#ifdef USE_PGP
	      if (replying && was_pgp_encoded &&
		  ! (pgp_status & PGP_MESSAGE)) {
              ClearLine(elm_LINES-2);
	      PutLine0(elm_LINES-2, 0, "The recv'd message was PGP encoded, are you sure? ");
	      for (;;) {
		cmd = ReadCh(0);
		if (cmd == *def_ans_yes) {
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmYesWord, 
					  "Yes."));
		  return(0);
		}
		if (cmd == *def_ans_no) {
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoWord, 
					  "No."));
		  break;
		}
	      }
	      break;
	    }
#endif /* USE_PGP */
	    return 0;
	    /*NOTREACHED*/

	case ctrl('F'):
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
					ElmPassphraseForget,
					"Forget passphrase"));
	    forget_passphrase();	      
	    break;

       case 'f': 
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuForget, 
					"Forget"));
#ifdef USE_PGP
            pgp_status = 0; /* make sure to reset! */
#endif
	    if (bytes(filename) <= 0) {
		; /* forget about empty files */
		return -2;
	    } else if (mail_only) {
		
	    } else if (user_level > 0) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmVfyMessageKept,
				  "Message kept.  Can be restored at next f)orward, m)ail or r)eply."));
	    }
	    return -1;
	    /*NOTREACHED*/

	case 'c':
	    if (did_prompt)
	      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
				      ElmVfyMenuCopyFile, 
				      "Copy file"));
	    if (name_copy_file(copy_file) != 0)
		*need_redraw_p = TRUE;
	    break;

	case 'e':
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuEdit, "Edit"));
	    if (*form_p == PREFORMATTED) {
		bad_cmd = TRUE;
	    } else {
		if (*form_p == YES)
		    *form_p = MAYBE;
		*need_redraw_p = TRUE;
		if (edit_the_message(filename, already_has_text,
				     headers,editor) != 0)
		    return -1;
	    }
	    break;

	case 'h':
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuHeaders,"Headers"));
	    edit_headers(headers);
	    *need_redraw_p = TRUE;
	    break;

	case 'm':
	    if (*form_p != MAYBE) {
		bad_cmd = TRUE;
	    } else {
		switch (check_form_file(filename)) {
		case -1:
		    /* couldn't open file??? */
		    return -1;
		case 0:
		    Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
					    ElmVfyNoFieldsInForm, 
					    "No fields in form!\007"));
		    if (sleepmsg > 0)
			sleep(sleepmsg);
		    break;
		default:
		    /* looks like a good form */
		    *form_p = YES;
		    break;
		}
	    }
	    break;

#ifdef ISPELL
	case 'i':
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuIspell2,"Ispell"));
	    if (*form_p == PREFORMATTED) {
		bad_cmd = TRUE;
	    } else {
		if (*form_p == YES)
		    *form_p = MAYBE;
		elm_sfprintf(lbuf, sizeof lbuf,
			     FRM("%s %s %s"),
			     ISPELL_PATH, ISPELL_OPTIONS, filename);
		Raw(OFF);
		system_call(lbuf, SY_ENAB_SIGHUP);
		*need_redraw_p = TRUE;
		Raw(ON);
	    }
	    break;
#endif

#ifdef ALLOW_SUBSHELL
	case '!':
	    if (subshell() != 0) {
		ClearScreen();
		*need_redraw_p = TRUE;
	    }
	    break;
#endif
#ifdef USE_PGP
        case 'p':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuPgp,"Pgp"));
	    if (!pgp_status) {
	      pgp_status = pgp_menu (filename,headers);
	      if (pgp_status)
		  def_cmd = 's';
	      else
		  def_cmd = 'p';
	      *need_redraw_p = TRUE;
	    }
            else
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPgpAlreadyEncSig,
				"This message is already encrypted and/or signed!"));
            break;
#endif
	default:
	    bad_cmd = TRUE;
	    break;

	}

    }

}

FILE * write_header_info(filename, headers,
			 form, copy, mime_info)
     char *filename;
     struct mailing_headers * headers;  
     int   form, copy;
     mime_send_t *mime_info;
{
    /** Try to open filedesc as the specified filename.  If we can,
	then write all the headers into the file.  The routine returns
	'filedesc' if it succeeded, NULL otherwise.  Added the ability
	to have backquoted stuff in the users .elmheaders file!
	If copy is TRUE, then treat this as the saved copy of outbound
	mail.
    **/
    
    time_t time();
    char *ctime();
    FILE *filedesc = NULL;		/* our friendly file descriptor  */
    int err;

    char  *get_arpa_date();

    mime_info -> encode_hdr = !form && !allow_no_hdrencoding;
	
    /* Create _new_ temporary file */
    filedesc = safeopen_rdwr(filename);

    if (filedesc == NULL) {
	err = errno;
	DPRINT(Debug,1, (&Debug,
			 "Attempt to open file %s for writing failed! (write_header_info)\n",
			 filename));
	DPRINT(Debug,1, (&Debug, "** %s **\n\n", error_description(err)));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorTryingToWrite,
			  "Error %s encountered trying to write to %s."), 
		  error_description(err), filename);
	return(NULL);		/* couldn't open it!! */
    }
    
#ifdef MMDF
    if(!copy && strcmp(submitmail,mailer) == 0) {
	do_mmdf_addresses(filedesc, headers);
    }
#endif /* MMDF */

    /** Subject moved to top of headers for mail because the
	pure System V.3 mailer, in its infinite wisdom, now
	assumes that anything the user sends is part of the 
	message body unless either:
	1. the "-s" flag is used (although it doesn't seem
	   to be supported on all implementations?? )
	2. the first line is "Subject:".  If so, then it'll
	   read until a blank line and assume all are meant
	   to be headers.
	So the gory solution here is to move the Subject: line
	up to the top.  I assume it won't break anyone elses program
	or anything anyway (besides, RFC-822 specifies that the *order*
	of headers is irrelevant).  Gahhhhh....
    **/

    if (headers->subject)
	write_string_header(filedesc,"Subject",
			    headers->subject,
			    mime_info->encoding_top,
			    mime_info->encode_hdr,
			    mime_info->hdr_charset);

    if (!form) {
	/* Our standard violations */
	char OSV[100];
	OSV[0] = '\0';
	  
	if ((!mime_info->encode_hdr)
	    && mime_info->hdr_charset->MIME_name)
	    add_parameter(OSV,"hdr-charset",
			  mime_info->hdr_charset->MIME_name,sizeof(OSV),FALSE);
	
	if (OSV[0]) {
	    fprintf(filedesc, "X-ELM-OSV: (Our standard violations) %s",OSV);
	    print_EOLN(filedesc,mime_info->encoding_top);
	}
    } else {	
	fprintf(filedesc, 
		"X-ELM-OSV: (Our standard violations) no-mime=1; no-hdr-encoding=1\n");
    }
    
    write_id_phrase_header(filedesc,"In-Reply-To",
			   & (headers->in_reply_to),
			   mime_info->encoding_top,
			   mime_info->encode_hdr,
			   mime_info->hdr_charset);

    if (headers->to.addrs)
	write_addr_header(filedesc,"To",headers->to.addrs,
			  mime_info->encoding_top,
			  mime_info->encode_hdr,
			  mime_info->hdr_charset);
    write_text_header(filedesc,"Date",get_arpa_date(),
		      mime_info->encoding_top);

    if (headers->from.addrs) 
	write_addr_header(filedesc,"From",headers->from.addrs,
			  mime_info->encoding_top,
			  mime_info->encode_hdr,
			  mime_info->hdr_charset);
    
    if (headers->cc.addrs)
	write_addr_header(filedesc,"CC",headers->cc.addrs,
			  mime_info->encoding_top,
			  mime_info->encode_hdr,
			  mime_info->hdr_charset);

    if ((copy && headers->bcc.addrs) ||
	/* If there is no To or CC recipients,
	 * show BCC recipients to make mail legal 
	 */
	(!headers->to.addrs && !headers->cc.addrs && headers->bcc.addrs))
	write_addr_header(filedesc,"Bcc",headers->bcc.addrs,
			  mime_info->encoding_top,
			  mime_info->encode_hdr,
			  mime_info->hdr_charset);
	
    if (headers->action)
	write_text_header(filedesc,"Action",headers->action,
			  mime_info->encoding_top);

    if (headers->priority)
	write_text_header(filedesc,"Priority",headers->priority,
			  mime_info->encoding_top);

    if (headers->precedence)
	write_text_header(filedesc,"Precedence",headers->precedence,
			  mime_info->encoding_top);

    if (headers->expires)
	write_text_header(filedesc,"Expires",headers->expires,
			  mime_info->encoding_top);

    if (headers->reply_to.addrs)
	write_addr_header(filedesc,"Reply-To",headers->reply_to.addrs,
			  mime_info->encoding_top,
			  mime_info->encode_hdr,
			  mime_info->hdr_charset);
	
    if (headers->user_defined_header) {
	fprintf(filedesc, "%s", headers->user_defined_header);
	print_EOLN(filedesc,mime_info->encoding_top);
    }

    add_mailheaders(filedesc);

#ifndef NO_XHEADER
    fprintf(filedesc, "X-Mailer: ELM [version %s]", version_buff);
    print_EOLN(filedesc,mime_info->encoding_top);
#endif /* !NO_XHEADER */

    if (form) 
	fprintf(filedesc, "Content-Type: mailform\n");
    else {
	mime_write_top_headers (filedesc, mime_info);
    }
    mime_info->cl_offset = 0;
    if (copy) {
	/* Only write content-length to copy */
	fprintf(filedesc, "Content-Length: ");
	mime_info->cl_offset = ftell(filedesc);
	fprintf(filedesc, "          "); /* Print Blanks as Placeholders */
	print_EOLN(filedesc,mime_info->encoding_top);
	fprintf(filedesc, "Status: RO");
	print_EOLN(filedesc,mime_info->encoding_top);
    }
    print_EOLN(filedesc,mime_info->encoding_top);
    return(filedesc);
}

static int copy_part P_((mime_send_t *mime_info,FILE *dest,
			 FILE *conv_file,struct mime_send_part * X,
			 int copy));
static int copy_part(mime_info,dest,conv_file,X,copy)
     mime_send_t *mime_info;
     FILE *dest;
     FILE *conv_file;
     struct mime_send_part * X;
     int copy;
{
    int line_len;
    char buffer[SLEN];			/* file reading buffer */
    long a = ftell(dest);

    if (0 != fseek(conv_file,X->start_loc,SEEK_SET)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSeekFailed,
			  "ELM [seek] failed trying to read %d bytes into file."),
		  (int) X->start_loc);
	return 0;
    }

    /* There is at least one extra \n added between different part so
     * mail_gets() should not go to next part ...
     */
       
    while (ftell(conv_file) < X->end_loc &&
	   (line_len = mail_gets(buffer, SLEN-1, conv_file))) {

	if (X->encoding_part == ENCODING_BINARY) {
	    /* \n -> \r\n conversion is done for that part already */
	    fwrite(buffer, 1, line_len, dest);
	} else if (mime_info->encoding_top == ENCODING_BINARY) {
	    /* It is better perhaps use canonical eol (CRLF) when mail have
	     * content transfer encoding BINARY somewhere (see notes about 
	     * BINARYMIME)
	     */
	    
	    if (buffer[line_len-1] == '\n') {
		int add = 1;
		if (line_len >1 && buffer[line_len-2] == '\r')
		    add = 0;
		if (add) {
		    buffer[line_len-1] = '\r';
		    buffer[line_len] = '\n';
		    line_len++;
		}	      
	    }
	    /* We don't do escaping because line does not end either 
	     * to plain \n now...
	     */
	    fwrite(buffer, 1, line_len, dest);
#ifndef DONT_ESCAPE_MESSAGES
	} else if (copy && (strncmp(buffer, "From ", 5) == 0)) {
	    /* Add in the > to a From on our copy */
	    fprintf(dest, ">");
	    fwrite(buffer, 1, line_len, dest);
#endif
#ifdef NEED_LONE_PERIOD_ESCAPE
	} else if (!copy && strcmp(buffer, ".\n") == 0) {
	    /* Because some mail transport agents take a lone period to
	     * mean EOF, we add a blank space on outbound message.
	     */
	    fputs(". \n", dest);
#endif /* NEED_LONE_PERIOD_ESCAPE */
	} else {
	    fwrite(buffer, 1, line_len, dest);
	}
    }

    if (ferror(dest) || ferror(conv_file))
	return 0;

    DPRINT(Debug,4, (&Debug,
	      "Preparing mail for %s: part %d -- %d bytes written to temp%s\n",
	      copy ? "copy" : "sending",
	      X-mime_info->top_parts,
	      ftell(dest)-a,
	      feof(conv_file) ? ", got EOF" : ""));

    return 1;
}

int copy_message_across(mime_info, dest, copy, conv_file)
     mime_send_t *mime_info;
     FILE *dest;
     int copy;
     FILE *conv_file;
{

    /** If copy is TRUE, treat as a saved copy of outbound mail. **/

    mime_info -> cl_start = ftell(dest);

    if (mime_info->msg_is_multipart) {
	int i;

	DPRINT(Debug,4, (&Debug,
			 "Preparing mail for %s: %d parts (multipart)\n",
			 copy ? "copy" : "sending",
			 mime_info->top_parts_count));

	for (i = 0; i < mime_info->top_parts_count; i++) {
	    if (!copy || mime_info->top_parts[i].save_it_on_copy) {

		print_EOLN(dest,mime_info->encoding_top);
		fprintf(dest,"--%s",mime_info->mime_boundary);
		print_EOLN(dest,mime_info->encoding_top);

		mime_write_part_headers(dest,mime_info,
					&(mime_info->top_parts[i]));
		print_EOLN(dest,mime_info->encoding_top);

		if (!copy_part(mime_info,dest,conv_file,
			       &(mime_info->top_parts[i]),copy)) {
		    return 0;
		}
	    }
	}
	print_EOLN(dest,mime_info->encoding_top);
	fprintf(dest,"--%s--", mime_info->mime_boundary);
	print_EOLN(dest,mime_info->encoding_top);

    } else if (1 == mime_info->top_parts_count) {
	DPRINT(Debug,4,(&Debug,  
		  "Preparing mail for %s: one part (not multipart)\n",
		  copy ? "copy" : "sending"));

	if (!copy || mime_info->top_parts[0].save_it_on_copy) {
	    if (!copy_part(mime_info,dest,conv_file,
			   &(mime_info->top_parts[0]),copy)) {
		return 0;
	    }
	}
    } else {
	DPRINT(Debug,4,(&Debug,  
			"Preparing mail for %s: ODD: %d parts (NOT multipart)\n",
			copy ? "copy" : "sending",mime_info->top_parts_count));
    }

    mime_info->cl_end = ftell(dest) ;
    if (mime_info->cl_offset > 0) {
	/* go fixup the content length header */
	fseek(dest, mime_info->cl_offset, 0);
	fprintf(dest, "%d", mime_info->cl_end - mime_info->cl_start);
	  
	/* Return to the end of the file! */
	fseek (dest, 0, 2);
    }

    DPRINT(Debug,4,(&Debug,  
		    "Preparing mail for %s: total %d bytes body, ~%d bytes headers\n",
		    copy ? "copy" : "sending",
		    mime_info->cl_end - mime_info -> cl_start,
		    mime_info -> cl_start));
    
    if (EOF == fflush(dest) || ferror(dest)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWriteFailedCopy,
			  "Write failed to temp file in copy"));
	return 0;
    }

    return 1;
}

static int append_sig(file, headers)
     FILE *file;
     struct mailing_headers *headers;
{
    /* Append the correct signature file to file.  Return TRUE if
       we append anything.  */
    
    /* Look at the to and cc list to determine which one to use */
    
    /* We could check the bcc list too, but we don't want people to
       know about bcc, even indirectly */
    
    /* Some people claim that  user@anything.same_domain should be 
       considered local.  Since it's not the same machine, better be 
       safe and use the remote sig (presumably it has more complete
       information).  You can't necessarily finger someone in the
       same domain. */

    if (!batch_only && (local_signature[0] || remote_signature[0])) {

	char filename2[SLEN];
	char *sig = "";

	/* check each @ for @thissite.domain */
	/* if any one is different than this, then use remote sig */

	struct addr_item *p;
    
	sig = local_signature;

	/* check To: list */
	for (p = headers->to.addrs ; 
	     p < headers->to.addrs + headers->to.addrs_len;
	     p++) { 
	    char *ptr = qstrpbrk(p->addr,":");
	    
	    /* skip route */
	    if (ptr)
		ptr = qstrpbrk(ptr,"@");
	    else
		ptr = qstrpbrk(p->addr,"@");

	    if (!ptr)
		continue;
	    ptr++;
	    
	    if (istrcmp(ptr, hostfullname) != 0) {
		sig = remote_signature;
		break;
	    }
	}

	if (sig == local_signature)		   /* still local? */         
	    /* check Cc: */
	    for (p = headers->cc.addrs ; 
		 p < headers->cc.addrs + headers->cc.addrs_len;
		 p++) { 
		char *ptr = qstrpbrk(p->addr,":");
		
		/* skip route */
		if (ptr)
		    ptr = qstrpbrk(ptr,"@");
		else
		    ptr = qstrpbrk(p->addr,"@");
		
		if (!ptr)
		    continue;
		ptr++;
	    
		if (istrcmp(ptr, hostfullname) != 0) {
		    sig = remote_signature;
		    break;
		}
	    }

	if (sig[0]) {  /* if there is a signature file */
	    if (sig[0] != '/')
		elm_sfprintf(filename2, sizeof filename2,
			     FRM("%s/%s"), 
			     home, sig);
	    else
		strfcpy(filename2, sig, sizeof filename2);
	    /* append the file - with a news 2.11 compatible */
	    /* seperator if "sig_dashes" is enabled */
	    (void) append(file, filename2, (sig_dashes ? "\n-- \n" : NULL));
	    
	    return TRUE;
	}    
    }
    return FALSE;
}

int check_8bit_str (str)
     char *str;
{
  char *s;

  for (s = str;	*s; s++)
    if (*s & 0x80)
      return HAVE_8BIT;
  return 0;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
