static char rcsid[] = "@(#)$Id: mailmsg1.c,v 1.22 2001/06/09 15:34:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.22 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Interface to allow mail to be sent to users.  Part of ELM  **/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"mail");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}


void zero_mailing_headers (hdrs)
     struct mailing_headers *hdrs;
{
    hdrs->subject     = NULL;
    zero_expanded_address(&(hdrs->from));
    zero_id_phrase(&(hdrs->in_reply_to));
    hdrs->expires     = NULL;
    hdrs->action      = NULL;
    hdrs->priority    = NULL;
    zero_expanded_address(&(hdrs->reply_to));
    zero_expanded_address(&(hdrs->to));
    zero_expanded_address(&(hdrs->cc));
    hdrs->user_defined_header = NULL;
    zero_expanded_address(&(hdrs->bcc));
    hdrs->precedence   = NULL;
    hdrs->expires_days = NULL;
}

void free_mailing_headers (hdrs)
     struct mailing_headers *hdrs;
{
    if (hdrs->subject)
	free_string(&(hdrs->subject));
    hdrs->subject     = NULL;
    free_expanded_address(&(hdrs->from));
    free_id_phrase(&(hdrs->in_reply_to));
    if (hdrs->expires)
	free(hdrs->expires);
    hdrs->expires     = NULL;
    if (hdrs->action)
	free(hdrs->action);
    hdrs->action      = NULL;
    if (hdrs->priority)
	free(hdrs->priority);
    hdrs->priority    = NULL;
    free_expanded_address(&(hdrs->reply_to));
    free_expanded_address(&(hdrs->to));
    free_expanded_address(&(hdrs->cc));
    if (hdrs->user_defined_header)
	free(hdrs->user_defined_header);
    hdrs->user_defined_header = NULL;
    free_expanded_address(&(hdrs->bcc));
    if (hdrs->precedence)
	free(hdrs->precedence);
    hdrs->precedence   = NULL;
    if (hdrs->expires_days)
	free(hdrs->expires_days);
    hdrs->expires_days = NULL;
}

static int to_line, to_col;

static int copy_the_msg P_((struct mailing_headers *headers,
			    int *is_a_response, int options));


static CONST unsigned char * csUs P_((const char *str));
static CONST unsigned char * csUs(str)
     CONST char *str;
{
    return (CONST unsigned char *)str;
}

static void output_abbreviated_to P_((struct addr_item *addrs));

static void output_abbreviated_to (addrs)
     struct addr_item *addrs;
{
    /** Output just the fields in parens, separated by commas if need
	be, and up to COLUMNS-50 characters...This is only used if the
	user is at level BEGINNER.
    **/

    struct string *newaddress = NULL;
    struct addr_item *p;

    for (p = addrs; p && p->fullname && p->addr; p++) {	
	if (newaddress)
	    add_ascii_to_string(newaddress,s2us(", "));
	else
	    newaddress = new_string(display_charset);
	if (string_len(p->fullname)) {
	    struct string * temp = cat_strings(newaddress,p->fullname,1);
	    free_string(&newaddress);
	    newaddress = temp;
	} else {
	    add_ascii_to_string(newaddress,csUs(p->addr));
	}
    }
    
    if (!newaddress)
	return;
    
    if (mail_only)
	if (string_len(newaddress) > 80) 
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToParen, 
			     "To: (%.*S...)"), 
		     60,newaddress);
	else
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %S"), 
		     newaddress);
    else if (string_len(newaddress) > 50) 
	PutLineX(to_line, to_col, 
		 CATGETS(elm_msg_cat, ElmSet, ElmToParen, "To: (%.*S...)"), 
		 40,newaddress);
    else {
	if (string_len(newaddress) > 30)
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %S"), 
		     newaddress);
	   else
	       PutLineX(to_line, to_col, 
			CATGETS(elm_msg_cat, ElmSet, ElmToNoParen2, 
				"          To: %S"), 
			newaddress);
	CleartoEOLN();
    }
    
    free_string(&newaddress);
    return;    
}

void display_to(address)
     struct expanded_address address;
{
    /** Simple routine to display the "To:" line according to the
	current configuration (etc) 			      
    **/
    struct string *addr_string;

    to_line = mail_only ? 3 : elm_LINES - 3;
    to_col = mail_only ? 0 : elm_COLUMNS - 50;

    if (names_only) {
	output_abbreviated_to(address.addrs);
	return;
    }

    addr_string = hdr_to_expval(address);
    if (!addr_string)
	return;

    if(mail_only)
	if(string_len(addr_string) > 80)
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToParen, 
			     "To: (%.*S...)"), 
		     75,addr_string);
	  else
	      PutLineX(to_line, to_col, 
		       CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %S"), 
		       addr_string);
    else if (string_len(addr_string) > 45) 
	PutLineX(to_line, to_col, 
		 CATGETS(elm_msg_cat, ElmSet, ElmToParen, "To: (%.*S)"), 
		 40,addr_string);
    else {
	if (string_len(addr_string) > 30) 
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %S"), 
		     addr_string);
	else
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen2, 
			     "          To: %S"), 
		     addr_string);
	CleartoEOLN();
    }
    free_string(&addr_string);
}

int get_to(to)
     struct expanded_address *to;
{
    char buffer[LONG_STRING];

    /** prompt for the "To:" field, expanding into address if possible.
	This routine returns ZERO if errored, or non-zero if okay **/
    
    expanded_to_edit_buffer(buffer, sizeof buffer, *to);

    if (to->surface_len == 0) {
	
	if (user_level < 2) {
	    int code;

	    PutLineX(elm_LINES-2, 0, 
		     CATGETS(elm_msg_cat, ElmSet, ElmSendTheMessageTo,
			     "Send the message to: "));
	    code = optionally_enter(buffer, -1, -1, 
				    OE_REDRAW_MARK, sizeof buffer); 
	    while (REDRAW_MARK == code) {
		PutLineX(elm_LINES-2, 0, 
			 CATGETS(elm_msg_cat, ElmSet, ElmSendTheMessageTo,
				 "Send the message to: "));
		code = optionally_enter(buffer, -1, -1, 
					OE_REDRAW_MARK|OE_APPEND_CURRENT,
					sizeof buffer); 
	    }
	    if (0 != code)
		return 0;
	}
	else {
	    int code;
	    PutLineX(elm_LINES-2, 0, 
		     CATGETS(elm_msg_cat, ElmSet, ElmTo, "To: "));
	    code = optionally_enter(buffer, -1, -1, OE_REDRAW_MARK,
				    sizeof buffer); 
	    while (code == REDRAW_MARK) {
		PutLineX(elm_LINES-2, 0, 
			 CATGETS(elm_msg_cat, ElmSet, ElmTo, "To: "));
		code = optionally_enter(buffer, -1, -1, 
					OE_REDRAW_MARK|OE_APPEND_CURRENT,
					sizeof buffer); 
		if (0 != code)
		    return 0;
	    }
	}
	if (strlen(buffer) == 0) {
	    free_expanded_address(to);
	    ClearLine(elm_LINES-2);	
	    return(0);
	}
	update_expanded_from_edit_buffer(to,buffer);
    }
  
    build_address_l(to);
    
    if (to->addrs_len == 0) {	/* bad address!  Removed!! */
	ClearLine(elm_LINES-2);
	return(0);
    }
    
    return(1);		/* everything is okay... */
}

static int get_copies P_((struct expanded_address * cc,
			  int copy_message));
static int get_subject P_((struct string **field));

static int send_msg_middle P_((
			       struct header_rec * current_header,
			       struct expanded_address *given_to, 
			       struct expanded_address *given_cc,
			       char *given_subject,
			       int   options, int form_letter));

static int send_msg_middle(current_header,
			   given_to, given_cc, given_subject, options, 
			   form_letter)
     struct header_rec * current_header;
     struct expanded_address *given_to, *given_cc;
     char *given_subject;
     int   options, form_letter;
{
    int res;
    int copy_msg = FALSE, is_a_response = FALSE;
    char *p;
    struct mailing_headers headers;

    zero_mailing_headers(&headers);
    if (given_subject)
	headers.subject = new_string2(display_charset,s2us(given_subject));
    if (given_to)
	copy_expanded_address(&headers.to,*given_to);
    if (given_cc)
	copy_expanded_address(&headers.cc,*given_cc);

    if ((p = getenv("REPLYTO")) != NULL)
	update_expanded_from_edit_buffer(&headers.reply_to,p);

    /* auto bcc line */
    if ((p = getenv("BCC")) != NULL)
	update_expanded_from_edit_buffer(&headers.bcc,p);

    /* copy msg into edit buffer? */
    copy_msg = copy_the_msg(&headers,
			    &is_a_response, options);
    if (copy_msg) options |= MAIL_COPY_MSG;

    /* get the To: address and expand */
    if (! get_to(&headers.to))
	return(0);

    /* expand the Cc: address */
    if (&headers.cc.surface_len)
	build_address_l(&headers.cc);

    /* expand the Reply-To: address */
    if (&headers.reply_to.surface_len)
	build_address_l(&headers.reply_to);

    /* expand the bcc address */
    if (&headers.bcc.surface_len)
	build_address_l(&headers.bcc);

    /** if we're batchmailing, let's send it and GET OUTTA HERE! **/
    
    if (batch_only) {
	/** if we're batchmailing, let's send it and GET OUTTA HERE! **/
	res = mail(NULL, 0, form_letter,&headers);
    } else {
	display_to(headers.to);

	/* get the Subject: field */

	if (get_subject(&headers.subject) == 0) {
	    res = 0;
	    goto free_it;
	}

	if (prompt_for_cc) {
	    if (get_copies(&headers.cc, copy_msg) == 0) {
		res = 0;
		goto free_it;
	    }
	}

	MoveCursor(elm_LINES,0);	/* so you know you've hit <return> ! */

	/** generate the In-Reply-To: header... **/
	
	if (is_a_response && 0 != (options & MAIL_REPLYING))
	    generate_reply_to(current_header,&headers);

	/* and mail that puppy outta here! */
	
	DPRINT(Debug,3,(&Debug, 
			"\nsend_msg() ready to mail...\n"));
	dump_expanded_address(3,"to",headers.to);
	if (headers.subject) {
	    DPRINT(Debug,3,
		   (&Debug,
		    "subject=\"%S\"\n",
		    headers.subject));
	}
	dump_expanded_address(5,"cc",headers.cc);
	dump_expanded_address(5,"bcc",headers.bcc);
	
	res=mail(current_header,options, form_letter,&headers);
    }

 free_it:    
    free_mailing_headers(&headers);
    return res;
}

int send_msg_l(current_header,
	       given_to, given_cc, given_subject, options, form_letter)
     struct header_rec * current_header;
     struct addr_item *given_to, *given_cc;
     char *given_subject;
     int   options, form_letter;
{
    int ret;
    struct expanded_address A, B;

    zero_expanded_address(&A);
    zero_expanded_address(&B);

    addr_to_expanded(&A,given_to);
    addr_to_expanded(&B,given_cc);

    ret = send_msg_middle(current_header,&A,&B,
			  given_subject,options,form_letter);
    free_expanded_address(&A);
    free_expanded_address(&B);
    return ret;
}

int send_msg_argv(argv, given_subject, options, form)
     char *argv[];
     char *given_subject;
     int   options;
     int form;
{
    int ret;
    struct expanded_address A, B;

    zero_expanded_address(&A);
    zero_expanded_address(&B);

    argv_to_expanded(&A,argv);

    ret = send_msg_middle(NULL,&A,&B,
			  given_subject,options,form);

    free_expanded_address(&A);
    free_expanded_address(&B);
    return ret;
}

static int get_subject(subject_field)
     struct string **subject_field;
{
    char	ch, msgbuf[SLEN];
    int code;
    
    /** get the subject and return non-zero if all okay... **/
    int prompt_line = mail_only ? 4 : elm_LINES-2;

redraw:
    if (user_level == 0) {
	code = optionally_enter2(subject_field, prompt_line, 0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK
				 /* Allow user paste mime encoded
				    words to buffer */
				 |OE_ALLOW_MIMEENC,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmSubjectOfMessage,
					 "Subject of message: "));
    } else
	code = optionally_enter2(subject_field, prompt_line, 0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK
				 /* Allow user paste mime encoded
				    words to buffer */
				 |OE_ALLOW_MIMEENC,
				 CATGETS(elm_msg_cat, ElmSet, ElmSubject, 
					 "Subject: "));
    
    if (REDRAW_MARK == code)
	goto redraw;

    if(code==-1){
	/** User hit the BREAK key! **/
	MoveCursor(prompt_line,0); 	
	CleartoEOLN();
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailNotSent, 
			  "Mail not sent."));
	return(0);
    }

    if (!*subject_field ||
	string_len(*subject_field) == 0) {	/* zero length subject?? */
	elm_sfprintf(msgbuf, sizeof msgbuf,
		     CATGETS(elm_msg_cat, ElmSet, ElmNoSubjectContinue,
			     "No subject - Continue with message? (%c/%c) "),
		     *def_ans_yes, *def_ans_no);
	
	ch = want_to(msgbuf, *def_ans_no, prompt_line, 0);
	if (ch != *def_ans_yes) {	/* user says no! */
	    if (sleepmsg > 0)
		sleep((sleepmsg + 1) / 2);
	    ClearLine(prompt_line);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailNotSend, 
			      "Mail not sent."));
	    return(0);
	}
	else {
	    PutLineX(prompt_line,0,
		     CATGETS(elm_msg_cat, ElmSet, 
			     ElmSubjectNone, 
			     "Subject: <none>"));
	    CleartoEOLN();
	    if (!*subject_field) 
		*subject_field = new_string(display_charset);
	}
    }
    
    return(1);		/** everything is cruising along okay **/
}

static int get_copies(struct expanded_address *cc,
		      int copy_message);

static int get_copies(cc,copy_message)
     struct expanded_address * cc; 
     int copy_message;
{
    /* Get the list of people that should be cc'd, returning ZERO if
     * any problems arise.  
     *
     * If copy-message, that means that we're going to have to invoke
     * a screen editor, so we'll need to delay after displaying the
     * possibly rewritten Cc: line...
     */

    int prompt_line;
    int code;
    char *buffer = NULL;
    int size = 0;

    prompt_line = mail_only ? 5 : elm_LINES - 1;
    PutLineX(prompt_line,0, 
	     CATGETS(elm_msg_cat, ElmSet, ElmCopiesTo, "Copies to: "));

    FlushBuffer();

    hdr_to_buffer(*cc,&buffer,&size);
    
    code = optionally_enter(buffer, prompt_line, 11, OE_REDRAW_MARK, size);
    while (REDRAW_MARK == code) {
	PutLineX(prompt_line,0, 
		 CATGETS(elm_msg_cat, ElmSet, ElmCopiesTo, "Copies to: "));
	code = optionally_enter(buffer, prompt_line, 11, 
				OE_REDRAW_MARK|OE_APPEND_CURRENT,
				size);
    }
    if (code == -1) {
	ClearLine(prompt_line-1);
	ClearLine(prompt_line);
	  
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailNotSend, 
			  "Mail not sent."));
	
	buffer_to_header(cc,buffer,TRUE);
	return(0);
    }
	
    /** The following test is that if the build_address routine had
	reason to rewrite the entry given, then, if we're mailing only
	print the new Cc line below the old one.  If we're not, then
	assume we're in screen mode and replace the incorrect entry on
	the line above where we are (e.g. where we originally prompted
	for the Cc: field).
    **/

    buffer_to_header(cc,buffer,FALSE);

    if (build_address_l(cc)) {
	struct string * B = hdr_to_expval(*cc);
	if (B) {
	    PutLineX(prompt_line, 11, FRM("%S"), B);
	    if ((strcmp(editor, "builtin") != 0 && strcmp(editor, "none") != 0)
		|| copy_message)
		sleep_message();
	    free_string(&B);
	}
    }
    
    return(1);		/* everything looks okay! */
}
	
static int copy_the_msg(headers,is_a_response, options)
     struct mailing_headers *headers;
     int *is_a_response;
     int options;
{
  int forwarding = 0 != (options & MAIL_FORWARDING);

  /** Returns True iff the user wants to copy the message being
    replied to into the edit buffer before invoking the editor! 
    Sets "is_a_response" to true if message is a response...
    **/

  char msg[SLEN];
  int answer = FALSE;
  
  if (forwarding)
    answer = TRUE;
  else if (headers->to.addrs_len > 0 && !mail_only) {  
    /* predefined 'to' line! */
    if (auto_copy) 
      answer = TRUE;
    else {
      elm_sfprintf(msg, sizeof msg,
		   CATGETS(elm_msg_cat, ElmSet, ElmCopyMessageYN,
			   "Copy message? (%c/%c) "), 
		   *def_ans_yes, *def_ans_no);
      answer = (want_to(msg, *def_ans_no, elm_LINES-3, 0) == *def_ans_yes);
    }
    *is_a_response = TRUE;
  }
  
  return(answer);
}

int a_sendmsg(edit_message, form_letter)
     int   edit_message, form_letter;
{
    /** Prompt for fields and then call mail() to send the specified
	message.  If 'edit_message' is true then by defualt go to
	editor. 'form_letter' can be "YES" "NO" or "MAYBE".
	if YES, then add the header.  If MAYBE, then add the M)ake form
	option to the last question (see mailsg2.c) etc. etc. 
	
	Return TRUE if the main part of the screen has been changed
	(useful for knowing whether a redraw is needed.
    **/

    register int tagged = 0, i;
    int ret;

    struct mailing_headers headers;
    
    zero_mailing_headers(&headers);

    tagged = aliases_to_expanded(&headers.to);
    
    DPRINT(Debug,4, (&Debug, "%d aliases tagged for mailing (a_sndmsg)\n",
		     tagged));

    /******* And now the real stuff! *******/
    
    /* build the To: address and expand */
    if (build_address_l(&headers.to) == 0)   
	return(0);

    display_to(headers.to);	/* display the To: field on screen... */

    /* get the Subject: field */

    if (get_subject(&headers.subject) == 0) {
	ret = 0;
	goto free_it;
    }

    if (prompt_for_cc) {
	if (get_copies(&headers.cc, FALSE) == 0) {
	    ret = 0;
	    goto free_it;
	}
    }
	
    MoveCursor(elm_LINES,0);	/* so you know you've hit <return> ! */
    
    /* and mail that puppy outta here! */
    
    DPRINT(Debug,3,(&Debug, 
		    "\na_sendmsg() ready to mail...\n"));
    dump_expanded_address(3,"to",headers.to);
    if (headers.subject) {
	DPRINT(Debug,4, (&Debug,	   
			 "subject=\"%S\"\n",
			 headers.subject));
    }
    dump_expanded_address(5,"cc",headers.cc);
    dump_expanded_address(5,"bcc",headers.bcc);
	
    main_state();
    ret = mail(NULL, edit_message ? MAIL_EDIT_MSG : 0, form_letter,
	       &headers);
    main_state();
    
    /*
     *	Since we got this far, it must be okay to clear the tags.
     */
    i = 0;
    while (tagged) {
	if (ison(aliases[i]->status, TAGGED)) {
	    clearit(aliases[i]->status, TAGGED);
	    show_msg_tag(i);
	    tagged--;
	}
	i++;
    }
    
 free_it:    
    free_mailing_headers(&headers);
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
