static char rcsid[] = "@(#)$Id: lock.c,v 1.12 2001/02/25 18:36:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** leave current folder, updating etc. as needed...
  
**/


#include "headers.h"
#include "me.h"
#include "s_elm.h"

#ifdef SYSCALL_LOCKING
#  if (defined(BSD_TYPE) || !defined(apollo))
#    include <sys/file.h>
#  endif
#endif
#include <errno.h>

extern int errno;

char *error_description();

extern char *mk_lockname();


int lock(direction, folder)
     int direction;
     struct folder_info *folder;
{
     /** Create lock file to ensure that we don't get any mail 
	  while altering the folder contents!
	  If it already exists sit and spin until 
	     either the lock file is removed...indicating new mail
	  or
	     we have iterated MAX_ATTEMPTS times, in which case we
	     either fail or remove it and make our own (determined
	     by if REMOVE_AT_LAST is defined in header file

	  If direction == INCOMING then DON'T remove the lock file
	  on the way out!  (It'd mess up whatever created it!).

	  But if that succeeds and if we are also locking by flock(),
	  follow a similar algorithm. Now if we can't lock by flock(),
	  we DO need to remove the lock file, since if we got this far,
	  we DID create it, not another process.
      **/
    int ret;

    ret = lock_folder(direction,folder);
    if (!ret) {
        sleep(1);
	MoveCursor(elm_LINES, 0);
	Raw(OFF);

	if (have_saved_ids) {
	  if (setgid(groupid) < 0) {
    	    int err = errno;
	    lib_error(FRM("Lock: setgid(%d) FAILED: %s"),
		      groupid,error_description(err));
	  }
	}

	if (direction == INCOMING)
	  leave_locked(0);
	else
	  emergency_exit(0);
    }
    
    return(0);
}

int unlock(interrupt, folder)
     int interrupt;
     struct folder_info *folder;
{
  /** Remove the lock file!    This must be part of the interrupt
      processing routine to ensure that the lock file is NEVER
      left sitting in the mailhome directory!
      
      If also using flock(), remove the file lock as well.
  **/

  return !unlock_folder(interrupt,folder);
}
