static char rcsid[] = "@(#)$Id: edit.c,v 1.9 2000/10/10 15:16:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine is for allowing the user to edit their current folder
    as they wish.

**/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

extern int errno;

char   *error_description();
long   bytes();

#ifdef ALLOW_MAILBOX_EDITING

void edit_mailbox()
{
    /** Allow the user to edit their folder, always resynchronizing
	afterwards.   Due to intense laziness on the part of the
	programmer, this routine will invoke $EDITOR on the entire
	file.  The mailer will ALWAYS resync on the folder
	even if nothing has changed since, not unreasonably, it's
	hard to figure out what occurred in the edit session...
	
	Also note that if the user wants to edit their incoming
	mailbox they'll actually be editing the tempfile that is
	an exact copy.  More on how we resync in that case later
	in this code.
    **/

    CONST char *edited_file = NULL;

    if (!current_folder)
	return;

    if (!start_edit_folder(current_folder,&edited_file))
	return;

    if (edit_a_file(edited_file) == 0) 
	return;
    
    switch(end_edit_folder(current_folder)) {
    case -1:
	emergency_exit(0);
    case 0:
	return;
    }

    if (sleepmsg > 0)
	sleep(sleepmsg);
    ClearScreen();
    newmbox_1(current_folder, FALSE);
    showscreen();
    return;
}

#endif

int edit_a_file(editfile)
     CONST char *editfile;
{
	/** Edit a file.  This routine is used by edit_mailbox()
	    and edit_aliases_text().  It gets all the editor info
	    from the elmrc file.
	**/

	char     buffer[SLEN];

	PutLineX(elm_LINES-1,0, CATGETS(elm_msg_cat, ElmSet, ElmInvokeEditor,
					"Invoking editor..."));

	if (strcmp(editor, "builtin") == 0 || strcmp(editor, "none") == 0) {
	  if (in_string(alternative_editor, "%s"))
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM(alternative_editor), editfile);
	  else
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("%s %s"), alternative_editor, editfile);
	} else {
	  if (in_string(editor, "%s"))
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM(editor), editfile);
	  else
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("%s %s"), editor, editfile);
	}

	Raw(OFF);

	if (system_call(buffer, SY_ENAB_SIGHUP) == -1) {
	    Raw(ON);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmProblemsInvokingEditor,
			      "Problems invoking editor %s!"), 
		      alternative_editor);
	    sleep_message();
	    return(0);
	}

	Raw(ON);
	/* a location not near the next request, so an absolute is used */
	SetXYLocation(0, 40);

	return(1);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */




