static char rcsid[] = "@(#)$Id: a_sort.c,v 1.8 2001/06/06 18:09:03 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.8 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Sort alias table by the field specified in the global
    variable "alias_sortby"...

**/

#include "headers.h"
#include "me.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

char *alias_sort_name();

static void alias_old_current P_((long iindex));

void sort_aliases(entries, visible, are_in_aliases)
     int entries, visible, are_in_aliases;
{
    /** Sort the header_table definitions... If 'visible', then
	put the status lines etc **/
    
    long last_index = -1;
    int compare_aliases();	/* for sorting */
    
    DPRINT(Debug,2, (&Debug, "\n** sorting aliases by %s **\n\n", 
		     alias_sort_name(FULL)));
    
    /* Don't get last_index if no entries or no current. */
    /* There would be no current if we are sorting for the first time. */
    if (entries > 0 && current > 0)
	last_index = aliases[current-1]->length;
    
    if ((entries > 30) && visible && are_in_aliases) {
	lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesSort,
			      "Sorting aliases by %s..."), 
		      alias_sort_name(FULL));
    }
    
    if (entries > 1)
	qsort((char *) aliases, (unsigned) entries,
	      sizeof (struct alias_rec *), compare_aliases);
  
    if (last_index > -1)
	alias_old_current(last_index);
  
    if (are_in_aliases) {
	clear_error();
    }
}

int compare_aliases(p1, p2)
     struct alias_rec **p1, **p2;
{
    /** compare two aliases according to the sortby value.
	
	Both are simple strcmp()'s on the alias or last_name
	components of the alias.
    **/
    
    struct alias_rec *first, *second;
    int ret;
    long diff;

    first = *p1;
    second = *p2;
    
    /* If (only) one of the compares is a duplicate we want it
     * to go to the end of the list regardless of the sorting
     * method.
     */
    if ((first->type ^ second->type) & DUPLICATE) {
	if (first->type & DUPLICATE)
	    ret = 1;
	else			/* It must be second... */
	    ret = -1;
	return ret;
    }
    
    switch (abs(alias_sortby)) {
    case ALIAS_SORT:
	ret = strcmp(first->alias, second->alias);
	break;
	
    case NAME_SORT:
	ret = strcmp(first->last_name, second->last_name);
	/*
	 * If equal on last name then compare on first name
	 * which is the first part of 'name'.
	 */
	if (ret == 0) {
	    ret = strcmp(first->name, second->name);
	}
	break;
	
    case TEXT_SORT:
	diff = (first - second);
	if ( diff < 0 )	ret = -1;
	else if ( diff > 0 ) ret = 1;
	else ret = 0;
	break;
	
    default:
	/* never get this! */
	ret = 0;
	break;
    }

    if (alias_sortby < 0)
	ret = -ret;
    
    return ret;
}

char *alias_sort_name(type)
     int type;
{
    /** return the name of the current sort option...
	type can be "FULL", "SHORT" or "PAD"
    **/
    int pad, abr;
    extern char *a_rev_alias_pad, *a_rev_alias_abr,
	*a_full_abr,
	*a_text_abr,
	*a_alias_pad, *a_alias_abr,
	*a_full_pad,
	*a_text_pad;
	
    pad = (type == PAD);
    abr = (type == SHORT);
    
    if (alias_sortby < 0) {
	switch (- alias_sortby) {
	case ALIAS_SORT   : return(
				   pad?     "Reverse Alias Name      " :
				   abr?     "Reverse-Alias" :
				   "Reverse Alias Name");
	case NAME_SORT    : return(
				   pad?     "Reverse Full (Real) Name" :
				   abr?     "Reverse-Name" :
				   "Reverse Full (Real) Name");
	    case TEXT_SORT    : return(
				       pad?     "Reverse Text File       " :
				       abr?     "Reverse-Text" :
				       "Reverse Text File");
	}
    }
    else {
	switch (alias_sortby) {
	case ALIAS_SORT   : return(
				   pad?     "Alias Name              " :
				   abr?     "Alias" :
				       "Alias Name");
	case NAME_SORT    : return(
				   pad?     "Full (Real) Name        " :
				   abr?     "Name" :
				   "Full (Real) Name");
	case TEXT_SORT    : return(
				   pad?     "Text File               " :
				   abr?     "Text" :
				   "Text File");
	}
    }
    
    return("*UNKNOWN-SORT-PARAMETER*");
}

static void alias_old_current(iindex)
     long iindex;
{
    /** Set current to the message that has "index" as it's 
	index number.  This is to track the current message
	when we resync... **/

    int i;
    
    DPRINT(Debug,4,
	   (&Debug, "alias-old-current(%d)\n", iindex));
    
    for (i = 0; i < message_count; i++)
	if (aliases[i]->length == iindex) {
	    current = i+1;
	    DPRINT(Debug,4,
		   (&Debug, "\tset current to %d!\n", current));
	    return;
	}
    
    DPRINT(Debug,4,
	   (&Debug,
	    "\tcouldn't find current index.  Current left as %d\n",
	    current));
    return;		/* can't be found.  Leave it alone, then */
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
