/* $Id: elmtls.h,v 1.12 2001/05/01 08:56:57 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmshared.h"

#include <openssl/ssl.h>
#include <openssl/bio.h>
#include <openssl/err.h>

extern struct stream_type TLS_STREAM;
extern struct SE_option_type tls_options;

struct SE_option_value {   /* TLS option values */
    enum { tls_none = -1, 
	   v_ssl = 0, v_tls = 1
    } v_starttls;        
};

extern int tls_init P_((int init_rand));
extern union stream_types create_TLS_stream P_((int tls));


#include "../../hdrs/ss_imp.h"
#include "../../hdrs/mbx_imp.h"

extern enum tls_connection_state { 
    tls_not_connected = 0,
	tls_connected = 1,
	tls_error     = 2,
	tls_closing   = 3,
	tls_closed    = 4
				 } ss_TLS_state P_((struct streamsched *ss,
						    int stack_idx));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
