case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac


echo "Extracting shared_libs/tls/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 1.11 2001/06/14 18:25:43 hurtta Exp $
#
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
#
#
INSTLIB		= $shlib/libelmme-tls.so$d_shared_rev
AR		=	ar
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
SONAME          = ${soname_opt}$shlib/libelmme-tls.so$d_shared_rev
!GROK!THIS!

if $test "$tls_lib_dir" != ""; then
    $cat >>Makefile <<EOS
LIBDIRLIST      =  -L$tls_lib_dir $rpath_opt$tls_lib_dir
EOS
else
    cat >>Makefile <<'EOX'
LIBDIRLIST      =
EOX
fi

if $test "$tls_include_dir" != "" ; then
    $cat >>Makefile <<EOS
INCDIRLIST      = -I$tls_include_dir
EOS
else
    $cat >>Makefile <<'EOX'
INCDIRLIST      =
EOX

fi
$cat >>Makefile <<'!NO!SUBS!'
CFLAGS		=	-I$(INCLDIR) $(INCDIRLIST) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	../include
OBJS            =       pop.o tls.o imap.o

all:	Makefile libtls.a ../../shlib/libelmme-tls.so
install: all $(INSTLIB)
uninstall:
clean: 
	rm -f $(OBJS) ../../shlib/libelmme-tls.so libtls.a

.PRECIOUS: $(INCLDIR)/elmshared.h ../../hdrs/defs.h 

$(INCLDIR)/elmshared.h: ../../hdrs/defs.h ../../hdrs/patchlevel.h ../../hdrs/elmlib.h $(INCLDIR)/shared.h
	$(CHMOD) u+w $@
	$(TOUCH) $@

../../hdrs/defs.h: ../../config.h ../../hdrs/sysdefs.h
		$(CHMOD) u+w $@
		$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

../../config.sh config.res:
	@echo "You must run 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

elmtls.h: $(INCLDIR)/elmshared.h ../../hdrs/ss_imp.h ../../hdrs/mbx_imp.h
	$(CHMOD) u+w $@
	$(TOUCH) $@

pop.o: elmtls.h
tls.o: elmtls.h ../../hdrs/save_opts.h ../../hdrs/rc_imp.h
imap.o: elmtls.h


libtls.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

../../shlib/libelmme-tls.so: $(OBJS)
	$(CC) $(CCFLAGS) $(LIBDIRLIST) $(SONAME) -o $@ $(OBJS) -lssl -lcrypto 

$(INSTLIB): ../../shlib/libelmme-tls.so
	-$(MV) $@ $@.old
	-$(RM) $@.old
	$(CP) ../../shlib/libelmme-tls.so $@
	$(CHMOD) ugo=r $@

!NO!SUBS!
