static char rcsid[] = "@(#)$Id: striparens.c,v 1.4 2001/06/03 12:19:22 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/* 
 * strip_parens() - Delete all (parenthesized) information from a string.
 * get_parens() - Extract all (parenthesized) information from a string.
 *
 * These routines handle RFC-822 comments.  Nested parens are understood.
 * get_parens() does not include the parens in the return result.  Both
 * routines are non-destructive.  They return a pointer to static data
 * that will be overwritten on the next call to either routine.
 */

#include "headers.h"

DEBUG_VAR(Debug,__FILE__,"addr");

static char paren_buffer[VERY_LONG_STRING];

char *strip_parens(src)
     CONST char *src;
{
    int len;
    char *dest = paren_buffer;
    CONST char *src0 = src;

    while (*src != '\0') {
	len = rfc822_toklen(src);		
	if (*src != '(') {	/*)*/
	    if ((dest-paren_buffer) + len < sizeof paren_buffer -1) {
		strncpy(dest, src, len);
		dest += len;
	    } else {
		DPRINT(Debug,1,(&Debug,
				"strip_parens: --- too long string (max=%d): %.30s...\n",
				sizeof paren_buffer,src0));	
		DPRINT(Debug,1,(&Debug,
				"strip_parens: next token: %.*s\n",len,src));
		break;
	    }
	}
	src += len;
    }
    *dest = '\0';
    return paren_buffer;
}

char *get_parens(src)
     CONST char *src;
{
    int len;
    char *dest = paren_buffer;
    CONST char *src0 = src;
    
    while (*src != '\0') {
	len = rfc822_toklen(src);
	if (len > 2 && *src == '(') {	/*)*/
	    if ((dest-paren_buffer) + len < sizeof paren_buffer) {	
		strncpy(dest, src+1, len-2);
		dest += (len-2);
	    } else {
		DPRINT(Debug,1,(&Debug,
				"get_parens: --- too long string (max=%d): %.30s...\n",
				sizeof paren_buffer,src0));	
		DPRINT(Debug,1,(&Debug,
				"get_parens: next token: %.*s\n",len,src));
		break;
	    }	    
	}
	src += len;
    }
    *dest = '\0';
    return paren_buffer;
}

#ifdef _TEST
main()
{
	char buf[1024];
	while (fputs("\nstr> ", stdout), gets(buf) != NULL) {
		printf("strip_parens() |%s|\n", strip_parens(buf));
		printf("get_parens()   |%s|\n", get_parens(buf));
	}
	putchar('\n');
	exit(0);
}
#endif



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
