static char rcsid[] = "@(#)$Id: hdrencode.c,v 1.5 2001/06/06 18:09:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Partially based on mime_encode.c, which is initially 
 *     written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "headers.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mime");

char hexchars[16] = {
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D',
	'E', 'F',
};

static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}


/* Need also encode special characters is comments and phrases:
   \ " ( ) < > and so on
*/
static char * hdr_tencode P_((char *buffer, const char *cs));
static char * hdr_tencode(buffer,cs)
     char *buffer;
     CONST char *cs;
{
    char * ret = NULL;
    int bad = 0;
    char * p1, *work;
    int clen;
    int l;
    int i = 0;

    if (!cs || 0 != strpbrk(cs," \t\r\n()\""))
	cs = "UNKNOWN-8BIT";
    clen = strlen(cs);

    for (p1 = buffer; *p1; p1++) {
	if ((*p1 < '0' || *p1 > '9') &&
	    (*p1 < 'a' || *p1 > 'z') &&
	    (*p1 < 'A' || *p1 > 'Z') &&
	    '-' != *p1 && ' ' != *p1)
	    bad++;
    }
    l = (p1 - buffer) + 3 * bad;
    work = safe_malloc(l+1);

    for (p1 = buffer; *p1 && i < l; p1++) {
	if (' ' == *p1) {
	    work[i++] = '_';
	} else if ((*p1 < '0' || *p1 > '9') &&
		   (*p1 < 'a' || *p1 > 'z') &&
		   (*p1 < 'A' || *p1 > 'Z') &&
		   '-' != *p1) {
	    unsigned char val = *p1;

	    work[i++] = '=';
	    work[i++] = hexchars[val / 16];
	    work[i++] = hexchars[val % 16];	    
	} else
	    work[i++] = *p1;

	/* If too long encoded word -- reset */
	if (i > 70 - clen) {
	    work[i] = '\0';

	    if (ret)
		ret = strmcat(ret," ");

	    ret = strmcat(ret,"=?");
	    ret = strmcat(ret,cs);
	    ret = strmcat(ret,"?Q?");
	    ret = strmcat(ret,work);
	    ret = strmcat(ret,"?=");
	    i = 0;   /* RESET */
	}
    }

    if (i > 0) {
	work[i] = '\0';

	if (ret)
	    ret = strmcat(ret," ");
	
	ret = strmcat(ret,"=?");
	ret = strmcat(ret,cs);
	ret = strmcat(ret,"?Q?");
	ret = strmcat(ret,work);
	ret = strmcat(ret,"?=");
    }

    free(work);
    return ret;
}

static char * hdr_encode P_((const struct string *buffer));
static char * hdr_encode(buffer)
     CONST struct string *buffer;
{
    char * tmp = us2s(stream_from_string(buffer,0,NULL));
    char * ret = hdr_tencode(tmp,
			     buffer->string_type->MIME_name ? 
			     buffer->string_type->MIME_name :
			     "UNKNOWN-8BIT");

    free(tmp);
    return ret;
}

static char * hdr_comment_quote P_((char *str));
static char * hdr_comment_quote(str)
     char *str;
{
    char * ret;
    int bad = 0;
    char * p1;
    int l;
    int i = 0;

    for (p1 = str; *p1; p1++)
	if ('\\' == *p1 ||
	    '('  == *p1 ||
	    ')'  == *p1)
	    bad++;
    l = (p1 - str) + bad;

    ret = safe_malloc(l+1);
  
    for (p1 = str; *p1 && i < l; p1++) {
	if ('\\' == *p1 ||
	    '('  == *p1 ||
	    ')'  == *p1)
	    ret[i++] = '\\';
	ret[i++] = *p1;
    }
    ret[i] = '\0';

    return ret;
}

static char * hdr_phrase P_((const struct string *buffer,
			     charset_t defcharset, int enmime));
static char * hdr_phrase(buffer,defcharset,enmime)
     CONST struct string *buffer;
     charset_t defcharset; 
     int enmime;
{
    char * ret = NULL;
    struct string *temp;
    char * tmp;
    int bad = 0;
    int hi = 0;
    char * p1;

    if (!enmime) 
	 temp = convert_string(defcharset,buffer,1);
    else 
	temp = ascify_string(buffer);
    tmp = us2s(stream_from_string(temp,0,NULL));

    for (p1 = tmp; *p1; p1++) {
	if ((*p1 < '0' || *p1 > '9') &&
	    (*p1 < 'a' || *p1 > 'z') &&
	    (*p1 < 'A' || *p1 > 'Z') &&
	    '-' != *p1 && ' ' != *p1)
	    bad++;
	if (*p1 & 128)
	    hi++;
    }
	
    if (!bad && ( !enmime || 
		  (temp->string_type->MIME_name && 
		   0 == istrcmp(temp->string_type->MIME_name,"US-ASCII")) ||
		  charset_ok_p(temp->string_type)))
	ret = strmcat(ret,tmp);
    else if (!enmime || 
	     (!hi && ( (temp->string_type->MIME_name &&
			0 == istrcmp(temp->string_type->MIME_name,
				     "US-ASCII")) ||
		       charset_ok_p(temp->string_type)))) {
	int l = (p1-tmp) + bad + 2;
	int i = 0;
	char * work = safe_malloc(l+1);

	work[i++] = '"';
	for (p1 = tmp; *p1 && i < l-1; p1++) {
	    if ('\\' == *p1 || '"' == *p1)
		work[i++] = '\\';
	    work[i++] = *p1;
	}
	work[i++] = '"';
	work[i] = '\0';
	ret = strmcat(ret,work);
	free(work);
    } else {
	char * work = hdr_tencode(tmp,
				  temp->string_type->MIME_name ?
				  temp->string_type->MIME_name :
				  "UNKNOWN-8BIT");
	ret = strmcat(ret,work);
	free(work);
    }
		 
    free(tmp);
    free_string(&temp);
    return ret;
}

static char * hdr_comment P_((const struct string *buffer,
		      charset_t defcharset, int enmime));
static char * hdr_comment(buffer,defcharset,enmime)
     CONST struct string *buffer;
     charset_t defcharset; 
     int enmime;
{
    char * ret;

    if (!enmime) {
	struct string *temp = convert_string(defcharset,buffer,1);
	char *tmp = us2s(stream_from_string(temp,0,NULL));

	ret = hdr_comment_quote(tmp);

	free_string(&temp);
	free(tmp);
    } else {
	char *A, *B;
	struct string *temp = ascify_string(buffer);
	ret = NULL;
	
	if (temp->string_type->MIME_name &&
	    0 == istrcmp(temp->string_type->MIME_name,"US-ASCII")) {
	    char *tmp = us2s(stream_from_string(temp,0,NULL));

	    if (NULL != (A = strstr(tmp,"=?")) &&
		NULL != (B = strstr(tmp,"?=")) &&
		B > A) {
		/* oops */
	    } else
		ret = hdr_comment_quote(tmp);
	    free(tmp);
	}

	if (!ret) 
	    ret = hdr_encode(temp);
	
	free_string(&temp);
    }
    return ret;
}

static char * hdr_text P_((const struct string *buffer,
		      charset_t defcharset, int enmime));
static char * hdr_text(buffer,defcharset,enmime)
     CONST struct string *buffer;
     charset_t defcharset; 
     int enmime;
{
    char * ret;
    if (!enmime) {
	struct string *temp = convert_string(defcharset,buffer,1);
	ret = us2s(stream_from_string(temp,0,NULL));
	free_string(&temp);
    } else {
	char *A, *B;
	struct string *temp = ascify_string(buffer);
	ret = NULL;

	if (temp->string_type->MIME_name &&
	    0 == istrcmp(temp->string_type->MIME_name,"US-ASCII")) {
	    ret = us2s(stream_from_string(temp,0,NULL));

	    if (NULL != (A = strstr(ret,"=?")) &&
		NULL != (B = strstr(ret,"?=")) &&
		B > A) {
		free(ret);
		ret = NULL;
	    }
	}

	if (!ret) 
	    ret = hdr_encode(temp);
	
	free_string(&temp);
    }
    return ret;
}

/* class is one of HDR_PHRASE, HDR_COMMENT, HDR_TEXT */
char * string_to_hdr(class,buffer,defcharset,enmime)
     int class;
     CONST struct string *buffer;
     charset_t defcharset; 
     int enmime;
{
    char * ret = NULL;

    switch(class) {
    case HDR_PHRASE:
	ret = hdr_phrase(buffer,defcharset,enmime);
	break;
    case HDR_COMMENT:
	ret = hdr_comment(buffer,defcharset,enmime);
	break;
    case HDR_TEXT:
	ret = hdr_text(buffer,defcharset,enmime);
	break;
    }

    DPRINT(Debug,30,(&Debug, 
		     "string_to_hdr=%s  (class=%d, buffer=%p, defcharset=%p '%s', enmime=%d)\n",
		     ret,
		     class,buffer,
		     defcharset,
		     defcharset->MIME_name ? defcharset->MIME_name : "<none>",
		     enmime));    

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
