case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

case "$d_strstr" in
define)	strsrc= strobj= ;;
*)	strsrc="strstr.c"
	strobj="strstr.o"
	;;
esac

case "$d_strftime" in
define)	ftimesrc= ftimeobj= ;;
*)	ftimesrc="strftime.c"
	ftimeobj="strftime.o"
	;;
esac

case "$d_msgcat" in
define) msgcatsrc= msgcatobj= ;;
*)      msgcatsrc=msgcat.c
        msgcatobj=msgcat.o
	;;
esac

case "$d_dlopen_libs" in
define)  sharedsrc=shared.c
	 sharedobj=shared.o
	 ;;
*)	 sharedsrc=
	 sharedobj=
	;;
esac

echo "Extracting lib/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 1.56 2001/06/14 18:25:42 hurtta Exp $
#
#  Makefile for the ELM mail program.
#
#	Copyright (c) 1986,1987 Dave Taylor
#	Copyright (c) 1988-1992 USENET Community Trust
#
#
#
# Variables
#	Variables established by Configure
AR		=	ar
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CP		=	$cp
CHMOD		=	$chmod
LINT		=	$lint
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
MV		=	$mv
TOUCH		=	$touch
TAGS		=	ctags

STRSRC		=	$strsrc
STROBJ		=	$strobj

FTIMESRC	=	$ftimesrc
FTIMEOBJ	=	$ftimeobj

MSGCATSRC	=	$msgcatsrc
MSGCATOBJ	=	$msgcatobj

SHAREDSRC	=	$sharedsrc
SHAREDOBJ	=	$sharedobj

!GROK!THIS!

case "$ccflags" in
	*-DDEBUG*)
cat >>Makefile <<SUBSTITUTE
DEBUGSRC = debug.c
DEBUGOBJ = debug.o
SUBSTITUTE
	;;
	*)
cat >>Makefile <<SUBSTITUTE
DEBUGSRC = 
DEBUGOBJ = 
SUBSTITUTE
	;;
esac

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<SUBSTITUTE
SHLIST          = ../shlib/libelmme-base.so
INSTLIB		= $shlib/libelmme-base.so$d_shared_rev
SONAME          = ${soname_opt}$shlib/libelmme-base.so$d_shared_rev
SHLIB		= $shlib
SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =
INSTLIB         =
SONAME		=
SHLIB		= 
!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'

#	Other general variables
CFLAGS		=	-I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) 
INCLDIR		=	../hdrs
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

# 	Lists
LIB_SRC		=	add_site.c	\
			atonum.c	\
			mk_aliases.c	\
			aliasdb.c	\
			mk_lockname.c	\
			can_access.c	\
			can_open.c	\
			chloc.c		\
			charset.c       \
			charset_input.c \
			cs_binary.c	\
			cs_fallback.c   \
			cs_utf.c        \
			date_util.c	\
			$(DEBUGSRC)	\
			dispaddr.c	\
			dynarray.c	\
			errno.c		\
			expand.c	\
			expires.c	\
			forwarded.c     \
			file_util.c     \
			gcos_name.c	\
			getaddr.c	\
			getaddr.c	\
			getaddrfrm.c	\
			getarpdate.c	\
			getfullnam.c	\
			getword.c	\
			get_tz.c	\
			hdrdecode.c	\
			hdrencode.c	\
			header_cmp.c	\
			headers.c	\
			in_list.c	\
			in_string.c	\
			imap.c		\
			iso2022.c 	\
			istrcmp.c	\
			ldstate.c	\
			len_next.c	\
			localmbx.c 	\
			mail_gets.c	\
			mbox.c		\
			move_left.c	\
			$(MSGCATSRC)	\
			ndbz.c		\
			okay_addr.c	\
			opt_utils.c	\
			output.c        \
			panic.c		\
			parsarpdat.c	\
			pmalloc.c	\
			posixsig.c	\
			pop.c		\
			putenv.c	\
			realfrom.c	\
			remote_mbx.c	\
			qstrings.c	\
			rc_handle.c	\
			read_rc.c       \
			remfirstwd.c	\
			reverse.c	\
			rfc822tlen.c	\
			safemalloc.c	\
			savefolder.c	\
			$(SHAREDSRC)	\
			sb_file.c       \
			sb_mem.c        \
			schedule.c	\
			service_list.c	\
			shiftlower.c	\
			streamsched.c	\
			strfcpy.c	\
			strincmp.c	\
			string.c	\
			stringbuffer.c	\
			striparens.c	\
			$(STRSRC)	\
			$(FTIMESRC)	\
			strmcpy.c	\
			strtokq.c	\
			terminal.c	\
			unicode.c	\
			unidata.c	\
			validname.c	\
			safeopen.c

LIB_OBJ		=	add_site.o	\
			atonum.o	\
			mk_aliases.o	\
			aliasdb.o	\
			mk_lockname.o	\
			can_access.o	\
			can_open.o	\
			chloc.o		\
			charset.o       \
			charset_input.o \
			cs_binary.o	\
			cs_fallback.o	\
			cs_utf.o	\
			date_util.o	\
			$(DEBUGOBJ)	\
			dispaddr.o	\
			dynarray.o	\
			errno.o		\
			expand.o	\
			expires.o	\
			forwarded.o     \
			file_util.o     \
			gcos_name.o	\
			get_tz.o	\
			hdrdecode.o	\
			hdrencode.o	\
			headers.o	\
			getaddr.o	\
			getaddrfrm.o	\
			getarpdate.o	\
			getfullnam.o	\
			getword.o	\
			header_cmp.o	\
			in_list.o	\
			in_string.o	\
			iso2022.o 	\
			imap.o		\
			istrcmp.o	\
			ldstate.o	\
			len_next.o	\
			localmbx.o	\
			mail_gets.o	\
			mbox.o		\
			move_left.o	\
			$(MSGCATOBJ)	\
			ndbz.o		\
			okay_addr.o	\
			opt_utils.o	\
			output.o	\
			panic.o		\
			parsarpdat.o	\
			pmalloc.o	\
			posixsig.o	\
			pop.o		\
			putenv.o	\
			qstrings.o	\
			rc_handle.o	\
			read_rc.o	\
			realfrom.o	\
			remote_mbx.o	\
			remfirstwd.o	\
			reverse.o	\
			rfc822tlen.o	\
			safemalloc.o	\
			savefolder.o	\
			$(SHAREDOBJ)	\
			sb_file.o       \
			sb_mem.o        \
			schedule.o	\
			service_list.o	\
			shiftlower.o	\
			streamsched.o	\
			strfcpy.o	\
			strincmp.o	\
			string.o	\
			stringbuffer.o	\
			striparens.o	\
			$(STROBJ)	\
			$(FTIMEOBJ)	\
			strmcpy.o	\
			strtokq.o	\
			terminal.o	\
			unicode.o	\
			unidata.o	\
			validname.o	\
			safeopen.o

all:			Makefile libutil.a $(SHLIST)

install:		Makefile libutil.a $(INSTLIB)

uninstall:		libutil.a

libutil.a:		$(LIB_OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		
		$(LINT) $(LINTFLAGS) $(LIB_SRC) > LINT.OUT

tags:
		$(TAGS) $(LIB_SRC)

clean:		
		$(RM) $(LIB_OBJ) libutil.a

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h $(INCLDIR)/headers.h

$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elm.h:	$(INCLDIR)/elm_curses.h $(INCLDIR)/defs.h $(INCLDIR)/melib.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/elm_curses.h $(INCLDIR)/defs.h $(INCLDIR)/elmlib.h $(INCLDIR)/me.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
add_site.o:	$(INCLDIR)/headers.h
atonum.o:	$(INCLDIR)/headers.h
dynarray.o:	$(INCLDIR)/headers.h
mk_aliases.o:	$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h $(INCLDIR)/s_newalias.h
aliasdb.o:	$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h
mk_lockname.o:	$(INCLDIR)/headers.h
can_access.o:	$(INCLDIR)/headers.h
can_open.o:	$(INCLDIR)/headers.h
chloc.o:	$(INCLDIR)/headers.h
charset.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
charset_input.o: $(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_binary.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_fallback.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_utf.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
date_util.o:	$(INCLDIR)/headers.h
debug.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/patchlevel.h
dispaddr.o:     $(INCLDIR)/headers.h
errno.o:	$(INCLDIR)/headers.h
expand.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elmrc.h 
expires.o:	$(INCLDIR)/headers.h
forwarded.o:	$(INCLDIR)/headers.h
file_util.o:    $(INCLDIR)/headers.h $(INCLDIR)/s_elm.h  $(INCLDIR)/s_me.h 
gcos_name.o:	$(INCLDIR)/headers.h
get_tz.o:	$(INCLDIR)/headers.h
getaddr.o:	$(INCLDIR)/headers.h
getaddrfrm.o:	$(INCLDIR)/headers.h
getarpdate.o:	$(INCLDIR)/headers.h
getfullnam.o:	$(INCLDIR)/headers.h
getword.o:	$(INCLDIR)/headers.h
hdrdecode.o:  	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h  
hdrencode.o:  	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h  
header_cmp.o:	$(INCLDIR)/headers.h
headers.o: 	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/hdr_imp.h
in_list.o:	$(INCLDIR)/headers.h
in_string.o:	$(INCLDIR)/headers.h
iso2022.o: 	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
imap.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/ss_imp.h
istrcmp.o:	$(INCLDIR)/headers.h
ldstate.o:	$(INCLDIR)/headers.h
len_next.o:	$(INCLDIR)/headers.h
localmbx.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h
mail_gets.o:	$(INCLDIR)/headers.h
mbox.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/shared_imp.h
mgets.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h
move_left.o:	$(INCLDIR)/headers.h
msgcat.o:	$(INCLDIR)/msgcat.h $(INCLDIR)/headers.h
ndbz.o:		$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h
okay_addr.o:	$(INCLDIR)/headers.h
opt_utils.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_error.h
output.o:	$(INCLDIR)/headers.h
panic.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h
parsarpdat.o:	$(INCLDIR)/headers.h
pmalloc.o:	$(INCLDIR)/defs.h $(INCLDIR)/s_elm.h
pop.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/ss_imp.h
posixsig.o:	$(INCLDIR)/headers.h
putenv.o:	$(INCLDIR)/headers.h
rc_handle.o:	$(INCLDIR)/headers.h $(INCLDIR)/save_opts.h $(INCLDIR)/s_elm.h $(INCLDIR)/rc_imp.h $(INCLDIR)/shared_imp.h
read_rc.o:      $(INCLDIR)/headers.h $(INCLDIR)/save_opts.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/rc_imp.h 
realfrom.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
remote_mbx.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/shared_imp.h $(INCLDIR)/ss_imp.h
qstrings.o:	$(INCLDIR)/headers.h
remfirstwd.o:	$(INCLDIR)/headers.h
reverse.o:	$(INCLDIR)/headers.h
rfc822tlen.o:	$(INCLDIR)/headers.h
safemalloc.o:	$(INCLDIR)/headers.h
savefolder.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h
shared.o:	$(INCLDIR)/headers.h ../shared_libs/include/shared.h $(INCLDIR)/shared_imp.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/save_opts.h $(INCLDIR)/rc_imp.h
sb_file.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/sb_imp.h
sb_mem.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/sb_imp.h
schedule.o:	$(INCLDIR)/headers.h
service_list.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/shared_imp.h $(INCLDIR)/ss_imp.h
shiftlower.o:	$(INCLDIR)/headers.h
streamsched.o:	$(INCLDIR)/headers.h $(INCLDIR)/ss_imp.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/shared_imp.h
strfcpy.o:      $(INCLDIR)/headers.h
string.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
stringbuffer.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/sb_imp.h
strmcpy.o:      $(INCLDIR)/headers.h
strincmp.o:	$(INCLDIR)/headers.h
striparens.o:	$(INCLDIR)/headers.h
strstr.o:	$(INCLDIR)/headers.h
strtokq.o:	$(INCLDIR)/headers.h
terminal.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
unicode.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h $(INCLDIR)/unidata.h
unidata.0:      $(INCLDIR)/headers.h $(INCLDIR)/s_me.h $(INCLDIR)/unidata.h
validname.o:	$(INCLDIR)/headers.h

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
../shlib/libelmme-base.so: $(LIB_OBJ)
		$(CC) $(CCFLAGS) $(SONAME) -o $@ $(LIB_OBJ)

$(SHLIB):
		mkdir $(SHLIB)

$(INSTLIB):	$(SHLIB) ../shlib/libelmme-base.so
		-$(MV) $@ $@.old
		-$(RM) $@.old
		$(CP) ../shlib/libelmme-base.so $@
		$(CHMOD) ugo=r $@
!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi



