/* $Id: me.h,v 1.47 2001/06/06 18:08:55 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.47 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "melib.h"

#define PUBLIC 
/* args.c */

extern char * parse_arguments P_((int argc, char *argv[], char ***to_whom));
extern char * wanted_charset;
extern int wanted_switchmode;

/* init.c */
void initialize P_((char *name));

/* file_util.c */

int check_mailfile_size P_((struct folder_info *mfile));
int append P_((FILE *fd, char *filename, char *prefix_str));

/* find_alias.c */

extern int find_alias P_((char *word, int alias_type));

/* elm.c */

extern void motion P_((int));
extern void check_range P_((void));
extern void forget_passphrase P_((void) );

/* help.c */

extern int display_helpfile P_((int section));
extern int help P_((int pager_help));

/* in_utils.c */

extern int want_to P_((char *question, int dflt, int where, 
		       int clear_and_center));
extern int read_number      P_((int, char *));

#define OE_APPEND_CURRENT   (1<<0)
#define OE_PASSWD           (1<<1)
#define OE_REDRAW_MARK      (1<<2)
#define OE_ADD_COMMA        (1<<3)
#define OE_ALT_SOLIDUS      (1<<4)
#define OE_ALLOW_MIMEENC    (1<<5)
#define OE_EDITOR_ESCAPE    (1<<6)
#define OE_TABACTION        (1<<7)

extern int optionally_enter2 P_((struct string **buffer, 
				 int x, int y, int flags, 
				 const char * format, const char *msg, ...));
extern int optionally_enter P_((char *, int, int, int, int));
extern int pattern_enter    P_((char *, char *, int, int, char *, int, int));
extern int GetPrompt        P_((void));


#ifdef ANSI_C
struct enter_info;
#endif

enum enter_mode { em_redraw, em_enter, em_prev, em_next, em_wrap,
		  em_redraw_initial, em_editor_escape, em_tabaction,
		  em_bs_prev, em_left, em_right};
typedef struct string **give_buffer_r P_((struct enter_info *I,
					  enum enter_mode em));


struct enter_info {
    int counter;
    struct string **pvector;
    int px;
    int py;
    give_buffer_r *give_buffer;
    int flags;
    int ch_count;
    struct builtin_edit  *builtin;
    folder_dir           dir_p;
};

extern int enter_helper P_((struct enter_info *info));

/* out_utils.c */

extern void sleep_message P_((void));
extern int  error P_((CONST char *s));
extern void out_util_setup P_((void));
extern void show_last_error P_((void));
extern void clear_error P_((void));
extern void set_error P_((char *s));
extern void lower_prompt P_((char *s));
extern void prompt P_((char *s));
extern void set_central_message P_((const char *format, 
				    const char *line, ...));
extern void display_central_message P_((void));
extern void clear_central_message P_((void));
extern void print_center P_((int line, struct string * buffer));
extern void print_format_center P_((int lineY,const char *format, 
				    const char *line, ...));

/* Used by newmbox.c */
extern int need_refresh_low_line P_((void));


/* pattern.c */

extern int from_matches P_((int message_number, char *pat));
extern int to_matches P_((int message_number, char *pat));
extern int cc_matches P_((int message_number, char *pat));
extern int subject_matches P_((int message_number, char *pat));
extern int match_in_message P_((char *pat));
extern int pattern_match P_((void));
extern int meta_match P_((int function));
extern int prev_message P_((int iindex, int skipdel));


/* id_phrase.c */

struct id_phrase {
    char           * id;
    struct string  * text;
};

extern void zero_id_phrase P_((struct id_phrase *P));
extern void free_id_phrase P_((struct id_phrase *P));
extern int check_8bit_id_phrase P_((struct id_phrase *P));
extern int check_8bit_string P_((struct string *P));
extern void write_id_phrase_header P_((FILE *f, char *hdr_name,
				       struct id_phrase * P,
				       int top_encoding,
				       int enmime,
				       charset_t charset));
extern void write_string_header P_((FILE *f,char *hdr_name,
				    struct string * P,
				    int top_encoding,
				    int enmime,
				    charset_t charset));


/* addr_util.c */

extern char * kludge_addr P_((char **addr));

struct textual {
  char *textual;
  int pos;
  int len;
};

struct expanded_address {
  struct addr_item *addrs;
  int addrs_len;

  struct textual *surface;
  int surface_len;
};

struct mailing_headers {
    struct string *subject;
    struct expanded_address from;
    struct id_phrase in_reply_to;

    char *expires;
    char *action; 
    char *priority;
    
    struct expanded_address reply_to; 
    struct expanded_address to;
    struct expanded_address cc;
 
    char *user_defined_header;
    struct expanded_address bcc;
    char *precedence;
    char *expires_days;

    
};

extern int build_address_l P_((struct expanded_address *expanded));
extern int argv_to_expanded P_((struct expanded_address *result,
				char *argv[]));
extern void addr_to_expanded P_((struct expanded_address *result,
				 struct addr_item *addrs));
extern void expanded_to_edit_buffer P_((char * buffer, int size,  
					struct expanded_address expanded));
extern void update_expanded_from_edit_buffer P_((struct expanded_address 
						 *expanded,
						 CONST char *buffer));
extern void zero_expanded_address P_((struct expanded_address *x));
extern void free_expanded_address P_((struct expanded_address *x));
extern void copy_expanded_address P_((struct expanded_address *result,
				      struct expanded_address source));

extern void write_addr_header P_((FILE *f, char *hdr_name, 
				  struct addr_item * addr,
				  int top_encoding, int enmime,
				  charset_t charset));
extern void write_text_header P_((FILE *f, char *hdr_name, 
				  char * text,
				  int top_encoding));
extern int check_8bit_addr P_((struct addr_item * addr));

extern char **argv_from_headers   P_((struct mailing_headers * headers));
extern void dump_expanded_address P_((int debuglevel, CONST char *text,
				      struct expanded_address expanded));

extern int aliases_to_expanded P_((struct expanded_address *x));

extern int make_from_addr P_((struct expanded_address *expanded));

/* alias.c */

extern void alias P_((void));
extern void main_state P_((void));
extern void open_alias_files P_((int are_in_aliases));
extern int delete_from_alias_text P_((char **name, int num_to_delete));
extern void install_aliases P_((void));

/* a_edit.c */

int edit_aliases_text P_((void));

/* a_sort.c */

void sort_aliases P_((int entries, int visible, int are_in_aliases));


/* a_screen.c */

extern struct string *build_alias_line P_((struct alias_rec *entry,
					   int message_number, int highlight));

extern void alias_screen P_((int modified));
extern void alias_title P_((int modified));
extern void show_alias_menu P_((void));


/* a_quit.c */

extern void exit_alias P_((void));
extern int change_file P_((void));
extern int delete_aliases P_((int newaliases, int prompt));
extern int resync P_((void));

/* exitprog.c */

extern int exit_prog P_((void));

/* file.c */

extern int expand_filename P_((char *, int, int));
extern void init_helpmsg P_(( char *, char *, int, int ));
extern int save P_((int *redraw, int silently, int delete, int text_only));

/* fileutil.c */

extern FILE *open_end_update P_((char *name));

/* src/remailer.c */

#ifdef USE_REMAILER
extern int remailer_copy_message_across P_((FILE *, FILE *, int, mime_send_t *));
extern int remailer_proc P_((void));
#endif 

#ifdef USE_PGP
/* pgp.c */
extern int pgp_menu			P_((char *filename,
					    struct mailing_headers *headers));
extern int pgp_extract_public_key	P_((void));
extern int pgp_mail_public_key          P_((void));
#endif

/* read_rc.c */

extern void directory_check     P_((void));



extern int metapager		P_((FILE *, struct header_rec *, int));
extern int builtinplusplus	P_((struct stringbuffer * bout));

/* mime.c */

extern int have_metamail         P_((void));
extern void clear_mime_send_info P_((mime_send_t *mime_info));
extern void free_mime_send_info P_((mime_send_t *mime_info));
extern void add_paramater_1 P_((char **ptr, char *name, 
				char *value, int quoted));

/* Returns 1 if OK */
extern int convert_text P_((FILE *source, FILE *dest, 
			    mime_send_t *mime_info,
			    charset_t from_charset,
			    charset_t to_charset,
			    int do_pgp,
			    mime_t *attachments));
extern void add_parameter_1 P_((char **ptr, char *name, char *value,  
				int quoted));


/* strings.c */


extern char **argv_from_to      P_((char *to));
extern void split_word P_((
			   char *buffer, char *first, char *rest));
extern void Centerline P_((int line,
			   char *string));

extern char *argv_zero P_((const char *string));


/* string2.c */

extern void remove_possible_trailing_spaces P_((char *string));
extern int occurances_of P_((char ch, char *string));

/* fileio.c */
extern int copy_message P_((struct folder_info *, struct header_rec *,
			     char *, FILE *, int));
extern int copy_message_d P_((struct folder_info *infolder,
			      struct header_rec *current_header,
			      char * prefix,
			      struct folder_browser *dir, 
			      WRITE_STATE dest, int cm_options));
extern int copy_message_2 P_((FILE *infile, 
			      struct header_rec *current_header,
			      char *prefix, 
			      out_state_t *dest_file, 
			      int cm_options,
			      int env_flags));

extern int copy_body P_((FILE *infile, 
			 struct header_rec *current_header,
			 char *prefix, 
			 out_state_t *dest_file, 
			 int cm_options));

extern int copy_plain P_((char *,out_state_t *,int, struct header_rec *, 
			   FILE *));
extern int copy_mime P_((char *,out_state_t *,int, struct header_rec *, 
			  FILE *));

typedef int copy_decoder P_((char *,out_state_t *,int, struct header_rec *,
			     FILE *));
typedef copy_decoder *copy_decoder_t;
extern copy_decoder_t select_copy_decoder P_((struct header_rec *));

/* newmbox.c */

extern  struct folder_info * current_folder;

extern void header_zero P_((struct header_rec *));
extern void header_clear P_((struct header_rec *));
extern int open_folder_lock P_((int direction,struct folder_info *folder));
extern int reopen_folder_lock_sessionlock P_((struct folder_info *folder));
extern int is_pre_mime_content_type P_((mime_t *,char *));
extern int same_file P_((char *,char *)); 


extern int newmbox P_((char *new_file, int adds_only));
extern int newmbox_1 P_((struct folder_info *new_folder,
			 int adds_only));


/* file_util.c */

extern long fsize P_((FILE *));
extern long bytes P_((char *));
extern int copy_to_folder P_((FILE * from, struct folder_info *to));
extern int copy1 P_((FILE *from, char *to, int isspool));

/* mailmsg1.c */

extern void zero_mailing_headers P_((struct mailing_headers *hdrs));
extern void free_mailing_headers P_((struct mailing_headers *hdrs));

extern int a_sendmsg P_((int edit_message, int form_letter));
int send_msg_argv P_((char *argv[],
		      char *given_subject,int options, int form));

extern int send_msg_l P_((struct header_rec * current_header,
			  struct addr_item *given_to, 
			  struct addr_item *given_cc,
			  char *given_subject,
			  int   options, int form_letter));
extern void display_to P_((struct expanded_address address));
extern int get_to P_((struct expanded_address *to));

/* mailmsg2.c */

#ifdef ANSI_C
struct run_state;           /* Needed for prototype */
#endif


extern int mail P_((struct header_rec *, int, int, struct mailing_headers *));
extern int mail_form P_((struct header_rec *, struct addr_item *, char *));
extern int mail_backend P_((FILE *real_reply,
			    struct mailing_headers * headers,
			    int dsn,  end_handler *func, 
			    int encoding_top, char *title,
			    int resend));
extern int check_8bit_str P_((char *str));    

/* froms.c */

extern int mail_filled_in_form P_((struct header_rec * current_header,
				   struct addr_item *address,
				   char *subject));


/* aliaslib.c */

struct addr_item *get_alias_address_l P_((
					  char *name, /* name to expand as an alias */
					  int mailing, /* TRUE to fully expand group names & recursive aliases */
					  int *too_longp /* error code if expansion overflows buffer             */
					  ));


/* syscall.c */

extern int system_call    P_((char *, VOLATILE int));
#ifdef ALLOW_SUBSHELL
extern int subshell       P_((void));
#endif
extern int do_pipe        P_((void));
extern int have_printout  P_((void));
extern int print_msg      P_((int pause_on_scroll));
extern int print_text      P_((int pause_on_scroll));

extern int create_folder_state_file P_((void));
extern int remove_folder_state_file P_((void));

/* lib/errno.c */

extern char *error_description P_((int));

/* savecopy.c */

struct copy_file {
    struct string         * copy_file;
    struct folder_browser * dir;
};


extern void zero_copy_file P_((struct copy_file *cf));
extern void clear_copy_file P_((struct copy_file *cf));
extern int name_copy_file P_((struct copy_file *cf));

extern int save_copy P_((struct mailing_headers * headers,
			 struct copy_file *cf,
			 int form,
			 mime_send_t *mime_info,
			 FILE * conv_file));

extern int append_copy_to_file P_((struct mailing_headers * headers,
				   struct folder_browser *cf,
				   int form,
				   mime_send_t *mime_info,
				   FILE * conv_file,
				   WRITE_STATE dest));

extern  FILE * write_header_info P_((char *filename,
				     struct mailing_headers * headers,
				     int   form, int copy,
				     mime_send_t *mime_info));

extern int copy_message_across P_((mime_send_t *mime_info,
				   FILE *dest, int copy,
				   FILE *conv_file));

/* mime.c */

extern int check_for_multipart	P_((FILE *, mime_send_t *));
extern int needs_encoding       P_((FILE *));

/* mime_encode.c */

extern int attach_message P_((mime_t *part, FILE *dest, 
			      mime_send_t *mime_info, 
			      struct mime_send_part * X));
extern void base64_encode	    P_((FILE *, FILE *, int, mime_send_t *));
extern void line_quoted_printable_encode P_((char *input, 
					     FILE *output, int len, 
					     int istext,
					     mime_send_t *mime_info));
extern void quoted_printable_encode  P_((FILE *srcfp, FILE *fpout, int istext,
					 mime_send_t *mime_info));
extern char *mime_generate_boundary	P_((char *, int));
extern void add_parameter		P_((char *,char *,char *,int, int));
extern void add_parameter_t             P_((mime_t *, char *, char *, int));

extern void print_EOLN			P_((FILE *,int));
extern int update_encoding		P_((int *,int));
extern void write_encoded P_((FILE *srcfp, FILE *fpout, int encoding, 
			      int is_text, mime_send_t *mime_info));

extern void mime_write_part_headers P_((FILE *fp,
					mime_send_t *ptr,
					struct mime_send_part * part));
extern void mime_write_top_headers P_((FILE *fp,
				       mime_send_t *ptr));
extern void rfc1522_encode_text         P_((char *,int,CONST char *,int));

/* attach_menu.c */

extern mime_t *attach_menu		P_((mime_t *mt, int rdonly, 
					    charset_t defcharset));
extern int Attach_it                    P_((char *));
extern int Check_attachments            P_((void));

/* returnadd.c */
extern void kludge                      P_((char *buffer, int size));

/* lock.c */

extern int Grab_the_file P_((int flock_fd));
extern int Release_the_file P_((int flock_fd));
extern int unlock P_((int interrupt, struct folder_info *folder));
extern int lock P_((int direction,struct folder_info *folder));
extern int flush_mailfile P_((struct folder_info *folder));


/* utils.c */

extern void emergency_exit P_((int interrupt));
extern void leave P_((int interrupt));
extern void create_new_folders P_((void));
extern void create_new_elmdir P_((void));
extern void rm_temps_exit P_((void));
extern void silently_exit P_((void));
extern void leave_locked P_((int));
extern int get_page P_((int msg_pointer));

/* date.c */

extern void days_ahead P_((int days, char *buffer, int size));
extern char * elm_date_str P_((char *buf, time_t seconds, int size));
extern void make_menu_date P_((struct header_rec *entry));

/* expires.h */

extern void process_expiration_date P_((char *date,
					int  *message_status));


/* reply.c */

extern void get_return_name P_((char *address, char *name,
				int   trans_to_lowercase,
				int size));
extern int forward P_((void));
extern int reply_to_everyone P_((void));
extern int reply P_((void));

/* leavembox.c */

int leave_mbox P_((int resyncing,  int quitting, int prompt,
		   struct folder_info **new_folder));
		
/* mkhdrs.c */

extern void generate_reply_to P_((struct header_rec * current_header,
				  struct mailing_headers *headers));

extern void add_mailheaders P_((FILE *filedesc));

/* options.c */

extern int options P_((void));

/* hdrconfig.c */

extern void edit_headers P_((struct mailing_headers *headers));
extern struct string *hdr_to_expval P_((struct expanded_address addrs));
extern void hdr_to_buffer P_((struct expanded_address addrs, 
			      char **ptr, int *size));
extern int buffer_to_header P_((struct expanded_address *addrs,char *ptr,
				int free_only));

/* remail.c */

extern int remail P_((void));
#ifdef MMDF
extern void do_mmdf_addresses P_((FILE *dest_file,
				  struct mailing_headers * headers));
#endif

/* editmsg.c */

extern int edit_the_message P_((char *filename,
				int  already_has_text,
				struct mailing_headers * headers,
				char *editor));


/* delete.c */

extern void delete_msg   P_((int real_del, int update_screen));
extern void undelete_msg P_((int update_screen));
extern void show_msg_status P_((int msg));
extern void show_msg_tag    P_((int msg));
extern void show_new_status P_((int msg));
extern int DeleteTagged     P_((void));
extern int tag_message P_((int update_screen));
extern void unread_msg P_((int update_screen));

/* encode.c */

extern void getkey P_((int send));
extern void get_key_no_prompt P_((void));
extern void encode P_((char *line));
extern void makekey P_((char *rkey));
extern void setup P_((void));

/* forms.c */

extern int format_form P_((char *filename));
extern int check_form_file P_((char *filename));

/* quit.c */

extern void quit P_((int prompt));

/* save_opts.c */

extern void save_options P_((void));
extern void save_user_options P_((FILE *elminfo_fd, FILE *newelmrc));


/* screen.c */

extern void showscreen P_((void));
extern void update_title P_((void));
extern void show_menu P_((void));
extern void show_current P_((void));
extern int show_headers P_((void));
extern int on_page P_((int message));

/* showmsg.c */

extern int show_msg P_((int number));

/* showmsg_c.c */

extern void put_cmd_name P_((char *command, int will_mangle));
extern void put_border P_((void));
extern void build_bottom P_((void));
extern int process_showmsg_cmd P_((int command));

/* sort.c */

extern void sort_mailbox P_((int entries, int visible));

/* edit.c */

extern void edit_mailbox P_((void));
extern int edit_a_file P_((const char *editfile));

/* limit.c */

extern int compute_visible P_((int message));
extern int next_message    P_((int iindex, int skipdel));
extern int visible_to_index P_((int message));
extern int limit P_((void));

/* calendar.c */

extern void scan_calendar P_((void));

/* browser.c */

extern struct folder_info * folder_browser P_((struct folder_browser *p,
					       struct string **buffer,
					       int *redraw,
					       CONST char *format, 
					       CONST char *msg, ...));


enum word_sel { word_change, word_save, word_copy, word_save_copy, 
		word_read };

extern void gen_browser P_((struct folder_browser *p,
			    struct string **buffer,
			    int *redraw,
			    enum word_sel w,
			    struct string * prev_fold,
			    CONST char *format, 
			    CONST char *msg, ...));

extern int browser_expand P_((struct folder_browser * XXX,
			      struct string **name,
			      struct string ** prev_folder));

extern int file_browser P_((struct folder_browser *p,
			    struct string **buffer,
			    int * redraw, enum word_sel w,
			    const char *format, const char *msg, ...));

/* metapager.c */

extern void PressAnyKeyToContinue P_((void));

/* signals.c */

extern char * Stopped_Text;  /* Initialized by init.c */
extern char * Back_Text;     /* Initialized by init.c */
extern char * Segv_Text;     /* Initialized by init.c */
extern char * Bus_Text;      /* Initialized by init.c */
extern char * Fpe_Text;      /* Initialized by init.c */
extern char * Ill_Text;      /* Initialized by init.c */

extern void init_signals P_((void));
extern void init_signals1 P_((void));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
