/* $Id: elmlib.h,v 1.123 2001/06/17 14:01:14 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.123 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

/* lib/strmcpy.c */

extern char *strmcpy P_((char *, CONST char *));
extern char *strmcat P_((char *, CONST char *));

/* safeopen.c */

extern FILE *safeopen P_((char *));
extern FILE *safeopen_rdwr P_((char *));

/* istrcmp.c */

extern int istrcmp P_((CONST char *, CONST char *));

/* add_site.c */

extern int add_site P_((char *, char *, char *, int));

/* atonum.c */

extern int atonum P_((char *));

/* mk_aliases.c */

extern int get_alias P_((FILE *,int));
extern int get_line P_((FILE *,char *,int, int));
extern void de_escape P_((char *));
extern int add_to_hash_table P_((char *,int32));
extern void add_to_table     P_((FILE *,char *, char *, char *, 
				 char *, char *));
extern int check_alias       P_((char *));
extern int check_address     P_((char *));
extern void put_alias        P_((FILE *));
extern int do_newalias       P_((char *, char *,int, int));

/* aliasdb.c */

/* fetch_alias */
extern char *next_addr_in_list P_((char **));

/* mk_lockname */
     
extern char * mk_lockname P_((char *));

/* can_access.c */
/* I don't understand this routine! access -system call uses
 * real uid / gid anyway!!!!!!!!!!!!!!
 *
 *                                - K E H <hurtta@ozone.FMI.FI>
 */

extern int can_access P_((char *,int));

/* can_open.c */

extern int can_open P_((CONST char *, CONST char *));

/* chloc.c */

/* Is this really needed? This does same than strchr or index, except
 *  that return type is different.
 *
 *                          - K E H <hurtta@ozone.FMI.FI>
 */

/* Argument (second) can't be char because there is both prototype and
 * non-prototype declaration.
 */
extern int chloc  P_((char *,int));
extern int qchloc P_((char *, int));

/* date_util.c */

extern int cvt_dayname_to_daynum     P_((char *,int *));
extern int cvt_monthname_to_monthnum P_((char *,int *));
extern int cvt_yearstr_to_yearnum    P_((char *,int *));
extern int cvt_mmddyy_to_dayofyear   P_((int, int, int, int*));
extern int cvt_timezone_to_offset    P_((char *str,int *, int));
extern int cvt_numtz_to_mins         P_((char *));
extern int cvt_timestr_to_hhmmss     P_((char *, int *, int *, int *));
extern long make_gmttime             P_((int, int, int, int, int, int));

/* dispaddr.c */
#ifdef ANSI_C
struct header_rec;           /* Needed for prototype */
struct string;
#endif

typedef void decode_who P_((int class, char *ptr, int size));
extern int DisplayAddress  P_((struct header_rec *h,struct string **f));

/* dynarray.c */

extern void ** DynamicArray P_((void **p, int record_size, int *max, int n));
extern void DestroyDynamicArray P_((void **p));

/* errno.c */

extern char *error_description P_((int));

/* expand.c */

extern int expand P_((char *, int));
extern int expand_env P_((char *dest, CONST char *src,unsigned destlen));
extern int expand_meta P_((char *dest, CONST char *src,unsigned destlen));
 
/* gcos_name.c */

extern char * gcos_name          P_((char *, char *));

/* get_tz.c */

extern int get_tz_mins   P_((time_t tval));
extern CONST char *get_tz_name P_((struct tm *));

/* getaddr.c */

extern void free_rfc822tokenized   P_((char **res));
/* Removes comments from vector: */
extern void remove_space_tokenized P_((char ** tokenized));
extern char **rfc822_tokenize      P_((CONST char *line));

typedef struct charcode_info * charset_t;

extern int look_special_tokens P_((char **tokenized,
				   CONST char *tok_chars,
				   int start, int *ended,
				   int demime, charset_t set,
				   struct string **comments,
				   char ***scanned));
extern struct string * scanned_to_phrase P_((char **scanned,
					     int demime, charset_t set));


extern struct addr_item {
    char *addr;
    struct string *fullname;
    struct string *comment;
			} 
* break_down_address P_((CONST char *buffer, int demime,
			 charset_t defcharset));

extern void  free_addr_items P_((struct addr_item *list));

/* getaddrfrm.c */

extern void get_address_from P_((char *, char *, int size));

/* getarpdate.c */

extern char * get_arpa_date P_((void));

extern CONST char *arpa_dayname[8];   /* src/date.c uses this          */
extern CONST char *arpa_monname[13];   /* src/date.c and IMAP code uses */

/* getfullnam.c */

extern char * get_full_name P_((char *));

/* getword.c */

extern int get_word P_((CONST char *,int,char *,int));

/* getword.c */

extern char * header_cmp P_((char *, char *, char *));


/* in_list.c */

/* in_list should use quoted -variants (strtokq, ...)
 *                            - K E H <hurtta@ozone.FMI.FI>
 */
extern int in_list   P_((char *, CONST char *));
extern int globmatch P_(( char *, char *));

/* in_string.c */

/* Is that needed? This is almost same as strstr (except return type).
 *                                     - K E H <hurtta@ozone.FMI.FI> 
 */
extern int in_string P_((char *, char *));

/* ldstate.c */

/*
 * Filled in by "load_folder_state_file()".  This allows an external program
 * (e.g. "readmsg") to receive information on the current Elm state.
 */
struct folder_state {
	char *folder_name;	/* full pathname to current folder	*/
	int num_mssgs;		/* number of messages in the folder	*/
	long *idx_list;		/* index of seek offsets for messages	*/
	int num_sel;		/* number of messages selected		*/
	int *sel_list;		/* list of selected message numbers	*/
};

extern int load_folder_state_file P_((struct folder_state *fst));

/* len_next.c */

extern int len_next_part P_((CONST char *));

/* mail_gets.c */

extern int mail_gets P_((char *,int,FILE *));

/* move_left.c */

extern void move_left P_((char *,int));

/* okay_address.c */

extern int addr_is_user P_((char *addr));
extern int okay_address_l P_((const struct addr_item *address, 
			      const struct addr_item *return_address));
/* opt_utils.c */

extern int gethostdomain P_((char *,int));

#ifndef HAS_CUSERID
extern char *cuserid P_((char *));
#ifndef L_cuserid
#define L_cuserid 9
#endif
#endif

#ifndef STRTOK
extern char *strtok  P_((char *, char *));
#endif

#ifndef STRPBRK
extern char *strpbrk     P_((char *, char *));
#endif

#ifndef STRSPN
extern int strspn        P_((char *, char *));
#endif

#ifndef STRCSPN
extern int strcspn       P_((char *, char *));
#endif

#ifndef TEMPNAM
extern char *tempnam     P_((char *, char *));
#endif

#ifndef GETOPT
extern int getopt P_((int,char	**, char *));
#endif

/* parsarpdat.c */

extern int parse_date_time P_((CONST char *str, 
			       char *time_zone, int size_time_zone,
			       time_t *tz_offset, time_t *time_result));

extern int parse_arpa_date P_((char *str,
			       struct header_rec *entry));

/* This perhaps should go away.   - K E H <hurtta@ozone.FMI.FI> */

extern void decode_who_none P_((int class, char *ptr, int size));
extern void parse_arpa_who P_((char *, char *,decode_who, int));

/* posixsig.c */

#ifdef POSIX_SIGNALS
extern SIGHAND_TYPE (*posig_signal  P_((int, 
					SIGHAND_TYPE (*fun)P_((int))
					))
		     )P_((int));
#endif
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
typedef union wait S__;
#else
typedef int        S__;
#endif

extern int my_wait P_((int pid, S__ *statptr)); 
extern int convert_status P_((S__ status,int *exit_code));

/* putenv.c */
#ifndef PUTENV
extern int putenv   P_((char *));
#endif

/* realfrom.c */

int real_from P_((char *buffer, struct header_rec *entry));

/* qstrings.c */

extern char *qstrpbrk   P_((char *, char *));
extern int qstrspn      P_((char *, char *));
extern int qstrcspn     P_((char *, char *));

/* remfirstwd.c */

void remove_first_word     P_((char *));
void remove_header_keyword P_((char *));

/* reverse.c */

extern void reverse P_((char *));

/* safemalloc.c */

extern void dflt_safe_malloc_fail_handler P_((char *proc,unsigned));
extern void (*safe_malloc_fail_handler)   P_((char *proc,unsigned));

extern malloc_t safe_malloc  P_((unsigned));
extern malloc_t safe_realloc P_((malloc_t,unsigned));
extern char *safe_strdup     P_((CONST char *));

#ifdef DEBUG
#define free(x)  safe_free(x)
extern void safe_free P_((malloc_t x));
#endif

/* shiftlower.c */

extern char *shift_lower     P_((CONST char *));

/* strfcpy.c */

extern char *strfcpy P_((char *, CONST char *, int));
extern char *strfcat P_((char *, CONST char *, int));
extern char *strnfcpy P_((char *dest, CONST char *src, int len, int size,
                          int *produced));


/* strincmp.c */

/* Is this needed? This is same than strncasecmp 
 *        - K E H <hurtta@ozone.FMI.FI>
 */

extern int strincmp P_((CONST char *, CONST char *, int));

/* striparens.c */

extern char *strip_parens P_((CONST char *s));
extern char *get_parens   P_((CONST char *s));

/* strstr.c */

/* Why there is both in_string and strstr????
 *     - K E H <hurtta@ozone.FMI.FI>
 */

#ifndef STRSTR
extern char *strstr P_((char *,char *)); 
#endif

/* strtokq.c */

/* Why there is ' -- it is not quote character in mail.
 *    - K E H <hurtta@ozone.FMI.FI>
 */
extern char *strtokq P_((char *, char *,int));

/* validname.c */

/* This is quite bogus   - K E H <hurtta@ozone.FMI.FI> */
int valid_name       P_((char *));

/* lib/cs_utf.c */

extern CONST charset_t IMAP_ENCODING;

/* lib/charset.c */

extern charset_t display_charset;	 /* current terminal charset */
extern charset_t system_charset;	 /* character set used by ctype()
					    routines
					  */
extern CONST charset_t RAW_BUFFER;            /* 'Raw' byte buffer !!!!!!  */

extern CONST charset_t ASCII_SET;

#define SET_valid   0x0001 /* make possible to 'clear' previous defination */
#define SET_mark    0x0002 /* mark used by charset_compatfunc and          */
#define SET_printed 0x0004
#define SET_nodata  0x0008
#define SET_havealias  0x0010

struct charcode_info {
    struct  charset_type    *   charset_type;
    struct  map_info        *   map_info;
    uint16                      flags;
    char                    *   MIME_name;    
    struct charcode_info    *   subtype;
    struct setlist          *   iso2022_info;
};

#define CS_printable         1     /* Have printable information */
#define CS_mapping           2     /* Have some mapping information */
extern int charset_properties P_((charset_t ptr));

extern charset_t MIME_name_to_charset P_((char *name,int create));
extern int charset_compatfunc P_((char **value, int enter));
extern int charset_iso646func P_((char **value, int enter));
extern int charset_ok_p P_((charset_t ptr));
extern int load_charset_map_info P_((charset_t *buffer, CONST char *data));
extern int get_charset_map_info P_((char *buffer, CONST char *data,
				    int size));
extern int charset_superset_of P_((charset_t charset, charset_t subset));

extern struct locale_map_item {
    char       *match;
    charset_t  charset;
} * load_locale_map P_((const char *filename, int *errors));
extern void dump_locale_map P_((FILE *f, struct locale_map_item *map));

/* helper routines on charset.c */
extern char * mime_parse_content_opts P_((char *str));
extern int mime_get_param             P_((const char *name, char *value,
					  const char *opts, int size));
extern void rfc822_reap_comments      P_((char *, char *, int));
extern char * dequote_opt P_((CONST char *source, int len));

/* lib/charset.c */

extern char base64chars[64];

#define to64(c) (((c) >= 0) && ((c) < 64)) ? base64chars[(c)] : -1


/* lib/charset_input.c */

struct charset_state {
    charset_t           charset;    
    int                 caller_flags;  /* Not used by lib/charset_input
					* but used by src/curses.c
					*/
    struct state_private_data   * p;
};

extern struct charset_state * new_state P_((charset_t set));
extern void free_state P_((struct charset_state **state));
extern int state_ready P_((struct charset_state *st));
extern int state_printable P_((struct charset_state *st));
extern int add_streambyte_to_state P_((struct charset_state *st, int ch));
extern void reset_state P_((struct charset_state *st, int hard));
extern uint16 give_unicode_from_state P_((struct charset_state *st));
extern int state_same_char P_((struct charset_state *A,
			       struct charset_state *B,
			       int ignore_case));

/* If character corresponds one byte on stream, returns it.
 * Otherwise returns 0. This is used implement ReadCh().
 * It is assumed that returned character corresponds to
 * code characterter set (and perhaps also US-ASCII)
 */
extern int state_is_onebyte P_((struct charset_state *st));

/* lib/string.c */

struct string {
    charset_t        string_type;    
    struct str_private_data   * p;
};

extern struct string * new_string P_((charset_t set));
extern void free_string P_((struct string **str));
extern int verify_string P_((struct string *str));

extern struct string * new_string2 P_((charset_t set, 
				       const unsigned char *data));

extern int add_streambyte_to_string P_((struct string *str, int ch));
extern int add_streambytes_to_string P_((struct string *str, 
					 int count, 
					 const unsigned char *data));
extern void add_state_to_string P_((struct string *str, 
				   struct charset_state *ch));

extern struct string * cat_strings P_((const struct string *str1, 
				       const struct string *str2,
				       int printind));
extern int string_len P_((struct string *str));
extern int string_cmp P_((struct string *str1, struct string *str2,
			  int unknown_val));
extern struct string * dup_string P_((const struct string *str));
extern struct string * convert_string P_((charset_t set,
					  const struct string *str,
					  int printind));
extern int string_match P_((const struct string * name, 
			    const struct string * pat));

typedef struct display_settings * screen_info_p; 
/* result is malloced */
extern unsigned char *stream_from_string P_((const struct string *str,
					     int printable,
					     screen_info_p terminal));

/* result is malloced */
extern void bytestream_from_string P_((const struct string *str,
				   char **res,
				   int *reslen));

/* result is malloced, printable only */
extern unsigned char *streamclip_from_string P_((const struct string *str,
						 int *pos, int len,
						 screen_info_p terminal)); 
					
extern struct string *ascify_string P_((const struct string *str));
extern int can_ascii_string P_((const struct string *str));
extern void add_ascii_to_string P_((struct string *str, 
				    const unsigned char *ascii));
extern void add_unicode_to_string P_((struct string *str, 
				      int len,
				      const uint16 *vector));

extern void fill_ascii_to_string P_((struct string *str, 
				     int count, unsigned int ascii));

extern struct string *clip_from_string P_((const struct string *str,
					   int *pos, int len));

extern int find_pattern_from_string P_((const struct string *str,
					const struct string *pattern,
					int ignore_case));

extern uint16 give_unicode_from_string P_((const struct string *str,
					   int pos));

extern struct string *skip_ascii_head_from_string P_((const struct string *str,
						      const unsigned char *ascii,
						      int ignore_case));
extern void remove_control P_((const struct string *str));

/* lib/stringbuffer.c */

struct stringbuffer {
    struct sb_type           * buffer_type;
    struct sb_private_data   * p;
};

extern struct stringbuffer * create_membuffer P_((void));
extern struct stringbuffer * create_filebuffer P_((void));
extern void free_stringbuffer P_((struct stringbuffer **ptr));
extern void add_line_to_stringbuffer P_((struct stringbuffer *buffer,
					 const struct string *string));
extern int linecount_stringbuffer P_((const struct stringbuffer *ptr));

/* caller of get_line_from_stringbuffer is expected to free_string ()
   resulting buffer */
extern struct string *get_line_from_stringbuffer P_((const struct 
						     stringbuffer *buffer,
						     int ptr));
/* lib/read_rc.c */

#define SLEN		256	    /* length for elmrc variables ... */

extern struct locale_map_item   * system_locale_map;
extern struct locale_map_item   * user_locale_map;
extern struct terminal_map_item * system_terminal_map;
extern struct terminal_map_item * user_terminal_map;

extern void locale_init P_((void));     /* sets locale and elm_msg_cat */
extern void user_init P_((void));       /* get username and home directory */
extern int init_defaults P_((void));
extern int read_rc_file  P_((void));
extern void post_init_check P_((void));  /* read_rc_file calls this */
extern void post_process_charset_options P_((void));
extern int matches_weedlist P_((char *buffer));

extern char system_text_file[SLEN];      /* aliases.text */
extern char system_data_file[SLEN];      /* aliases */
extern char system_rc_file[SLEN];        /* elm.rc */
extern char system_mime_types[SLEN];     /* $lib/elm.mimetypes */
extern char hostdomfile[SLEN];           /* $lib/domain */
extern char system_mime_charsets[SLEN];  /* $lib/elm.mimecharsets */
extern char system_terminal_info[SLEN];  /* $lib/elm.terminalinfo */
extern char system_mail_services[SLEN];  /* $lib/elm.mailservices */
extern char map_txtdir[SLEN];            /* $lib/elm.map.txt */
extern char raw_map_txtdir[SLEN];        /* $lib/elm.map.txt */
extern char map_bindir[SLEN];            /* $lib/elm.map.bin */
extern char raw_map_bindir[SLEN];        /* $lib/elm.map.bin */
extern char unidata_path[SLEN];            /* $lib/elm.map.bin */
extern char raw_unidata_path[SLEN];        /* $lib/elm.map.bin */

extern char user_rc_file[SLEN];          /* .elm/elmrc */
extern char user_text_file[SLEN];        /* .elm/aliases.text */
extern char user_data_file[SLEN];        /* .elm/aliases */
extern char user_mime_types[SLEN];       /* .elm/mime.types */
extern char user_mailheaders[SLEN];      /* .elm/elmheaders */
extern char user_mime_charsets[SLEN];    /* .elm/mime.charsets */
extern char user_terminal_info[SLEN];    /* .elm/terminal.info */
extern char user_mail_services[SLEN];    /* .elm/mail.services */
extern char defaultfile[SLEN];	         /* name of default folder */
extern char raw_defaultfile[SLEN];       /* Name of default folder */
extern char calendar_file[SLEN];	/* name of file for clndr  */
extern char raw_calendar_file[SLEN];	/* unexpanded name of file for clndr  */

extern nl_catd elm_msg_cat;	/* message catalog	    */
extern int  clear_pages;	/* flag: clear screen w/ builtin pgr? */
extern int  title_messages;	/* flag: title message display?       */
extern char home[SLEN];		/* home directory of user  */
extern char username[SLEN];	/* return address name!    */
extern int userid;		/* uid for current user	      */
extern int groupid;		/* groupid for current user   */

extern int mailgroupid;		/* groupid for current user   */
extern int have_saved_ids;      /* sysconf _SC_SAVED_IDS      */

/* *** Readed from elmrc: */

extern int  alias_sortby;	/* how to sort aliases        */
extern int  add_irt_phrase;     /* In-reply-to: Add phare to in-reply-to ?
				   True = Do not follow RFC 2822 */
extern char alternative_editor[SLEN];/* the 'other' editor    */
extern struct addr_rec *alternative_addresses;	/* how else do we get mail? */
extern int  always_del;		/* flag: always delete marked msgs?   */
extern int  always_keep;	/* flag: always keep unread msgs?     */
extern int  always_store;	/* flag: always store read mail?      */
extern int  arrow_cursor;	/* flag: use "->" regardless?	      */
extern int  question_me;	/* flag: ask questions as we leave?   */
extern int  prompt_for_cc;	/* flag: prompt user for 'cc' value?  */
#ifdef USE_PGP
extern int pgp_askpgpsig;   /* Should pgp ask userid to sign messages with? */
extern int pgp_sign_type;   /* 0 = application/pgp
			       1 = text/plain
			       2 = text/x-pgp
			     */
enum pgp_version { pgp_none = 0, pgp2 = 1, pgp5 = 2, gpg = 3,
                   PGP_NUM };
extern enum pgp_version send_pgp_version; /* preferred pgp version*/
#endif
extern char attribution[SLEN];  /* attribution string for replies     */
extern int  auto_copy;		/* flag: auto copy source into reply? */
#ifdef BACKGROUD_PROCESSES       
extern int background_wait_time; /* If > 0 background mailer after
				  * this number of seconds
				  */
#endif
extern int allow_charset_switching; /* flag: allow changing charset of terminal
				      if terminal supports it */
/* extern int  bounceback;	*/   /* flag: bounce copy off remote?      */
extern int browser_wildcards;   /* flag: do wildcard match?      */
extern int  builtin_lines;	/* int use builtin pager?             */
extern char      raw_text_charset[SLEN];  /* name of character set       */
extern charset_t text_charset;	          /* pointer to character set    */
extern char raw_default_nomime_charset[SLEN]; /* name of character set       */
extern charset_t default_nomime_charset;      /* pointer to character set    */
extern char config_options[SLEN];	/* which options are in o)ptions */
extern int  confirm_append;	/* flag: confirm append to folder?    */
extern int  confirm_create;	/* flag: confirm create new folder?   */
extern int  confirm_files;	/* flag: confirm files for append?    */
extern int  confirm_folders;	/* flag: confirm folders for create?     */
extern int  convert_comment;    /* flag: convert comment to fullname ?   */
extern int  auto_copy_sent;	/* flag:  automatically copy sent mail?  */
extern char display_locale[SLEN];	/* LC_CTYPE locale (character set) */
extern char raw_display_charset[SLEN];
extern charset_t wanted_display_charset; /* name of character set */
#ifdef USE_DSN
extern int DSN_success;         /* flag: Ask successfull DSNes      */
#endif
extern char e_editor[SLEN];	/* "~e" editor...   */
extern char editor[SLEN];	/* default editor for mail */
extern int env_from_source;     /* 0 == forward-from,
                                   1 == from,
                                   2 == return-path
				*/
extern char raw_editor[SLEN];	/* unexpanded default editor for mail */
extern char escape_char;	/* '~' or something else...    */
extern int  force_name;		/* flag: save by name forced?	      */
extern int  allow_forms;	/* flag: are AT&T Mail forms okay?    */
extern char full_username[SLEN];/* Full username - gecos   */
extern int phrase_display_mode; /* 0 == plain, 1 = quoted */
extern char hostdomain[SLEN];	/* name of domain we're in */
extern char hostfullname[SLEN]; /* name of FQDN we're in */
extern char hostname[SLEN];	/* name of machine we're on*/
extern int  menu_display_host;  /* flag: Display host on mailbox menu* */
extern int  keep_empty_files;	/* flag: keep empty files??	      */
#ifdef USE_PGP
extern int pgp_keeppass;    /* should Elm keep the passphrase? */
#endif
/* extern int  hp_terminal; */	/* flag: are we on an hp terminal?    */
extern int local_fast_lookup;     /* flag: directory listing not needed 
				     for lookup */
extern char raw_local_fs_charset[SLEN]; /* filesystem charset */
extern charset_t local_fs_charset;     /* filesystem charset */
extern char local_signature[SLEN];/* local msg signature file   */
extern char raw_local_signature[SLEN];/* unexpanded local msg signature file */
extern int lockfolders;         /* Lock folder when open */
extern int lock_in_copy;        /* Lock folder when copied to it */
extern char folders[SLEN];	/* folder home directory   */
extern char raw_folders[SLEN];	/* unexpanded folder home directory   */
extern char extra_mailbox_dir[SLEN];
extern char raw_extra_mailbox_dir[SLEN];
extern int  mail_permissions;	/* int: permissions for mailbox files   */
extern int  mini_menu;		/* flag: display menu?     	      */
extern char raw_metamail_path[SLEN];
extern char metamail_path[SLEN];  /* Metamail path or "none" if no metamail */
extern int  metoo;		/* flag: copy me on mail to alias?    */
extern int mimeforward;
extern int mime_body_keywords; /* flag: if false the body is not parsed for keywords */
extern int  move_when_paged;	/* flag: move when '+' or '-' used?   */
extern int  names_only;		/* flag: display names but no addrs?  */
extern int allow_no_encoding;       /* 1: Allow 8bit without -B8BITMIME
                                     * 2: Allow binary without -BBINARYMIME
                                     *    and 8bit without -B8BITMIME */
extern int allow_no_hdrencoding;    /* TRUE, if header encoding is 
				     * not required */
extern int  noheader;		/* flag: copy + header to file?       */
extern int  noheaderfwd;	/* flag: copy + header to file?(fwd)  */
extern int pagealternative;
extern int page_known_charsets;
extern int pagemultipart;
extern int pagesigned;
extern char pager[SLEN];	/* what pager to use...    */
extern char raw_pager[SLEN];	/* unexpanded what pager to use...    */
#ifdef USE_PGP
extern char pgp2_path[SLEN];    /* Pgp2 path or "none" if no pgp2 */
extern char raw_pgp2_path[SLEN];
extern char pgp5_dir[SLEN];   /* pgp5 binary directory or "none" if no pgp5 */
extern char raw_pgp5_dir[SLEN];
extern char gpg_path[SLEN];
extern char raw_gpg_path[SLEN];
#endif
extern int  point_to_new;	/* flag: start pointing at new msgs?  */
extern char allowed_precedences[SLEN];	/* list of precedences user may specify */
extern char prefixchars[SLEN];	/* prefix char(s) for msgs */
extern char printout[SLEN];	/* how to print messages   */
extern char raw_printout[SLEN];	/* unexpanded how to print messages   */
extern int  prompt_after_pager;	/* flag: prompt after pager exits     */
extern int  quote_forward;	/* flag: fwd'd msgs quoted like replies */
extern int  readdatapercentinc;	/* data percent increment during new mbox read */
extern int  readmsginc;		/* msg cnt increment during new mbox read */
extern char recvd_mail[SLEN];	/* folder for storing received mail	*/
extern char raw_recvdmail[SLEN];/* unexpanded recvd_mail name */
extern char remote_signature[SLEN];/* remote msg signature file */
extern char raw_remote_signature[SLEN];/* unexpanded remote msg signature file*/
extern int req_mime_bodyencoding;
extern int req_mime_hdrencoding;
extern int  resolve_mode;	/* flag: resolve before moving mode?  */
extern int  save_by_name;  	/* flag: save mail by login name?     */
extern char sent_mail[SLEN];	/* name of file to save copies to */
extern char raw_sentmail[SLEN];	/* unexpanded name of file to save to */
extern char shell[SLEN];	/* default system shell    */
extern char raw_shell[SLEN];	/* unexpanded default system shell    */
#ifdef USE_PGP
extern int pgp_noarmor;     /* Should Elm display text before PGP armor */
#endif
extern int  showto;
extern int  show_header_errors; /* flag: should some header reported? */
extern int  sig_dashes;		/* flag: put dashes above signature?  */
extern int  sleepmsg;		/* time to sleep for messages being overwritten on screen */
/* extern int  hp_softkeys; */	/* flag: are there softkeys?          */
extern int  sortby;		/* how to sort folders	      */
extern long elm_timeout;        /* seconds for main level timeout     */
extern int sort_thread_max_time; /* Number of days which can considered 
				    be same thread */
extern char temp_dir[SLEN];     /* name of temp directory */
extern char raw_temp_dir[SLEN]; /* unexpanded name of temp directory */
#ifdef USE_PGP
extern int pgp_keeppass;         /* should Elm keep the passphrase in*/
#endif
extern int  user_level;		/* flag: how knowledgable is user?    */
extern int  use_tite;		/* flag: use termcap/terminfo ti/te?  */
extern int utf7_encode_optional; /* flag: Should utf7 optional direct 
				    characters to be encoded?        */
extern char v_editor[SLEN];	/* "~v" editor...   */
extern int  elm_filter;		/* flag: weed out header lines?	      */
extern int  send_mime_plain;    /* Send text/plain US-ASCII as MIME?  */
extern char *weedlist[MAX_IN_WEEDLIST];
extern int  weedcount;		/* how many headers to check?        */
#ifdef REMOTE_MBX
extern char raw_imap_charset[SLEN];  /* IMAP foldername charset */
extern int imap_fast_lookup;         /* flag: skip directory listing */
extern charset_t imap_charset;       /* IMAP foldername charset */
extern int IMAP_connection_cache; /* flag: call cache_connection() ? */
extern int IMAP_name_convention; /* flag: Should imap international folder
				    convention be used? */
extern int IMAP_use_examine;   /* flag: Should EXAMINE command to be used? */
extern int IMAP_show_greeting; /* flag: Should untagged OK messages be shown? */
extern int IMAP_show_warning; /* flag: Should untagged NO messages be shown? */
extern int IMAP_show_error;  /* flag: Should untagged BAD messages be shown? */
extern int POP_show_greeting;  /* flag: Should POP server greeting be shown? */
#endif

/* lib/output.c */

#define FRM(format)  format,format
#define CATGETS(cat,set,def,format) format,catgets(cat,set,def,format) 

typedef int err_handler P_((const char *str));
extern int lib_error P_((const char * format, const char *msg, ...));
extern void set_error_handler P_((err_handler *h));

extern int lib_transient P_((const char * format, const char *msg, ...));
extern void set_transient_handler P_((err_handler *h));

extern char *elm_vmessage P_((int max_alloc,
			      const char *format, const char *msg, 
			      va_list args));
extern struct string * elm_smessage P_((int max_alloc,
					const char *format, const char *msg,
					va_list args));
extern char *elm_message P_((const char * format, const char *msg, ...));
extern struct string *format_string P_((const char * format, 
					const char *msg, ...));
extern int elm_sfprintf P_((char *buffer, int size,
			    const char * format, const char *msg, ...));
extern int elm_fprintf P_((FILE *f,const char * format, const char *msg, ...));

/* result mast be malloced */
typedef char * prompt_handler P_((const char *str, int pass)); 
extern char * lib_prompt P_((int pass, const char * format, 
			     const char *msg, ...));
extern void set_prompt_handler P_((prompt_handler *h));


/* low level output routines: */
struct  format_elem {
    int fill;
    int left;
    int plus;
    int val1, val2;
    int long_f;
    
    enum val_type  { V_none,
		     V_signed_val, V_unsigned_val, V_str_val,
		     V_chr_val, V_string_val, V_cs_val,
		     V_ptr_val, V_double_val } type;
    union val_value {
	long                      signed_val;
	unsigned long           unsigned_val;
	char *                       str_val;
	int                          chr_val;
	struct string *           string_val;
	struct charset_state *        cs_val;
	void *                       ptr_val;
	double                    double_val;
    } value;	

    char format_chr;

};

/* Returns number of args parsed: -1 is parse error,
   - this routine can be called from interrupt handler,
     so this does not malloc anything or call charset routines ...
   - this routine is also part of debugging output routine,
     so do not call debugging output on here...
 */

extern int parse_format_args P_((struct  format_elem *elems,
				 int              max_elems,
				 const char        * format,
				 va_list               args,
				 char        **format_error));


/* convert_number may be callled form signal handler, therefore
   it must not malloc annything ... 
*/

extern int convert_number P_((char * buffer, int buffer_size, 
			      struct  format_elem *elem));



/* lib/file_util.c */

#ifdef ANSI_C
struct folder_info;                /* Needed for prototype */
#endif

extern long file_bytes P_((CONST char *name));
extern int save_file_stats P_((CONST char *fname));
extern int restore_file_stats P_((CONST char *fname));
extern FILE *open_or_create P_((CONST char *name));
extern int copy_to_fh P_((FILE *from, FILE *to));
extern int copy1 P_((FILE *from, char *to, int isspool));
extern int elm_chown P_((CONST char *file, int userid, int groupid));


/* lib/forwarded.c */

void forwarded P_((char *buffer, struct header_rec *entry));

/* lib/savefolder.c */

enum selection_type { selection_file, selection_folder };

typedef struct folder_browser  *folder_dir;

extern void free_dir P_((struct folder_browser **dir));
extern struct folder_browser *new_browser P_((enum selection_type  sel_type));

/* Returns 1 if succesfully, and may canonify argument
   may change type of dir
 */

extern int change_dir P_((struct folder_browser *dir, 
			  struct string **buffer));
extern int select_dir_item P_((struct folder_browser *dir, 
			       struct string **buffer));
extern int change_dir_to_entry P_((struct folder_browser *dir, 
				   int entry,
				   struct string **buffer));
extern int change_dir_up P_((struct folder_browser *dir, 
			     struct string **buffer));


extern struct string * give_title_dir P_((struct folder_browser *dir,
					  int *entry_count));
extern int give_edit_buffer P_((struct folder_browser *dir,
				int entry, struct string **buffer,
				int fill_with_entry));

extern int dir_is_wildcard P_((struct folder_browser *dir,
			       struct string **buffer));


#define BROWSER_NODIR              1          /* Not a directory */         
#define BROWSER_NOFOLDER           2          /* Not a folder  */
#define BROWSER_MARKED             4          /* New mails ?   */

/* return reference to array -- do not free_string !!! */
extern struct string * give_line_dir P_((struct folder_browser *dir,
					 int idx,
					 int *flags));

/* Operations for selection */

#define BROWSER_MAILFILE            64

#define BROWSER_SELECTED           128
#define BROWSER_EXIST              256

extern int give_dir_flags P_((struct folder_browser *dir));
extern struct folder_info * 
folder_from_dir_item P_((struct folder_browser *dir));

extern int create_selection_dir P_((struct folder_browser *dir));

typedef struct browser_write_state * WRITE_STATE;
extern int prepare_write_folder P_((struct folder_browser *dir,
				    WRITE_STATE * write_state_ptr));
extern int end_write_folder P_((struct folder_browser *dir,
				    WRITE_STATE * write_state_ptr));
extern struct string * selection_name_dir P_((struct folder_browser *dir));
extern void clear_selection_dir P_((struct folder_browser *dir));

/* Returns -1 if not seekable, else position */
extern long tell_dir_write_state P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr));
/* Returns 0 on failure! */
extern int seek_dir_write_state P_((struct folder_browser *dir,
                                    WRITE_STATE write_state_ptr,
				    long pos));
/* Return 0 on failure */

extern int dir_make_ref P_((struct folder_browser *dir,
			    char **refname, int *iscopy, int is_text));

#define WE_ADD_RETURN_PATH           1
#define WE_USE_CRLF                  2

extern int write_dir_write_state P_((struct folder_browser *dir,
				     WRITE_STATE write_state_ptr,
				     int l, const char *buffer));
extern int write_envelope_start P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr,
				    int write_envelope,
				    struct header_rec *current_header,
				    int *env_flags));
extern int write_envelope_end P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr,
				    int write_envelope,
				    struct header_rec *current_header));

extern int selection_is_folder P_((struct folder_browser *dir,
				   struct folder_info *folder));

/* helper routines for fileio.c */
extern void start_fd_write_state P_((FILE *fd, 
			       struct folder_browser **dir,
			       WRITE_STATE *write_state_ptr));
extern void end_fd_write_state P_((struct folder_browser **dir,
			       WRITE_STATE *write_state_ptr));


/* lib/mbox.c */

typedef struct read_folder_state * READ_STATE;

enum sessionlock_mode { SESSIONLOCK_NORMAL   = 0,
			SESSIONLOCK_REOPEN   = 1,
			SESSIONLOCK_TRUNCATE = 2,
			SESSIONLOCK_CHECK    = 3,
			SESSIONLOCK_NONE     = 4};

typedef struct folder_type * folder_type_p;

struct folder_info {
    char             * cur_folder_sys;	 /* name of current folder         */
    struct string    * cur_folder_disp;  /* Display name of current folder */

    char cur_tempfolder[SLEN];  /* name of temp folder open for a mailbox */

    folder_type_p folder_type;	 /* flag: type of folder     */
    long mailfile_size;	         /* size of current mailfile */

    struct private_data * p;
};

enum close_mode { CLOSE_NORMAL = 0,
		  CLOSE_LEAVE_LOCKED = 1 };

extern void close_folder P_((struct folder_info *folder,
			     enum close_mode mode));
extern void flush_folder P_((struct folder_info *folder));

extern struct folder_info *enter_new_folder P_((char *new_file)); /* create */
extern void leave_old_folder P_((struct folder_info *folder,
				 enum close_mode mode));    /* free   */

#define FOLDER_MBOX          0x001         /* Folder is mbox */
#define FOLDER_RDONLY        0x002         /* Folder is read-only */
#define FOLDER_FILE          0x004         /* Folder is file */

extern int get_folder_mode P_((struct folder_info *folder));

/* Opens folder -- Return 1 on succeed */
extern int sessionlock_folder P_((struct folder_info *folder,
				  enum sessionlock_mode mode));
/* Return 1 on succeed */
extern int lock_folder P_((int direction,struct folder_info *folder));
extern int unlock_folder P_((int interrupt, struct folder_info *folder));
extern int ferror_folder P_((struct folder_info *folder, int clean));

enum prepare_mode { PREPARE_NORMAL = 0, PREPARE_NEW_ONLY = 1,
		    PREPARE_NOLOCK = 2, PREPARE_NEW_ONLY_NOLOCK = 3 };

extern int prepare_read_folder P_((struct folder_info *folder,
				   enum prepare_mode mode,
				   READ_STATE * read_state_ptr));
extern int end_read_folder P_((struct folder_info *folder,
			       READ_STATE * read_state_ptr,
			       int silent));

/* Returns:  0 = End of folder
             1 = OK
	    -1 = format error
*/
extern int copy_envelope_folder P_((struct folder_info *folder,
				    READ_STATE read_state_ptr,
				    struct header_rec *entry));
extern CONST char * is_forwarded_folder P_((struct folder_info *folder,
					    READ_STATE read_state_ptr));
extern long copy_fbytes_folder P_((struct folder_info *folder,
				   READ_STATE read_state_ptr));
extern int copy_lines_folder P_((struct folder_info *folder,
				   READ_STATE read_state_ptr));
/* Gives header including continuation lines */
extern int copy_header_folder P_((struct folder_info *folder,
				  READ_STATE read_state_ptr,
				  char **buffer, int *len));

/* Unfolds line returned by copy_header_folder */
extern void unfold_header P_((char *buffer, int *len, 
			    struct header_rec *current_header));



extern int copy_body_folder P_((struct folder_info *folder,
				READ_STATE read_state_ptr,
				char **buffer, int *len,
				long *content_remaining));

/* Returns 0 if not end of message (needs resync without content-length) */
extern int copy_envelope_end_folder P_((struct folder_info *folder,
					READ_STATE read_state_ptr));

extern int copy_envelope_reset_body P_((struct folder_info *folder,
                                        READ_STATE read_state_ptr,
					long *content_remaining));

extern FILE * folder_to_fd P_((struct folder_info *folder,long offset));

extern int new_mail_on_folder P_((struct folder_info *folder,int *bytes));

/* possible removes file and closes folder -- 
   returns 1 if removed  and closed */
extern int consider_remove_folder P_((struct folder_info *folder));

typedef struct keep_folder_state * KEEP_STATE;

extern int prepare_keep_folder P_((struct folder_info *folder,
				   KEEP_STATE * keep_state_ptr));
extern int end_keep_folder P_((struct folder_info *folder,
			       KEEP_STATE * keep_state_ptr));
extern void mark_keep_folder P_((struct folder_info *folder,
				 KEEP_STATE keep_state_ptr,
				 struct header_rec *entry,
				 int keep));

extern CONST char * folder_type P_((struct folder_info *folder));
extern int start_edit_folder P_((struct folder_info *folder, 
				 CONST char **buffer));
extern int end_edit_folder P_((struct folder_info *folder));
extern void write_folder_info P_((FILE *F, struct folder_info *folder));

extern void free_rec_mbx_info P_((struct header_rec *entry));

extern void return_path_to_env_from P_((struct header_rec *entry,
					const char *value));

/* lib/headers.c */

typedef struct header_info * header_ptr;

/* Returns pointer to static storage */
extern char * give_header_name P_((header_ptr X));
extern int give_header_flags P_((header_ptr X));

#define HEADER_magic        0xFC00

typedef struct header_list {
    unsigned short magic;
    header_ptr header_name;
    struct header_list * next_this_header;
    struct header_list * next_header;
    struct header_list * next_other_header;
    char * body;
} * header_list_ptr;


extern void update_header_list P_((header_list_ptr *list,
				   header_list_ptr *last1,
				   const char * name,
				   const char * value));

extern header_ptr find_header  P_((const char *name, int create_flag));
extern int classify_header     P_((const char *name));
extern header_list_ptr locate_header      P_((header_list_ptr,header_ptr));

#define locate_header_by_name(h,n)      locate_header(h,find_header(n,0))
extern void delete_headers              P_((header_list_ptr *hdr));

header_list_ptr read_folder_headers P_((READ_STATE read_state_ptr,
					struct folder_info *folder,
					struct header_rec *entry));

struct string * give_decoded_header P_((header_list_ptr tmphdr,
					int demime, charset_t defcharset));


/* lib/schedule.c */

/* if returns 0 -- action is removed from list */
typedef int action_routine P_((int fd, void * data));
extern int no_action_routine P_((int fd, void * data));

extern void change_action P_((int fd, 
			      int timeout_sec,
			      action_routine * read_act, 
			      action_routine * write_act, 		       
			      action_routine * timeout_act,
			      void *data));
extern void clear_action P_((int fd));
extern int have_actions P_((void));

typedef enum schedule_return { 
    schedule_remove = 0, schedule_reconsider = 1,
    schedule_done = 2, schedule_have_action = 3 } 
schedule_routine P_((int fd, void * data));

extern enum schedule_return no_schedule_routine P_((int fd, void * data));
		   
void set_schedule_action P_((int fd,
			     schedule_routine *routine,
			     void * data));

extern VOLATILE int wait_can_signal;

#if POLL_METHOD

/* Returns 1 if action occured                     */
extern int wait_for_action P_((action_routine * action));
extern int wait_for_any_action P_((void));
extern int wait_for_timeout P_((int seconds));
/* Returns 1 if action or timeout occured          */
extern int wait_for_action_or_timeout P_((action_routine * action,
					  int seconds));
extern int wait_for_any_action_or_timeout P_((int seconds));
#endif

/* lib/panic.c */

typedef void panic_prepare P_((CONST int interrupt, 
			       CONST char * title,
			       CONST char * ms));

extern void set_panic_prepare P_((panic_prepare *fn));

typedef void panic_exit P_((CONST int interrupt));
extern void set_panic_exit P_((panic_exit *fn));

extern void panic P_((CONST char * title,
		      CONST char * f,
		      CONST int ln,
		      CONST char * pr,
		      CONST char * ms,
		      CONST int interrupt));


/* lib/hdrdecode.c */

extern char * blstrpbrk P_((char *string, CONST char *set));
extern struct string * hdr_to_string P_((int class,CONST char *buffer,
					 charset_t defcharset, int demime));

extern int index_hex[128];
extern int index_64[128];

#define base64(c) ((((c) > 0) && ((c) < 127)) ? index_64[ (c) ] : -1)
#define hex(c) ((((c) > 0) && ((c) < 127)) ? index_hex[ (c) ] : -1)

/* lib/hdrencode.c */

extern char hexchars[16];

/* result is malloced */
extern char * string_to_hdr P_((int class, const struct string *buffer,
				charset_t defcharset, int enmime));

/* lib/terminal.c */

enum terminal_map_keyword { terminal_bad = -1, terminal_iso2022 = 0,
                            terminal_private = 1};


extern struct terminal_map_item {
    char                    * match;
    enum terminal_map_keyword keyword;
    union {
	struct cset {
	    charset_t  charset;  
	    int        is_def;
	} iso2022;
        struct privset {
            charset_t           charset;
            unsigned char *     bytes;
	} private;
    } value;
} * load_terminal_map P_((const char *filename, int *errors));

extern void dump_terminal_map P_((FILE *f, struct terminal_map_item *map));
extern int terminal_can_switch_to P_((const char *terminal, charset_t set, 
				      int silent));

extern void terminal_can_switch P_((const char *terminal,
				    charset_t *storage,
				    int *n,
				    int max));
			   
/* Result is malloced */
extern char * terminal_switch_to P_((char *terminal, charset_t set,
				     screen_info_p *terminal_info));


/* lib/remote_mbx.c */

#ifdef REMOTE_MBX
extern int close_cached_connections P_((void));
extern int set_transaction_file P_((const char *filename));
#endif



/* rfc822tlen.c */

extern int rfc822_toklen P_((const char *str));

/* shared.c */

#if defined(USE_DLOPEN) || defined(REMOTE_MBX)
typedef enum { IMAP_error = 0,
	       IMAP_idle,
	       IMAP_command,
	       IMAP_command_ready_OK,
	       IMAP_command_ready_NO,
	       IMAP_command_ready_BAD,
	       IMAP_closing
} imap_states;
#endif

#ifdef USE_DLOPEN
extern int use_sharedfunc P_((char **value, int enter));

extern void seed_rand_bits P_((const char *buf, int size,
			       int entropy_bits));


enum CAPA_phase { 
    capa_prelogin        = 0,
    capa_prelogin_again  = 1,
    capa_do_login        = 2,
    capa_logged          = 3,
    capa_logged_again    = 4
};

#ifdef ANSI_C
struct POP_capa_libs;
#endif

extern void probe_pop_capa_lib P_((struct POP_capa_libs * *pop_capa_libs,
				   int                  * pop_capa_libcount,
				   const char *capa,
				   const char *capa_args));

typedef int f_pop_push_command P_((struct folder_info *folder,
				   char *command, int simple));
typedef int f_pop_command_ok P_((struct folder_info *folder));
typedef void f_pop_clear_command P_((struct folder_info *folder));

struct pop_callbacks {
    f_pop_push_command   * push_command;
    f_pop_command_ok     * command_ok;
    f_pop_clear_command  * clear_command;
};

/* Also frees pop_capa_libs list ... */
extern int handle_pop_capa_libs P_((struct folder_info *folder,
				    struct POP_capa_libs * *pop_capa_libs,
				    int                  * pop_capa_libcount,
				    enum CAPA_phase      * phase,
				    struct pop_callbacks *commands));

#ifdef ANSI_C
struct IMAP_capa_libs;
struct connection_cache;
#endif

extern void probe_imap_capa_lib P_((struct IMAP_capa_libs * *imap_capa_libs,
				   int                  * imap_capa_libcount,
				   const char *capa));

typedef void f_imap_wait P_((struct connection_cache *con));
typedef void f_imap_idle_wait P_((struct connection_cache *con));
typedef int f_imap_command_ok P_((struct connection_cache *con,
				  imap_states *cmd_result,
				  char        **extra_code));
typedef int f_start_imap_command P_((struct connection_cache *con,
				     char * verb));
typedef void f_imap_command_push_atom P_((struct connection_cache *con,
					  const char *st));
typedef void f_imap_command_push_literal P_((struct connection_cache *con,
					     int len, const char *st));
typedef void f_imap_command_push_string P_((struct connection_cache *con,
					    const char *st));
typedef void f_imap_command_push_astring P_((struct connection_cache *con,
					 const char *st));
typedef void f_imap_command_push_aliteral P_((struct connection_cache *con,
					      const char *st));
typedef void f_imap_command_push_range P_((struct connection_cache *con,
					   int A, int B));
typedef void f_imap_command_push_number P_((struct connection_cache *con,
					 int A));
typedef void f_imap_command_push_list P_((struct connection_cache *con,
					  const char **l));
typedef void f_end_imap_command P_((struct connection_cache *con));
typedef void f_imap_clear_command P_((struct connection_cache *con));

struct imap_callbacks {
    f_imap_wait                  * wait;
    f_imap_idle_wait             * idle_wait;
    f_imap_command_ok            * command_ok;
    f_start_imap_command         * start_command;
    f_imap_command_push_atom     * command_push_atom;
    f_imap_command_push_literal  * command_push_literal;
    f_imap_command_push_string   * command_push_string;
    f_imap_command_push_astring  * command_push_astring;
    f_imap_command_push_aliteral * command_push_aliteral;
    f_imap_command_push_range    * command_push_range;
    f_imap_command_push_number   * command_push_number;
    f_imap_command_push_list     * command_push_list;
    f_end_imap_command           * end_command;
    f_imap_clear_command         * clear_command;
};

enum imap_phase { IMAP_prelogin = 0, IMAP_logged = 1 };
/* Also frees imap_capa_libs list ... */
extern int handle_imap_capa_libs P_((struct connection_cache *con,
				    struct IMAP_capa_libs * *imap_capa_libs,
				    int                  * imap_capa_libcount,
				    enum CAPA_phase      * phase,
				    struct imap_callbacks *commands));

extern void free_only_imap_capa_libs P_((struct IMAP_capa_libs * *imap_capa_libs,
					 int                  * imap_capa_libcount));

extern struct SE_option_type * get_option_type P_((const char *prefix));
#endif

/* service_list.c */

extern int parse_service_entries P_((const char *filename, int system,
				     int *errors));
extern void dump_service_entries P_((FILE *f, int system));


/* debug.c */

#if DEBUG

/* Given arhument must be statically alloced */
extern void init_debugfile P_((const char *progname));
extern int  set_debugging P_((const char *arg));

struct debug_struct {
    CONST char          * class;
    CONST char          * file;
    CONST char          * ID;
    struct debug_target * target;
    int   active;
};

#define DEBUG_VAR(x,file,class) \
static struct debug_struct x = { class, file, rcsid, NULL, -1 }

extern void debug_level_check P_((struct debug_struct *a));
extern void debug_action_call P_((struct debug_struct *a, 
				  const char * format,
				  ...));

extern void debug_action_sigcall P_((struct debug_struct *a, 
				     const char * format,
				     ...));

extern void debug_user_init P_((void));

#define DPRINT(x,level,action) do { \
    if (x.active == -1) debug_level_check(&x); \
    if (x.active >= level) debug_action_call action; \
} while(0)

#define SIGDPRINT(x,level,action) do { \
    if (x.active >= level) debug_action_sigcall action; \
} while(0)

/* Called from signal handler, returns largest debug level */
extern int panic_dprint P_((const char * format, ...));
extern FILE * debug_to_FILE P_((struct debug_struct *a));

#else

#define DPRINT(x,level,action)
#define SIGDPRINT(x,level,action)
#define DEBUG_VAR(x,file,class)

#endif



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */




