/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: misc.c,v 1.6 1994/12/07 03:34:12 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"

#ifndef HAVE_STRERROR
char *strerror(num)
  int num;
{
  extern char *sys_errlist[];

  return(sys_errlist[num]);
}
#endif /* HAVE_STRERROR */

#ifndef HAVE_WAITPID
pid_t
waitpid(pid, status, options)
  pid_t pid;
#ifdef HAVE_UNION_WAIT
  union wait *status;
#else
  int *status;
#endif
  int options;
{
  return(wait4(pid, status, options, NULL));
}
#endif /* HAVE_WAITPID */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/util/RCS/misc.c,v $ */
