#ifndef _DEPOTLIB_H
#define _DEPOTLIB_H

/* $Id: depotlib.h,v 1.8 1995/03/20 20:48:59 ww0r Exp $ */

#include "cmu-copyright.h"
#include "depot_autoconf.h"

#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#endif 

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <sys/file.h>

#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <grp.h>
#include <math.h>
#include <pwd.h>

#ifdef HAVE_VALUES_H
#include <values.h>
#endif

#include <netinet/in.h> /* for htonl, ntohl */

#ifndef INHIBIT_VARARGS_H
#include <varargs.h>
#endif

/* taken from the example in gnu-autoconf */
#if defined(HAVE_DIRENT_H) || defined(_POSIX_VERSION)
#include <dirent.h>
#define NLENTH(dirent) (strlen((dirent)->d_name))
#else 
#define dirent direct
#define NLENTH(dirent) (strlen((dirent)->d_namelen))
#ifdef HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif /* SYSNDIR */
#ifdef HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif 
#ifdef HAVE_SYS_NDIR_H
#include <ndir.h>
#endif 
#endif /* defined(DIRENT) ... */

#if HAVE_STRING_H
#include <string.h>
#if HAVE_MEOMRY_H
#include <memory.h>
#endif /* HAVE_MEMORY_H */

#ifndef HAVE_BCOPY
/* If you have one, you probably have them all... */
#define bcopy(s,d,n)    memcpy((d), (s), (n))
#define bcmp(s1, s2, n) memcmp((s1), (s2), (n))
#define bzero(s,n)      memset((s), 0, (n))
#endif /* HAVE_BCOPY */
#else /* HAVE_STRING_H */
#include <strings.h>
#endif

#ifndef STDIN_FILENO
#define STDIN_FILENO 0
#endif

#ifndef STDOUT_FILENO
#define STDOUT_FILENO 1
#endif

/* Non POSIX goo */
#ifndef POSIX_SOURCE 

#ifndef WEXITSTATUS
    /* assume BSD style return code if WEXITSTATUS is not defined */
#define WEXITSTATUS(x) (x).w_retcode
#endif

#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif

#ifndef S_IXUSR
#define S_IXUSR 0000100
#define S_IXGRP 0000010
#define S_IXOTH 0000001
#define S_ISDIR(mode) (((mode) & (_S_IFMT)) == (_S_IFDIR))
#define S_ISREG(mode) (((mode) & (_S_IFMT)) == (_S_IFREG))
#endif

#endif /* POSIX_SOURCE */

/* deal with SABER -> CODECENTER renaming */
#ifdef __CENTERLINE__
#define SABER 1
#endif 
#endif /* _DEPOTLIB_H */

/* If the lock file is older than DEPOT_EXPIRE_LOCKFILE then
 * depot will disregard the lockfile. The format of the file is in seconds.
 */
#define DEPOT_EXPIRE_LOCKFILE  (60*60*24)   /* 1 day */

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/019/src/lib/include/RCS/depotlib.h,v $ */
