/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Merge.c,v 1.4 1994/08/12 22:25:24 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"


static void TargetDB_NodeMerge();
static TARGETDB *TargetDB_TreeMerge();


static void 
TargetDB_NodeMerge(targetdbnodep, deltadbnodep, newpathtosources)
     TARGETDB *targetdbnodep, *deltadbnodep;
     Boolean newpathtosources;
{
  register unsigned int i;
  register TARGETSOURCE *sp;

  TARGETSOURCELIST *newsourcelistp;

  newsourcelistp = TARGETDB_SourceList(deltadbnodep);

  /* merge newsourcelist */
  TARGETDB_SourceList(targetdbnodep) =
    SourceList_Merge(TARGETDB_SourceList(targetdbnodep),
		     newsourcelistp,
		     newpathtosources);
  TARGETDB_Status(targetdbnodep) |= S_MODIFIED;

  for (i = 0;
       (PROGRAM_ErrorNo == E_NULL)
       && (i < TARGETSOURCELIST_NSources(newsourcelistp));
       i++) {
    sp = TARGETSOURCELIST_Source(newsourcelistp, i);
    /* if we have an enduring subcollection, unobsolete source in subtree */
    if (TARGETSOURCE_Status(sp) & S_ENDURINGSUBTREE) {
      (void) TargetDB_UnObsoleteSource(targetdbnodep,
				       TARGETSOURCE_Path(sp),
				       TARGETSOURCE_CollectionId(sp),
				       TARGETSOURCE_UpdateSpec(sp)
				       & (U_MAPLINK | U_MAPCOPY));
    }
  }

  return;
}



static TARGETDB *
TargetDB_TreeMerge(targetdbp, deltadbp, newpathtosources)
     TARGETDB *targetdbp, *deltadbp;
     Boolean newpathtosources;
{
  register unsigned int i;
  register TARGETDB **deltachildp;

  TARGETDB *newtargetdbp;
  int childnodeindex;

  newtargetdbp = targetdbp;

  if (deltadbp != NULL) {
    TargetDB_NodeMerge(newtargetdbp, deltadbp, newpathtosources);

    if ((PROGRAM_ErrorNo == E_NULL) && (TARGETDB_ChildCount(deltadbp) > 0)) {
      TARGETDB_Status(newtargetdbp) |= S_MODIFIEDCHILDREN;
    }
    /* merge child nodes of deltadbp */
    for (i = 0, deltachildp = TARGETDB_Children(deltadbp);
	 (PROGRAM_ErrorNo == E_NULL) && (i < TARGETDB_ChildCount(deltadbp));
	 i++, deltachildp++) {
      /* 
       * locate index to the child node corresponding to it in newtargetdbp
       * creating the child if necessary
       */
      childnodeindex =
	TargetDB_LocateIndexToChildNode(newtargetdbp,
					TARGETDB_Name(*deltachildp),
					TDB_LOCATE | TDB_CREATE);
      /* recursively merge the child node of deltadbp */
      if ((PROGRAM_ErrorNo == E_NULL) && (childnodeindex >= 0)) {
	*(TARGETDB_Children(newtargetdbp) + childnodeindex) =
	  TargetDB_TreeMerge(*(TARGETDB_Children(newtargetdbp)
			       + childnodeindex),
			     *deltachildp,
			     newpathtosources);
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



TARGETDB *
TargetDB_Merge(targetdbp, deltadbp, newpathtosources)
     TARGETDB *targetdbp, *deltadbp;
     Boolean newpathtosources;
{
  TARGETDB *newtargetdbp;

  newtargetdbp = targetdbp;

  if (newtargetdbp == NULL) {
    newtargetdbp = TargetDB(deltadbp);
  } else {
    newtargetdbp = TargetDB_TreeMerge(newtargetdbp, deltadbp, newpathtosources);
  }

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/TargetDB/RCS/TargetDB_Merge.c,v $ */
