/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: TargetDB_CreateTargetPath.c,v 1.4 1994/08/12 22:24:09 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"


TARGETDB *TargetDB_CreateTargetPath(targetdbp,
				    targetpath,
				    updatespec)
     TARGETDB *targetdbp;
     char *targetpath;
     unsigned updatespec;
{
  register char **sp;

  TARGETDB *newtargetdbp;
  TARGETDB *childnodep;
  STRINGARRAY *targetpathstringarray;
  char **targetpatharray;
  unsigned pathupdatespec;

  if (targetpath == NULL)
    {
      FatalError(E_BADTARGET,
		 "Attempt to create path to NULL target.\n");
    }
  if (!(updatespec & (U_NOOP | U_SPECIAL | U_COMMAND)))
    {
      FatalError(E_BADTARGETUPDTSPEC,
		 "Attempt to create path %s with bad update specification %s\n",
		 targetpath, updatespec);
    } 

  pathupdatespec = U_MKDIR|U_NONVIRGIN;
  if (updatespec & U_NOOP) pathupdatespec |= U_NOOPPATH;
  if (updatespec & U_SPECIAL) pathupdatespec |= U_SPECIALPATH;
  if (updatespec & U_COMMAND) pathupdatespec |= U_COMMANDPATH;

  newtargetdbp = targetdbp;

  /* create rootnode for newtargetdbp if necessary */
  if ((PROGRAM_ErrorNo == E_NULL) && (newtargetdbp == NULL))
    {
      newtargetdbp = TargetDB_Create("/" 	/* name of root node */,
				     pathupdatespec	/* update_spec */,
				     NULL	/* file status */,
				     S_NULL	/* status */,
				     NULL	/* sourcelist */,
				     U_NULL	/* update_spec_old */,
				     NULL       /* old file status */,
				     0, NULL	/* childcount, children */);
    }

  /* split target path into array of its components */
  if (PROGRAM_ErrorNo == E_NULL)
    {
      targetpathstringarray = StringToStringArray(targetpath,
					    '/' /* delimited by /s */,
					    -1 /* no quotechar */);
    }
  if (PROGRAM_ErrorNo == E_NULL)
    {
      if (targetpathstringarray == NULL)
	{ targetpatharray = NULL; }
      else
	{ targetpatharray = STRINGARRAY_Values(targetpathstringarray); }
    }

  if ((PROGRAM_ErrorNo == E_NULL) && (targetpatharray != NULL))
    {
      TARGETDB_UpdateSpec(newtargetdbp) |= pathupdatespec;
      for (sp = targetpatharray, childnodep = newtargetdbp;
	   (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	   sp++)
	{
	  /* create new child node if necessary */
	  childnodep = TargetDB_LocateChildNode(childnodep,
						*sp,
						TDB_LOCATE|TDB_CREATE);
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      if (*(sp+1) == NULL)
		{
		  if (updatespec & U_SPECIAL)
		    TARGETDB_UpdateSpec(childnodep) = updatespec;
		  else
		    TARGETDB_UpdateSpec(childnodep) |= updatespec;
		}
	      else
		{ TARGETDB_UpdateSpec(childnodep) |= pathupdatespec; }
	    }
	}
    }

  if (targetpathstringarray != NULL)
    StringArray_Free(targetpathstringarray);

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/TargetDB/RCS/TargetDB_CreateTargetPath.c,v $ */
