/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: TargetDB_Conflict.c,v 1.4 1994/08/12 22:23:41 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "Preference.h"


/*
 * $$$NOTE$$$
 *	I wind up having to include Collection.h and the whole schpiele here
 * because I need to have the collectionlist handy to check preferences
 * Better to improve separation by splitting up collectionlist into
 * collectionnamelist and collectionlist - so that TargetDB etc. does not
 * refer to even an include file in Collection module.
 */


static Boolean TargetDB_NodeCheckSourceConsistency();
static Boolean TargetDB_TreeCheckSourceConsistency();


static Boolean TargetDB_NodeCheckSourceConsistency(targetdbnodep,
						   preferencedb,
						   collectionlistp,
						   findallconflicts)
     TARGETDB *targetdbnodep;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
     Boolean findallconflicts;
{
  Boolean NoConflictFound;

  NoConflictFound = TRUE;

  if ((TARGETDB_SourceList(targetdbnodep) != NULL)
      && (TARGETSOURCELIST_NSources(TARGETDB_SourceList(targetdbnodep)) > 0))
    {
      NoConflictFound =
	SourceList_CheckConsistency(TARGETDB_SourceList(targetdbnodep),
				    preferencedb,
				    collectionlistp,
				    findallconflicts);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? NoConflictFound : FALSE;
}



static Boolean TargetDB_TreeCheckSourceConsistency(targetdbp,
						   preferencedb,
						   collectionlistp,
						   findallconflicts)
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
     Boolean findallconflicts;
{
  register int i;
  register TARGETDB **childp;

  Boolean NoConflictFound;

  NoConflictFound = TRUE;

  if (targetdbp != NULL)
    {
      NoConflictFound =
	TargetDB_NodeCheckSourceConsistency(targetdbp,
					    preferencedb,
					    collectionlistp,
					    findallconflicts);

      for (i = 0, childp = TARGETDB_Children(targetdbp);
	   (PROGRAM_ErrorNo == E_NULL)
	   && (i < TARGETDB_ChildCount(targetdbp))
	   && (NoConflictFound || findallconflicts);
	   i++, childp++)
	{
	  NoConflictFound &=
	    TargetDB_TreeCheckSourceConsistency(*childp,
						preferencedb,
						collectionlistp,
						findallconflicts);
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? NoConflictFound : FALSE;
}



Boolean TargetDB_CheckSourceConsistency(targetdbp,
					preferencedb,
					collectionlistp,
					findallconflicts)
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
     Boolean findallconflicts;
{
  Boolean NoConflictFound;

  NoConflictFound =
    TargetDB_TreeCheckSourceConsistency(targetdbp,
					preferencedb,
					collectionlistp,
					findallconflicts);

  if ((PROGRAM_ErrorNo == E_NULL)
      && findallconflicts && (NoConflictFound == FALSE))
    {
      FatalError(E_TARGETSOURCECONFLICT,
		 "Conflicting sources found in target database.\n");
    }

  return (PROGRAM_ErrorNo == E_NULL) ? NoConflictFound : FALSE;
}


char *
Update_Dump(upd)
  unsigned upd;
{
  static char msg[512];

  bzero(msg, sizeof(msg));
  if (upd & U_NULL) {
    strcat(msg,"U_NULL ");
  }
  if (upd & U_NOOP) {
    strcat(msg,"U_NOOP ");
  }
  if (upd & U_DELETE) {
    strcat(msg,"U_DELETE ");
  }
  if (upd & U_MAP) {
    strcat(msg,"U_MAP ");
  }
  if (upd & U_MAPCOPY) {
    strcat(msg,"U_MAPCOPY ");
  }
  if (upd & U_MAPLINK) {
    strcat(msg,"U_MAPLINK ");
  }
  if (upd & U_SPECIAL) {
    strcat(msg,"U_SPECIAL ");
  }
  if (upd & U_MKDIR) {
    strcat(msg,"U_MKDIR ");
  }
  if (upd & U_COMMAND) {
    strcat(msg,"U_COMMAND ");
  }
  if (upd & U_HARDLINK) {
    strcat(msg,"U_HARDLINK ");
  }
  if (upd & U_GROUP) {
    strcat(msg,"U_GROUP ");
  }
  if (upd & U_OWNER) {
    strcat(msg,"U_OWNER ");
  }
  if (upd & U_MODE) {
    strcat(msg,"U_MODE ");
  }
  if (upd & U_SETSTICKY) {
    strcat(msg,"U_SETSTICKY ");
  }
  if (upd & U_SETGID) {
    strcat(msg,"U_SETGID ");
  }
  if (upd & U_SETUID) {
    strcat(msg,"U_SETUID ");
  }
  if (upd & U_TARGET) {
    strcat(msg,"U_TARGET ");
  }
  if (upd & U_NONVIRGIN) {
    strcat(msg,"U_NONVIRGIN ");
  }
  if (upd & U_SPECIALPATH) {
    strcat(msg,"U_SPECIALPATH ");
  }
  if (upd & U_NOOPPATH) {
    strcat(msg,"U_NOOPPATH ");
  }
  if (upd & U_COMMANDPATH) {
    strcat(msg,"U_COMMANDPATH ");
  }
  if (upd & U_STATUSPATH) {
    strcat(msg,"U_STATUSPATH ");
  }
  if (upd & U_VIRGINLINK) {
    strcat(msg,"U_VIRGINLINK ");
  }
  if (upd & U_IMMACULATE) {
    strcat(msg,"U_IMMACULATE ");
  }

  return(msg);
}


void
TargetDB_ReportUpdateConflict(source1, source2, coll) 
  TARGETSOURCE *source1, *source2;
  COLLECTION *coll;
{
  FatalError(E_TARGETSOURCECONFLICT, "Source Conflict in collection: %s\n");
  if (strcmp(TARGETSOURCE_Path(source1), TARGETSOURCE_Path(source2)) == 0) {
    fprintf(stderr,"\tPATH:   %s\n", TARGETSOURCE_Path(source1));
  } else {
    fprintf(stderr,"\tPATH:   %s -vs- %s\n", TARGETSOURCE_Path(source1),
	    TARGETSOURCE_Path(source2));
  }

  fprintf(stderr,"\tUpdate Conflict of %s(0x%x) -vs- %s(0x%x)\n",
	  Update_Dump(TARGETSOURCE_UpdateSpec(source1)),
	  TARGETSOURCE_UpdateSpec(source1),
	  Update_Dump(TARGETSOURCE_UpdateSpec(source2)),
	  TARGETSOURCE_UpdateSpec(source1));
}  

void
TargetDB_ReportFileConflict(source1, source2, coll1, coll2, findallconflicts) 
  TARGETSOURCE *source1, *source2;
  COLLECTION   *coll1,   *coll2;
  Boolean      findallconflicts;
{
  static char msg[] = "Source conflict in ";

  if (findallconflicts)  {
    fprintf(stderr,"%s", msg);
  } else {
    FatalError(E_TARGETSOURCECONFLICT, 
	       "%s", msg);
  }
  
  fprintf(stderr,"collections: %s %s\n", COLLECTION_Name(coll1), 
	  COLLECTION_Name(coll2));

  
  /* how do I find out what is the real path and what is the
   * depot.conf\'d path? 
   */
  if (strcmp(TARGETSOURCE_Path(source1), TARGETSOURCE_Path(source2)) == 0) {
    fprintf(stderr,"\tPATH:   %s\n",TARGETSOURCE_Path(source1));
  } else {
    fprintf(stderr,"\tPATH:   %s -vs- %s\n", TARGETSOURCE_Path(source1),
	    TARGETSOURCE_Path(source2));
  }

  if (TARGETSOURCE_UpdateSpec(source1) == TARGETSOURCE_UpdateSpec(source2)) {
    fprintf(stderr,"\tUPDATE: %s(0x%x)\n", 
	    Update_Dump(TARGETSOURCE_UpdateSpec(source1)),
	    TARGETSOURCE_UpdateSpec(source1));
  } else {
    fprintf(stderr,"\tUPDATE: %s(0x%x) -vs- %s(0x%x)\n",
	    Update_Dump(TARGETSOURCE_UpdateSpec(source1)),
	    TARGETSOURCE_UpdateSpec(source1),
	    Update_Dump(TARGETSOURCE_UpdateSpec(source2)),
	    TARGETSOURCE_UpdateSpec(source2));
  }
}

void
TargetDB_ReportMergeConflict(source1, source2)
  TARGETSOURCE *source1, *source2;
{
  FatalError(E_TARGETSOURCECONFLICT, 
	     "Source Conflict in merge: %s -vs- %s\n", 
	     TARGETSOURCE_Path(source1),
	     TARGETSOURCE_Path(source2));
  fprintf(stderr,"\tUpdate Modes: %s(0x%x) -vs- %s(0x%x)\n",
	  Update_Dump(TARGETSOURCE_UpdateSpec(source1)),
	  TARGETSOURCE_UpdateSpec(source1),
	  Update_Dump(TARGETSOURCE_UpdateSpec(source2)),
	  TARGETSOURCE_UpdateSpec(source2));
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/TargetDB/RCS/TargetDB_Conflict.c,v $ */
