/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: Preference_Set.c,v 1.7 1994/10/13 19:38:13 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"
#include "File.h"


PREFERENCEDB *Preference_SetInt(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     int prefval;
{
  PREFERENCE *pp;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      PREFERENCE_IVal(pp) = prefval;
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}


PREFERENCEDB *Preference_SetUnsigned(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     unsigned prefval;
{
  PREFERENCE *pp;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      PREFERENCE_UVal(pp) = prefval;
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}


PREFERENCEDB *Preference_SetBoolean(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     Boolean prefval;
{
  PREFERENCE *pp;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      PREFERENCE_BoolVal(pp) = prefval;
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}


PREFERENCEDB *Preference_SetString(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     char *prefval;
{
  PREFERENCE *pp;
  char *oldval;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      oldval = PREFERENCE_StrVal(pp);
      PREFERENCE_StrVal(pp) = String(prefval, strlen(prefval));
      if (oldval != NULL)
	String_Free(oldval);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}


PREFERENCEDB *Preference_SetStringArray(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     STRINGARRAY *prefval;
{
  PREFERENCE *pp;
  STRINGARRAY *oldval;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      oldval = PREFERENCE_StrArrVal(pp);
      PREFERENCE_StrArrVal(pp) = StringArray(prefval,
					     StringArray_Size(prefval));
      if (oldval != NULL)
        StringArray_Free(oldval);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}


PREFERENCEDB *Preference_SetStringSet(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     STRINGSET *prefval;
{
  PREFERENCE *pp;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      PREFERENCE_StrSetVal(pp) = StringSet_Merge(PREFERENCE_StrSetVal(pp),
						 prefval);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}


PREFERENCEDB *Preference_SetSentence(prefdbp, item, prefname, prefval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     SENTENCE *prefval;
{
  PREFERENCE *pp, *fl;
  SENTENCE *oldval;

  pp = Preference_Lookup(prefdbp, item, prefname, TRUE/*Create*/);
  if ((PROGRAM_ErrorNo != E_NULL) || (pp == NULL))
    {
      FatalError(E_PREFSETFAILED,
		 "Could not set preference %s for %s\n", item, prefname);
    }
  else
    {
      oldval = PREFERENCE_SentenceVal(pp);
      PREFERENCE_SentenceVal(pp) = StringArray(prefval,
					       StringArray_Size(prefval));
      if (oldval != NULL)
        StringArray_Free(oldval);
    }

  if (Preference_Type(prefname) & PREF_FILTER)
      /* We need to add this filter to our global filter list */
      if (! (fl =  Preference_Lookup(prefdbp, PrefInternalCmdList,
				     PrefInternalPref, FALSE/*Create*/))) {
	  fl =  Preference_Lookup(prefdbp, PrefInternalCmdList,
				  PrefInternalPref, TRUE/*Create*/);
	  if ((PROGRAM_ErrorNo != E_NULL) || (fl == NULL))
		  FatalError(E_PREFSETFAILED,
			     "Could not set preference %s for %s\n",
			     item, prefname);
	  PREFERENCE_StrArrVal(fl) = StringArray_AppendString(NULL, item);
      } else {
	  if ((PROGRAM_ErrorNo != E_NULL) || (fl == NULL))
	      FatalError(E_PREFSETFAILED,
			 "Could not set preference %s for %s\n", item, prefname);
	  PREFERENCE_StrArrVal(fl) =
	      StringArray_AppendString(PREFERENCE_StrArrVal(fl), item);
      }

  return (PROGRAM_ErrorNo == E_NULL) ? prefdbp : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/014/src/lib/Preference/RCS/Preference_Set.c,v $ */
