
%{

/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: Preference_Parse.l,v 1.5 1994/08/12 22:14:01 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"
#include "Preference_Read.h"

static unsigned short ptype, preftype;
static char yyerrormessage[1024];

#define dbgprintf(x) /* fprintf x */

void
yyparseinit() {
BEGIN 0;
}

%}


/* definitions */
W	[ \t]
COM	#[^\n]*
RET	\n
QUOT	\\
C	[^ \t\n\\#\\,]
COMMA	\,
D	[0-9]
QUOTC	{QUOT}.


%START PITEM INTVAL UNSVAL BOOLVAL STRVAL STRARRVAL STRSETVAL SENTENCEVAL UNKVAL

%%

<PITEM>{C}+	{
	{
	  dbgprintf((stdout, "PITEM %s\n", yytext));
	  yylval.strval=String(yytext, strlen(yytext));
	  switch (ptype)
	    {
	    case PREF_INTEGER:
	      BEGIN INTVAL; break;
	    case PREF_UNSIGNED:
	      BEGIN UNSVAL; break;
	    case PREF_BOOLEAN:
	      BEGIN BOOLVAL; break;
	    case PREF_STRING:
	      BEGIN STRVAL; break;
	    case PREF_STRINGARRAY:
	      BEGIN STRARRVAL; break;
	    case PREF_STRINGSET:
	      BEGIN STRSETVAL; break;
	    case PREF_SENTENCE:
	      BEGIN SENTENCEVAL; break;
	    case PREF_UNKNOWN:
	    default:
	      BEGIN UNKVAL; break;
	    }
	   return(ITEM);
	}}

<PITEM>({C}|{QUOTC})+	{
	{
	  dbgprintf((stdout, "PITEM %s\n", yytext));
	  yylval.strval=String_RemoveQuotes(yytext, '\\');
	  switch (ptype)
	    {
	    case PREF_INTEGER:
	      BEGIN INTVAL; break;
	    case PREF_UNSIGNED:
	      BEGIN UNSVAL; break;
	    case PREF_BOOLEAN:
	      BEGIN BOOLVAL; break;
	    case PREF_STRING:
	      BEGIN STRVAL; break;
	    case PREF_STRINGARRAY:
	      BEGIN STRARRVAL; break;
	    case PREF_STRINGSET:
	      BEGIN STRSETVAL; break;
	    case PREF_SENTENCE:
	      BEGIN SENTENCEVAL; break;
	    case PREF_UNKNOWN:
	    default:
	      BEGIN UNKVAL; break;
	    }
	  return(ITEM);
	}}

<INTVAL>-?{D}+	{
	{
	  dbgprintf((stdout, "INTVAL %s\n", yytext));
	  yylval.ival = atoi(yytext);
	  return INTEGER;
	}}

<UNSVAL>{D}+	{
	{
	  dbgprintf((stdout, "UNSVAL %s\n", yytext));
	  yylval.unsval = (unsigned)atoi(yytext);
	  return UNSIGNED;
	}}

<BOOLVAL>([Tt]|[Tt][Rr][Uu][Ee])	{
	{
	  dbgprintf((stdout, "BOOLVAL %s\n", yytext));
	  yylval.boolval = TRUE;
	  return BOOLEAN;
	}}

<BOOLVAL>([Ff]|[Ff][Aa][Ll][Ss][Ee])	{
	{
	  dbgprintf((stdout, "BOOLVAL %s\n", yytext));
	  yylval.boolval = FALSE;
	  return BOOLEAN;
	}}

<STRVAL,STRARRVAL,STRSETVAL,SENTENCEVAL,UNKVAL>{C}+	{
	{
	  dbgprintf((stdout, "STRING %s\n", yytext));
	  yylval.strval = String(yytext, strlen(yytext));
	  return(STRING);
	}}

<STRVAL,STRARRVAL,STRSETVAL,SENTENCEVAL,UNKVAL>({C}|{QUOTC})+	{
	{
	  dbgprintf((stdout, "STRING %s\n", yytext));
	  yylval.strval=String_RemoveQuotes(yytext, '\\');
	  return(STRING);
	}}

<STRARRVAL,STRSETVAL,UNKVAL>{W}*{COMMA}{W}* {
	{
	  dbgprintf((stdout, "COMMA\n"));
	  yylval.ival = 1;
	  return(STRINGDELIMITER);
	}}

<SENTENCEVAL>{W}+    {
	{
	  dbgprintf((stdout, "WHITESPACE\n"));
          yylval.ival = 1;
          return(SENTENCEDELIMITER);
        }}

{W}+	{
	  dbgprintf((stdout, "WHITESPACE\n"));
	  yylval.ival = 1;
	  return(WHITESPACE);
	}

{COM}	{
	  dbgprintf((stdout, "COMMENT\n"));
	  yylval.ival = 1;
	  BEGIN 0; return(COMMENT);
	}

{RET}	{
	  dbgprintf((stdout, "NEWLINE\n"));
	  yylval.ival = 1;
	  BEGIN 0; return(NEWLINE);
	}

{C}+	{
	  dbgprintf((stdout, "PNAME %s\n", yytext));
	  yylval.strval=String(yytext, strlen(yytext));
	  preftype = Preference_Type(yylval.strval);
	  if (preftype & PREF_REGULAR)
	    {
	      if (preftype & PREF_INTEGER)
		{ ptype = PREF_INTEGER; BEGIN PITEM; return INTRPREFNAME; }
	      else if (preftype & PREF_UNSIGNED)
		{ ptype = PREF_UNSIGNED; BEGIN PITEM; return UNSRPREFNAME; }
	      else if (preftype & PREF_BOOLEAN)
		{ ptype = PREF_BOOLEAN; BEGIN PITEM; return BOOLRPREFNAME; }
	      else if (preftype & PREF_STRING)
		{ ptype = PREF_STRING; BEGIN PITEM; return STRRPREFNAME; }
	      else if (preftype & PREF_STRINGARRAY)
		{ ptype = PREF_STRINGARRAY;BEGIN PITEM;return STRARRRPREFNAME; }
	      else if (preftype & PREF_STRINGSET)
		{ ptype = PREF_STRINGSET; BEGIN PITEM; return STRSETRPREFNAME; }
	      else if (preftype & PREF_SENTENCE)
		{ ptype = PREF_SENTENCE;BEGIN PITEM;return SENTENCERPREFNAME; }
	      else
		{
		  sprintf(yyerrormessage,
			  "Unknown preference name %s", yylval.strval);
		  yyerror(yyerrormessage);
		  ptype = PREF_UNKNOWN; BEGIN PITEM; return UNKNOWNPREFNAME;
		}
	    }
	  else if (preftype & PREF_GLOBAL)
	    {
	      if (preftype & PREF_INTEGER)
		{ BEGIN INTVAL; return INTGPREFNAME; }
	      else if (preftype & PREF_UNSIGNED)
		{ BEGIN UNSVAL; return UNSGPREFNAME; }
	      else if (preftype & PREF_BOOLEAN)
		{ BEGIN BOOLVAL; return BOOLGPREFNAME; }
	      else if (preftype & PREF_STRING)
		{ BEGIN STRVAL; return STRGPREFNAME; }
	      else if (preftype & PREF_STRINGARRAY)
		{ BEGIN STRARRVAL; return STRARRGPREFNAME; }
	      else if (preftype & PREF_STRINGSET)
		{ BEGIN STRSETVAL; return STRSETGPREFNAME; }
	      else if (preftype & PREF_SENTENCE)
		{ BEGIN SENTENCEVAL; return SENTENCEGPREFNAME; }
	      else
		{
		  sprintf(yyerrormessage,
			  "Unknown preference name %s", yylval.strval);
		  yyerror(yyerrormessage);
		  BEGIN UNKVAL; return UNKNOWNPREFNAME;
		}
	    }
	  else
	    {
	      sprintf(yyerrormessage,
		      "Unknown preference name %s\n", yylval.strval);
	      yyerror(yyerrormessage);
	      BEGIN UNKVAL; return UNKNOWNPREFNAME;
	    }
	}

({C}|{QUOTC})+	{
	{
	  dbgprintf((stdout, "PNAME %s\n", yytext));
	  yylval.strval=String_RemoveQuotes(yytext, '\\');
	  preftype = Preference_Type(yylval.strval);
          if (preftype & PREF_REGULAR)
	    {
	      if (preftype & PREF_INTEGER)
		{ ptype = PREF_INTEGER; BEGIN PITEM; return INTRPREFNAME; }
	      else if (preftype & PREF_UNSIGNED)
		{ ptype = PREF_UNSIGNED; BEGIN PITEM; return UNSRPREFNAME; }
	      else if (preftype & PREF_BOOLEAN)
		{ ptype = PREF_BOOLEAN; BEGIN PITEM; return BOOLRPREFNAME; }
	      else if (preftype & PREF_STRING)
		{ ptype = PREF_STRING; BEGIN PITEM; return STRRPREFNAME; }
	      else if (preftype & PREF_STRINGARRAY)
		{ ptype = PREF_STRINGARRAY;BEGIN PITEM;return STRARRRPREFNAME; }
	      else if (preftype & PREF_STRINGSET)
		{ ptype = PREF_STRINGSET; BEGIN PITEM; return STRSETRPREFNAME; }
	      else if (preftype & PREF_SENTENCE)
		{ ptype = PREF_SENTENCE;BEGIN PITEM;return SENTENCERPREFNAME; }
	      else
		{
		  sprintf(yyerrormessage,
			  "Unknown preference name %s\n", yylval.strval);
		  yyerror(yyerrormessage);
		  ptype = PREF_UNKNOWN; BEGIN PITEM; return UNKNOWNPREFNAME;
		}
	    }
	  else if (preftype & PREF_GLOBAL)
	    {
	      if (preftype & PREF_INTEGER)
		{ BEGIN INTVAL; return INTGPREFNAME; }
	      else if (preftype & PREF_UNSIGNED)
		{ BEGIN UNSVAL; return UNSGPREFNAME; }
	      else if (preftype & PREF_BOOLEAN)
		{ BEGIN BOOLVAL; return BOOLGPREFNAME; }
	      else if (preftype & PREF_STRING)
		{ BEGIN STRVAL; return STRGPREFNAME; }
	      else if (preftype & PREF_STRINGARRAY)
		{ BEGIN STRARRVAL; return STRARRGPREFNAME; }
	      else if (preftype & PREF_STRINGSET)
		{ BEGIN STRSETVAL; return STRSETGPREFNAME; }
	      else if (preftype & PREF_SENTENCE)
		{ BEGIN SENTENCEVAL; return SENTENCEGPREFNAME; }
	      else
		{
		  sprintf(yyerrormessage,
			  "Unknown preference name %s\n", yylval.strval);
		  yyerror(yyerrormessage);
		  BEGIN UNKVAL; return UNKNOWNPREFNAME;
		}
	    }
	  else
	    {
	      sprintf(yyerrormessage,
		      "Unknown preference name %s\n", yylval.strval);
	      yyerror(yyerrormessage);
	      BEGIN UNKVAL; return UNKNOWNPREFNAME;
	    }
	}}


%%

/* $Source: /afs/andrew/system/src/local/depot2/016/src/lib/Preference/RCS/Preference_Parse.l,v $ */
