/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: PreferenceUtil.c,v 1.8 1994/10/11 15:20:31 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"

/* implement a traverse */

static struct PrefTypePair
{
    char *prefname;
    unsigned int preftype;
} PrefTypeList[] =
{
  { "path",		PREF_REGULAR|PREF_STRING},
  { "hintfile",		PREF_REGULAR |PREF_STRING},
  { "override",		PREF_REGULAR|PREF_STRINGSET},
  { "command",		PREF_REGULAR|PREF_SENTENCE|PREF_COMMAND},
  { "filter",		PREF_REGULAR|PREF_SENTENCE|PREF_FILTER},
  { "target.command",	PREF_REGULAR|PREF_STRINGSET},
  { "ignore",		PREF_GLOBAL |PREF_STRINGSET},
  { "collection.installmethod",	PREF_REGULAR |PREF_STRINGSET},
  { "target.installmethod", PREF_REGULAR |PREF_STRINGSET},
  { "target.modemask",	PREF_REGULAR|PREF_STRINGSET},
  { "searchpath",	PREF_REGULAR|PREF_STRINGARRAY},
  { "target.owner",	PREF_REGULAR|PREF_STRINGSET},
  { "target.group",	PREF_REGULAR|PREF_STRINGSET},
  { "target.setgid",	PREF_REGULAR|PREF_STRINGSET},
  { "target.setuid",	PREF_REGULAR|PREF_STRINGSET},
  { "specialfile",	PREF_GLOBAL |PREF_STRINGSET},
  { "usemodtimes",	PREF_GLOBAL |PREF_BOOLEAN},
  { "keepcopiedfileattributes", PREF_GLOBAL|PREF_BOOLEAN},
  { "compresstargetdb", PREF_GLOBAL|PREF_BOOLEAN},
  { "version",		PREF_REGULAR|PREF_INTEGER},
  { "versiondelimiter",	PREF_GLOBAL |PREF_STRING},
  { "DEPOT_INTERNAL",   PREF_REGULAR|PREF_STRINGARRAY|PREF_INTERNAL}
  /*
   * { "unsignedtest",	PREF_GLOBAL |PREF_UNSIGNED},
   */
};

static unsigned int NPrefTypes = sizeof(PrefTypeList)/sizeof(PrefTypeList[0]);

char *PrefInternalPref = "DEPOT_INTERNAL";
char *PrefInternalCmdList = "CMD_LIST";

static struct PrefTypePair *PrefTypePair_LocateByName(pname)
     char *pname;
{
  register struct PrefTypePair *pp;
  register unsigned i;
  register Boolean FoundPreferenceName;
  
  i = 0; pp = PrefTypeList; FoundPreferenceName = FALSE;
  while ((i < NPrefTypes) && !FoundPreferenceName)
    {
      if (strcmp(pname, pp->prefname) == 0)
	FoundPreferenceName = TRUE;
      else
	{ i++, pp++; }
    }

  return (FoundPreferenceName == TRUE) ? pp : NULL;
}


unsigned short Preference_Type(pname)
     char *pname;
{
  struct PrefTypePair *pp;

  pp = PrefTypePair_LocateByName(pname);
  return (pp == NULL) ? PREF_UNKNOWN : pp->preftype ;
}


int Preference_OptionID(pname)
     char *pname;
{
  int optionid;
  struct PrefTypePair *pp;

  pp = PrefTypePair_LocateByName(pname);
  if (pp == NULL)
    {
      FatalError(E_BADPREFNAME,
		 "Attempt to get id of unknown preference option %s\n", pname);
    }
  else
    optionid = pp - PrefTypeList + 1;

  return (PROGRAM_ErrorNo == E_NULL) ? optionid : -1;
}


char *Preference_OptionName(id)
     int id;
{
  char *pname;

  if (id > NPrefTypes)
    {
      FatalError(E_BADPREFID,
		 "Attempt to to get name of unknown preference option id %d\n",
		 id);
    }
  else
    pname = (PrefTypeList+id-1)->prefname;

  return (PROGRAM_ErrorNo == E_NULL) ? pname : NULL;
}


int PreferenceArray_Size(pp)
     PREFERENCE **pp;
{
  register PREFERENCE **rover;
  int size;

  if (pp == NULL)
    size = 0;
  else
    {
      rover = pp;
      while (*rover != NULL) rover++;
      size = rover - pp;
    }

  return size;
}


int Preference_Comparator(prefp, item, name)
     PREFERENCE *prefp;
     char *item, *name;
{
  int Comparison;

  Comparison = 0;
  if ((PREFERENCE_Operand(prefp) != NULL)
      && (item != NULL))
    Comparison = strcmp(PREFERENCE_Operand(prefp), item);
  else if ((PREFERENCE_Operand(prefp) == NULL)
	   && (item != NULL))
    Comparison = -1;
  else if ((PREFERENCE_Operand(prefp) != NULL)
	   && (item == NULL))
    Comparison = 1;
  /* else ((PREFERENCE_Operand(prefp) == NULL)&& (item == NULL)) */
  /* Comparison = 0; */

  if (Comparison == 0)
    {
      if ((PREFERENCE_Option(prefp) != NULL)
	  && (name != NULL))
	Comparison = strcmp(PREFERENCE_Option(prefp), name);
      else if ((PREFERENCE_Option(prefp) == NULL)
	       && (name != NULL))
	Comparison = -1;
      else if ((PREFERENCE_Option(prefp) != NULL)
	       && (name == NULL))
	Comparison = 1;
      /* else ((PREFERENCE_Option(prefp) == NULL)&& (name == NULL)) */
      /* Comparison = 0; */
    }

  return Comparison;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/014/src/lib/Preference/RCS/PreferenceUtil.c,v $ */
