/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: HintDB_Read.c,v 1.3 1994/08/12 18:01:16 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"


static HINT *Hint_Read(fp)
          FILE *fp;
{
  HINT *hintp;

  hintp = (HINT *)emalloc(sizeof(HINT));
  if (PROGRAM_ErrorNo == E_NULL)
    HINT_PathName(hintp) = efgetstring(fp, '\\' /* quotechar */);
  if (PROGRAM_ErrorNo == E_NULL)
    HINT_UniqueID(hintp) = efgetstring(fp, '\\' /* quotechar */);
  if (PROGRAM_ErrorNo == E_NULL)
    HINT_ModTime(hintp) = (time_t)efgetlong(fp);

  return (PROGRAM_ErrorNo == E_NULL) ? hintp : NULL;
}



/*
 * Read hint database from file
 */
HINTDB HintDB_Read(fp)
     FILE *fp;
{
  register HINTDB hpp;
  register unsigned int i;
  HINTDB hintdb;
  unsigned int hintdbsize;

  hintdb = NULL;
  hintdbsize = efgetunsigned(fp);
  if (hintdbsize > 0)
    {
      if (PROGRAM_ErrorNo == E_NULL)
	hintdb = (HINTDB)emalloc((hintdbsize+1)*sizeof(HINT *));
      for (i = 0, hpp = hintdb;
	   (i < hintdbsize) && (PROGRAM_ErrorNo == E_NULL);
	   i++, hpp++)
	*hpp = Hint_Read(fp);
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  *(hintdb+hintdbsize) = NULL;
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? hintdb : NULL;
}

/*  $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Hint/RCS/HintDB_Read.c,v $ */
